/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.client;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.report.IMTOOrderTraceFacade;
import com.kingdee.eas.mm.report.MTOOrderTraceFacadeFactory;
import com.kingdee.eas.mm.report.client.AbstractMTOBillTraceTreeUI;
import com.kingdee.eas.mm.report.client.ITreeController;
import com.kingdee.eas.mm.report.client.MTOBillTraceUI;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class MTOBillTraceTreeUI
extends AbstractMTOBillTraceTreeUI {
    private static final Logger logger = CoreUIObject.getLogger(MTOBillTraceTreeUI.class);
    public static final String REPORT_RESOURCE = "com.kingdee.eas.mm.report.ReportResource";
    private ITreeController controller;
    private FilterInfo filterInfo;
    private DefaultTreeModel model = null;
    private Map trackNumsToSaleOrders = new HashMap();
    private Map saleOrdersToTrackNums = new HashMap();
    private TreeSelectionListener treeSelectionListener;

    public MTOBillTraceTreeUI() throws Exception {
    }

    public MTOBillTraceTreeUI(FilterInfo filterInfo, ITreeController controller) throws Exception {
        this.filterInfo = filterInfo;
        this.controller = controller;
        this.model = (DefaultTreeModel)this.treeMain.getModel();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.treeView.getControlPane().remove(4);
        this.treeView.getControlPane().remove(4);
        this.initTree();
    }

    public boolean isSelectedTreeNode() {
        KDTreeNode node = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        return node != null;
    }

    public void initTree() throws Exception {
        Map trackNumsAndSaleOrders = new HashMap();
        try {
            trackNumsAndSaleOrders = this.getTreeInterface().getTrackNumsAndSaleOrders(this.filterInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        if (this.treeMain.getTreeSelectionListeners().length > 0) {
            this.treeMain.removeTreeSelectionListener(this.treeSelectionListener);
        }
        KDTreeNode rootNode = new KDTreeNode((Object)"root");
        ((DefaultTreeModel)this.treeMain.getModel()).setRoot((TreeNode)rootNode);
        this.treeMain.setShowsRootHandles(true);
        this.treeMain.setRootVisible(false);
        if (this.model != null && this.model.getRoot() != null) {
            this.treeMain.expandPath(new TreePath(this.model.getRoot()));
        }
        List trackNumberList = (List)trackNumsAndSaleOrders.get("trackNumber");
        List saleOrderList = (List)trackNumsAndSaleOrders.get("saleOrder");
        Iterator iterTrackNumber = trackNumberList.iterator();
        this.trackNumsToSaleOrders.clear();
        this.saleOrdersToTrackNums.clear();
        while (iterTrackNumber.hasNext()) {
            TrackNumberInfo trackNumberInfo = (TrackNumberInfo)iterTrackNumber.next();
            KDTreeNode trackNumberNode = new KDTreeNode((Object)trackNumberInfo);
            trackNumberNode.setText(trackNumberInfo.getNumber());
            this.model.insertNodeInto((MutableTreeNode)trackNumberNode, (MutableTreeNode)rootNode, rootNode.getChildCount());
            ArrayList<SaleOrderInfo> saleOrderListToTrackNum = new ArrayList<SaleOrderInfo>();
            for (int i = 0; i < saleOrderList.size(); ++i) {
                SaleOrderInfo saleOrderInfo = (SaleOrderInfo)saleOrderList.get(i);
                if (null == saleOrderInfo.getEntries().get(0).getTrackNumber() || !trackNumberInfo.getNumber().equals(saleOrderInfo.getEntries().get(0).getTrackNumber().getNumber())) continue;
                KDTreeNode saleOrderNode = new KDTreeNode((Object)saleOrderInfo);
                saleOrderNode.setText(saleOrderInfo.getNumber() + "  " + saleOrderInfo.getEntries().get(0).getSeq());
                this.model.insertNodeInto((MutableTreeNode)saleOrderNode, (MutableTreeNode)trackNumberNode, trackNumberNode.getChildCount());
                saleOrderListToTrackNum.add(saleOrderInfo);
                this.trackNumsToSaleOrders.put(saleOrderInfo, trackNumberInfo);
            }
            this.saleOrdersToTrackNums.put(trackNumberInfo.getNumber(), saleOrderListToTrackNum);
            if (!"true".equals((String)trackNumsAndSaleOrders.get("isQueryByTrackNumber"))) continue;
            SaleOrderInfo saleOrderWithoutTrackNum = new SaleOrderInfo();
            KDTreeNode noTrackNumberNode = new KDTreeNode((Object)saleOrderWithoutTrackNum);
            noTrackNumberNode.setText(EASResource.getString((String)REPORT_RESOURCE, (String)"BILL_WITHOUT_SALEORDER"));
            this.model.insertNodeInto((MutableTreeNode)noTrackNumberNode, (MutableTreeNode)trackNumberNode, trackNumberNode.getChildCount());
            this.trackNumsToSaleOrders.put(saleOrderWithoutTrackNum, trackNumberInfo);
        }
        if (trackNumberList.size() > 0) {
            ((MTOBillTraceUI)this.controller).setSaleOrdersSaved((List)this.saleOrdersToTrackNums.get(((TrackNumberInfo)trackNumberList.get(0)).getNumber()));
            ((MTOBillTraceUI)this.controller).setTrackNumberInfo((TrackNumberInfo)trackNumberList.get(0));
            TreePath parent = new TreePath(((DefaultTreeModel)this.treeMain.getModel()).getRoot());
            KDTreeNode treeNode = (KDTreeNode)parent.getLastPathComponent();
            TreePath path = parent.pathByAddingChild(treeNode.getChildAt(0));
            this.treeMain.expandPath(path);
            this.treeMain.setSelectionPath(path);
        } else {
            ((MTOBillTraceUI)this.controller).setSaleOrdersSaved(new ArrayList());
        }
        if (this.treeSelectionListener == null) {
            this.treeSelectionListener = new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    KDTreeNode currentNode = (KDTreeNode)e.getPath().getLastPathComponent();
                    if (currentNode.getUserObject() instanceof TrackNumberInfo) {
                        MTOBillTraceTreeUI.this.controller.selectTrackNumber((TrackNumberInfo)currentNode.getUserObject(), MTOBillTraceTreeUI.this.saleOrdersToTrackNums);
                    }
                    if (currentNode.getUserObject() instanceof SaleOrderInfo) {
                        MTOBillTraceTreeUI.this.controller.selectSaleOrder((SaleOrderInfo)currentNode.getUserObject(), MTOBillTraceTreeUI.this.trackNumsToSaleOrders);
                    }
                }
            };
        }
        this.treeMain.addTreeSelectionListener(this.treeSelectionListener);
    }

    protected IMTOOrderTraceFacade getTreeInterface() throws Exception {
        return MTOOrderTraceFacadeFactory.getRemoteInstanceWithObjectContext(this.getUserContext());
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    public void setFilterInfo(FilterInfo filterInfo) {
        this.filterInfo = filterInfo;
    }
}

