/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.report.client.AbstractManufactureOrderTraceFilterUI;
import com.kingdee.eas.mm.report.util.reportUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class ManufactureOrderTraceFilterUI
extends AbstractManufactureOrderTraceFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ManufactureOrderTraceFilterUI.class);
    private HashMap contextHashMap = null;
    protected KDBizPromptBox[] disableCommitF7 = new KDBizPromptBox[]{this.PromptBizType, this.PromProductTranType, this.kDBizBillNumFrom, this.kDBizBillNumTo, this.promMaterialNumFrom, this.promMaterialNumTo, this.prmtprojectStart, this.prmtprojectEnd, this.prmtttrackNumStart, this.prmttrackNumEnd, this.promRootingNumFrom, this.promRootingNumTo, this.promPersonFrom, this.promPersonTo, this.promOrgUnitFrom, this.promOrgUnitTo};

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected Date getNextMonthDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 1);
        return calendar.getTime();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.promRootingNumFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                ManufactureOrderTraceFilterUI.this.addEntityView(true);
            }
        });
        this.promRootingNumTo.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                ManufactureOrderTraceFilterUI.this.addEntityView(false);
            }
        });
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, ManufactureOrderTraceFilterUI.getResource("Stroage_IsNotNull")));
        this.comboBaseStatus.removeItem((Object)BillBaseStatusEnum.VERSION);
        this.comboBaseStatus.removeItem((Object)BillBaseStatusEnum.ALTERING);
        this.comboBaseStatus.removeItem((Object)BillBaseStatusEnum.ADD);
        this.comboBaseStatus.removeItem((Object)BillBaseStatusEnum.FINISH);
        this.comboBaseStatus.removeItem((Object)BillBaseStatusEnum.PUBLISHED);
        Timestamp[] dates = ManufactureOrderTraceFilterUI.getDefaultDateRange(SCMClientUtils.getServerDate2());
        CompositeFilterElement elements = new CompositeFilterElement(0);
        RangeFilterElement elementBizDate = new RangeFilterElement("bizDate", (Component)this.dateBizDateFrom, (Component)this.dateBizDateTo);
        elementBizDate.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)elementBizDate);
        elements.add((FilterElement)new SingleFilterElement("bizType.number", (Component)this.PromptBizType));
        elements.add((FilterElement)new SingleFilterElement("transactionType.number", (Component)this.PromProductTranType));
        elements.add((FilterElement)new RangeFilterElement("number", (Component)this.kDBizBillNumFrom, (Component)this.kDBizBillNumTo));
        elements.add((FilterElement)new RangeFilterElement("material.number", (Component)this.promMaterialNumFrom, (Component)this.promMaterialNumTo));
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtprojectStart);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtprojectEnd);
        elements.add((FilterElement)new RangeFilterElement("project.number", (Component)this.prmtprojectStart, (Component)this.prmtprojectEnd));
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtttrackNumStart);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmttrackNumEnd);
        elements.add((FilterElement)new RangeFilterElement("trackNumber.number", (Component)this.prmtttrackNumStart, (Component)this.prmttrackNumEnd));
        elements.add((FilterElement)new RangeFilterElement("routing.number", (Component)this.promRootingNumFrom, (Component)this.promRootingNumTo));
        UIHelper.registerBizOrgF7((KDBizPromptBox)this.promOrgUnitFrom, null, null, (OrgType)this.getMainBizOrgType(), (OrgType)OrgType.Admin, (boolean)false);
        UIHelper.registerBizOrgF7((KDBizPromptBox)this.promOrgUnitTo, null, null, (OrgType)this.getMainBizOrgType(), (OrgType)OrgType.Admin, (boolean)false);
        elements.add((FilterElement)new RangeFilterElement("adminOrgUnit.number", (Component)this.promOrgUnitFrom, (Component)this.promOrgUnitTo));
        this.promOrgUnitFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (ManufactureOrderTraceFilterUI.this.prmtStorageOrgUnit.getValue() == null) {
                    ManufactureOrderTraceFilterUI.this.cancelF7Event(e);
                    return;
                }
                try {
                    ManufactureOrderTraceFilterUI.this.setMoDepartmentF7(e, ManufactureOrderTraceFilterUI.this.prmtStorageOrgUnit, ManufactureOrderTraceFilterUI.this.promOrgUnitFrom);
                }
                catch (Exception ex) {
                    ManufactureOrderTraceFilterUI.this.handUIException(ex);
                }
            }
        });
        this.promOrgUnitFrom.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                if (ManufactureOrderTraceFilterUI.this.prmtStorageOrgUnit.getValue() == null) {
                    ManufactureOrderTraceFilterUI.this.cancelF7Event(e);
                    return;
                }
                try {
                    ManufactureOrderTraceFilterUI.this.setMoDepartmentF7(e, ManufactureOrderTraceFilterUI.this.prmtStorageOrgUnit, ManufactureOrderTraceFilterUI.this.promOrgUnitFrom);
                }
                catch (Exception ex) {
                    ManufactureOrderTraceFilterUI.this.handUIException(ex);
                }
            }
        });
        this.promOrgUnitTo.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (ManufactureOrderTraceFilterUI.this.prmtStorageOrgUnit.getValue() == null) {
                    ManufactureOrderTraceFilterUI.this.cancelF7Event(e);
                    return;
                }
                try {
                    ManufactureOrderTraceFilterUI.this.setMoDepartmentF7(e, ManufactureOrderTraceFilterUI.this.prmtStorageOrgUnit, ManufactureOrderTraceFilterUI.this.promOrgUnitTo);
                }
                catch (Exception ex) {
                    ManufactureOrderTraceFilterUI.this.handUIException(ex);
                }
            }
        });
        this.promOrgUnitTo.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                if (ManufactureOrderTraceFilterUI.this.prmtStorageOrgUnit.getValue() == null) {
                    ManufactureOrderTraceFilterUI.this.cancelF7Event(e);
                    return;
                }
                try {
                    ManufactureOrderTraceFilterUI.this.setMoDepartmentF7(e, ManufactureOrderTraceFilterUI.this.prmtStorageOrgUnit, ManufactureOrderTraceFilterUI.this.promOrgUnitTo);
                }
                catch (Exception ex) {
                    ManufactureOrderTraceFilterUI.this.handUIException(ex);
                }
            }
        });
        elements.add((FilterElement)new RangeFilterElement("dispatcher.number", (Component)this.promPersonFrom, (Component)this.promPersonTo));
        this.promPersonFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                ManufactureOrderTraceFilterUI.this.setPersonFilter(ManufactureOrderTraceFilterUI.this.promPersonFrom);
            }
        });
        this.promPersonFrom.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                ManufactureOrderTraceFilterUI.this.setPersonFilter(ManufactureOrderTraceFilterUI.this.promPersonFrom);
            }
        });
        this.promPersonTo.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                ManufactureOrderTraceFilterUI.this.setPersonFilter(ManufactureOrderTraceFilterUI.this.promPersonTo);
            }
        });
        this.promPersonTo.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                ManufactureOrderTraceFilterUI.this.setPersonFilter(ManufactureOrderTraceFilterUI.this.promPersonTo);
            }
        });
        RangeFilterElement planBeginDate = new RangeFilterElement("planBeginDate", (Component)this.datePlanStartFrom, (Component)this.datePlanStartTo);
        planBeginDate.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)planBeginDate);
        RangeFilterElement planEnfDate = new RangeFilterElement("planEndDate", (Component)this.datePlanEndFrom, (Component)this.datePlanEndTo);
        planEnfDate.setDefaultValue((Object)ManufactureOrderTraceFilterUI.getDefaultDateRange());
        planEnfDate.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)planEnfDate);
        RangeFilterElement FactStratDate = new RangeFilterElement("actureBeginDate", (Component)this.dateFactStratFrom, (Component)this.dateFactStratTo);
        FactStratDate.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)FactStratDate);
        RangeFilterElement FactEndDate = new RangeFilterElement("actureEndDate", (Component)this.dateFactEndFrom, (Component)this.dateFactEndTo);
        FactEndDate.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)FactEndDate);
        elements.add((FilterElement)new SingleFilterElement("baseStatus", (Component)this.comboBaseStatus, (Object)BillBaseStatusEnum.NULL));
        this.f7Manager.registerContextChangeF7(this.kDBizBillNumFrom, "storageOrgUnit.id");
        this.f7Manager.registerContextChangeF7(this.kDBizBillNumTo, "storageOrgUnit.id");
        this.f7Manager.registerContextChangeF7(this.PromProductTranType, "storageOrgUnit.id");
        this.f7Manager.registerContextChangeF7(this.promRootingNumFrom, "storageOrgUnit.id");
        this.f7Manager.registerContextChangeF7(this.promRootingNumTo, "storageOrgUnit.id");
        elements.add((FilterElement)mainOrgElement);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        this.PromptBizType.setEntityViewInfo(reportUtil.getMMBizTypeEntityView());
        this.PromProductTranType.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                ManufactureOrderTraceFilterUI.this.productTranTypeaddEntityView();
            }
        });
        this.promRootingNumFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                ManufactureOrderTraceFilterUI.this.RootingNumaddEntityView();
            }
        });
        this.promRootingNumTo.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                ManufactureOrderTraceFilterUI.this.RootingNumaddEntityView();
            }
        });
        this.setMaterialFilter();
        MMUtils.resetF7CommitParser((KDBizPromptBox[])this.disableCommitF7);
    }

    public boolean verify() {
        return super.verify();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getViewPermission() {
        return "mm_manuordertrace_view";
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public void clear() {
        super.clear();
    }

    public Date getCurrentlyDate() {
        return new Date();
    }

    private void addEntityView(boolean isform) {
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource", (String)"Stroage_IsNotNull"));
        }
    }

    public static Timestamp[] getDefaultDateRange(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (d != null) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        Timestamp currDate = new Timestamp(calendar.getTimeInMillis());
        calendar.add(2, -1);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp[]{new Timestamp(calendar.getTimeInMillis()), currDate};
    }

    public static Timestamp[] getDefaultDateRange() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(calendar.get(1), calendar.get(2) + 1, 0, 23, 59, 59);
        calendar.set(14, 999);
        Timestamp currDate = new Timestamp(calendar.getTimeInMillis());
        calendar.set(calendar.get(1), calendar.get(2), 1, 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp[]{new Timestamp(calendar.getTimeInMillis()), currDate};
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource", (String)strKey);
    }

    private void productTranTypeaddEntityView() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)"20", CompareType.EQUALS));
        try {
            this.PromProductTranType.getEntityViewInfo().getFilter().mergeFilter(filter, "and");
            this.PromProductTranType.getQueryAgent().resetRuntimeEntityView();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void setMaterialFilter() {
        String queryInfo = UIHelper.getMaterialPlanQuery((int)this.f7Manager.getF7DisplayMode());
        this.setBizMaterialF7(this.promMaterialNumFrom, false, queryInfo);
        this.setBizMaterialF7(this.promMaterialNumTo, false, queryInfo);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("plan.materialAttr", (Object)String.valueOf(10040), CompareType.NOTEQUALS));
        view.setFilter(filter);
        this.promMaterialNumFrom.setEntityViewInfo(view);
        this.promMaterialNumTo.setEntityViewInfo(view);
        this.promMaterialNumTo.getQueryAgent().resetRuntimeEntityView();
        this.promMaterialNumFrom.getQueryAgent().resetRuntimeEntityView();
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.promMaterialNumFrom, this.promMaterialNumTo});
    }

    private void RootingNumaddEntityView() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)"60", CompareType.EQUALS));
        try {
            this.promRootingNumFrom.getEntityViewInfo().getFilter().mergeFilter(filter, "and");
            this.promRootingNumTo.getEntityViewInfo().getFilter().mergeFilter(filter, "and");
            this.promRootingNumFrom.getQueryAgent().resetRuntimeEntityView();
            this.promRootingNumTo.getQueryAgent().resetRuntimeEntityView();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void setPersonFilter(KDBizPromptBox f7) {
        List<String> sStorageOrg = this.getStorageOrgFromF7(this.prmtStorageOrgUnit);
        HashSet<String> sAdminOrg = new HashSet<String>();
        HashSet tempAdminOrg = new HashSet();
        if (sStorageOrg.size() == 0) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", null));
        } else {
            for (int i = 0; i < sStorageOrg.size(); ++i) {
                tempAdminOrg = MMUtils.getAdminOrgByStorageOrg((String)sStorageOrg.get(i));
                if (tempAdminOrg.size() <= 0) continue;
                for (int j = 0; j < tempAdminOrg.size(); ++j) {
                    sAdminOrg.add((String)tempAdminOrg.toArray()[j]);
                }
            }
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (sAdminOrg.size() != 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", sAdminOrg, CompareType.INCLUDE));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", null));
        }
        viewInfo.setFilter(filterInfo);
        f7.setEntityViewInfo(viewInfo);
        f7.getQueryAgent().resetRuntimeEntityView();
    }

    private List<String> getStorageOrgFromF7(KDBizPromptBox prmtStorageOrgUnit) {
        ArrayList<String> sStorageOrg;
        block3: {
            Object[] storages;
            block4: {
                block2: {
                    sStorageOrg = new ArrayList<String>();
                    if (!(prmtStorageOrgUnit.getValue() instanceof StorageOrgUnitInfo)) break block2;
                    sStorageOrg.add(((StorageOrgUnitInfo)prmtStorageOrgUnit.getValue()).getId().toString());
                    break block3;
                }
                if (!(prmtStorageOrgUnit.getValue() instanceof LinkedHashSet)) break block4;
                LinkedHashSet set = (LinkedHashSet)prmtStorageOrgUnit.getValue();
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    sStorageOrg.add((String)it.next());
                }
                break block3;
            }
            if (!(prmtStorageOrgUnit.getValue() instanceof Object[]) || (storages = (Object[])prmtStorageOrgUnit.getValue()).length <= 0) break block3;
            for (int i = 0; i < storages.length; ++i) {
                sStorageOrg.add(((StorageOrgUnitInfo)storages[i]).getId().toString());
            }
        }
        return sStorageOrg;
    }

    protected void cancelF7Event(Object e) {
        if (e instanceof SelectorEvent) {
            ((SelectorEvent)e).setCanceled(true);
        } else if (e instanceof CommitEvent) {
            ((CommitEvent)e).setCanceled(true);
        }
    }

    public void setMoDepartmentF7(Object e, KDBizPromptBox prmtStorageOrgUnit, KDBizPromptBox bizOrgUnitBox) throws BOSException, EASBizException {
        List<String> sStorageOrg = this.getStorageOrgFromF7(prmtStorageOrgUnit);
        HashSet<String> sAdminOrg = new HashSet<String>();
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
        if (sStorageOrg.size() == 0) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("id", null));
        } else {
            for (int i = 0; i < sStorageOrg.size(); ++i) {
                OrgUnitCollection receiptOrgCol = iUnitRel.getToUnit(sStorageOrg.get(i), 4, 0);
                if (receiptOrgCol.size() <= 0) continue;
                for (int j = 0; j < receiptOrgCol.size(); ++j) {
                    sAdminOrg.add(((AdminOrgUnitInfo)receiptOrgCol.get(j)).getId().toString());
                }
            }
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (sAdminOrg.size() != 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", sAdminOrg, CompareType.INCLUDE));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", null));
        }
        viewInfo.setFilter(filterInfo);
        bizOrgUnitBox.setEntityViewInfo(viewInfo);
        bizOrgUnitBox.getQueryAgent().resetRuntimeEntityView();
    }
}

