/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BalanceAllocationRuleEnum;
import com.kingdee.eas.mm.basedata.PlanVersionSetInfo;
import com.kingdee.eas.mm.basedata.PlanningHorizonSetEntryCollection;
import com.kingdee.eas.mm.basedata.PlanningHorizonSetEntryInfo;
import com.kingdee.eas.mm.basedata.PlanningHorizonSetInfo;
import com.kingdee.eas.mm.basedata.PlanningHorizonUnitEnum;
import com.kingdee.eas.mm.common.MMCommonException;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.planning.app.mrp.MRPDynamicTableManager;
import com.kingdee.eas.mm.planning.app.mrp.MRPRunningTablesInfo;
import com.kingdee.eas.mm.report.util.PeriodDivideInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PlanerWorkUtil {
    public static final String KEY_STARTDATE = "startDate";
    public static final String KEY_ENDDATE = "endDate";
    public static final String MRP_RESOURCE_PATH = "com.kingdee.eas.mm.report.PlannerResource";

    public static String[] getTitleFields(StringBuffer sql, Context ctx, String[] para) throws BOSException {
        IRowSet rowStatus = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        int n = para.length;
        int i = 0;
        if (n > 0) {
            String[] fileds = new String[n];
            try {
                while (rowStatus.next()) {
                    for (i = 0; i <= n - 1; ++i) {
                        para[i] = rowStatus.getString(i + 1);
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            return fileds;
        }
        return null;
    }

    public static void clearStrings(String[] str) {
        for (int i = 0; i < str.length; ++i) {
            str[i] = "";
        }
    }

    public static String getFormatString(int scale) {
        String temp = "";
        for (int i = 0; i < scale; ++i) {
            temp = temp + '0';
        }
        if (scale >= 0) {
            temp = temp.equals("") ? "%r{#,##0}f" : "%r{#,##0." + temp + "}f";
        }
        return temp;
    }

    public static void checkNull(String[] str) {
        for (int i = 0; i < str.length; ++i) {
            if (str[i] != null) continue;
            str[i] = "";
        }
    }

    public static Timestamp getSCMQueryTime(Date d, String s) {
        Calendar calendar = Calendar.getInstance();
        if (d != null) {
            calendar.setTime(d);
        } else {
            calendar.setTime(SCMClientUtils.getServerDate2());
        }
        if (s.equalsIgnoreCase(KEY_STARTDATE)) {
            calendar.add(4, -1);
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
            calendar.set(14, 0);
        } else if (s.equalsIgnoreCase(KEY_ENDDATE)) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
            calendar.set(14, 999);
        }
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static String getString(Context ctx, String resourceName) {
        String strTemp = ResourceBase.getString((String)MRP_RESOURCE_PATH, (String)resourceName, (Locale)ctx.getLocale());
        if (strTemp.equals("Missing Resource")) {
            return "Missing Resource{" + resourceName + "}";
        }
        return strTemp;
    }

    public static Map getMRPRunningTables(Context ctx, String storageOrgUnitId, String planVersionId, boolean isFormal) throws EASBizException, BOSException {
        HashMap<String, String> tableMap = new HashMap<String, String>();
        List list = MRPDynamicTableManager.getTableName((Context)ctx, (String)storageOrgUnitId, (String)planVersionId, (boolean)isFormal);
        tableMap.put("material", ((MRPRunningTablesInfo)list.get(0)).getTableName());
        tableMap.put("detail", ((MRPRunningTablesInfo)list.get(1)).getTableName());
        return tableMap;
    }

    public static Object[] getUpdateParam(Date date, String reportDataId, List periodDivision) {
        Calendar calendar = PlanerWorkUtil.getCalendar(date);
        int year = calendar.get(1);
        int weekOfYear = calendar.get(3);
        String dayDispName = new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime());
        String monthDispName = new SimpleDateFormat("yyyy-MM").format(calendar.getTime());
        String weekDispName = String.valueOf(year) + ".W" + String.valueOf(weekOfYear);
        String displayName = null;
        int displayPeriod = 0;
        PeriodDivideInfo pdInfo = null;
        for (int i = 0; i < periodDivision.size(); ++i) {
            pdInfo = (PeriodDivideInfo)periodDivision.get(i);
            if (calendar.before(pdInfo.getStartDate()) || calendar.after(pdInfo.getEndDate())) continue;
            displayName = pdInfo.getDisplayName();
            displayPeriod = i;
            break;
        }
        Object[] param = new Object[]{new Integer(year), dayDispName, monthDispName, new Integer(weekOfYear), weekDispName, new Integer(displayPeriod), displayName, reportDataId};
        return param;
    }

    public static List calculatePeriodDivision(Date startDate, Date mrpDate, PlanVersionSetInfo pvInfo) {
        PeriodDivideInfo obj;
        PlanningHorizonSetInfo planHorizon = pvInfo.getPlanningHorizon();
        boolean isEqualCycle = planHorizon.isIsEqualCycle();
        PlanningHorizonUnitEnum horizonUnit = planHorizon.getCyclePeriodUnit();
        ArrayList<PeriodDivideInfo> periods = new ArrayList<PeriodDivideInfo>();
        Calendar divideDate = PlanerWorkUtil.getCalendar(startDate);
        Calendar mrpCalendar = PlanerWorkUtil.getCalendar(mrpDate);
        long interval = (mrpCalendar.getTimeInMillis() - divideDate.getTimeInMillis()) / 86400000L;
        divideDate.add(6, -1);
        Calendar endDate = (Calendar)divideDate.clone();
        endDate.add(6, planHorizon.getHorizonLength() + new Long(interval).intValue());
        Calendar lastDivideDate = (Calendar)divideDate.clone();
        PeriodDivideInfo pdInfo = null;
        Calendar entryEndDate = null;
        if (isEqualCycle) {
            while (divideDate.before(endDate)) {
                lastDivideDate.add(6, 1);
                PlanerWorkUtil.rollDate(divideDate, planHorizon.getCycleLength(), horizonUnit.getValue());
                pdInfo = new PeriodDivideInfo(lastDivideDate, (Calendar)divideDate.clone(), isEqualCycle, horizonUnit);
                periods.add(pdInfo);
                lastDivideDate = (Calendar)divideDate.clone();
            }
        } else {
            PlanningHorizonSetEntryCollection phsEntries = planHorizon.getEntries();
            PlanningHorizonSetEntryInfo phsEntry = null;
            entryEndDate = (Calendar)divideDate.clone();
            for (int i = 0; i < phsEntries.size(); ++i) {
                phsEntry = phsEntries.get(i);
                horizonUnit = phsEntry.getCyclePeriodShowUnit();
                PlanerWorkUtil.rollDate(entryEndDate, phsEntry.getPeriodLength(), phsEntry.getCyclePeriodDivideUnit().getValue());
                while (divideDate.before(entryEndDate) && divideDate.before(endDate)) {
                    lastDivideDate.add(6, 1);
                    PlanerWorkUtil.rollDate(divideDate, 1, phsEntry.getCyclePeriodShowUnit().getValue());
                    pdInfo = new PeriodDivideInfo(lastDivideDate, (Calendar)divideDate.clone(), isEqualCycle, horizonUnit);
                    periods.add(pdInfo);
                    lastDivideDate = (Calendar)divideDate.clone();
                }
                if (i >= phsEntries.size() - 1) continue;
                entryEndDate.setTime(divideDate.getTime());
            }
        }
        if (divideDate.after(endDate) && (entryEndDate == null || entryEndDate.before(endDate))) {
            if (BalanceAllocationRuleEnum.UNITEATLAST.equals((Object)planHorizon.getBalAllocRule())) {
                periods.remove(periods.size() - 1);
                obj = (PeriodDivideInfo)periods.get(periods.size() - 1);
                obj.setEndDate(endDate);
            } else if (BalanceAllocationRuleEnum.ADDCYCLE.equals((Object)planHorizon.getBalAllocRule())) {
                obj = (PeriodDivideInfo)periods.get(periods.size() - 1);
                obj.setDisplayName(EASResource.getString((String)MRP_RESOURCE_PATH, (String)"PERIOD_SUPLUS"));
                obj.setEndDate(endDate);
            } else {
                periods.remove(periods.size() - 1);
            }
        } else if (divideDate.before(endDate)) {
            if (BalanceAllocationRuleEnum.UNITEATLAST.equals((Object)planHorizon.getBalAllocRule())) {
                obj = (PeriodDivideInfo)periods.get(periods.size() - 1);
                obj.setEndDate(endDate);
            } else if (BalanceAllocationRuleEnum.ADDCYCLE.equals((Object)planHorizon.getBalAllocRule())) {
                lastDivideDate.add(6, 1);
                pdInfo = new PeriodDivideInfo(lastDivideDate, endDate, isEqualCycle, horizonUnit);
                pdInfo.setDisplayName(EASResource.getString((String)MRP_RESOURCE_PATH, (String)"PERIOD_SUPLUS"));
                periods.add(pdInfo);
            }
        }
        return periods;
    }

    private static void rollDate(Calendar date, int length, int periodUnit) {
        switch (periodUnit) {
            case 10: {
                date.add(6, length);
                break;
            }
            case 20: {
                int dayOfWeek = date.get(7);
                int maxOfWeek = date.getActualMaximum(7);
                if (dayOfWeek > 1) {
                    date.add(7, maxOfWeek + 1 - dayOfWeek);
                    date.add(3, length - 1);
                    break;
                }
                date.add(3, length);
                break;
            }
            case 40: {
                int dayOfMonth = date.get(5);
                int maxOfMonth = date.getActualMaximum(5);
                if (dayOfMonth > 1 && dayOfMonth < maxOfMonth) {
                    date.add(5, maxOfMonth - dayOfMonth);
                    date.add(2, length - 1);
                    break;
                }
                date.add(2, length);
                break;
            }
            default: {
                date.add(6, length);
            }
        }
    }

    private static Calendar getCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Calendar calendar1 = (Calendar)calendar.clone();
        calendar1.set(calendar.get(1), 0, 1);
        int firstDay = calendar1.get(7);
        int minimalDaysInFirstWeek = 1;
        if (firstDay > 1) {
            minimalDaysInFirstWeek = calendar1.getMaximum(7) - firstDay + 2;
        }
        calendar.setMinimalDaysInFirstWeek(minimalDaysInFirstWeek);
        return calendar;
    }

    public static void testTempTable(Context ctx, String tableName) throws Exception {
        String testSql = "select top 1 * from " + tableName;
        try {
            SQLUtils.executeQuery((Context)ctx, (String)testSql);
        }
        catch (Exception e) {
            MMCommonException commonExcp = new MMCommonException(MMCommonException.TEMPTABLE_NOT_EXIST);
            if (e instanceof SQLException) {
                throw commonExcp;
            }
            for (Throwable exception = e.getCause(); exception != null; exception = exception.getCause()) {
                if (!(exception instanceof SQLException)) continue;
                throw commonExcp;
            }
            throw e;
        }
    }
}

