/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.mm.sfc.AssistantTimeReportEntryCollection;
import com.kingdee.eas.mm.sfc.AssistantTimeReportEntryInfo;
import com.kingdee.eas.mm.sfc.AssistantTimeReportFactory;
import com.kingdee.eas.mm.sfc.AssistantTimeReportInfo;
import com.kingdee.eas.mm.sfc.CountWagesWayEnum;
import com.kingdee.eas.mm.sfc.IAssistantTimeReport;
import com.kingdee.eas.mm.sfc.SalaryCaculateEnum;
import com.kingdee.eas.mm.sfc.client.AbstractAssistantTimeReportCostAlterUI;
import com.kingdee.eas.mm.sfc.client.AssistantTimeReportEditUI;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class AssistantTimeReportCostAlterUI
extends AbstractAssistantTimeReportCostAlterUI {
    private static final Logger logger = CoreUIObject.getLogger(AssistantTimeReportCostAlterUI.class);
    private final Color COLOR_YELLOW = new Color(252, 251, 223);
    private final Color COLOR_WHITE = new Color(255, 255, 255);
    private static final String TB_CLASSGROUP = "classGroup";
    private static final String TB_PERSON = "person";
    private static final String TB_ASSTIMETYPE = "assistantTimeType";
    private static final String TB_TIME = "workTime";
    private static final String TB_UNIT = "timeUnit";
    private static final String TB_LABORCOST = "laborCost";
    private static final String TB_LABORCOSTUNIT = "laborCostUnit";
    private static final String TB_DATE = "date";
    private static final String TB_PROJECT = "projectNum";
    private static final String TB_TRACKNUM = "trackNum";
    private static final String TB_MATERIAL = "material";
    private static final String TB_MATERIALNAME = "materialName";
    private static final String TB_MODEL = "model";
    private static final String TB_REMARK = "remark";
    private static final String TB_SALARYCACULATEFLAG = "salaryCaculateFlag";
    private static final String TB_WAGEACCOUNTFORM = "wagesAccountForm";
    private static final String TB_ID = "id";

    public AssistantTimeReportCostAlterUI() throws Exception {
        this.KDTable.checkParsed();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        KDFormattedTextField kdtEntries_workTime_TextField = new KDFormattedTextField();
        kdtEntries_workTime_TextField.setName("kdtEntries_workTime_TextField");
        kdtEntries_workTime_TextField.setVisible(true);
        kdtEntries_workTime_TextField.setEditable(true);
        kdtEntries_workTime_TextField.setHorizontalAlignment(2);
        kdtEntries_workTime_TextField.setDataType(1);
        kdtEntries_workTime_TextField.setMinimumValue((Comparable)new BigDecimal("-1.0E13"));
        kdtEntries_workTime_TextField.setMaximumValue((Comparable)new BigDecimal("1.0E13"));
        kdtEntries_workTime_TextField.setPrecision(8);
        kdtEntries_workTime_TextField.setNegatived(false);
        KDTDefaultCellEditor kdtEntries_workTime_CellEditor = new KDTDefaultCellEditor((JTextField)kdtEntries_workTime_TextField);
        this.KDTable.getColumn(TB_TIME).setEditor((ICellEditor)kdtEntries_workTime_CellEditor);
        KDFormattedTextField kdtEntries_laborCost_TextField = new KDFormattedTextField();
        kdtEntries_laborCost_TextField.setName("kdtEntries_laborCost_TextField");
        kdtEntries_laborCost_TextField.setVisible(true);
        kdtEntries_laborCost_TextField.setEditable(true);
        kdtEntries_laborCost_TextField.setHorizontalAlignment(2);
        kdtEntries_laborCost_TextField.setDataType(1);
        kdtEntries_laborCost_TextField.setPrecision(8);
        kdtEntries_laborCost_TextField.setNegatived(false);
        KDTDefaultCellEditor kdtEntries_laborCost_CellEditor = new KDTDefaultCellEditor((JTextField)kdtEntries_laborCost_TextField);
        this.KDTable.getColumn(TB_LABORCOST).setEditor((ICellEditor)kdtEntries_laborCost_CellEditor);
        this.KDTable.setUserObject((Object)this.getEditableRows());
        this.loadTable();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.KDTable.getColumn(TB_DATE).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
    }

    protected List getEditableRows() {
        ArrayList<AssistantTimeReportEntryInfo> editableList = new ArrayList<AssistantTimeReportEntryInfo>();
        AssistantTimeReportInfo atrInfo = (AssistantTimeReportInfo)this.getUIContext().get("uiObject");
        AssistantTimeReportEntryCollection entryCol = atrInfo.getEntry();
        if (entryCol != null) {
            for (int i = 0; i < entryCol.size(); ++i) {
                AssistantTimeReportEntryInfo entryInfo = entryCol.get(i);
                if (!SalaryCaculateEnum.CAN_CACULATE.equals((Object)entryInfo.getSalaryCaculateFlag())) continue;
                editableList.add(entryInfo);
            }
        } else {
            return null;
        }
        return editableList;
    }

    protected void loadTable() {
        this.KDTable.removeRows();
        List list = (List)this.KDTable.getUserObject();
        if (list != null) {
            for (AssistantTimeReportEntryInfo entryInfo : list) {
                this.initRowData(entryInfo);
            }
        }
    }

    protected void initRowData(AssistantTimeReportEntryInfo entryInfo) {
        IRow newRow = null;
        if (entryInfo != null) {
            this.KDTable.checkParsed();
            newRow = this.KDTable.addRow();
            newRow.getCell(TB_ID).setValue(entryInfo.getId() != null ? entryInfo.getId().toString() : null);
            newRow.getCell(TB_WAGEACCOUNTFORM).setValue((Object)entryInfo.getWagesAccountForm());
            newRow.getCell(TB_CLASSGROUP).setValue(entryInfo.getClassGroup() != null ? entryInfo.getClassGroup().getName() : null);
            newRow.getCell(TB_PERSON).setValue(entryInfo.getPerson() != null ? entryInfo.getPerson().getName() : null);
            newRow.getCell(TB_SALARYCACULATEFLAG).setValue((Object)entryInfo.getSalaryCaculateFlag());
            newRow.getCell(TB_ASSTIMETYPE).setValue(entryInfo.getAssistantTimeType() != null ? entryInfo.getAssistantTimeType().getName() : null);
            newRow.getCell(TB_TIME).setValue((Object)entryInfo.getWorkTime());
            newRow.getCell(TB_TIME).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
            newRow.getCell(TB_UNIT).setValue((Object)entryInfo.getTimeUnit());
            newRow.getCell(TB_LABORCOST).setValue((Object)entryInfo.getLaborCost());
            newRow.getCell(TB_LABORCOST).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
            newRow.getCell(TB_LABORCOSTUNIT).setValue((Object)entryInfo.getLaborCostUnit());
            newRow.getCell(TB_DATE).setValue((Object)entryInfo.getDate());
            newRow.getCell(TB_TRACKNUM).setValue(entryInfo.getTrackNum() != null ? entryInfo.getTrackNum().getNumber() : null);
            newRow.getCell(TB_PROJECT).setValue(entryInfo.getProjectNum() != null ? entryInfo.getProjectNum().getNumber() : null);
            newRow.getCell(TB_MATERIAL).setValue(entryInfo.getMaterial() != null ? entryInfo.getMaterial().getNumber() : null);
            newRow.getCell(TB_MATERIALNAME).setValue(entryInfo.getMaterial() != null ? entryInfo.getMaterial().getName() : null);
            newRow.getCell(TB_MODEL).setValue(entryInfo.getMaterial() != null ? entryInfo.getMaterial().getModel() : null);
            newRow.getCell(TB_REMARK).setValue((Object)entryInfo.getRemark());
            if (CountWagesWayEnum.PERSON.equals((Object)entryInfo.getWagesAccountForm())) {
                newRow.getCell(TB_CLASSGROUP).getStyleAttributes().setBackground(this.COLOR_WHITE);
                newRow.getCell(TB_PERSON).getStyleAttributes().setBackground(this.COLOR_YELLOW);
            } else {
                newRow.getCell(TB_PERSON).getStyleAttributes().setBackground(this.COLOR_WHITE);
                newRow.getCell(TB_CLASSGROUP).getStyleAttributes().setBackground(this.COLOR_YELLOW);
            }
        }
    }

    protected Map getNewData() {
        HashMap caInfoMap = new HashMap();
        AssistantTimeReportEditUI parentUI = (AssistantTimeReportEditUI)((Object)this.getUIContext().get("ATREditUI"));
        AssistantTimeReportInfo atrInfo = (AssistantTimeReportInfo)this.getUIContext().get("uiObject");
        AssistantTimeReportEntryCollection entryCol = atrInfo.getEntry();
        if (entryCol != null) {
            for (int i = 0; i < entryCol.size(); ++i) {
                AssistantTimeReportEntryInfo entryInfo = entryCol.get(i);
                if (entryInfo == null) continue;
                this.loadNewData(entryInfo, caInfoMap);
            }
        }
        parentUI.getUIContext().put("newData", atrInfo);
        return caInfoMap;
    }

    private void loadNewData(AssistantTimeReportEntryInfo entryInfo, Map caInfoMap) {
        String entryId = entryInfo.getId().toString();
        if (this.KDTable != null && this.KDTable.getRowCount() > 0) {
            for (int i = 0; i < this.KDTable.getRowCount(); ++i) {
                if (this.KDTable.getCell(i, TB_ID).getValue() == null || !entryId.equals(this.KDTable.getCell(i, TB_ID).getValue().toString())) continue;
                entryInfo.setLaborCost(this.KDTable.getCell(i, TB_LABORCOST).getValue() != null ? (BigDecimal)this.KDTable.getCell(i, TB_LABORCOST).getValue() : new BigDecimal("0.00"));
                entryInfo.setWorkTime(this.KDTable.getCell(i, TB_TIME).getValue() != null ? (BigDecimal)this.KDTable.getCell(i, TB_TIME).getValue() : new BigDecimal("0.00"));
                caInfoMap.put(entryId, entryInfo);
                break;
            }
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        Map caInfoMap = this.getNewData();
        IAssistantTimeReport IAtr = AssistantTimeReportFactory.getRemoteInstance();
        if (caInfoMap != null) {
            IAtr.costAlter(caInfoMap);
        }
        super.destroyWindow();
    }

    @Override
    public void actionEsc_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    public boolean destroyWindow() {
        AssistantTimeReportEditUI parentUI = (AssistantTimeReportEditUI)((Object)this.getUIContext().get("ATREditUI"));
        parentUI.getUIContext().put("newData", this.getUIContext().get("uiObject"));
        return super.destroyWindow();
    }
}

