/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.mm.basedata.AssistantWorkCategoryInfo;
import com.kingdee.eas.mm.basedata.OprTimeUnitEnum;
import com.kingdee.eas.mm.common.client.KDTableUtils;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.sfc.AssistantTimeReportEntryInfo;
import com.kingdee.eas.mm.sfc.AssistantTimeReportFactory;
import com.kingdee.eas.mm.sfc.AssistantTimeReportInfo;
import com.kingdee.eas.mm.sfc.CountWagesWayEnum;
import com.kingdee.eas.mm.sfc.SalaryCaculateEnum;
import com.kingdee.eas.mm.sfc.client.AbstractAssistantTimeReportEditUI;
import com.kingdee.eas.mm.sfc.client.AssistantTimeReportCostAlterUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.ActionProxyFactory;
import com.kingdee.eas.scm.common.action.ISupportBatchAction;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class AssistantTimeReportEditUI
extends AbstractAssistantTimeReportEditUI {
    private static final Logger logger = CoreUIObject.getLogger(AssistantTimeReportEditUI.class);
    private static final String resource = "com.kingdee.eas.mm.sfc.AssistantTimeReportResource";
    public static final String ASSISTANTTIMEREPORT_BILLTYPEID = "n0SwvzJuRMzgQAB/AQB9lEY+1VI=";
    private final Color COLOR_YELLOW = new Color(252, 251, 223);
    private final Color COLOR_WHITE = new Color(255, 255, 255);
    private static final String TB_CLASSGROUP = "classGroup";
    private static final String TB_PERSON = "person";
    private static final String TB_ASSTIMETYPE = "assistantTimeType";
    private static final String TB_TIME = "workTime";
    private static final String TB_UNIT = "timeUnit";
    private static final String TB_LABORCOST = "laborCost";
    private static final String TB_LABORCOSTUNIT = "laborCostUnit";
    private static final String TB_DATE = "date";
    private static final String TB_PROJECT = "projectNum";
    private static final String TB_TRACKNUM = "trackNum";
    private static final String TB_MATERIAL = "material";
    private static final String TB_MATERIALNAME = "materialName";
    private static final String TB_MODEL = "model";
    private static final String TB_REMARK = "remark";
    private static final String TB_SALARYCACULATEFLAG = "salaryCaculateFlag";
    private static final String TB_WAGEACCOUNTFORM = "wagesAccountForm";
    private static final String[] columnsConstant = new String[]{"classGroup", "person", "assistantTimeType", "workTime", "timeUnit", "laborCost", "laborCostUnit", "date", "projectNum", "trackNum", "material", "materialName", "model", "remark", "salaryCaculateFlag", "wagesAccountForm"};
    private DataChangeListener storageOrgChangeListener = null;
    private DataChangeListener departmentChangeListener = null;
    private KDTEditAdapter entryChangeKDTEditAdapter;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initControlType();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_sfc_ATReportAddNew");
        StorageOrgUnitInfo storage = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        this.kdtEntries.getActionMap().remove("Paste");
        this.chkMenuItemSubmitAndAddNew.setText(this.chkMenuItemSubmitAndAddNew.getText() + "(F)");
        this.menuSubmitOption.setIcon(EASResource.getIcon((String)"imgTbtn_descryrefer"));
        this.setMaterialFilter(storage);
        this.setDepartmentFilter(storage);
        this.setAssTimeTypeFilter(storage);
        this.kdtEntries.getColumn(TB_DATE).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        KDTextField txtInput = new KDTextField();
        txtInput.setMaxLength(400);
        this.kdtEntries.getColumn(TB_REMARK).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtInput));
        UIHelper.registerProjectF7((KDBizPromptBox)this.getMainOrgUnit(), null, (KDTable)this.getDetailTable(), (String)TB_PROJECT);
        UIHelper.registerTrackNumberF7((KDBizPromptBox)this.getMainOrgUnit(), null, (KDTable)this.getDetailTable(), (String)TB_PROJECT, (String)TB_TRACKNUM, (boolean)false);
        this.btnAuditResult.setVisible(false);
        this.separatorFW2.setVisible(false);
        this.setLaborCostPrecision(new String[]{TB_LABORCOST}, 8);
        this.registerPersonF7();
        this.registerClassGroupF7();
        super.setReservationVisible(false);
    }

    protected void addListener() {
        if (this.storageOrgChangeListener == null) {
            this.storageOrgChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    AssistantTimeReportEditUI.this.storageOrgChanged(e);
                }
            };
        }
        if (this.departmentChangeListener == null) {
            this.departmentChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    AssistantTimeReportEditUI.this.departmentChanged(e);
                }
            };
        }
        this.entryChangeKDTEditAdapter = new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                AssistantTimeReportEditUI.this.kdtEntries_editStarting(e);
            }

            public void editStopped(KDTEditEvent e) {
                try {
                    AssistantTimeReportEditUI.this.kdtEntries_Changed(e);
                }
                catch (Exception exc) {
                    AssistantTimeReportEditUI.this.handUIException(exc);
                }
            }
        };
        this.prmtStorageOrgUnit.addDataChangeListener(this.storageOrgChangeListener);
        this.prmtDepartment.addDataChangeListener(this.departmentChangeListener);
        this.kdtEntries.addKDTEditListener((KDTEditListener)this.entryChangeKDTEditAdapter);
    }

    protected void removeListener() {
        if (this.storageOrgChangeListener != null) {
            this.prmtStorageOrgUnit.removeDataChangeListener(this.storageOrgChangeListener);
        }
        if (this.departmentChangeListener != null) {
            this.prmtDepartment.removeDataChangeListener(this.departmentChangeListener);
        }
        if (this.entryChangeKDTEditAdapter != null) {
            this.kdtEntries.removeKDTEditListener((KDTEditListener)this.entryChangeKDTEditAdapter);
        }
    }

    protected void departmentChanged(DataChangeEvent e) {
        AdminOrgUnitInfo newDepartment;
        AdminOrgUnitInfo oldDepartment = (AdminOrgUnitInfo)e.getOldValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldDepartment, (Object)(newDepartment = (AdminOrgUnitInfo)e.getNewValue()));
        if (!isDiffrent) {
            return;
        }
        if (oldDepartment != null && this.kdtEntries != null && this.kdtEntries.getRowCount() > 0) {
            int result = MsgBox.showConfirm2((Component)this.prmtDepartment, (String)this.getResource("INFO_DEPT_CHANGE"));
            if (result == 0) {
                this.kdtEntries.removeRows();
            } else {
                this.prmtDepartment.setDataNoNotify((Object)oldDepartment);
            }
        }
    }

    private void storageOrgChanged(DataChangeEvent e) {
        StorageOrgUnitInfo newStorage;
        StorageOrgUnitInfo oldStorage = (StorageOrgUnitInfo)e.getOldValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldStorage, (Object)(newStorage = (StorageOrgUnitInfo)e.getNewValue()));
        if (isDiffrent) {
            if (this.prmtDepartment.getValue() != null) {
                int result = MsgBox.showConfirm2((Component)this.prmtStorageOrgUnit, (String)this.getResource("INFO_STORAGEORG_CHANGE"));
                if (result == 0) {
                    this.prmtDepartment.setDataNoNotify(null);
                    this.prmtCurrency.setValue(null);
                    this.kdtEntries.removeRows();
                    this.setDepartmentFilter(newStorage);
                    this.setCurrencyFilter(newStorage);
                    this.setAssTimeTypeFilter(newStorage);
                    this.setMaterialFilter(newStorage);
                } else {
                    this.prmtStorageOrgUnit.setDataNoNotify((Object)oldStorage);
                }
            }
        } else {
            return;
        }
        StorageOrgUnitInfo storageInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        this.setDepartmentFilter(storageInfo);
        this.setCurrencyFilter(storageInfo);
        this.setAssTimeTypeFilter(storageInfo);
        this.setMaterialFilter(storageInfo);
    }

    protected void kdtEntries_editStarting(KDTEditEvent e) {
        int colIndex = e.getColIndex();
        String fieldName = this.kdtEntries.getColumnKey(colIndex);
        for (int i = 0; i < columnsConstant.length; ++i) {
            if (!columnsConstant[i].equalsIgnoreCase(fieldName) || this.prmtDepartment.getValue() != null) continue;
            MsgBox.showInfo((String)this.getResource("DepartmentNotNull"));
            SysUtil.abort();
        }
    }

    protected void kdtEntries_Changed(KDTEditEvent e) {
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getOldValue(), (Object)e.getValue());
        if (isDiffrent) {
            int i;
            AssistantTimeReportEntryInfo entryInfo;
            IRow row;
            Object cellData;
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            String fieldName = this.kdtEntries.getColumnKey(colIndex);
            if (TB_ASSTIMETYPE.equals(fieldName)) {
                AssistantWorkCategoryInfo awcInfo = (AssistantWorkCategoryInfo)this.kdtEntries.getCell(rowIndex, colIndex).getValue();
                if (awcInfo == null) {
                    this.kdtEntries.getCell(rowIndex, TB_LABORCOST).setValue(null);
                    this.kdtEntries.getCell(rowIndex, TB_LABORCOSTUNIT).setValue(null);
                } else {
                    this.kdtEntries.getCell(rowIndex, TB_LABORCOST).setValue((Object)awcInfo.getLaborCost());
                    this.kdtEntries.getCell(rowIndex, TB_LABORCOSTUNIT).setValue((Object)awcInfo.getLaborCostUnit());
                }
            }
            if (TB_MATERIAL.equalsIgnoreCase(fieldName)) {
                MaterialInfo materialInfo = (MaterialInfo)this.kdtEntries.getCell(rowIndex, colIndex).getValue();
                if (materialInfo == null) {
                    this.kdtEntries.getCell(rowIndex, TB_MATERIALNAME).setValue(null);
                    this.kdtEntries.getCell(rowIndex, TB_MODEL).setValue(null);
                } else {
                    this.kdtEntries.getCell(rowIndex, TB_MATERIALNAME).setValue((Object)materialInfo.getName());
                    this.kdtEntries.getCell(rowIndex, TB_MODEL).setValue((Object)materialInfo.getModel());
                }
            }
            if (TB_WAGEACCOUNTFORM.equalsIgnoreCase(fieldName)) {
                if (CountWagesWayEnum.PERSON == (CountWagesWayEnum)((Object)this.kdtEntries.getCell(rowIndex, colIndex).getValue())) {
                    this.kdtEntries.getCell(rowIndex, TB_CLASSGROUP).setValue(null);
                    this.kdtEntries.getCell(rowIndex, TB_CLASSGROUP).getStyleAttributes().setLocked(true);
                    this.kdtEntries.getCell(rowIndex, TB_CLASSGROUP).getStyleAttributes().setBackground(this.COLOR_WHITE);
                    this.kdtEntries.getCell(rowIndex, TB_PERSON).getStyleAttributes().setBackground(this.COLOR_YELLOW);
                    this.kdtEntries.getCell(rowIndex, TB_PERSON).getStyleAttributes().setLocked(false);
                } else {
                    this.kdtEntries.getCell(rowIndex, TB_PERSON).setValue(null);
                    this.kdtEntries.getCell(rowIndex, TB_PERSON).getStyleAttributes().setLocked(true);
                    this.kdtEntries.getCell(rowIndex, TB_PERSON).getStyleAttributes().setBackground(this.COLOR_WHITE);
                    this.kdtEntries.getCell(rowIndex, TB_CLASSGROUP).getStyleAttributes().setBackground(this.COLOR_YELLOW);
                    this.kdtEntries.getCell(rowIndex, TB_CLASSGROUP).getStyleAttributes().setLocked(false);
                }
            }
            if (TB_PERSON.equalsIgnoreCase(fieldName) && (cellData = this.kdtEntries.getCell(rowIndex, colIndex).getValue()) instanceof Object[]) {
                Object[] personList = (Object[])cellData;
                row = null;
                entryInfo = null;
                for (i = 1; i < personList.length; ++i) {
                    row = this.kdtEntries.addRow(rowIndex + i);
                    entryInfo = (AssistantTimeReportEntryInfo)this.createNewDetailData(this.kdtEntries);
                    entryInfo.put(TB_PERSON, personList[i]);
                    this.loadLineFields(this.kdtEntries, row, (IObjectValue)entryInfo);
                }
                this.kdtEntries.getCell(rowIndex, fieldName).setValue(personList[0]);
            }
            if (TB_CLASSGROUP.equalsIgnoreCase(fieldName) && (cellData = this.kdtEntries.getCell(rowIndex, colIndex).getValue()) instanceof Object[]) {
                Object[] classGroupList = (Object[])cellData;
                row = null;
                entryInfo = null;
                for (i = 1; i < classGroupList.length; ++i) {
                    row = this.kdtEntries.addRow(rowIndex + i);
                    entryInfo = (AssistantTimeReportEntryInfo)this.createNewDetailData(this.kdtEntries);
                    entryInfo.put(TB_CLASSGROUP, classGroupList[i]);
                    entryInfo.put(TB_WAGEACCOUNTFORM, (Object)CountWagesWayEnum.GROUP);
                    this.loadLineFields(this.kdtEntries, row, (IObjectValue)entryInfo);
                }
                this.kdtEntries.getCell(rowIndex, fieldName).setValue(classGroupList[0]);
            }
        }
    }

    private void setMaterialFilter(StorageOrgUnitInfo storage) {
        KDBizPromptBox prmtMaterial = new KDBizPromptBox();
        prmtMaterial.setDisplayFormat("$number$");
        prmtMaterial.setEditFormat("$number$");
        prmtMaterial.setCommitFormat("$number$");
        KDTDefaultCellEditor materialCellEditor = new KDTDefaultCellEditor((IKDEditor)prmtMaterial);
        this.getDetailTable().getColumn(TB_MATERIAL).setEditor((ICellEditor)materialCellEditor);
        ObjectValueRender materialOVR = new ObjectValueRender();
        materialOVR.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.getDetailTable().getColumn(TB_MATERIAL).setRenderer((IBasicRender)materialOVR);
        String queryInfo = UIHelper.getMaterialPlanQuery((int)this.f7Manager.getF7DisplayMode());
        this.f7Manager.registerBizMaterialF7(prmtMaterial, null, queryInfo, (OrgUnitInfo)storage, OrgType.Storage, false, true);
    }

    private void setCurrencyFilter(StorageOrgUnitInfo storage) {
        if (storage != null) {
            CompanyOrgUnitInfo companyOrgInfo = MMUtils.getCompanyOrgByStorageOrg((String)storage.getId().toString());
            try {
                if (companyOrgInfo != null) {
                    CurrencyInfo currencyInfo = (CurrencyInfo)CurrencyFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(companyOrgInfo.getBaseCurrency().getId()));
                    this.prmtCurrency.setValue((Object)currencyInfo);
                }
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    private void setDepartmentFilter(StorageOrgUnitInfo storage) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (storage != null) {
            HashSet adminOrgIdSet = new HashSet();
            adminOrgIdSet = MMUtils.getAdminOrgByStorageOrg((String)storage.getId().toString());
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)adminOrgIdSet, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", null));
        }
        view.setFilter(filter);
        this.prmtDepartment.setEntityViewInfo(view);
    }

    private void setAssTimeTypeFilter(StorageOrgUnitInfo storage) {
        KDBizPromptBox prmtAssTimeType = (KDBizPromptBox)((KDTDefaultCellEditor)this.getDetailTable().getColumn(TB_ASSTIMETYPE).getEditor()).getComponent();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (storage != null) {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storage.getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(20), CompareType.EQUALS));
            view.setFilter(filter);
            prmtAssTimeType.setEntityViewInfo(view);
        }
    }

    private void initControlType() {
        KDBizPromptBox kdtEntries_projectNum_PromptBox = new KDBizPromptBox();
        kdtEntries_projectNum_PromptBox.setQueryInfo("com.kingdee.eas.mm.project.app.F7ProjectQuery");
        kdtEntries_projectNum_PromptBox.setVisible(true);
        kdtEntries_projectNum_PromptBox.setEditable(true);
        kdtEntries_projectNum_PromptBox.setDisplayFormat("$number$");
        kdtEntries_projectNum_PromptBox.setEditFormat("$number$");
        kdtEntries_projectNum_PromptBox.setCommitFormat("$number$");
        KDTDefaultCellEditor kdtEntries_projectNum_CellEditor = new KDTDefaultCellEditor((IKDEditor)kdtEntries_projectNum_PromptBox);
        this.kdtEntries.getColumn(TB_PROJECT).setEditor((ICellEditor)kdtEntries_projectNum_CellEditor);
        ObjectValueRender kdtEntries_projectNum_OVR = new ObjectValueRender();
        kdtEntries_projectNum_OVR.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntries.getColumn(TB_PROJECT).setRenderer((IBasicRender)kdtEntries_projectNum_OVR);
        KDFormattedTextField kdtEntries_workTime_TextField = new KDFormattedTextField();
        kdtEntries_workTime_TextField.setName("kdtEntries_workTime_TextField");
        kdtEntries_workTime_TextField.setVisible(true);
        kdtEntries_workTime_TextField.setEditable(true);
        kdtEntries_workTime_TextField.setHorizontalAlignment(2);
        kdtEntries_workTime_TextField.setDataType(1);
        kdtEntries_workTime_TextField.setMinimumValue((Comparable)new BigDecimal("-1.0E13"));
        kdtEntries_workTime_TextField.setMaximumValue((Comparable)new BigDecimal("1.0E13"));
        kdtEntries_workTime_TextField.setPrecision(2);
        kdtEntries_workTime_TextField.setNegatived(false);
        KDTDefaultCellEditor kdtEntries_workTime_CellEditor = new KDTDefaultCellEditor((JTextField)kdtEntries_workTime_TextField);
        this.kdtEntries.getColumn(TB_TIME).setEditor((ICellEditor)kdtEntries_workTime_CellEditor);
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, AssistantTimeReportFactory.class);
        this.getTableSelectionHelper().setTableProperty((ISupportBatchAction)this, this.kdtEntries, "id", this.txtNumber, null);
        ActionProxy actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.SUBMIT, (ItemAction)this.actionSubmit, (String)"submitRelations", (ContextTypeEnum)this.actionManager.getContextType());
        this.actionManager.registerBatchAction(actionProxy, "actionSubmit");
        actionProxy.bindTo((AbstractButton)this.btnSubmit);
        actionProxy.bindTo((AbstractButton)this.menuItemSubmit);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.AUDIT, (ItemAction)this.actionAudit, (String)"audit");
        this.actionManager.registerBatchAction(actionProxy, "actionAudit");
        actionProxy.bindTo((AbstractButton)this.btnAudit);
        actionProxy.bindTo((AbstractButton)this.menuItemAudit);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.UNAUDIT, (ItemAction)this.actionUnAudit, (String)"unAudit");
        this.actionManager.registerBatchAction(actionProxy, "actionUnAudit");
        actionProxy.bindTo((AbstractButton)this.btnUnAudit);
        actionProxy.bindTo((AbstractButton)this.menuItemUnAudit);
    }

    @Override
    public void actionCopyLine_actionPerformed(ActionEvent e) throws Exception {
        KDTable table = this.getDetailTable();
        if (table == null) {
            return;
        }
        KDTSelectManager manager = table.getSelectManager();
        if (manager.getBlocks().size() > 0 && table.getRowCount() > 0) {
            ICell cellId;
            KDTSelectBlock selectedBlock = (KDTSelectBlock)manager.getBlocks().get(0);
            int beginBlockRow = selectedBlock.getBeginRow();
            int endBlockRow = selectedBlock.getEndRow();
            if (manager.getBlocks().size() > 1 || beginBlockRow != endBlockRow) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MultiRows"));
                return;
            }
            IRow copyFromRowObj = null;
            IRow copyToRowObj = table.addRow(endBlockRow + 1);
            this.appendFootRow(this.getDetailTable());
            int copyFromRowIndex = 0;
            copyFromRowIndex = selectedBlock.getEndRow();
            if (copyFromRowIndex < 0) {
                copyFromRowIndex = 0;
            }
            copyFromRowObj = table.getRow(copyFromRowIndex);
            for (int cellIndex = 0; cellIndex < table.getColumnCount(); ++cellIndex) {
                ICell copyFromCell = copyFromRowObj.getCell(cellIndex);
                ICell copyToCell = copyToRowObj.getCell(cellIndex);
                if (copyFromCell == null || copyToCell == null) continue;
                Object orgValue = copyFromCell.getValue();
                copyToCell.setValue(orgValue);
                copyToCell.getStyleAttributes().setLocked(copyFromCell.getStyleAttributes().isLocked());
                copyToCell.getStyleAttributes().setBackground(copyFromCell.getStyleAttributes().getBackground());
            }
            if (this.getSubKeyFieldName() != null && (cellId = copyToRowObj.getCell(this.getSubKeyFieldName())) != null) {
                cellId.setValue(null);
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneRow"));
            return;
        }
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        if (this.kdtEntries != null && this.kdtEntries.getRowCount() > 0) {
            int rows = this.kdtEntries.getRowCount();
            for (int i = 0; i < rows; ++i) {
                IRow row = this.kdtEntries.getRow(i);
                if (row == null) continue;
                row.getCell(TB_SALARYCACULATEFLAG).setValue((Object)SalaryCaculateEnum.NOT_CANCACULATE);
                this.setGroupAndPersonEditable(row);
            }
        }
        this.pkSalaryCalDate.setValue(null);
        this.setEntryOperateBtnStatus(true);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        if (this.kdtEntries != null && this.kdtEntries.getRowCount() > 0) {
            int rows = this.kdtEntries.getRowCount();
            for (int i = 0; i < rows; ++i) {
                IRow row = this.kdtEntries.getRow(i);
                if (row == null) continue;
                this.setGroupAndPersonEditable(row);
            }
        }
    }

    protected String getBillTypeId() {
        super.getBillTypeId();
        return ASSISTANTTIMEREPORT_BILLTYPEID;
    }

    protected boolean isModifySave() {
        return this.editData.getBaseStatus() != BillBaseStatusEnum.SUBMITED;
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        super.loadLineFields(table, row, obj);
        if (obj instanceof AssistantTimeReportEntryInfo) {
            AssistantTimeReportEntryInfo atrEntryInfo = (AssistantTimeReportEntryInfo)obj;
            if (CountWagesWayEnum.PERSON == atrEntryInfo.getWagesAccountForm()) {
                row.getCell(TB_CLASSGROUP).getStyleAttributes().setLocked(true);
                row.getCell(TB_CLASSGROUP).getStyleAttributes().setBackground(this.COLOR_WHITE);
                row.getCell(TB_PERSON).getStyleAttributes().setBackground(this.COLOR_YELLOW);
                row.getCell(TB_PERSON).getStyleAttributes().setLocked(false);
            } else {
                row.getCell(TB_PERSON).getStyleAttributes().setLocked(true);
                row.getCell(TB_PERSON).getStyleAttributes().setBackground(this.COLOR_WHITE);
                row.getCell(TB_CLASSGROUP).getStyleAttributes().setBackground(this.COLOR_YELLOW);
                row.getCell(TB_CLASSGROUP).getStyleAttributes().setLocked(false);
            }
        }
    }

    private void registerPersonF7() {
        KDBizPromptBox personBox = new KDBizPromptBox();
        personBox.setEnabledMultiSelection(true);
        personBox.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
        personBox.setDisplayFormat("$number$");
        personBox.setEditFormat("$number$");
        personBox.setCommitFormat("$number$;$idNum$");
        HashMap<String, Object> hash = new HashMap<String, Object>();
        hash.put("DEFAULT_SHOW_ALL", "DEFAULT_SHOW_ALL");
        hash.put("IS_SINGLE_SELECT", new Boolean(false));
        hash.put("0", "2");
        hash.put("UserBizOrgRangeAdminOrg", new Boolean(true));
        hash.put("UserAndCuAdminOrgRange", new Boolean(false));
        hash.put("UserAdminOrgRange", new Boolean(false));
        PersonPromptBox selector = new PersonPromptBox((IUIObject)this, hash);
        personBox.setSelector((KDPromptSelector)selector);
        personBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                AssistantTimeReportEditUI.this.prmtPersonChanged(AssistantTimeReportEditUI.TB_PERSON, e);
            }
        });
        KDTDefaultCellEditor person_CellEditor = new KDTDefaultCellEditor((IKDEditor)personBox);
        this.kdtEntries.getColumn(TB_PERSON).setEditor((ICellEditor)person_CellEditor);
    }

    private void registerClassGroupF7() {
        final KDBizPromptBox classGroupBox = (KDBizPromptBox)this.kdtEntries.getColumn(TB_CLASSGROUP).getEditor().getComponent();
        classGroupBox.setEnabledMultiSelection(true);
        classGroupBox.setQueryInfo("com.kingdee.eas.mm.basedata.app.F7ClassGroupQuery");
        classGroupBox.setDisplayFormat("$number$");
        classGroupBox.setEditFormat("$number$");
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("*"));
        selectors.add(new SelectorItemInfo("person.id"));
        selectors.add(new SelectorItemInfo("person.name"));
        selectors.add(new SelectorItemInfo("workshop.id"));
        classGroupBox.setSelectorCollection(selectors);
        classGroupBox.addSelectorListener(new SelectorListener(){
            EntityViewInfo entityViewInfo = new EntityViewInfo();

            public void willShow(SelectorEvent e) {
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("workshop.id", AssistantTimeReportEditUI.this.prmtDepartment.getValue() != null ? ((AdminOrgUnitInfo)AssistantTimeReportEditUI.this.prmtDepartment.getValue()).getId().toString() : null, CompareType.EQUALS));
                this.entityViewInfo.setFilter(filterInfo);
                classGroupBox.setEntityViewInfo(this.entityViewInfo);
                if (!this.entityViewInfo.equals((Object)classGroupBox.getQueryAgent().getRuntimeEntityView())) {
                    classGroupBox.getQueryAgent().resetRuntimeEntityView();
                }
            }
        });
        classGroupBox.addCommitListener(new CommitListener(){
            EntityViewInfo entityViewInfo = new EntityViewInfo();

            public void willCommit(CommitEvent e) {
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("workshop.id", AssistantTimeReportEditUI.this.prmtDepartment.getValue() != null ? ((AdminOrgUnitInfo)AssistantTimeReportEditUI.this.prmtDepartment.getValue()).getId().toString() : null, CompareType.EQUALS));
                this.entityViewInfo.setFilter(filterInfo);
                classGroupBox.setEntityViewInfo(this.entityViewInfo);
                if (!this.entityViewInfo.equals((Object)classGroupBox.getQueryAgent().getRuntimeEntityView())) {
                    classGroupBox.getQueryAgent().resetRuntimeEntityView();
                }
            }
        });
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtCurrency.getValue() == null) {
            MsgBox.showInfo((String)this.getResource("FinanceOrgNotNull"));
            SysUtil.abort();
        }
        super.actionSave_actionPerformed(e);
        this.editData.getBaseStatus();
    }

    @Override
    public void actionCostAlter_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkCostAlter()) {
            MsgBox.showWarning((String)this.getResource("CannotAlter"));
            SysUtil.abort();
        }
        try {
            this.pubFireVOChangeListener(this.editData.getId().toString());
        }
        catch (Throwable exp) {
            this.handUIException(exp);
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"uiObject", (Object)this.editData);
        uiContext.put((Object)"ATREditUI", (Object)this);
        UIHelper.openUIWindow((UIContext)uiContext, (String)AssistantTimeReportCostAlterUI.class.getName());
        this.editData = (AssistantTimeReportInfo)this.getUIContext().get("newData");
        this.loadFields();
    }

    private boolean checkCostAlter() {
        boolean flag = false;
        boolean canCalFlag = false;
        boolean yetCalFlag = false;
        int size = this.kdtEntries.getRowCount();
        for (int i = 0; i < size; ++i) {
            SalaryCaculateEnum scvalue = (SalaryCaculateEnum)((Object)this.kdtEntries.getCell(i, TB_SALARYCACULATEFLAG).getValue());
            if (scvalue == null) continue;
            if (SalaryCaculateEnum.CAN_CACULATE.equals((Object)scvalue)) {
                canCalFlag = true;
            }
            if (!SalaryCaculateEnum.YET_CACULATE.equals((Object)scvalue)) continue;
            yetCalFlag = true;
        }
        if (canCalFlag && yetCalFlag) {
            flag = true;
        }
        return flag;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return AssistantTimeReportFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        AssistantTimeReportEntryInfo detailObj = new AssistantTimeReportEntryInfo();
        this.initNewDetailData(detailObj);
        return detailObj;
    }

    @Override
    protected IObjectValue createNewData() {
        AssistantTimeReportInfo objectValue = new AssistantTimeReportInfo();
        if ((StorageOrgUnitInfo)this.getDefaultMainBizOrg() == null) {
            MsgBox.showInfo((String)this.getResource("no_addnew_permission"));
            SysUtil.abort();
        }
        objectValue.setId(BOSUuid.create((BOSObjectType)objectValue.getBOSType()));
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        objectValue.setStorageOrgUnit((StorageOrgUnitInfo)this.getDefaultMainBizOrg());
        if ((StorageOrgUnitInfo)this.getDefaultMainBizOrg() != null) {
            CompanyOrgUnitInfo companyOrgInfo = MMUtils.getCompanyOrgByStorageOrg((String)((StorageOrgUnitInfo)this.getDefaultMainBizOrg()).getId().toString());
            try {
                if (companyOrgInfo != null) {
                    CurrencyInfo currencyInfo = (CurrencyInfo)CurrencyFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(companyOrgInfo.getBaseCurrency().getId()));
                    objectValue.setCurrency(currencyInfo);
                }
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        objectValue.setBizDate(new Date());
        AssistantTimeReportEntryInfo entry = new AssistantTimeReportEntryInfo();
        this.initNewDetailData(entry);
        return objectValue;
    }

    private void initNewDetailData(AssistantTimeReportEntryInfo detailObj) {
        detailObj.setWorkTime(new BigDecimal("0.00"));
        detailObj.setTimeUnit(OprTimeUnitEnum.Hour);
        detailObj.setDate(new Date());
        detailObj.setSalaryCaculateFlag(SalaryCaculateEnum.NOT_CANCACULATE);
        detailObj.setWagesAccountForm(CountWagesWayEnum.PERSON);
    }

    public String getOprtState() {
        if (this.oprtState == null) {
            this.oprtState = "ADDNEW";
        }
        return this.oprtState;
    }

    protected String getPermissionItem(String status) {
        if ("ADDNEW".equals(status)) {
            return "mm_sfc_ATReportAddNew";
        }
        return null;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorageOrgUnit;
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtStorageOrgUnit;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.CU"));
        sic.add(new SelectorItemInfo("department.id"));
        sic.add(new SelectorItemInfo("department.name"));
        sic.add(new SelectorItemInfo("department.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("entry.person.id"));
        sic.add(new SelectorItemInfo("entry.person.name"));
        sic.add(new SelectorItemInfo("entry.person.number"));
        sic.add(new SelectorItemInfo("entry.classGroup.id"));
        sic.add(new SelectorItemInfo("entry.classGroup.name"));
        sic.add(new SelectorItemInfo("entry.classGroup.number"));
        sic.add(new SelectorItemInfo("entry.material.id"));
        sic.add(new SelectorItemInfo("entry.material.name"));
        sic.add(new SelectorItemInfo("entry.material.number"));
        sic.add(new SelectorItemInfo("entry.material.model"));
        sic.add(new SelectorItemInfo("entry.assistantTimeType.id"));
        sic.add(new SelectorItemInfo("entry.assistantTimeType.name"));
        sic.add(new SelectorItemInfo("entry.assistantTimeType.number"));
        sic.add(new SelectorItemInfo("entry.assistantTimeType.status"));
        sic.add(new SelectorItemInfo("entry.assistantTimeType.laborCost"));
        sic.add(new SelectorItemInfo("entry.assistantTimeType.laborCostUnit"));
        sic.add(new SelectorItemInfo("entry.assistantTimeType.storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("entry.projectNum.id"));
        sic.add(new SelectorItemInfo("entry.projectNum.name"));
        sic.add(new SelectorItemInfo("entry.projectNum.number"));
        sic.add(new SelectorItemInfo("entry.trackNum.id"));
        sic.add(new SelectorItemInfo("entry.trackNum.name"));
        sic.add(new SelectorItemInfo("entry.trackNum.number"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("auditor.number"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("modifier.id"));
        sic.add(new SelectorItemInfo("modifier.number"));
        sic.add(new SelectorItemInfo("modifier.name"));
        sic.add(new SelectorItemInfo("entry.salaryCaculateFlag"));
        sic.add(new SelectorItemInfo("entry.wagesAccountForm"));
        return sic;
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        if (null != this.editData && this.editData.getId() != null) {
            if (this.editData.getBaseStatus().getValue() == 2) {
                this.btnAudit.setEnabled(true);
                this.btnUnAudit.setEnabled(false);
            } else if (this.editData.getBaseStatus().getValue() == 4) {
                this.btnAudit.setEnabled(false);
                this.btnUnAudit.setEnabled(true);
            } else {
                this.btnAudit.setEnabled(false);
                this.btnUnAudit.setEnabled(false);
            }
        } else {
            this.btnAudit.setEnabled(false);
            this.btnUnAudit.setEnabled(false);
        }
        if ((this.getOprtState().equals("ADDNEW") || this.getOprtState().equals("EDIT")) && this.kdtEntries != null && this.kdtEntries.getRowCount() > 0) {
            int rows = this.kdtEntries.getRowCount();
            for (int i = 0; i < rows; ++i) {
                IRow row = this.kdtEntries.getRow(i);
                if (row == null) continue;
                this.setGroupAndPersonEditable(row);
            }
        }
        this.addListener();
    }

    private void setGroupAndPersonEditable(IRow row) {
        if (CountWagesWayEnum.PERSON == row.getCell(TB_WAGEACCOUNTFORM).getValue()) {
            row.getCell(TB_CLASSGROUP).getStyleAttributes().setLocked(true);
            row.getCell(TB_CLASSGROUP).getStyleAttributes().setBackground(this.COLOR_WHITE);
            row.getCell(TB_PERSON).getStyleAttributes().setBackground(this.COLOR_YELLOW);
            row.getCell(TB_PERSON).getStyleAttributes().setLocked(false);
        } else {
            row.getCell(TB_PERSON).getStyleAttributes().setLocked(true);
            row.getCell(TB_PERSON).getStyleAttributes().setBackground(this.COLOR_WHITE);
            row.getCell(TB_CLASSGROUP).getStyleAttributes().setBackground(this.COLOR_YELLOW);
            row.getCell(TB_CLASSGROUP).getStyleAttributes().setLocked(false);
        }
    }

    protected void initDataStatus() {
        AssistantTimeReportInfo info = (AssistantTimeReportInfo)this.dataBinder.getValueObject();
        if (info.getBaseStatus().getValue() == 4) {
            this.setOprtState("VIEW");
            this.setEntryOperateBtnStatus(false);
            this.btnCostAlter.setEnabled(true);
            this.actionCostAlter.setEnabled(true);
        } else {
            this.btnCostAlter.setEnabled(false);
            this.actionCostAlter.setEnabled(false);
        }
        super.initDataStatus();
        if (null != info.getId() && this.getOprtState().equals("EDIT")) {
            if (info.getBaseStatus().getValue() == 1 || info.getBaseStatus().getValue() == 2) {
                this.setEntryOperateBtnStatus(true);
            }
        } else if (null != info.getId() && this.getOprtState().equals("VIEW")) {
            this.setEntryOperateBtnStatus(false);
        } else if (null != info.getId() && this.getOprtState().equals("ADDNEW")) {
            this.setEntryOperateBtnStatus(true);
        }
    }

    private void setEntryOperateBtnStatus(boolean enableKey) {
        this.actionCopyLine.setEnabled(enableKey);
        this.prmtDepartment.setEnabled(enableKey);
        if (!enableKey) {
            this.kdtEntries.getActionMap().remove("AddRow");
        } else {
            this.kdtEntries.getActionMap().put("AddRow", (Action)this.actionAddLine);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
    }

    public String getResource(String key) {
        return EASResource.getString((String)resource, (String)key);
    }

    private void setLaborCostPrecision(String[] cols, int precision) {
        MMUtils.changeTableColPrecisionByCol((int)precision, (KDTable)this.kdtEntries, (String[])cols, (boolean)false);
    }

    public void onShow() throws Exception {
        super.onShow();
        KDTableUtils.setDefaultFreezeCol((KDTable)this.kdtEntries, (int)(this.kdtEntries.getColumnIndex(TB_PERSON) + 1));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuBiz.setVisible(false);
    }

    protected void prmtPersonChanged(String tbPerson, DataChangeEvent e) {
        block6: {
            try {
                KDBizPromptBox bizPersonBox = (KDBizPromptBox)e.getSource();
                KDTSelectBlock selected = this.kdtEntries.getSelectManager().get();
                if (selected == null) {
                    return;
                }
                if (e.getNewValue() != null) {
                    ArrayList personList;
                    if (e.getNewValue() instanceof ArrayList && (personList = (ArrayList)e.getNewValue()) != null && personList.size() > 0) {
                        bizPersonBox.setValue(personList.get(0));
                        for (int i = 1; i < personList.size(); ++i) {
                            IRow mulRow = this.getDetailTable().addRow();
                            mulRow.getCell(TB_TIME).setValue((Object)new BigDecimal("0.00"));
                            mulRow.getCell(TB_UNIT).setValue((Object)OprTimeUnitEnum.Hour);
                            mulRow.getCell(TB_DATE).setValue((Object)new Date());
                            mulRow.getCell(TB_PERSON).setValue(personList.get(i));
                        }
                    }
                    break block6;
                }
                return;
            }
            catch (Exception exc) {
                this.handUIException(exc);
            }
        }
    }
}

