/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.sfc.SalaryCaculateEnum;
import com.kingdee.eas.mm.sfc.client.AbstractAssistantTimeReportFilterUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class AssistantTimeReportFilterUI
extends AbstractAssistantTimeReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(AssistantTimeReportFilterUI.class);
    public static final String KEY_STARTDATE = "startDate";
    public static final String KEY_ENDDATE = "endDate";
    private Timestamp[] dates = SCMUtils.getDefaultDateRange(null);
    private DataChangeListener prmtStorageOrgUnitDataChanged = null;
    private DataChangeListener prmtDepartmentDataChanged = null;

    public void onLoad() throws Exception {
        super.onLoad();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_sfc_ATReportView");
        this.cmbBillStatus.removeAllItems();
        this.cmbBillStatus.addItem((Object)BillBaseStatusEnum.NULL);
        this.cmbBillStatus.addItem((Object)BillBaseStatusEnum.TEMPORARILYSAVED);
        this.cmbBillStatus.addItem((Object)BillBaseStatusEnum.SUBMITED);
        this.cmbBillStatus.addItem((Object)BillBaseStatusEnum.AUDITED);
        this.cmbSalaryCalStatus.removeAllItems();
        this.cmbSalaryCalStatus.addItem((Object)SalaryCaculateEnum.NULL);
        this.cmbSalaryCalStatus.addItem((Object)SalaryCaculateEnum.NOT_CANCACULATE);
        this.cmbSalaryCalStatus.addItem((Object)SalaryCaculateEnum.CAN_CACULATE);
        this.cmbSalaryCalStatus.addItem((Object)SalaryCaculateEnum.YET_CACULATE);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        RangeFilterElement element1 = new RangeFilterElement("bizDate", (Component)this.pkBizDateFrom, (Component)this.pkBizDateTo);
        element1.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, this.getResource("BizDateBiginEarlier")));
        element1.setDefaultValue((Object)this.dates);
        elements.add((FilterElement)element1);
        RangeFilterElement element2 = new RangeFilterElement("salaryCalDate", (Component)this.pkSalaryCalDateFrom, (Component)this.pkSalaryCalDateTo);
        element2.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, this.getResource("SCDateBiginEarlier")));
        elements.add((FilterElement)element2);
        elements.add((FilterElement)new RangeFilterElement("number", (Component)this.prmtNumberFrom, (Component)this.prmtNumberTo));
        elements.add((FilterElement)new SingleFilterElement("department.number", (Component)this.prmtDepartment));
        elements.add((FilterElement)new SingleFilterElement("baseStatus", (Component)this.cmbBillStatus, (Object)BillBaseStatusEnum.NULL));
        elements.add((FilterElement)new SingleFilterElement("entry.salaryCaculateFlag", (Component)this.cmbSalaryCalStatus, (Object)SalaryCaculateEnum.NULL));
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, this.getResource("StorageNUll")));
        elements.add((FilterElement)mainOrgElement);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.prmtNumberFrom, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.prmtNumberTo, this.getPropertyOfMainBizOrg());
        this.addListener();
        this.pkSalaryCalDateFrom.setValue(null);
    }

    protected void prmtDepartment_dataChanged(DataChangeEvent e) {
        try {
            boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getNewValue(), (Object)e.getOldValue());
            if (!isDiffrent) {
                return;
            }
            this.initNumberF7();
            this.prmtNumberFrom.setValue(null);
            this.prmtNumberTo.setValue(null);
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    protected void prmtStorageOrgUnit_dataChanged(DataChangeEvent e) {
        try {
            boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getNewValue(), (Object)e.getOldValue());
            if (!isDiffrent) {
                return;
            }
            this.initDepartmentF7();
            this.prmtDepartment.setValue(null);
            this.prmtNumberFrom.setValue(null);
            this.prmtNumberTo.setValue(null);
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    private void initDepartmentF7() throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        HashSet set = new HashSet();
        HashSet setSum = new HashSet();
        if (this.prmtStorageOrgUnit.getValue() != null) {
            if (this.prmtStorageOrgUnit.getValue() instanceof StorageOrgUnitInfo) {
                StorageOrgUnitInfo storage = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
                set = MMUtils.getAdminOrgByStorageOrg((String)storage.getId().toString());
                setSum.addAll(set);
            } else if (this.prmtStorageOrgUnit.getValue() instanceof Object[]) {
                Object[] org = (Object[])this.prmtStorageOrgUnit.getValue();
                for (int i = 0; i < org.length; ++i) {
                    OrgUnitInfo storage = (OrgUnitInfo)org[i];
                    set = MMUtils.getAdminOrgByStorageOrg((String)storage.getId().toString());
                    setSum.addAll(set);
                }
            }
            if (setSum != null && setSum.size() > 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", setSum, CompareType.INCLUDE));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", null, CompareType.EQUALS));
            }
        }
        viewInfo.setFilter(filterInfo);
        this.prmtDepartment.setEntityViewInfo(viewInfo);
    }

    private void initNumberF7() {
        HashSet<String> setSum = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        OrgUnitInfo adminInfo = (OrgUnitInfo)this.prmtDepartment.getValue();
        if (this.prmtStorageOrgUnit.getValue() != null && this.prmtStorageOrgUnit.getValue() instanceof Object[]) {
            Object[] org = (Object[])this.prmtStorageOrgUnit.getValue();
            for (int i = 0; i < org.length; ++i) {
                OrgUnitInfo storage = (OrgUnitInfo)org[i];
                setSum.add(storage.getName().toString());
            }
        }
        if (setSum != null && setSum.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.name", setSum, CompareType.INCLUDE));
        }
        if (adminInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("department.name", (Object)adminInfo.getName(), CompareType.EQUALS));
        }
        view.setFilter(filter);
        this.prmtNumberFrom.setEntityViewInfo(view);
        this.prmtNumberTo.setEntityViewInfo(view);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    public String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.mm.sfc.AssistantTimeReportResource", (String)key);
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.removeListener();
        super.loadData(entityViewInfo);
        this.addListener();
    }

    private void removeListener() {
        this.prmtStorageOrgUnit.removeDataChangeListener(this.prmtStorageOrgUnitDataChanged);
        this.prmtDepartment.removeDataChangeListener(this.prmtDepartmentDataChanged);
    }

    private void addListener() {
        if (this.prmtStorageOrgUnitDataChanged == null) {
            this.prmtStorageOrgUnitDataChanged = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    AssistantTimeReportFilterUI.this.prmtStorageOrgUnit_dataChanged(eventObj);
                }
            };
        }
        this.prmtStorageOrgUnit.addDataChangeListener(this.prmtStorageOrgUnitDataChanged);
        if (this.prmtDepartmentDataChanged == null) {
            this.prmtDepartmentDataChanged = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    AssistantTimeReportFilterUI.this.prmtDepartment_dataChanged(eventObj);
                }
            };
        }
        this.prmtDepartment.addDataChangeListener(this.prmtDepartmentDataChanged);
    }
}

