/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntry;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.scm.common.action.ITableSelectionHelper;
import java.util.ArrayList;
import java.util.HashSet;

public class CoreTableSelectionHelper
implements ITableSelectionHelper {
    private CoreUI uiObj;
    protected KDTable tblMain;
    private String idColName;
    private String orgIdColName;
    private String numberColName;
    protected String entryIdColName;
    protected String entrySeqColName;

    public CoreTableSelectionHelper(CoreUI uiObj) {
        this.uiObj = uiObj;
    }

    public void setTableProperty(CoreUI uiObj, KDTable table, String idColName, String numberColName, String orgIdColName) {
        this.uiObj = uiObj;
        this.tblMain = table;
        this.idColName = idColName;
        this.numberColName = numberColName;
        this.orgIdColName = orgIdColName;
    }

    public void refresh(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, int countSuccess) throws Exception {
        if (countSuccess == 0) {
            return;
        }
        int curIndex = 0;
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            curIndex = selectBlock.getTop();
        }
        if (bizAction.equals((Object)BatchActionEnum.DELETE)) {
            // empty if block
        }
        this.tblMain.getSelectManager().select(curIndex, 0);
        this.tblMain.getLayoutManager().scrollRowToShow(curIndex);
    }

    public BatchSelectionEntries getSelectedIDs(Context mainOrgContext, ActionLevelEnum actionLevel) throws BOSException {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            return null;
        }
        if (size == 1 && selectRows.length == 1) {
            int rowNum = this.tblMain.getSelectManager().get().getTop();
            IRow row = this.tblMain.getRow(rowNum);
            return this.getSelectedOneID(row, actionLevel);
        }
        int mode = 0;
        ArrayList blockList = this.tblMain.getSelectManager().getBlocks();
        if (blockList != null && blockList.size() == 1) {
            mode = ((IBlock)this.tblMain.getSelectManager().getBlocks().get(0)).getMode();
        }
        if (mode == 8) {
            return this.getSelectedMultiIDs(mainOrgContext, actionLevel, selectRows);
        }
        return this.getSelectedMultiIDs(mainOrgContext, actionLevel, selectRows);
    }

    public boolean hasSelectedRows(ActionLevelEnum actionLevel) {
        return this.tblMain.getRowCount() > 0 && this.tblMain.getSelectManager().size() > 0;
    }

    protected BatchSelectionEntries getSelectedMultiIDs(Context mainOrgContext, ActionLevelEnum actionLevel, int[] selectRows) throws BOSException {
        BatchSelectionEntries results = new BatchSelectionEntries(actionLevel, selectRows.length);
        HashSet<Object> keySet = new HashSet<Object>();
        for (int i = 0; i < selectRows.length; ++i) {
            BatchSelectionEntry entry;
            IRow row = this.tblMain.getRow(selectRows[i]);
            if (actionLevel.equals((Object)ActionLevelEnum.HEAD)) {
                Object id = this.getCellValue(row.getCell(this.idColName));
                if (keySet.contains(id)) continue;
                keySet.add(id);
            }
            if ((entry = this.getSelectionEntry(row, actionLevel)) == null) continue;
            results.add(entry);
        }
        return results;
    }

    protected BatchSelectionEntries getSelectedOneID(IRow row, ActionLevelEnum actionLevel) throws BOSException {
        BatchSelectionEntries results = new BatchSelectionEntries(actionLevel, 1);
        results.add(this.getSelectionEntry(row, actionLevel));
        return results;
    }

    protected final Object getCellValue(ICell cell) throws BOSException {
        if (cell == null) {
            throw new IllegalArgumentException("TableSelectionHelper.setTableProperty: the column name in parameters is incorrect.");
        }
        return cell.getValue();
    }

    protected BatchSelectionEntry getSelectionEntry(IRow row, ActionLevelEnum actionLevel) throws BOSException {
        BatchSelectionEntry entry = new BatchSelectionEntry();
        String id = (String)this.getCellValue(row.getCell(this.idColName));
        if (id == null) {
            return null;
        }
        entry.setId((String)this.getCellValue(row.getCell(this.idColName)));
        entry.setNumber((String)this.getCellValue(row.getCell(this.numberColName)));
        if (actionLevel.equals((Object)ActionLevelEnum.ENTRY)) {
            String entryId = (String)this.getCellValue(row.getCell(this.entryIdColName));
            if (entryId == null) {
                return null;
            }
            entry.setEntryId(entryId);
            entry.setSeq(((Integer)this.getCellValue(row.getCell(this.entrySeqColName))).intValue());
        }
        entry.setRowNum(row.getRowIndex());
        entry.setOrgId((String)this.getCellValue(row.getCell(this.orgIdColName)));
        return entry;
    }

    public int getSelectedEntrySize(Context mainOrgContext, ActionLevelEnum actionLevel) throws BOSException {
        return 0;
    }
}

