/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import java.math.BigDecimal;

public class DirectDeliveryClientUtils {
    public static final BigDecimal BIGDECIMAL_ONE;
    public static final BigDecimal EXCHANGERATE_DEFAULT;
    public static final int PRECISION_DEFAUL_DB = 8;

    public static SelectorItemCollection getPurOrderSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("qty");
        sic.add("totalReceiveQty");
        sic.add("totalReceiptQty");
        sic.add("seq");
        sic.add("parent.id");
        sic.add("parent.number");
        sic.add("parent.baseStatus");
        sic.add("parent.purchaseOrgUnit.id");
        sic.add("parent.purchaseOrgUnit.name");
        sic.add("material.id");
        sic.add("material.number");
        sic.add("material.name");
        sic.add("material.model");
        sic.add("material.AssistAttr.id");
        sic.add("material.AssistAttr.number");
        sic.add("material.AssistAttr.name");
        sic.add("unit.id");
        sic.add("unit.number");
        sic.add("unit.name");
        sic.add("baseUnit.id");
        sic.add("baseUnit.number");
        sic.add("baseUnit.name");
        sic.add("material.assistunit.id");
        sic.add("material.assistunit.number");
        sic.add("material.assistunit.name");
        sic.add("project.id");
        sic.add("project.number");
        sic.add("trackNo.id");
        sic.add("trackNo.number");
        sic.add("assistunit.id");
        sic.add("assistunit.number");
        sic.add("assistunit.name");
        sic.add("wareHouse.id");
        sic.add("wareHouse.number");
        sic.add("wareHouse.name");
        sic.add("supplier.id");
        sic.add("supplier.number");
        sic.add("supplier.name");
        sic.add("storageOrgUnit.id");
        sic.add("storageOrgUnit.name");
        return sic;
    }

    public static SelectorItemCollection getSourceMOSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("lot");
        selector.add("storageOrgUnit.id");
        selector.add("storageOrgUnit.number");
        selector.add("storageOrgUnit.name");
        selector.add("material.id");
        selector.add("material.number");
        selector.add("material.name");
        selector.add("material.model");
        selector.add("unit.id");
        selector.add("unit.number");
        selector.add("unit.name");
        selector.add("baseUnit.id");
        selector.add("baseUnit.number");
        selector.add("baseUnit.name");
        selector.add("project.id");
        selector.add("project.number");
        selector.add("trackNumber.id");
        selector.add("trackNumber.number");
        selector.add("qty");
        selector.add("isDirectSend");
        selector.add("totalSplitQty");
        selector.add("totalDirectSendQty");
        selector.add("transactionType.isWPManagement");
        selector.add("baseStatus");
        selector.add("scrapQty");
        selector.add("concessionQty");
        selector.add("toStroreQty");
        selector.add("defaultWarehous.id");
        selector.add("defaultWarehous.number");
        selector.add("defaultWarehous.name");
        selector.add("defaultWarehous.hasLocation");
        selector.add("material.assistunit.id");
        selector.add("material.assistunit.number");
        selector.add("material.assistunit.name");
        selector.add("adminOrgUnit.id");
        selector.add("adminOrgUnit.number");
        selector.add("adminOrgUnit.name");
        selector.add("passQty");
        selector.add("material.assistAttr.id");
        selector.add("material.assistAttr.number");
        selector.add("material.assistAttr.name");
        return selector;
    }

    public static SelectorItemCollection getSourceMaterialSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("lot");
        sic.add("baseQty");
        sic.add("curStoreQty");
        sic.add("material.id");
        sic.add("material.number");
        sic.add("material.name");
        sic.add("material.model");
        sic.add("material.AssistAttr.id");
        sic.add("material.AssistAttr.number");
        sic.add("material.AssistAttr.name");
        sic.add("storetype.id");
        sic.add("storetype.number");
        sic.add("storetype.name");
        sic.add("storageOrgUnit.id");
        sic.add("storageOrgUnit.number");
        sic.add("storageOrgUnit.name");
        sic.add("warehouse.id");
        sic.add("warehouse.number");
        sic.add("warehouse.name");
        sic.add("location.id");
        sic.add("location.number");
        sic.add("location.name");
        sic.add("storestatus.id");
        sic.add("storestatus.number");
        sic.add("storestatus.name");
        sic.add("unit.id");
        sic.add("unit.number");
        sic.add("unit.name");
        sic.add("baseUnit.id");
        sic.add("baseUnit.number");
        sic.add("baseUnit.name");
        sic.add("assistUnit.name");
        sic.add("whman.name");
        sic.add("trackNumber.number");
        sic.add("trackNumber.id");
        sic.add("project.number");
        sic.add("project.id");
        return sic;
    }

    public static SelectorItemCollection getDestMOSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("qty");
        sic.add("issueMode");
        sic.add("baseQty");
        sic.add("plannedQty");
        sic.add("plannedBaseQty");
        sic.add("lineSeq");
        sic.add("operationNo");
        sic.add("actIssueQty");
        sic.add("totalDirectReceiveQty");
        sic.add("totalDirectReceiveBaseQty");
        sic.add("demandTime");
        sic.add("parent.id");
        sic.add("parent.isAutoFinished");
        sic.add("parent.number");
        sic.add("parent.baseStatus");
        sic.add("parent.material.id");
        sic.add("parent.material.number");
        sic.add("parent.material.name");
        sic.add("material.id");
        sic.add("material.number");
        sic.add("material.name");
        sic.add("material.model");
        sic.add("material1.number");
        sic.add("material1.name");
        sic.add("material1.model");
        sic.add("storageOrgUnit.number");
        sic.add("storageOrgUnit.name");
        sic.add("unit.id");
        sic.add("unit.number");
        sic.add("unit.name");
        sic.add("parent.project.id");
        sic.add("parent.project.number");
        sic.add("project.number");
        sic.add("parent.trackNumber.id");
        sic.add("parent.trackNumber.number");
        sic.add("trackNumber.number");
        sic.add("workcenter.id");
        sic.add("workcenter.number");
        sic.add("workcenter.name");
        sic.add("operation.id");
        sic.add("operation.number");
        sic.add("operation.name");
        sic.add("baseUnit.id");
        sic.add("baseUnit.number");
        sic.add("baseUnit.name");
        sic.add("pickDept.name");
        sic.add("pickDept.id");
        sic.add("pickDept.number");
        sic.add("parent.adminOrgUnit.id");
        sic.add("parent.adminOrgUnit.name");
        sic.add("parent.adminOrgUnit.number");
        return sic;
    }

    public static BigDecimal getExchangeQtyForClient(String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = qty;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
        MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfo.getId().toString());
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = DirectDeliveryClientUtils.effectualNumeric(qty).multiply(baseExchangeRate1);
            int scale = 8;
            if (baseQty != null && qty != null) {
                scale = othermultiUnifInfo.getQtyPrecision();
            }
            targetQty = DirectDeliveryClientUtils.effectualNumeric(baseQty).divide(DirectDeliveryClientUtils.effectualExchangeRate(baseExchangeRate2), scale != 0 ? scale : 8, 4);
        }
        return targetQty;
    }

    public static BigDecimal effectualNumeric(BigDecimal v) {
        return DirectDeliveryClientUtils.equalsZero(v) ? SysConstant.BIGZERO : v;
    }

    public static boolean equalsZero(BigDecimal v) {
        return v == null || SysConstant.BIGZERO.compareTo(v) == 0;
    }

    public static BigDecimal effectualExchangeRate(BigDecimal exchangeRate) {
        return DirectDeliveryClientUtils.isDistrustExchangeRate(exchangeRate) ? exchangeRate : EXCHANGERATE_DEFAULT;
    }

    public static boolean isDistrustExchangeRate(BigDecimal exchangeRate) {
        return exchangeRate != null && exchangeRate.compareTo(SysConstant.BIGZERO) != 0 && exchangeRate.compareTo(SysConstant.BIGZERO) != -1;
    }

    public static void setNullExpColls(KDTable table, int rowIndex, String[] colKeys) {
        IRow row = table.getRow(rowIndex);
        for (int i = 0; i < table.getColumnCount(); ++i) {
            IColumn col = table.getColumn(i);
            String key = col.getKey();
            boolean isExist = false;
            for (int j = 0; j < colKeys.length; ++j) {
                if (!colKeys[j].equals(key)) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            row.getCell(key).setValue(null);
        }
    }

    public static SelectorItemCollection getWarehouseSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("storageOrg.id");
        sic.add("storageOrg.number");
        sic.add("storageOrg.name");
        sic.add("whman.id");
        sic.add("whman.number");
        sic.add("whman.name");
        sic.add("whState");
        sic.add("transState");
        sic.add("hasLocation");
        sic.add("hasLocationLevel");
        return sic;
    }

    static {
        EXCHANGERATE_DEFAULT = BIGDECIMAL_ONE = new BigDecimal("1.0");
    }
}

