/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractPrintDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.mm.sfc.DirectDeliveryBillFactory;
import com.kingdee.eas.mm.sfc.DirectSourceTypeEnum;
import com.kingdee.eas.mm.sfc.DirectTypeEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.text.DecimalFormat;

public class DirectDeliveryDataProvider
extends AbstractPrintDataProvider {
    private String directDeliveryBillID = null;
    private String BILL_SOURCE = "source";
    private String BILL_DEST = "dest";
    private String BILL = "bill";

    public DirectDeliveryDataProvider(String billID) {
        this.directDeliveryBillID = billID;
    }

    public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
        IRowSet rowSet = null;
        if ("DirectDeliveryHeadQuery".equals(dataSource.getId())) {
            rowSet = DirectDeliveryBillFactory.getRemoteInstance().getPrintData(this.directDeliveryBillID, this.BILL);
            rowSet = this.updateRowSet(rowSet);
            return rowSet;
        }
        if ("DirectDeliverySourceBillQuery".equals(dataSource.getId())) {
            rowSet = DirectDeliveryBillFactory.getRemoteInstance().getPrintData(this.directDeliveryBillID, this.BILL_SOURCE);
            rowSet = this.updateRowSet(rowSet);
            return rowSet;
        }
        if ("DirectDeliveryDestQuery".equals(dataSource.getId())) {
            rowSet = DirectDeliveryBillFactory.getRemoteInstance().getPrintData(this.directDeliveryBillID, this.BILL_DEST);
            rowSet = this.updateRowSet(rowSet);
            return rowSet;
        }
        return null;
    }

    private IRowSet updateRowSet(IRowSet rowSet) throws BOSException {
        try {
            IRowSetMetaData metaData = rowSet.getRowSetMetaData();
            DynamicRowSet dynamicRowSet = new DynamicRowSet(metaData.getColumnCount());
            String columnKey = null;
            int k = 0;
            while (rowSet.next()) {
                dynamicRowSet.moveToInsertRow();
                for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                    columnKey = metaData.getColumnName(i);
                    dynamicRowSet.setColInfo(i, new ColInfo(columnKey, columnKey, 12, null));
                    dynamicRowSet.updateString(columnKey, this.getRightString(columnKey, rowSet.getString(columnKey)));
                }
                dynamicRowSet.insertRow();
                ++k;
            }
            if (k > 0) {
                dynamicRowSet.beforeFirst();
                return dynamicRowSet;
            }
            return rowSet;
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
    }

    private String getRightString(String key, String value) throws BOSException {
        try {
            DecimalFormat fmt = new DecimalFormat();
            fmt.applyPattern("0.######");
            if ("baseStatus".equalsIgnoreCase(key) || "fbaseStatus".equalsIgnoreCase(key)) {
                return BillBaseStatusEnum.getEnum((int)Integer.parseInt(value)).getAlias();
            }
            if ("sourceAffirm".equalsIgnoreCase(key)) {
                return Integer.parseInt(value) == 1 ? DirectDeliveryDataProvider.getResource("CONFIRM_YES") : DirectDeliveryDataProvider.getResource("CONFIRM_NO");
            }
            if ("destAffirm".equalsIgnoreCase(key)) {
                return Integer.parseInt(value) == 1 ? DirectDeliveryDataProvider.getResource("CONFIRM_YES") : DirectDeliveryDataProvider.getResource("CONFIRM_NO");
            }
            if ("gainAffrim".equalsIgnoreCase(key)) {
                return Integer.parseInt(value) == 1 ? DirectDeliveryDataProvider.getResource("CONFIRM_YES") : DirectDeliveryDataProvider.getResource("CONFIRM_NO");
            }
            if ("DirectType".equalsIgnoreCase(key)) {
                return DirectTypeEnum.getEnum(Integer.parseInt(value)).getAlias();
            }
            if ("souceType".equalsIgnoreCase(key)) {
                return DirectSourceTypeEnum.getEnum(Integer.parseInt(value)).getAlias();
            }
            if (!"replaceFlag".equalsIgnoreCase(key) && "issMode".equalsIgnoreCase(key)) {
                MaterialIssueModeEnum materialIssueMode = MaterialIssueModeEnum.getEnum((int)Integer.parseInt(value));
                return materialIssueMode.getAlias();
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        return value;
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.sfc.DirectDeliveryResource", (String)strKey);
    }
}

