/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.appframework.databinding.DataComponentMap;
import com.kingdee.bos.appframework.databinding.Field;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.ManufactureStrategyInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.sfc.DirectDeliveryBillInfo;
import com.kingdee.eas.mm.sfc.DirectDestCollection;
import com.kingdee.eas.mm.sfc.DirectDestInfo;
import com.kingdee.eas.mm.sfc.DirectDetailInfo;
import com.kingdee.eas.mm.sfc.DirectSourceCollection;
import com.kingdee.eas.mm.sfc.DirectSourceInfo;
import com.kingdee.eas.mm.sfc.DirectSourceTypeEnum;
import com.kingdee.eas.mm.sfc.client.AbstractDirectDeliveryDetailUI;
import com.kingdee.eas.mm.sfc.client.DirectDeliveryClientUtils;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.im.inv.InventoryCollection;
import com.kingdee.eas.scm.im.inv.InventoryFactory;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class DirectDeliveryDetailUI
extends AbstractDirectDeliveryDetailUI {
    private static final Logger logger = CoreUIObject.getLogger(DirectDeliveryDetailUI.class);
    private static final String TB_SOURCETYPE = "sourceType";
    private static final String TB_SOURCEBILLNUMBER = "sourceBillnumber";
    private static final String TB_SEQ = "seq";
    private static final String TB_SOURCEBILLSEQ = "sourceBillseq";
    private static final String TB_MATERIALNUMBER = "materialNumber";
    private static final String TB_MATERIALNAME = "materialName";
    private static final String TB_MATERIALMODEL = "model";
    private static final String TB_LOTNO = "lotNo";
    private static final String TB_SOURCEUNIT = "unit";
    private static final String TB_BASEUNIT = "baseUnit";
    private static final String TB_PROJECTNUMBER = "projectNumber";
    private static final String TB_TRACKNUMBER = "trackNumber";
    private static final String TB_PRODUCTDATE = "productDate";
    private static final String TB_EXP = "exp";
    private static final String TB_WAREHOUSE = "warehouse";
    private static final String TB_LOCATION = "location";
    private static final String TB_ASSIGNQTY = "assignQty";
    private static final String TB_BASEASSIGNQTY = "baseAssignQty";
    private static final String TB_SOURCEID = "sourceId";
    private static final String TB_DESTID = "destId";
    private static final String TB_MONUMBER = "moNumber";
    private static final String TB_ADMINORGUNIT = "adminOrgUnit";
    private static final String TB_PICKDEPT = "pickDept";
    private static final String TB_PICKMATERIALNUMBER = "pickMaterialNumber";
    private static final String TB_PICKMATERIALNAME = "pickMaterialName";
    private static final String TB_OPERATIONNO = "opertaionNO";
    private static final String TB_DEMANDDATA = "demandDate";
    private static final String TB_DESTUNIT = "pickUnit";
    private static final String TB_DESTQTY = "qty";
    private static final String TB_DESTRECEIVEDQTY = "receivedQty";
    private static final String TB_RECEIVEWAREHOUSE = "receiveWarehouse";
    private static final String TB_RECQTY = "recQty";
    private static final String TB_PURORDERENTRY = "purOrderEntry";
    private static final String TB_MO = "mo";
    private static final String TB_ASSISTUNIT = "assistunit";
    private static final String TB_MATERIAL = "material";
    private KDBizPromptBox prmtPurOrder;
    private KDBizPromptBox prmtSourceMO;
    private KDBizPromptBox prmtInventory;
    private KDTEditAdapter detailKDTEditAdapter;
    private DirectDeliveryBillInfo headInfo = new DirectDeliveryBillInfo();
    private DirectDeliveryBillInfo copyDirectBillInfo = new DirectDeliveryBillInfo();
    private boolean isSave = false;
    private String[] fieldsToCopy = null;
    private SCMEntryDataVO headVO;
    private SCMEntryDataVO destVo;
    private static final int DEFAULT_PREC = 2;
    private Map strategyCatch = new HashMap();

    public DirectDeliveryDetailUI() throws Exception {
        this.kdtDetail.checkParsed();
    }

    protected KDTable getDetailTable() {
        return this.kdtDetail;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        DirectDetailInfo detailInfo = new DirectDetailInfo();
        detailInfo.setAssianQty(new BigDecimal("0"));
        detailInfo.setBaseAssignQty(new BigDecimal("0"));
        detailInfo.setReceQty(new BigDecimal("0"));
        detailInfo.setQty(new BigDecimal("0"));
        detailInfo.setReceivedQty(new BigDecimal("0"));
        return detailInfo;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        StringBuffer err = new StringBuffer();
        StringBuffer mError = new StringBuffer();
        StringBuffer qError = new StringBuffer();
        StringBuffer sTypeErr = new StringBuffer();
        StringBuffer sBillNumErr = new StringBuffer();
        StringBuffer moNumErr = new StringBuffer();
        StringBuffer sumErr = new StringBuffer();
        for (int i = this.kdtDetail.getRowCount() - 1; i >= 0; --i) {
            Object assignQty;
            IRow row = this.kdtDetail.getRow(i);
            if (row.getCell(TB_SOURCETYPE).getValue() == null) {
                sTypeErr.append(i + 1 + ",");
            }
            if (row.getCell(TB_MATERIALNUMBER).getValue() == null) {
                mError.append(i + 1 + ",");
            }
            if ((assignQty = row.getCell(TB_ASSIGNQTY).getValue()) == null || ((BigDecimal)assignQty).doubleValue() <= 0.0) {
                qError.append(i + 1 + ",");
            }
            if (!DirectSourceTypeEnum.invSource.equals(row.getCell(TB_SOURCETYPE).getValue()) && row.getCell(TB_SOURCEBILLNUMBER).getValue() == null) {
                sBillNumErr.append(i + 1 + ",");
            }
            if (row.getCell(TB_MONUMBER).getValue() == null) {
                moNumErr.append(i + 1 + ",");
            }
            this.submitVerify(row, sumErr);
        }
        if (sTypeErr.length() > 0) {
            err.append(this.getResource("detailError1", new String[]{sTypeErr.replace(sTypeErr.length() - 1, sTypeErr.length(), "").toString()}) + "\n");
        }
        if (mError.length() > 0) {
            err.append(this.getResource("detailError4", new String[]{mError.replace(mError.length() - 1, mError.length(), "").toString()}) + "\n");
        }
        if (qError.length() > 0) {
            err.append(this.getResource("detailError5", new String[]{qError.replace(qError.length() - 1, qError.length(), "").toString()}) + "\n");
        }
        if (sBillNumErr.length() > 0) {
            err.append(this.getResource("detailError2", new String[]{sBillNumErr.replace(sBillNumErr.length() - 1, sBillNumErr.length(), "").toString()}) + "\n");
        }
        if (moNumErr.length() > 0) {
            err.append(this.getResource("detailError3", new String[]{moNumErr.replace(moNumErr.length() - 1, moNumErr.length(), "").toString()}) + "\n");
        }
        if (sumErr.length() > 0) {
            err.append(sumErr);
        }
        if (err.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)DirectDeliveryDetailUI.getResource("AutoDispathFaild"), (String)err.toString(), (int)2);
            SysUtil.abort();
        }
        this.SaveDirectBillQty();
        this.isSave = true;
        this.actionExitCurrent_actionPerformed(e);
    }

    private void SaveDirectBillQty() {
        int j;
        DirectDetailInfo detail;
        int i;
        DirectDeliveryBillInfo billInfo = (DirectDeliveryBillInfo)this.getUIContext().get("uiObject");
        this.dataBinder.setValueObject((IObjectValue)this.headInfo);
        this.storeFields();
        billInfo.getDetails().clear();
        for (i = 0; i < this.headInfo.getDetails().size(); ++i) {
            detail = this.headInfo.getDetails().get(i);
            billInfo.getDetails().add(detail);
        }
        for (j = 0; j < billInfo.getSources().size(); ++j) {
            DirectSourceInfo source = billInfo.getSources().get(j);
            source.setAssignQty(new BigDecimal("0"));
            source.setBaseAssignQty(new BigDecimal("0"));
            source.setAffrimDirectQty(new BigDecimal("0"));
            source.setBaseAffDirQty(new BigDecimal("0"));
        }
        for (j = 0; j < billInfo.getDests().size(); ++j) {
            DirectDestInfo dest = billInfo.getDests().get(j);
            dest.setAffirmReceiveQty(new BigDecimal("0"));
            dest.setBaseAffrimReceQty(new BigDecimal("0"));
        }
        for (i = 0; i < this.headInfo.getDetails().size(); ++i) {
            BigDecimal baseAssignQty;
            BigDecimal assignQty;
            int j2;
            detail = this.headInfo.getDetails().get(i);
            for (j2 = 0; j2 < billInfo.getSources().size(); ++j2) {
                DirectSourceInfo source = billInfo.getSources().get(j2);
                if (!source.getId().toString().equals(detail.getSourceId())) continue;
                assignQty = source.getAssignQty();
                baseAssignQty = source.getBaseAssignQty();
                assignQty = assignQty.add(detail.getAssianQty());
                baseAssignQty = baseAssignQty.add(detail.getBaseAssignQty());
                source.setAffrimDirectQty(assignQty);
                source.setBaseAffDirQty(baseAssignQty);
                source.setAssignQty(assignQty);
                source.setBaseAssignQty(baseAssignQty);
            }
            for (j2 = 0; j2 < billInfo.getDests().size(); ++j2) {
                DirectDestInfo dest = billInfo.getDests().get(j2);
                if (!dest.getId().toString().equals(detail.getDestId())) continue;
                assignQty = dest.getAffirmReceiveQty();
                baseAssignQty = dest.getBaseAffrimReceQty();
                assignQty = assignQty.add(detail.getReceQty());
                baseAssignQty = baseAssignQty.add(detail.getBaseAssignQty());
                dest.setAffirmReceiveQty(assignQty);
            }
        }
        this.getUIContext().put("uiObject", billInfo);
        this.getUIContext().put("operation", "confirm");
    }

    private void checkQtyMatch(DirectDeliveryBillInfo billInfo) {
        DirectSourceCollection sources;
        String key;
        String trackNumberId;
        String projectId;
        String materialId;
        int i;
        int i2;
        DirectSourceCollection invSrc = (DirectSourceCollection)((Object)billInfo.getSources().clone());
        DirectSourceCollection moSrc = (DirectSourceCollection)((Object)billInfo.getSources().clone());
        DirectSourceCollection purReqSrc = (DirectSourceCollection)((Object)billInfo.getSources().clone());
        DirectSourceInfo source = null;
        for (i2 = invSrc.size() - 1; i2 >= 0; --i2) {
            source = invSrc.get(i2);
            if (source.getSourceType() != null && source.getSourceType().getValue() == 10) continue;
            invSrc.removeObject(i2);
        }
        for (i2 = moSrc.size() - 1; i2 >= 0; --i2) {
            source = moSrc.get(i2);
            if (source.getSourceType() != null && source.getSourceType().getValue() == 30) continue;
            moSrc.removeObject(i2);
        }
        for (i2 = purReqSrc.size() - 1; i2 >= 0; --i2) {
            source = purReqSrc.get(i2);
            if (source.getSourceType() != null && source.getSourceType().getValue() == 20) continue;
            purReqSrc.removeObject(i2);
        }
        HashMap<String, DirectSourceCollection> sourceMap = new HashMap<String, DirectSourceCollection>();
        for (i = 0; i < invSrc.size(); ++i) {
            source = invSrc.get(i);
            if (source.getMaterial() == null) continue;
            materialId = source.getMaterial().getId().toString();
            projectId = source.getProject() == null ? "" : source.getProject().getId().toString();
            trackNumberId = source.getTrackNumber() == null ? "" : source.getTrackNumber().getId().toString();
            key = materialId + "," + projectId + "," + trackNumberId;
            if (sourceMap.containsKey(key)) {
                sources = (DirectSourceCollection)((Object)sourceMap.get(key));
                sources.add(source);
                sourceMap.put(key, sources);
                continue;
            }
            sources = new DirectSourceCollection();
            sources.add(source);
            sourceMap.put(key, sources);
        }
        for (i = 0; i < moSrc.size(); ++i) {
            source = moSrc.get(i);
            if (source.getMaterial() == null) continue;
            materialId = source.getMaterial().getId().toString();
            projectId = source.getProject() == null ? "" : source.getProject().getId().toString();
            trackNumberId = source.getTrackNumber() == null ? "" : source.getTrackNumber().getId().toString();
            key = materialId + "," + projectId + "," + trackNumberId;
            if (sourceMap.containsKey(key)) {
                sources = (DirectSourceCollection)((Object)sourceMap.get(key));
                sources.add(source);
                sourceMap.put(key, sources);
                continue;
            }
            sources = new DirectSourceCollection();
            sources.add(source);
            sourceMap.put(key, sources);
        }
        for (i = 0; i < purReqSrc.size(); ++i) {
            source = purReqSrc.get(i);
            if (source.getMaterial() == null) continue;
            materialId = source.getMaterial().getId().toString();
            projectId = source.getProject() == null ? "" : source.getProject().getId().toString();
            trackNumberId = source.getTrackNumber() == null ? "" : source.getTrackNumber().getId().toString();
            key = materialId + "," + projectId + "," + trackNumberId;
            if (sourceMap.containsKey(key)) {
                sources = (DirectSourceCollection)((Object)sourceMap.get(key));
                sources.add(source);
                sourceMap.put(key, sources);
                continue;
            }
            sources = new DirectSourceCollection();
            sources.add(source);
            sourceMap.put(key, sources);
        }
        HashMap<String, DirectDestCollection> destMap = new HashMap<String, DirectDestCollection>();
        DirectDestCollection dests = (DirectDestCollection)((Object)billInfo.getDests().clone());
        DirectDestInfo dest = null;
        for (int i3 = 0; i3 < dests.size(); ++i3) {
            DirectDestCollection destColls;
            dest = dests.get(i3);
            if (dest.getPickmaterial() == null) continue;
            String materialId2 = dest.getPickmaterial().getId().toString();
            String projectId2 = dest.getProject() == null ? "" : dest.getProject().getId().toString();
            String trackNumberId2 = dest.getTrackNumber() == null ? "" : dest.getTrackNumber().getId().toString();
            String key2 = materialId2 + "," + projectId2 + "," + trackNumberId2;
            if (destMap.containsKey(key2)) {
                destColls = (DirectDestCollection)((Object)destMap.get(key2));
                destColls.add(dest);
                destMap.put(key2, destColls);
                continue;
            }
            destColls = new DirectDestCollection();
            destColls.add(dest);
            destMap.put(key2, destColls);
        }
        Set sourceSet = sourceMap.keySet();
        Iterator it = sourceSet.iterator();
        StringBuffer errStr = new StringBuffer();
        while (it.hasNext()) {
            StringBuffer sumErr = new StringBuffer();
            StringBuffer sumErr1 = new StringBuffer();
            String key3 = it.next().toString();
            DirectSourceCollection sources2 = (DirectSourceCollection)((Object)sourceMap.get(key3));
            BigDecimal totalBaseAffirmQty = new BigDecimal("0");
            BigDecimal curDirectQty = new BigDecimal("0");
            for (int i4 = 0; i4 < sources2.size(); ++i4) {
                DirectSourceInfo src = sources2.get(i4);
                curDirectQty = src.getBaseCurDirQty() == null ? new BigDecimal("0") : src.getBaseCurDirQty();
                totalBaseAffirmQty = totalBaseAffirmQty.add(src.getBaseAffDirQty() == null ? new BigDecimal("0") : src.getBaseAffDirQty());
            }
            if (destMap.get(key3) == null) continue;
            DirectDestCollection destColls = (DirectDestCollection)((Object)destMap.get(key3));
            BigDecimal totalBaseCurRecQty = new BigDecimal("0");
            for (int i5 = 0; i5 < destColls.size(); ++i5) {
                DirectDestInfo currDest = destColls.get(i5);
                totalBaseCurRecQty = totalBaseCurRecQty.add(currDest.getBaseCurReceiveQty() == null ? new BigDecimal("0") : currDest.getBaseCurReceiveQty());
            }
            if (totalBaseAffirmQty.subtract(totalBaseCurRecQty).doubleValue() > 0.0) {
                DirectSourceInfo src = sources2.get(0);
                sumErr.append(DirectDeliveryDetailUI.getResource(TB_MATERIAL) + src.getMaterial().getNumber());
                if (src.getProject() != null) {
                    sumErr.append(DirectDeliveryDetailUI.getResource(TB_PROJECTNUMBER) + src.getProject().getNumber());
                }
                if (src.getTrackNumber() != null) {
                    sumErr.append(DirectDeliveryDetailUI.getResource(TB_TRACKNUMBER) + src.getTrackNumber().getNumber());
                }
                sumErr.append(DirectDeliveryDetailUI.getResource("affirmQtyOver"));
            }
            if (totalBaseAffirmQty.subtract(curDirectQty).doubleValue() > 0.0) {
                DirectSourceInfo src = sources2.get(0);
                sumErr1.append(DirectDeliveryDetailUI.getResource(TB_MATERIAL) + src.getMaterial().getNumber());
                if (src.getProject() != null) {
                    sumErr1.append(DirectDeliveryDetailUI.getResource(TB_PROJECTNUMBER) + src.getProject().getNumber());
                }
                if (src.getTrackNumber() != null) {
                    sumErr1.append(DirectDeliveryDetailUI.getResource(TB_TRACKNUMBER) + src.getTrackNumber().getNumber());
                }
                sumErr1.append(DirectDeliveryDetailUI.getResource("affirmQtyOverCurrReceQty"));
            }
            if (sumErr.length() > 0) {
                errStr.append(sumErr.toString() + "\n");
            }
            if (sumErr1.length() <= 0) continue;
            errStr.append(sumErr1.toString() + "\n");
        }
        if (errStr.length() > 0) {
            MsgBox.showInfo((String)errStr.toString());
            SysUtil.abort();
        }
    }

    private void initLocationF7() {
        KDBizPromptBox prmtLocation = new KDBizPromptBox();
        prmtLocation.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7LocationQuery");
        prmtLocation.setVisible(true);
        prmtLocation.setDisplayFormat("$name$");
        prmtLocation.setEditFormat("$number$");
        prmtLocation.setCommitFormat("$number$");
        ObjectValueRender locationRender = new ObjectValueRender();
        locationRender.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtDetail.getColumn(TB_LOCATION).setRenderer((IBasicRender)locationRender);
        this.kdtDetail.getColumn(TB_LOCATION).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtLocation));
        this.kdtDetail.getColumn(TB_LOCATION).setRenderer((IBasicRender)locationRender);
    }

    private void initWarehouseF7() {
        KDBizPromptBox prmtWarehouse = new KDBizPromptBox();
        prmtWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7AllWarehouseQuery");
        prmtWarehouse.setVisible(true);
        prmtWarehouse.setDisplayFormat("$name$");
        prmtWarehouse.setEditFormat("$number$");
        prmtWarehouse.setCommitFormat("$number$");
        KDTDefaultCellEditor kdtSources_warehouse_CellEditor = new KDTDefaultCellEditor((IKDEditor)prmtWarehouse);
        this.kdtDetail.getColumn(TB_WAREHOUSE).setEditor((ICellEditor)kdtSources_warehouse_CellEditor);
        ObjectValueRender kdtSources_warehouse_OVR = new ObjectValueRender();
        kdtSources_warehouse_OVR.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtDetail.getColumn(TB_WAREHOUSE).setRenderer((IBasicRender)kdtSources_warehouse_OVR);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onLoad() throws Exception {
        Boolean isSpan;
        super.onLoad();
        this.strategyCatch = (Map)this.getUIContext().get("strategyCatch");
        KDComboBox kdtSources_souceType_ComboBox = new KDComboBox();
        kdtSources_souceType_ComboBox.setName("cbSourceType");
        kdtSources_souceType_ComboBox.setVisible(true);
        kdtSources_souceType_ComboBox.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.mm.sfc.DirectSourceTypeEnum").toArray());
        KDTDefaultCellEditor kdtSources_souceType_CellEditor = new KDTDefaultCellEditor((JComboBox)kdtSources_souceType_ComboBox);
        this.kdtDetail.getColumn(TB_SOURCETYPE).setEditor((ICellEditor)kdtSources_souceType_CellEditor);
        KDFormattedTextField assignQtyCol = new KDFormattedTextField();
        assignQtyCol.setName(TB_ASSIGNQTY);
        assignQtyCol.setVisible(true);
        assignQtyCol.setEditable(true);
        assignQtyCol.setHorizontalAlignment(2);
        assignQtyCol.setDataType(1);
        assignQtyCol.setPrecision(8);
        assignQtyCol.setNegatived(false);
        this.kdtDetail.getColumn(TB_ASSIGNQTY).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)assignQtyCol));
        KDFormattedTextField recQtyCol = new KDFormattedTextField();
        recQtyCol.setName(TB_RECQTY);
        recQtyCol.setVisible(true);
        recQtyCol.setEditable(true);
        recQtyCol.setHorizontalAlignment(2);
        recQtyCol.setDataType(1);
        recQtyCol.setPrecision(8);
        recQtyCol.setNegatived(false);
        this.kdtDetail.getColumn(TB_RECQTY).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)recQtyCol));
        KDBizPromptBox prmtSourceUnit = new KDBizPromptBox();
        prmtSourceUnit.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery");
        prmtSourceUnit.setVisible(true);
        prmtSourceUnit.setEditable(true);
        prmtSourceUnit.setDisplayFormat("$name$");
        prmtSourceUnit.setEditFormat("$number$");
        prmtSourceUnit.setCommitFormat("$number$");
        this.kdtDetail.getColumn(TB_SOURCEUNIT).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSourceUnit));
        ObjectValueRender ovr = new ObjectValueRender();
        ovr.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtDetail.getColumn(TB_SOURCEUNIT).setRenderer((IBasicRender)ovr);
        KDBizPromptBox prmtBaseUnit = new KDBizPromptBox();
        prmtBaseUnit.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery");
        prmtBaseUnit.setVisible(true);
        prmtBaseUnit.setEditable(true);
        prmtBaseUnit.setDisplayFormat("$name$");
        prmtBaseUnit.setEditFormat("$number$");
        prmtBaseUnit.setCommitFormat("$number$");
        this.kdtDetail.getColumn(TB_BASEUNIT).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtBaseUnit));
        ObjectValueRender baseUnitOve = new ObjectValueRender();
        ovr.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtDetail.getColumn(TB_BASEUNIT).setRenderer((IBasicRender)baseUnitOve);
        KDBizPromptBox prmtDestUnit = new KDBizPromptBox();
        prmtDestUnit.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery");
        prmtDestUnit.setVisible(true);
        prmtDestUnit.setEditable(true);
        prmtDestUnit.setDisplayFormat("$name$");
        prmtDestUnit.setEditFormat("$number$");
        prmtDestUnit.setCommitFormat("$number$");
        this.kdtDetail.getColumn(TB_DESTUNIT).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtDestUnit));
        this.kdtDetail.getColumn(TB_DESTUNIT).setRenderer((IBasicRender)ovr);
        KDDatePicker productDate_DatePicker = new KDDatePicker();
        productDate_DatePicker.setName("kdtSources_productDate_DatePicker");
        productDate_DatePicker.setVisible(true);
        productDate_DatePicker.setEditable(true);
        KDTDefaultCellEditor productDate_CellEditor = new KDTDefaultCellEditor(productDate_DatePicker);
        this.kdtDetail.getColumn(TB_PRODUCTDATE).setEditor((ICellEditor)productDate_CellEditor);
        KDDatePicker exp_DatePicker = new KDDatePicker();
        exp_DatePicker.setName("kdtSources_productDate_DatePicker");
        exp_DatePicker.setVisible(true);
        exp_DatePicker.setEditable(true);
        KDTDefaultCellEditor exp_CellEditor = new KDTDefaultCellEditor(exp_DatePicker);
        this.kdtDetail.getColumn(TB_EXP).setEditor((ICellEditor)exp_CellEditor);
        KDBizPromptBox prmtProject = new KDBizPromptBox();
        prmtProject.setQueryInfo("com.kingdee.eas.mm.project.app.F7ProjectQuery");
        prmtProject.setVisible(true);
        prmtProject.setEditable(true);
        prmtProject.setDisplayFormat("$number$");
        prmtProject.setEditFormat("$number$");
        prmtProject.setCommitFormat("$number$");
        KDTDefaultCellEditor kdtDest_projectNumber_CellEditor = new KDTDefaultCellEditor((IKDEditor)prmtProject);
        this.kdtDetail.getColumn(TB_PROJECTNUMBER).setEditor((ICellEditor)kdtDest_projectNumber_CellEditor);
        ObjectValueRender kdtDest_projectNumber_OVR = new ObjectValueRender();
        kdtDest_projectNumber_OVR.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtDetail.getColumn(TB_PROJECTNUMBER).setRenderer((IBasicRender)kdtDest_projectNumber_OVR);
        KDBizPromptBox prmtTrackNumber = new KDBizPromptBox();
        prmtTrackNumber.setQueryInfo("com.kingdee.eas.mm.basedata.app.TrackNumberQuery");
        prmtTrackNumber.setVisible(true);
        prmtTrackNumber.setEditable(true);
        prmtTrackNumber.setDisplayFormat("$number$");
        prmtTrackNumber.setEditFormat("$number$");
        prmtTrackNumber.setCommitFormat("$number$");
        KDTDefaultCellEditor kdtDest_trackNumber_CellEditor = new KDTDefaultCellEditor((IKDEditor)prmtTrackNumber);
        this.kdtDetail.getColumn(TB_TRACKNUMBER).setEditor((ICellEditor)kdtDest_trackNumber_CellEditor);
        ObjectValueRender kdtDest_trackNumber_OVR = new ObjectValueRender();
        kdtDest_trackNumber_OVR.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtDetail.getColumn(TB_TRACKNUMBER).setRenderer((IBasicRender)kdtDest_trackNumber_OVR);
        KDBizPromptBox prmtPurOrderEntry = new KDBizPromptBox();
        prmtPurOrderEntry.setQueryInfo("com.kingdee.eas.mm.sfc.app.F7PurOrderEntryQuery");
        prmtPurOrderEntry.setVisible(true);
        prmtPurOrderEntry.setEditable(true);
        prmtPurOrderEntry.setDisplayFormat("$id$");
        prmtPurOrderEntry.setEditFormat("$id$");
        prmtPurOrderEntry.setCommitFormat("$id$");
        KDTDefaultCellEditor kdtDetail_purOrderEntry_CellEditor = new KDTDefaultCellEditor((IKDEditor)prmtPurOrderEntry);
        this.kdtDetail.getColumn(TB_PURORDERENTRY).setEditor((ICellEditor)kdtDetail_purOrderEntry_CellEditor);
        ObjectValueRender kdtDetail_purOrderEntry_OVR = new ObjectValueRender();
        kdtDetail_purOrderEntry_OVR.setFormat((IDataFormat)new BizDataFormat("$id$"));
        this.kdtDetail.getColumn(TB_PURORDERENTRY).setRenderer((IBasicRender)kdtDetail_purOrderEntry_OVR);
        KDBizPromptBox prmtMO = new KDBizPromptBox();
        prmtMO.setQueryInfo("com.kingdee.eas.mm.mo.app.F7ManufactureOrderQuery");
        prmtMO.setVisible(true);
        prmtMO.setEditable(true);
        prmtMO.setDisplayFormat("$id$");
        prmtMO.setEditFormat("$id$");
        prmtMO.setCommitFormat("$id$");
        KDTDefaultCellEditor kdtDetail_trackNumber_CellEditor = new KDTDefaultCellEditor((IKDEditor)prmtMO);
        this.kdtDetail.getColumn(TB_MO).setEditor((ICellEditor)kdtDetail_trackNumber_CellEditor);
        ObjectValueRender kdtDetail_MO_OVR = new ObjectValueRender();
        kdtDetail_MO_OVR.setFormat((IDataFormat)new BizDataFormat("$id$"));
        this.kdtDetail.getColumn(TB_MO).setRenderer((IBasicRender)kdtDetail_MO_OVR);
        KDBizPromptBox prmtPickingMaterial = new KDBizPromptBox();
        prmtPickingMaterial.setQueryInfo("com.kingdee.eas.basedata.master.material.app.MaterialQuery");
        prmtPickingMaterial.setEditFormat("$number$");
        prmtPickingMaterial.setDisplayFormat("$number$");
        prmtPickingMaterial.setCommitFormat("$number$");
        prmtPickingMaterial.setVisible(true);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtDetail.getColumn(TB_PICKMATERIALNUMBER).setRenderer((IBasicRender)avr);
        this.kdtDetail.getColumn(TB_PICKMATERIALNUMBER).getStyleAttributes().setLocked(true);
        this.kdtDetail.getColumn(TB_PICKMATERIALNUMBER).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtPickingMaterial));
        BindingUtility.loadDetailData((IObjectValue)this.headInfo, (Field)new Field("header"), (DataComponentMap)this.dataBinder.getDataComponentMap(), null);
        this.initWarehouseF7();
        this.initLocationF7();
        DirectDeliveryBillInfo billInfo = (DirectDeliveryBillInfo)this.getUIContext().get("uiObject");
        this.copyDirectBillInfo = (DirectDeliveryBillInfo)billInfo.clone();
        if (billInfo.getDetails().size() > 0) {
            MaterialInfo[] sourceMaterials = new MaterialInfo[billInfo.getDetails().size()];
            MeasureUnitInfo[] sourceUnits = new MeasureUnitInfo[billInfo.getDetails().size()];
            MaterialInfo[] destMaterials = new MaterialInfo[billInfo.getDetails().size()];
            MeasureUnitInfo[] destUnits = new MeasureUnitInfo[billInfo.getDetails().size()];
            MeasureUnitInfo[] baseUnits = new MeasureUnitInfo[billInfo.getDetails().size()];
            for (int i = 0; i < billInfo.getDetails().size(); ++i) {
                DirectDetailInfo detail = billInfo.getDetails().get(i);
                sourceMaterials[i] = detail.getMaterial();
                sourceUnits[i] = detail.getUnit();
                baseUnits[i] = detail.getBaseUnit();
                destMaterials[i] = detail.getMaterial();
                destUnits[i] = detail.getDestUnit();
            }
            this.headVO = this.getOrderPrecision(billInfo.getSourceOrgUnit(), sourceMaterials, sourceUnits, baseUnits);
            this.destVo = this.getOrderPrecision(billInfo.getSourceOrgUnit(), destMaterials, destUnits, baseUnits);
        }
        for (int i = 0; i < billInfo.getDetails().size(); ++i) {
            int unitPrec;
            Object material;
            DirectDetailInfo detail = billInfo.getDetails().get(i);
            IRow row = this.kdtDetail.addRow();
            this.dataBinder.loadLineFields(this.kdtDetail, row, (IObjectValue)detail);
            this.initDESTMOF7(i, detail.getMaterial(), detail.getProject(), detail.getTrackNumber());
            if (detail.getSourceType().getValue() == 20) {
                row.getCell(TB_SOURCEBILLNUMBER).getStyleAttributes().setLocked(false);
                this.initPurOrderF7(i);
                this.initMaterialF7(i);
                if (row.getCell(TB_PURORDERENTRY).getValue() != null) {
                    PurOrderEntryInfo pEntry = (PurOrderEntryInfo)row.getCell(TB_PURORDERENTRY).getValue();
                    row.getCell(TB_SOURCEBILLNUMBER).setValue((Object)pEntry);
                }
                if (row.getCell(TB_MATERIAL).getValue() != null) {
                    material = row.getCell(TB_MATERIAL).getValue();
                    row.getCell(TB_MATERIALNUMBER).setValue(material);
                    row.getCell(TB_MATERIALNUMBER).getStyleAttributes().setLocked(true);
                }
            } else if (detail.getSourceType().getValue() == 30) {
                row.getCell(TB_SOURCEBILLNUMBER).getStyleAttributes().setLocked(false);
                this.initSourceMOF7(i);
                this.initMaterialF7(i);
                if (row.getCell(TB_MO).getValue() != null) {
                    ManufactureOrderInfo mo = (ManufactureOrderInfo)row.getCell(TB_MO).getValue();
                    row.getCell(TB_SOURCEBILLNUMBER).setValue((Object)mo);
                }
                if (row.getCell(TB_MATERIAL).getValue() != null) {
                    material = row.getCell(TB_MATERIAL).getValue();
                    row.getCell(TB_MATERIALNUMBER).setValue(material);
                    row.getCell(TB_MATERIALNUMBER).getStyleAttributes().setLocked(true);
                }
            } else {
                row.getCell(TB_SOURCEBILLNUMBER).getStyleAttributes().setLocked(true);
                this.initInvF7(i);
                FilterInfo filter = new FilterInfo();
                MaterialInfo material2 = null;
                if (row.getCell(TB_MATERIAL).getValue() != null) {
                    material2 = (MaterialInfo)row.getCell(TB_MATERIAL).getValue();
                    filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)material2.getId().toString(), CompareType.EQUALS));
                }
                WarehouseInfo wh = null;
                if (row.getCell(TB_WAREHOUSE).getValue() != null) {
                    wh = (WarehouseInfo)row.getCell(TB_WAREHOUSE).getValue();
                    filter.getFilterItems().add(new FilterItemInfo("warehouse.id", (Object)wh.getId().toString(), CompareType.EQUALS));
                }
                LocationInfo location = null;
                if (row.getCell(TB_LOCATION).getValue() != null) {
                    location = (LocationInfo)row.getCell(TB_LOCATION).getValue();
                    filter.getFilterItems().add(new FilterItemInfo("location.id", (Object)location.getId().toString(), CompareType.EQUALS));
                }
                String lotNo = null;
                if (row.getCell(TB_LOTNO).getValue() != null) {
                    lotNo = row.getCell(TB_LOTNO).getValue().toString();
                    filter.getFilterItems().add(new FilterItemInfo("lot", (Object)lotNo, CompareType.EQUALS));
                }
                EntityViewInfo viewer = new EntityViewInfo();
                viewer.setFilter(filter);
                viewer.setSelector(DirectDeliveryClientUtils.getSourceMaterialSelector());
                InventoryCollection inventorys = InventoryFactory.getRemoteInstance().getInventoryCollection(viewer);
                if (inventorys.size() > 0) {
                    row.getCell(TB_MATERIALNUMBER).setValue((Object)inventorys.get(0));
                }
            }
            int baseUnitPrec = this.getPrec(detail.getMaterial(), detail.getBaseUnit());
            SCMClientUtils.changeTableColPrecision((int)baseUnitPrec, (KDTable)this.kdtDetail, (String[])new String[]{TB_BASEASSIGNQTY}, (int)i, (boolean)false);
            int srcPrec = unitPrec = this.getPrec(detail.getMaterial(), detail.getUnit());
            SCMClientUtils.changeTableColPrecision((int)srcPrec, (KDTable)this.kdtDetail, (String[])new String[]{TB_ASSIGNQTY}, (int)i, (boolean)false);
            int descPrec = this.getDestPrec(detail.getMaterial(), detail.getDestUnit());
            SCMClientUtils.changeTableColPrecision((int)descPrec, (KDTable)this.kdtDetail, (String[])new String[]{TB_DESTRECEIVEDQTY, TB_RECQTY, TB_DESTQTY}, (int)i, (boolean)false);
        }
        if (this.getUIContext().get("oprtState") != null) {
            String oprtState = this.getUIContext().get("oprtState").toString();
            if (oprtState.equals(OprtState.VIEW)) {
                this.kDSubmit.setEnabled(false);
                this.actionAddLine.setEnabled(false);
                this.actionInsertLine.setEnabled(false);
                this.actionDeleteLine.setEnabled(false);
                this.kdtDetail.setEnabled(false);
            } else {
                this.kDSubmit.setEnabled(true);
                this.actionAddLine.setEnabled(true);
                this.actionInsertLine.setEnabled(true);
                this.actionDeleteLine.setEnabled(true);
                this.kdtDetail.setEnabled(true);
            }
        }
        if ((isSpan = (Boolean)this.getUIContext().get("isSpan")).booleanValue()) {
            this.kdtDetail.getColumn(TB_RECEIVEWAREHOUSE).getStyleAttributes().setHided(true);
        } else {
            this.kdtDetail.getColumn(TB_RECEIVEWAREHOUSE).getStyleAttributes().setHided(false);
        }
        this.kdtDetail.getActionMap().remove("Delete");
        this.kdtDetail.getActionMap().remove("Paste");
        if (this.kdtDetail.getViewManager().getFreezeCol() <= 0) {
            this.kdtDetail.getViewManager().setFreezeView(-1, this.kdtDetail.getColumnIndex(TB_MATERIALNUMBER) + 1);
        }
        this.kdtDetail.getColumn(TB_PRODUCTDATE).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.kdtDetail.getColumn(TB_EXP).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.kdtDetail.getColumn(TB_DEMANDDATA).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
    }

    public boolean destroyWindow() {
        if (!this.isSave) {
            this.getUIContext().put("uiObject", this.copyDirectBillInfo);
            this.getUIContext().put("operation", "nosave");
        }
        return super.destroyWindow();
    }

    private SCMEntryDataVO getOrderPrecision(StorageOrgUnitInfo storageOrg, MaterialInfo[] material, MeasureUnitInfo[] unit, MeasureUnitInfo[] baseUnit) {
        SCMEntryDataVO voResult = new SCMEntryDataVO();
        if (storageOrg != null && material != null && unit != null && baseUnit != null) {
            MeasureUnitInfo[] measureUnitInfoArray;
            MeasureUnitInfo[] measureUnitInfoArray2;
            MeasureUnitInfo[] measureUnitInfoArray3;
            SCMEntryDataVO vo = new SCMEntryDataVO();
            vo.setMaterialInfos(material);
            vo.setStorageOrgUnitInfos(new StorageOrgUnitInfo[]{storageOrg});
            vo.setIsLoadingMou(true);
            vo.setIsLoadingMmuPrecision(true);
            vo.setIsLoadingMaterialPlan(false);
            vo.setIsLoadingMaterialInventory(false);
            if (unit == null) {
                MeasureUnitInfo[] measureUnitInfoArray4 = new MeasureUnitInfo[1];
                measureUnitInfoArray3 = measureUnitInfoArray4;
                measureUnitInfoArray4[0] = null;
            } else {
                measureUnitInfoArray3 = unit;
            }
            vo.setMeasureUnitInfos(measureUnitInfoArray3);
            if (baseUnit == null) {
                MeasureUnitInfo[] measureUnitInfoArray5 = new MeasureUnitInfo[1];
                measureUnitInfoArray2 = measureUnitInfoArray5;
                measureUnitInfoArray5[0] = null;
            } else {
                measureUnitInfoArray2 = baseUnit;
            }
            vo.setBaseMeasureUnitInfos(measureUnitInfoArray2);
            if (baseUnit == null) {
                MeasureUnitInfo[] measureUnitInfoArray6 = new MeasureUnitInfo[1];
                measureUnitInfoArray = measureUnitInfoArray6;
                measureUnitInfoArray6[0] = null;
            } else {
                measureUnitInfoArray = baseUnit;
            }
            vo.setAssistMeasureUnitInfos(measureUnitInfoArray);
            try {
                voResult = SCMGroupFacadeFactory.getRemoteInstance().loadComplexData(vo);
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
        }
        return voResult;
    }

    private int getPrec(MaterialInfo material, MeasureUnitInfo unitInfo) throws BOSException, EASBizException {
        int prec = 2;
        if (material != null && unitInfo != null) {
            String key = material.getId().toString() + unitInfo.getId().toString();
            if (this.headVO != null && this.headVO.getMmuPrecisions() != null && this.headVO.getMmuPrecisions().get(key) != null) {
                prec = (Integer)this.headVO.getMmuPrecisions().get(key);
            } else {
                IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
                MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(material.getId().toString(), unitInfo.getId().toString());
                prec = multiUnifInfo.getQtyPrecision();
            }
        }
        return prec;
    }

    private int getDestPrec(MaterialInfo material, MeasureUnitInfo unitInfo) {
        int prec = 2;
        if (material != null && unitInfo != null) {
            String key = material.getId().toString() + unitInfo.getId().toString();
            if (this.destVo != null && this.destVo.getMmuPrecisions() != null && this.destVo.getMmuPrecisions().get(key) != null) {
                prec = (Integer)this.destVo.getMmuPrecisions().get(key);
            }
        }
        return prec;
    }

    protected void initDESTMOF7(int rowIndex, MaterialInfo material, ProjectInfo project, TrackNumberInfo trackNumber) {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = DirectDeliveryClientUtils.getDestMOSelector();
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        if (material != null) {
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
            ManufactureStrategyInfo strategy = (ManufactureStrategyInfo)this.strategyCatch.get(material.getId().toString());
            String curTrackNumberId = "";
            if (trackNumber != null) {
                curTrackNumberId = trackNumber.getId().toString();
            }
            String curProjectId = "";
            if (project != null) {
                curProjectId = project.getId().toString();
            }
            if ("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=".equals(strategy.getId().toString()) || "qAYfaBzTrmLgQKjAYj0f3dg0uEU=".equals(strategy.getId().toString())) {
                filter.getFilterItems().add(new FilterItemInfo("trackNumber.id", (Object)curTrackNumberId, CompareType.EQUALS));
            } else if ("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=".equals(strategy.getId().toString())) {
                if (IsolatedRuleEnum.ITEM == strategy.get("rule")) {
                    filter.getFilterItems().add(new FilterItemInfo("project.id", (Object)curProjectId, CompareType.EQUALS));
                } else if (IsolatedRuleEnum.ITEM_TRACKNO == strategy.get("rule")) {
                    filter.getFilterItems().add(new FilterItemInfo("trackNumber.id", (Object)curTrackNumberId, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("project.id", (Object)curProjectId, CompareType.EQUALS));
                }
            }
        } else {
            filter.getFilterItems().add(new FilterItemInfo("material.id", null, CompareType.IS));
        }
        HashSet<String> destSet = new HashSet<String>();
        DirectDeliveryBillInfo billInfo = (DirectDeliveryBillInfo)this.getUIContext().get("uiObject");
        for (int i = 0; i < billInfo.getDests().size(); ++i) {
            DirectDestInfo dest = billInfo.getDests().get(i);
            destSet.add(dest.getSourceBillEntryId());
        }
        if (destSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", destSet, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        String queryInfo = "com.kingdee.eas.mm.sfc.app.F7MOEntryQuery";
        KDBizPromptBox prmtDestMOEntry = new KDBizPromptBox();
        prmtDestMOEntry = new KDBizPromptBox();
        prmtDestMOEntry.setQueryInfo(queryInfo);
        prmtDestMOEntry.setEditFormat("$parent.number$");
        prmtDestMOEntry.setDisplayFormat("$parent.number$");
        prmtDestMOEntry.setCommitFormat("$parent.number$");
        prmtDestMOEntry.setEditable(true);
        prmtDestMOEntry.setSelectorCollection(sic);
        prmtDestMOEntry.setEntityViewInfo(view);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$parent.number$"));
        this.kdtDetail.getColumn(TB_MONUMBER).setRenderer((IBasicRender)avr);
        this.kdtDetail.getColumn(TB_MONUMBER).getStyleAttributes().setLocked(false);
        this.kdtDetail.getCell(rowIndex, TB_MONUMBER).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtDestMOEntry));
    }

    protected void initListener() {
        super.initListener();
        this.detailKDTEditAdapter = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    DirectDeliveryDetailUI.this.detailEntry_changed(e);
                }
                catch (Exception exc) {
                    DirectDeliveryDetailUI.this.handUIException(exc);
                }
            }
        };
        this.kdtDetail.addKDTEditListener((KDTEditListener)this.detailKDTEditAdapter);
    }

    protected void detailEntry_changed(KDTEditEvent e) {
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.kdtDetail.getColumnKey(colIndex);
        if (!SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)newValue)) {
            return;
        }
        try {
            if (TB_SOURCETYPE.equalsIgnoreCase(fieldName)) {
                DirectSourceTypeEnum sourceType = (DirectSourceTypeEnum)((Object)newValue);
                DirectDeliveryClientUtils.setNullExpColls(this.kdtDetail, rowIndex, this.getNotClearColsForSrcType());
                switch (sourceType.getValue()) {
                    case 20: {
                        this.initPurOrderF7(rowIndex);
                        this.initMaterialF7(rowIndex);
                        this.kdtDetail.getCell(rowIndex, TB_MATERIALNUMBER).getStyleAttributes().setLocked(true);
                        this.kdtDetail.getCell(rowIndex, TB_SOURCEBILLNUMBER).getStyleAttributes().setLocked(false);
                        break;
                    }
                    case 30: {
                        this.initSourceMOF7(rowIndex);
                        this.initMaterialF7(rowIndex);
                        this.kdtDetail.getCell(rowIndex, TB_SOURCEBILLNUMBER).getStyleAttributes().setLocked(false);
                        this.kdtDetail.getCell(rowIndex, TB_MATERIALNUMBER).getStyleAttributes().setLocked(true);
                        break;
                    }
                    default: {
                        this.kdtDetail.getCell(rowIndex, TB_SOURCEBILLNUMBER).getStyleAttributes().setLocked(true);
                        this.kdtDetail.getCell(rowIndex, TB_MATERIALNUMBER).getStyleAttributes().setLocked(false);
                        this.initInvF7(rowIndex);
                        break;
                    }
                }
            } else if (TB_SOURCEBILLNUMBER.equalsIgnoreCase(fieldName)) {
                DirectSourceTypeEnum sourceType = (DirectSourceTypeEnum)((Object)this.kdtDetail.getCell(rowIndex, TB_SOURCETYPE).getValue());
                DirectDeliveryBillInfo billInfo = (DirectDeliveryBillInfo)this.getUIContext().get("uiObject");
                String dsinfo_lotno = "";
                if (newValue == null) {
                    DirectDeliveryClientUtils.setNullExpColls(this.kdtDetail, rowIndex, new String[]{TB_SOURCETYPE});
                    return;
                }
                this.kdtDetail.getCell(rowIndex, TB_MONUMBER).getStyleAttributes().setLocked(false);
                for (int i = 0; i < billInfo.getSources().size(); ++i) {
                    DirectSourceInfo tempdsinfo = billInfo.getSources().get(i);
                    if (tempdsinfo.getSourceType().equals((Object)DirectSourceTypeEnum.invSource) || tempdsinfo.getLotNo() == null) continue;
                    if (newValue == null || sourceType == null) break;
                    if ((sourceType.getValue() != 20 || !tempdsinfo.getSourceBillEntryId().equals(((PurOrderEntryInfo)newValue).getId().toString())) && (sourceType.getValue() != 30 || !tempdsinfo.getSourceBillId().equals(((ManufactureOrderInfo)newValue).getId().toString()))) continue;
                    dsinfo_lotno = tempdsinfo.getLotNo();
                }
                if (sourceType != null) {
                    switch (sourceType.getValue()) {
                        case 20: {
                            DirectDeliveryClientUtils.setNullExpColls(this.kdtDetail, rowIndex, this.getNotClearColsForSrcMaterial());
                            PurOrderEntryInfo poEntry = (PurOrderEntryInfo)newValue;
                            SCMClientUtils.changeTableColPrecision((int)this.getPrec(poEntry.getMaterial(), poEntry.getUnit()), (KDTable)this.kdtDetail, (String[])new String[]{TB_ASSIGNQTY}, (int)rowIndex, (boolean)false);
                            SCMClientUtils.changeTableColPrecision((int)this.getPrec(poEntry.getMaterial(), poEntry.getBaseUnit()), (KDTable)this.kdtDetail, (String[])new String[]{TB_BASEASSIGNQTY}, (int)rowIndex, (boolean)false);
                            this.kdtDetail.getCell(rowIndex, TB_SOURCEBILLSEQ).setValue((Object)new Integer(poEntry.getSeq()));
                            this.kdtDetail.getCell(rowIndex, TB_MATERIAL).setValue((Object)poEntry.getMaterial());
                            this.kdtDetail.getCell(rowIndex, TB_MATERIALNUMBER).setValue((Object)poEntry.getMaterial());
                            this.kdtDetail.getCell(rowIndex, TB_MATERIALNAME).setValue((Object)poEntry.getMaterial().getName());
                            this.kdtDetail.getCell(rowIndex, TB_MATERIALMODEL).setValue((Object)poEntry.getMaterial().getModel());
                            if (!dsinfo_lotno.equals("")) {
                                this.kdtDetail.getCell(rowIndex, TB_LOTNO).setValue((Object)dsinfo_lotno);
                            }
                            this.kdtDetail.getCell(rowIndex, TB_SOURCEUNIT).setValue((Object)poEntry.getUnit());
                            this.kdtDetail.getCell(rowIndex, TB_BASEUNIT).setValue((Object)poEntry.getBaseUnit());
                            this.kdtDetail.getCell(rowIndex, TB_PROJECTNUMBER).setValue((Object)poEntry.getProject());
                            this.kdtDetail.getCell(rowIndex, TB_TRACKNUMBER).setValue((Object)poEntry.getTrackNo());
                            this.kdtDetail.getCell(rowIndex, TB_PURORDERENTRY).setValue((Object)poEntry);
                            this.kdtDetail.getCell(rowIndex, TB_ASSISTUNIT).setValue((Object)poEntry.getMaterial().getAssistUnit());
                            this.calBaseAssignQty(rowIndex);
                            this.kdtDetail.getCell(rowIndex, TB_ASSIGNQTY).setValue(null);
                            this.kdtDetail.getCell(rowIndex, TB_BASEASSIGNQTY).setValue(null);
                            this.initSourceId(rowIndex, sourceType, poEntry.getParent().getId().toString(), poEntry.getId().toString(), poEntry.getMaterial());
                            this.initDESTMOF7(rowIndex, poEntry.getMaterial(), poEntry.getProject(), poEntry.getTrackNo());
                            break;
                        }
                        case 30: {
                            DirectDeliveryClientUtils.setNullExpColls(this.kdtDetail, rowIndex, this.getNotClearColsForSrcMaterial());
                            if (newValue == null) {
                                return;
                            }
                            ManufactureOrderInfo moInfo = (ManufactureOrderInfo)newValue;
                            SCMClientUtils.changeTableColPrecision((int)this.getPrec(moInfo.getMaterial(), moInfo.getUnit()), (KDTable)this.kdtDetail, (String[])new String[]{TB_ASSIGNQTY}, (int)rowIndex, (boolean)false);
                            SCMClientUtils.changeTableColPrecision((int)this.getPrec(moInfo.getMaterial(), moInfo.getBaseUnit()), (KDTable)this.kdtDetail, (String[])new String[]{TB_BASEASSIGNQTY}, (int)rowIndex, (boolean)false);
                            this.kdtDetail.getCell(rowIndex, TB_SEQ).setValue(null);
                            this.kdtDetail.getCell(rowIndex, TB_MATERIAL).setValue((Object)moInfo.getMaterial());
                            this.kdtDetail.getCell(rowIndex, TB_MATERIALNUMBER).setValue((Object)moInfo.getMaterial());
                            this.kdtDetail.getCell(rowIndex, TB_MATERIALNAME).setValue((Object)moInfo.getMaterial().getName());
                            this.kdtDetail.getCell(rowIndex, TB_MATERIALMODEL).setValue((Object)moInfo.getMaterial().getModel());
                            if (!dsinfo_lotno.equals("")) {
                                this.kdtDetail.getCell(rowIndex, TB_LOTNO).setValue((Object)dsinfo_lotno);
                            } else {
                                this.kdtDetail.getCell(rowIndex, TB_LOTNO).setValue(null);
                            }
                            this.kdtDetail.getCell(rowIndex, TB_SOURCEUNIT).setValue((Object)moInfo.getUnit());
                            this.kdtDetail.getCell(rowIndex, TB_BASEUNIT).setValue((Object)moInfo.getBaseUnit());
                            this.kdtDetail.getCell(rowIndex, TB_PROJECTNUMBER).setValue((Object)moInfo.getProject());
                            this.kdtDetail.getCell(rowIndex, TB_TRACKNUMBER).setValue((Object)moInfo.getTrackNumber());
                            this.kdtDetail.getCell(rowIndex, TB_MO).setValue((Object)moInfo);
                            this.kdtDetail.getCell(rowIndex, TB_ASSISTUNIT).setValue((Object)moInfo.getMaterial().getAssistUnit());
                            this.calBaseAssignQty(rowIndex);
                            for (int i = 0; i < billInfo.getSources().size(); ++i) {
                                if (!moInfo.getId().equals((Object)billInfo.getSources().get(i).getMo().getId())) continue;
                                DirectSourceInfo tempSourceInfo = billInfo.getSources().get(i);
                                DirectDetailInfo detailInfo = (DirectDetailInfo)this.kdtDetail.getRow(rowIndex).getUserObject();
                                detailInfo.setAssistProperty(tempSourceInfo.getAssistProperty());
                                break;
                            }
                            this.initSourceId(rowIndex, sourceType, moInfo.getId().toString(), null, moInfo.getMaterial());
                            this.initDESTMOF7(rowIndex, moInfo.getMaterial(), moInfo.getProject(), moInfo.getTrackNumber());
                            break;
                        }
                    }
                }
            } else if (TB_MATERIALNUMBER.equalsIgnoreCase(fieldName)) {
                if (newValue == null) {
                    DirectDeliveryClientUtils.setNullExpColls(this.kdtDetail, rowIndex, this.getNotClearColsForSrcMaterial());
                    return;
                }
                this.kdtDetail.getCell(rowIndex, TB_MONUMBER).getStyleAttributes().setLocked(false);
                DirectSourceTypeEnum sourceType = (DirectSourceTypeEnum)((Object)this.kdtDetail.getCell(rowIndex, TB_SOURCETYPE).getValue());
                if (DirectSourceTypeEnum.invSource == sourceType) {
                    InventoryInfo inv = (InventoryInfo)newValue;
                    SCMClientUtils.changeTableColPrecision((int)this.getPrec(inv.getMaterial(), inv.getUnit()), (KDTable)this.kdtDetail, (String[])new String[]{TB_ASSIGNQTY}, (int)rowIndex, (boolean)false);
                    SCMClientUtils.changeTableColPrecision((int)this.getPrec(inv.getMaterial(), inv.getBaseUnit()), (KDTable)this.kdtDetail, (String[])new String[]{TB_BASEASSIGNQTY}, (int)rowIndex, (boolean)false);
                    this.kdtDetail.getCell(rowIndex, TB_MATERIAL).setValue((Object)inv.getMaterial());
                    this.kdtDetail.getCell(rowIndex, TB_MATERIALNUMBER).setValue((Object)inv.getMaterial());
                    this.kdtDetail.getCell(rowIndex, TB_MATERIALNAME).setValue((Object)inv.getMaterial().getName());
                    this.kdtDetail.getCell(rowIndex, TB_MATERIALMODEL).setValue((Object)inv.getMaterial().getModel());
                    this.kdtDetail.getCell(rowIndex, TB_LOTNO).setValue((Object)inv.getLot());
                    this.kdtDetail.getCell(rowIndex, TB_SOURCEUNIT).setValue((Object)inv.getUnit());
                    this.kdtDetail.getCell(rowIndex, TB_BASEUNIT).setValue((Object)inv.getBaseUnit());
                    this.kdtDetail.getCell(rowIndex, TB_ASSISTUNIT).setValue((Object)inv.getAssistUnit());
                    this.kdtDetail.getCell(rowIndex, TB_PROJECTNUMBER).setValue((Object)inv.getProject());
                    this.kdtDetail.getCell(rowIndex, TB_TRACKNUMBER).setValue((Object)inv.getTrackNumber());
                    this.kdtDetail.getCell(rowIndex, TB_WAREHOUSE).setValue((Object)inv.getWarehouse());
                    this.kdtDetail.getCell(rowIndex, TB_LOCATION).setValue((Object)inv.getLocation());
                    this.calBaseAssignQty(rowIndex);
                    this.initSourceIdForInv(rowIndex, sourceType, inv);
                    this.initDESTMOF7(rowIndex, inv.getMaterial(), inv.getProject(), inv.getTrackNumber());
                }
            } else if (TB_MONUMBER.equalsIgnoreCase(fieldName)) {
                if (newValue == null) {
                    this.kdtDetail.getCell(rowIndex, TB_PICKMATERIALNUMBER).setValue(null);
                    this.kdtDetail.getCell(rowIndex, TB_PICKMATERIALNAME).setValue(null);
                    this.kdtDetail.getCell(rowIndex, TB_DESTUNIT).setValue(null);
                    this.kdtDetail.getCell(rowIndex, TB_DEMANDDATA).setValue(null);
                    this.kdtDetail.getCell(rowIndex, TB_OPERATIONNO).setValue(null);
                    this.kdtDetail.getCell(rowIndex, TB_DESTQTY).setValue(null);
                    this.kdtDetail.getCell(rowIndex, TB_DESTRECEIVEDQTY).setValue(null);
                    this.kdtDetail.getCell(rowIndex, TB_RECQTY).setValue(null);
                    this.kdtDetail.getCell(rowIndex, TB_ASSISTUNIT).setValue(null);
                    this.kdtDetail.getCell(rowIndex, TB_ADMINORGUNIT).setValue(null);
                    this.kdtDetail.getCell(rowIndex, TB_PICKDEPT).setValue(null);
                    return;
                }
                DirectSourceTypeEnum sourceType = (DirectSourceTypeEnum)((Object)this.kdtDetail.getCell(rowIndex, TB_SOURCETYPE).getValue());
                if (sourceType != null) {
                    ManufactureOrderStockInfo stock = (ManufactureOrderStockInfo)newValue;
                    SCMClientUtils.changeTableColPrecision((int)this.getPrec(stock.getMaterial(), stock.getUnit()), (KDTable)this.kdtDetail, (String[])new String[]{TB_DESTRECEIVEDQTY, TB_RECQTY, TB_DESTQTY}, (int)rowIndex, (boolean)false);
                    this.kdtDetail.getCell(rowIndex, TB_PICKMATERIALNUMBER).setValue((Object)stock.getParent().getMaterial());
                    this.kdtDetail.getCell(rowIndex, TB_PICKMATERIALNAME).setValue((Object)stock.getParent().getMaterial().getName());
                    this.kdtDetail.getCell(rowIndex, TB_DESTUNIT).setValue((Object)stock.getUnit());
                    this.kdtDetail.getCell(rowIndex, TB_DEMANDDATA).setValue((Object)stock.getDemandTime());
                    this.kdtDetail.getCell(rowIndex, TB_OPERATIONNO).setValue((Object)new Integer(stock.getOperationNo()));
                    this.kdtDetail.getCell(rowIndex, TB_DESTQTY).setValue((Object)stock.getPlannedQty());
                    this.calRecQty(rowIndex);
                    this.kdtDetail.getCell(rowIndex, TB_DESTRECEIVEDQTY).setValue((Object)(stock.getTotalDirectReceiveQty() == null ? new BigDecimal("0") : stock.getTotalDirectReceiveQty()));
                    this.kdtDetail.getCell(rowIndex, TB_ADMINORGUNIT).setValue((Object)stock.getParent().getAdminOrgUnit());
                    this.kdtDetail.getCell(rowIndex, TB_PICKDEPT).setValue((Object)stock.getPickDept());
                    this.initDestId(rowIndex, stock.getId().toString());
                }
            } else if (TB_ASSIGNQTY.equalsIgnoreCase(fieldName)) {
                this.calBaseAssignQty(rowIndex);
                this.calRecQty(rowIndex);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private void calBaseAssignQty(int rowIndex) throws EASBizException, BOSException {
        MaterialInfo material = null;
        if (this.kdtDetail.getCell(rowIndex, TB_MATERIAL).getValue() != null) {
            material = (MaterialInfo)this.kdtDetail.getCell(rowIndex, TB_MATERIAL).getValue();
        }
        MeasureUnitInfo unit = null;
        if (this.kdtDetail.getCell(rowIndex, TB_SOURCEUNIT).getValue() != null) {
            unit = (MeasureUnitInfo)this.kdtDetail.getCell(rowIndex, TB_SOURCEUNIT).getValue();
        }
        MeasureUnitInfo baseUnit = null;
        if (this.kdtDetail.getCell(rowIndex, TB_BASEUNIT).getValue() != null) {
            baseUnit = (MeasureUnitInfo)this.kdtDetail.getCell(rowIndex, TB_BASEUNIT).getValue();
        }
        BigDecimal assignQty = null;
        if (this.kdtDetail.getCell(rowIndex, TB_ASSIGNQTY).getValue() != null) {
            assignQty = (BigDecimal)this.kdtDetail.getCell(rowIndex, TB_ASSIGNQTY).getValue();
        }
        if (material != null && unit != null && baseUnit != null && assignQty != null) {
            BigDecimal baseAssignQty = DirectDeliveryClientUtils.getExchangeQtyForClient(material.getId().toString(), unit, baseUnit, assignQty);
            this.kdtDetail.getCell(rowIndex, TB_BASEASSIGNQTY).setValue((Object)baseAssignQty);
        }
    }

    private void calRecQty(int rowIndex) throws EASBizException, BOSException {
        BigDecimal baseAssignQty = null;
        if (this.kdtDetail.getCell(rowIndex, TB_BASEASSIGNQTY).getValue() != null) {
            baseAssignQty = (BigDecimal)this.kdtDetail.getCell(rowIndex, TB_BASEASSIGNQTY).getValue();
        }
        MaterialInfo material = null;
        if (this.kdtDetail.getCell(rowIndex, TB_MATERIAL).getValue() != null) {
            material = (MaterialInfo)this.kdtDetail.getCell(rowIndex, TB_MATERIAL).getValue();
        }
        MeasureUnitInfo baseUnit = null;
        if (this.kdtDetail.getCell(rowIndex, TB_BASEUNIT).getValue() != null) {
            baseUnit = (MeasureUnitInfo)this.kdtDetail.getCell(rowIndex, TB_BASEUNIT).getValue();
        }
        MeasureUnitInfo destUnit = null;
        if (this.kdtDetail.getCell(rowIndex, TB_DESTUNIT).getValue() != null) {
            destUnit = (MeasureUnitInfo)this.kdtDetail.getCell(rowIndex, TB_DESTUNIT).getValue();
        }
        BigDecimal recQty = new BigDecimal("0");
        if (baseAssignQty != null && material != null && baseUnit != null && destUnit != null) {
            recQty = DirectDeliveryClientUtils.getExchangeQtyForClient(material.getId().toString(), baseUnit, destUnit, baseAssignQty);
        }
        this.kdtDetail.getCell(rowIndex, TB_RECQTY).setValue((Object)recQty);
    }

    protected String[] getNotClearColsForSrcMaterial() {
        return new String[]{TB_SEQ, TB_SOURCETYPE, TB_SOURCEBILLNUMBER};
    }

    protected String[] getNotClearColsForSrcType() {
        return new String[]{TB_SEQ, TB_SOURCETYPE};
    }

    private void initMaterialF7(int rowIndex) {
        KDBizPromptBox prmtPickingMaterial = new KDBizPromptBox();
        prmtPickingMaterial.setQueryInfo("com.kingdee.eas.basedata.master.material.app.MaterialQuery");
        prmtPickingMaterial.setEditFormat("$number$");
        prmtPickingMaterial.setDisplayFormat("$number$");
        prmtPickingMaterial.setCommitFormat("$number$");
        prmtPickingMaterial.setVisible(true);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtDetail.getCell(rowIndex, TB_MATERIALNUMBER).setRenderer((IBasicRender)avr);
        this.kdtDetail.getCell(rowIndex, TB_MATERIALNUMBER).getStyleAttributes().setLocked(true);
        this.kdtDetail.getCell(rowIndex, TB_MATERIALNUMBER).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtPickingMaterial));
    }

    private void initSourceId(int rowIndex, DirectSourceTypeEnum sourceType, String sourceBillId, String sourceBillEntryId, MaterialInfo material) {
        DirectDeliveryBillInfo billInfo = (DirectDeliveryBillInfo)this.getUIContext().get("uiObject");
        for (int i = 0; i < billInfo.getSources().size(); ++i) {
            DirectSourceInfo source = billInfo.getSources().get(i);
            if (!sourceType.equals((Object)source.getSourceType()) || sourceBillId != null && !sourceBillId.equals(source.getSourceBillId()) || sourceBillEntryId != null && !sourceBillEntryId.equals(source.getSourceBillEntryId()) || material != null && !material.getId().toString().equals(source.getMaterial().getId().toString())) continue;
            this.kdtDetail.getCell(rowIndex, TB_SOURCEID).setValue((Object)source.getId().toString());
            this.kdtDetail.getCell(rowIndex, TB_PRODUCTDATE).setValue((Object)source.getProductDate());
            this.kdtDetail.getCell(rowIndex, TB_EXP).setValue((Object)source.getOutDate());
            this.kdtDetail.getCell(rowIndex, TB_WAREHOUSE).setValue((Object)source.getWarehouse());
            this.kdtDetail.getCell(rowIndex, TB_LOCATION).setValue((Object)source.getLocation());
            break;
        }
    }

    private void initSourceIdForInv(int rowIndex, DirectSourceTypeEnum sourceType, InventoryInfo inv) {
        DirectDeliveryBillInfo billInfo = (DirectDeliveryBillInfo)this.getUIContext().get("uiObject");
        for (int i = 0; i < billInfo.getSources().size(); ++i) {
            String sourceProject;
            String sourceTrack;
            String sourceLot;
            String sourceLocationid;
            String sourceWarehouseid;
            MaterialInfo ma;
            DirectSourceInfo source = billInfo.getSources().get(i);
            if (!sourceType.equals((Object)source.getSourceType()) || !(ma = inv.getMaterial()).getId().toString().equals(source.getMaterial().getId().toString())) continue;
            String invWarehouseid = inv.getWarehouse() == null ? "" : inv.getWarehouse().getId().toString();
            String string = sourceWarehouseid = source.getWarehouse() == null ? "" : source.getWarehouse().getId().toString();
            if (!invWarehouseid.equals(sourceWarehouseid)) continue;
            String invLocationid = inv.getLocation() == null ? "" : inv.getLocation().getId().toString();
            String string2 = sourceLocationid = source.getLocation() == null ? "" : source.getLocation().getId().toString();
            if (!invLocationid.equals(sourceLocationid)) continue;
            String invLot = inv.getLot() == null ? "" : inv.getLot();
            String string3 = sourceLot = source.getLotNo() == null ? "" : source.getLotNo();
            if (!invLot.equals(sourceLot)) continue;
            String invTrack = inv.getTrackNumber() == null ? "" : inv.getTrackNumber().getId().toString();
            String string4 = sourceTrack = source.getTrackNumber() == null ? "" : source.getTrackNumber().getId().toString();
            if (!invTrack.equals(sourceTrack)) continue;
            String invProject = inv.getProject() == null ? "" : inv.getProject().getId().toString();
            String string5 = sourceProject = source.getProject() == null ? "" : source.getProject().getId().toString();
            if (!invProject.equals(sourceProject)) continue;
            this.kdtDetail.getCell(rowIndex, TB_SOURCEID).setValue((Object)source.getId().toString());
            this.kdtDetail.getCell(rowIndex, TB_PRODUCTDATE).setValue((Object)source.getProductDate());
            this.kdtDetail.getCell(rowIndex, TB_EXP).setValue((Object)source.getOutDate());
            break;
        }
    }

    private void initDestId(int rowIndex, String moEntryId) {
        DirectDeliveryBillInfo billInfo = (DirectDeliveryBillInfo)this.getUIContext().get("uiObject");
        for (int i = 0; i < billInfo.getDests().size(); ++i) {
            DirectDestInfo dest = billInfo.getDests().get(i);
            if (!dest.getSourceBillEntryId().equals(moEntryId)) continue;
            this.kdtDetail.getCell(rowIndex, TB_DESTID).setValue((Object)dest.getId().toString());
            this.kdtDetail.getCell(rowIndex, TB_RECEIVEWAREHOUSE).setValue((Object)dest.getReceiveWarehouse());
            break;
        }
    }

    protected void initPurOrderF7(int rowIndex) {
        String queryInfo = "com.kingdee.eas.mm.sfc.app.F7PurOrderEntryQuery";
        this.prmtPurOrder = new KDBizPromptBox();
        this.prmtPurOrder.setQueryInfo(queryInfo);
        this.prmtPurOrder.setEditFormat("$parent.number$");
        this.prmtPurOrder.setDisplayFormat("$parent.number$");
        this.prmtPurOrder.setCommitFormat("$parent.number$");
        this.prmtPurOrder.setEditable(true);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = DirectDeliveryClientUtils.getPurOrderSelector();
        view.setSelector(sic);
        this.prmtPurOrder.setSelectorCollection(sic);
        FilterInfo filter = new FilterInfo();
        DirectDeliveryBillInfo billInfo = (DirectDeliveryBillInfo)this.getUIContext().get("uiObject");
        HashSet<String> sourceSet = new HashSet<String>();
        for (int i = 0; i < billInfo.getSources().size(); ++i) {
            DirectSourceInfo source = billInfo.getSources().get(i);
            if (source.getSourceType() == null || source.getSourceType().getValue() != 20) continue;
            sourceSet.add(source.getSourceBillEntryId());
        }
        filter.getFilterItems().add(new FilterItemInfo("id", sourceSet, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtPurOrder.setEntityViewInfo(view);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$parent.number$"));
        this.kdtDetail.getCell(rowIndex, TB_SOURCEBILLNUMBER).setRenderer((IBasicRender)avr);
        this.kdtDetail.getCell(rowIndex, TB_SOURCEBILLNUMBER).getStyleAttributes().setLocked(false);
        this.kdtDetail.getCell(rowIndex, TB_SOURCEBILLNUMBER).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.prmtPurOrder));
    }

    protected void initInvF7(int rowIndex) throws BOSException {
        String queryInfo = "com.kingdee.eas.mm.sfc.app.F7InventoryQuery";
        this.prmtInventory = new KDBizPromptBox();
        this.prmtInventory.setQueryInfo(queryInfo);
        this.prmtInventory.setEditFormat("$material.number$");
        this.prmtInventory.setDisplayFormat("$material.number$");
        this.prmtInventory.setCommitFormat("$material.number$");
        this.prmtInventory.setEditable(true);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = DirectDeliveryClientUtils.getSourceMaterialSelector();
        view.setSelector(sic);
        this.prmtInventory.setSelectorCollection(sic);
        DirectDeliveryBillInfo billInfo = (DirectDeliveryBillInfo)this.getUIContext().get("uiObject");
        FilterInfo filter = new FilterInfo();
        for (int i = 0; i < billInfo.getSources().size(); ++i) {
            DirectSourceInfo source = billInfo.getSources().get(i);
            if (source.getSourceType() == null || source.getMaterial() == null || source.getSourceType().getValue() != 10) continue;
            FilterInfo tempFilter = new FilterInfo();
            if (source.getMaterial() != null) {
                tempFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)source.getMaterial().getId().toString(), CompareType.EQUALS));
            }
            if (source.getWarehouse() != null) {
                tempFilter.getFilterItems().add(new FilterItemInfo("warehouse.id", (Object)source.getWarehouse().getId().toString(), CompareType.EQUALS));
            } else {
                tempFilter.getFilterItems().add(new FilterItemInfo("warehouse.id", null, CompareType.EQUALS));
            }
            if (source.getLocation() != null) {
                tempFilter.getFilterItems().add(new FilterItemInfo("location.id", (Object)source.getLocation().getId().toString(), CompareType.EQUALS));
            } else {
                tempFilter.getFilterItems().add(new FilterItemInfo("location.id", null, CompareType.EQUALS));
            }
            if (source.getLotNo() != null) {
                tempFilter.getFilterItems().add(new FilterItemInfo("lot", (Object)source.getLotNo(), CompareType.EQUALS));
            } else {
                tempFilter.getFilterItems().add(new FilterItemInfo("lot", null, CompareType.EQUALS));
            }
            if (source.getTrackNumber() != null) {
                tempFilter.getFilterItems().add(new FilterItemInfo("trackNumber.id", (Object)source.getTrackNumber().getId().toString(), CompareType.EQUALS));
            } else {
                tempFilter.getFilterItems().add(new FilterItemInfo("trackNumber.id", null, CompareType.EQUALS));
            }
            if (source.getProject() != null) {
                tempFilter.getFilterItems().add(new FilterItemInfo("project.id", (Object)source.getProject().getId().toString(), CompareType.EQUALS));
            } else {
                tempFilter.getFilterItems().add(new FilterItemInfo("project.id", null, CompareType.EQUALS));
            }
            tempFilter.getFilterItems().add(new FilterItemInfo("ROUND(ISNULL(baseqty,0),8)", (Object)new BigDecimal(0), CompareType.GREATER));
            tempFilter.getFilterItems().add(new FilterItemInfo("storestatus.number", (Object)"1", CompareType.EQUALS));
            if (tempFilter.getFilterItems().size() == 0) continue;
            filter.mergeFilter(tempFilter, "OR");
        }
        if (filter.getFilterItems().size() == 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", null, CompareType.EQUALS));
            filter.mergeFilter(filter, "AND");
        }
        view.setFilter(filter);
        this.prmtInventory.setEntityViewInfo(view);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$material.number$"));
        this.kdtDetail.getCell(rowIndex, TB_MATERIALNUMBER).setRenderer((IBasicRender)avr);
        this.kdtDetail.getCell(rowIndex, TB_MATERIALNUMBER).getStyleAttributes().setLocked(false);
        this.kdtDetail.getCell(rowIndex, TB_MATERIALNUMBER).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.prmtInventory));
    }

    protected void initSourceMOF7(int rowIndex) {
        String queryInfo = "com.kingdee.eas.mm.sfc.app.F7MOQuery";
        this.prmtSourceMO = new KDBizPromptBox();
        this.prmtSourceMO.setQueryInfo(queryInfo);
        this.prmtSourceMO.setEditFormat("$number$");
        this.prmtSourceMO.setDisplayFormat("$number$");
        this.prmtSourceMO.setCommitFormat("$number$");
        this.prmtSourceMO.setEditable(true);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = DirectDeliveryClientUtils.getSourceMOSelector();
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        HashSet<String> sourceSet = new HashSet<String>();
        DirectDeliveryBillInfo billInfo = (DirectDeliveryBillInfo)this.getUIContext().get("uiObject");
        for (int i = 0; i < billInfo.getSources().size(); ++i) {
            DirectSourceInfo source = billInfo.getSources().get(i);
            if (source.getSourceType() == null || source.getSourceType().getValue() != 30) continue;
            sourceSet.add(source.getSourceBillId());
        }
        filter.getFilterItems().add(new FilterItemInfo("id", sourceSet, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtSourceMO.setEntityViewInfo(view);
        this.prmtSourceMO.setSelectorCollection(selector);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtDetail.getCell(rowIndex, TB_SOURCEBILLNUMBER).setRenderer((IBasicRender)avr);
        this.kdtDetail.getCell(rowIndex, TB_SOURCEBILLNUMBER).getStyleAttributes().setLocked(false);
        this.kdtDetail.getCell(rowIndex, TB_SOURCEBILLNUMBER).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.prmtSourceMO));
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable() != null) {
            if (this.kdtDetail == null) {
                return;
            }
            IObjectValue detailData = this.createNewDetailData(this.kdtDetail);
            if (detailData != null) {
                IRow row = this.kdtDetail.addRow();
                row.getCell(TB_SOURCEBILLNUMBER).getStyleAttributes().setLocked(true);
                row.getCell(TB_MATERIALNUMBER).getStyleAttributes().setLocked(true);
                this.getUILifeCycleHandler().fireOnAddNewLine((Object)this.kdtDetail, detailData);
                this.dataBinder.loadLineFields(this.kdtDetail, row, detailData);
                row.getCell(TB_MONUMBER).getStyleAttributes().setLocked(true);
            }
        }
    }

    @Override
    public void actionDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable() != null) {
            this.removeLine(this.getDetailTable());
        }
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0 || this.isTableColumnSelected(table)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            int i;
            int size = table.getSelectManager().size();
            KDTSelectBlock selectBlock = null;
            KDTSelectBlock tempBlock = null;
            IRow iRow = null;
            Vector<KDTSelectBlock> vtemp = new Vector<KDTSelectBlock>(0);
            for (i = 0; i < size; ++i) {
                selectBlock = table.getSelectManager().get(i);
                boolean find = false;
                for (int j = 0; j < vtemp.size(); ++j) {
                    tempBlock = (KDTSelectBlock)vtemp.get(j);
                    if (selectBlock.getTop() > tempBlock.getTop()) continue;
                    vtemp.add(j, selectBlock);
                    find = true;
                    break;
                }
                if (find) continue;
                vtemp.add(selectBlock);
            }
            for (i = size - 1; i >= 0; --i) {
                selectBlock = (KDTSelectBlock)vtemp.get(i);
                for (int j = selectBlock.getBottom(); j >= selectBlock.getTop(); --j) {
                    int index;
                    iRow = table.getRow(j);
                    if (iRow == null) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                        return;
                    }
                    IObjectValue detailData = (IObjectValue)iRow.getUserObject();
                    table.removeRow(j);
                    IObjectCollection collection = (IObjectCollection)table.getUserObject();
                    if (collection == null) {
                        logger.error((Object)"collection not be binded to table");
                        continue;
                    }
                    if (detailData == null || (index = this.getCollectionIndex(collection, detailData)) == -1) continue;
                    collection.removeObject(index);
                }
            }
        }
    }

    private int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.getDetailTable().getEditManager().stopEditing();
        if (this.getDetailTable() != null) {
            if (this.kdtDetail == null) {
                return;
            }
            IObjectValue detailData = this.createNewDetailData(this.kdtDetail);
            IRow row = null;
            if (this.kdtDetail.getSelectManager().size() > 0) {
                int top = this.kdtDetail.getSelectManager().get().getTop();
                row = this.isTableColumnSelected(this.kdtDetail) ? this.kdtDetail.addRow() : this.kdtDetail.addRow(top);
            } else {
                row = this.kdtDetail.addRow();
            }
            this.getUILifeCycleHandler().fireOnAddNewLine((Object)this.kdtDetail, detailData);
            this.dataBinder.loadLineFields(this.kdtDetail, row, detailData);
            row.getCell(TB_MONUMBER).getStyleAttributes().setLocked(true);
            row.getCell(TB_SOURCEBILLNUMBER).getStyleAttributes().setLocked(true);
            row.getCell(TB_MATERIALNUMBER).getStyleAttributes().setLocked(true);
        }
        if (this.getDetailTable() != null && this.getDetailTable().getRowCount() != 1 && this.getDetailTable().getRowCount() > 1) {
            this.setDefaultValueOnColumn(this.getDetailTable().getSelectManager().getActiveRowIndex(), 1);
        }
    }

    protected final boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    public void setFieldsToCopy(String[] fieldsToCopy) {
        this.fieldsToCopy = fieldsToCopy;
    }

    protected void setDefaultValueOnColumn(int beginIdx, int count) {
        if (this.fieldsToCopy != null && this.fieldsToCopy.length > 0) {
            Object[] values = new Object[this.fieldsToCopy.length];
            IRow arow = this.getDetailTable().getRow(beginIdx - 1);
            if (arow == null) {
                arow = this.getDetailTable().getRow(beginIdx + 1);
            }
            if (arow == null) {
                arow = this.getDetailTable().getRow(beginIdx);
            }
            if (arow != null) {
                for (int j = 0; j < this.fieldsToCopy.length; ++j) {
                    if (arow.getCell(this.fieldsToCopy[j]) == null) continue;
                    values[j] = arow.getCell(this.fieldsToCopy[j]).getValue();
                }
                for (int i = beginIdx; i < beginIdx + count; ++i) {
                    arow = this.getDetailTable().getRow(i);
                    if (arow == null) continue;
                    for (int j = 0; j < this.fieldsToCopy.length; ++j) {
                        if (arow.getCell(this.fieldsToCopy[j]) == null) continue;
                        arow.getCell(this.fieldsToCopy[j]).setValue(values[j]);
                    }
                }
            }
        }
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.sfc.DirectDeliveryResource", (String)strKey);
    }

    private String getResource(String key, String[] params) {
        String message = ResourceManage.getResource((String)"com.kingdee.eas.mm.sfc.DirectDeliveryResource", (String)key, (Locale)SysContext.getSysContext().getLocale());
        StringBuffer sb = new StringBuffer();
        String REGEX_L = "\\{";
        String REGEX_R = "\\}";
        for (int i = 0; i < params.length; ++i) {
            sb.setLength(0);
            message = message.replaceAll(sb.append(REGEX_L).append(i).append(REGEX_R).toString(), params[i]);
        }
        return message;
    }

    private void submitVerify(IRow row, StringBuffer err) throws EASBizException, BOSException {
        Map curQtyMap = (Map)this.getUIContext().get("curQtyMap");
        BigDecimal curQty = new BigDecimal("0");
        BigDecimal assignQty = new BigDecimal("0");
        if (row.getCell(TB_SOURCEID).getValue() != null && curQtyMap.get(row.getCell(TB_SOURCEID).getValue().toString()) != null) {
            curQty = new BigDecimal((String)curQtyMap.get(row.getCell(TB_SOURCEID).getValue().toString()));
            assignQty = row.getCell(TB_ASSIGNQTY).getValue() != null ? new BigDecimal(row.getCell(TB_ASSIGNQTY).getValue().toString()) : new BigDecimal("0");
        }
        if (curQty.compareTo(assignQty) == -1) {
            err.append(this.getResource("detailUIEntryIndex", new String[]{String.valueOf(row.getRowIndex() + 1)}));
            err.append("   ");
            err.append(this.getResource("detailUIassignQtyOverCurrReceQty", new String[]{(String)curQtyMap.get(row.getCell(TB_SOURCEID).getValue().toString())}));
            err.append("\n");
        }
    }
}

