/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.mm.basedata.ClassGroupEntryCollection;
import com.kingdee.eas.mm.basedata.ClassGroupEntryFactory;
import com.kingdee.eas.mm.basedata.ClassGroupEntryInfo;
import com.kingdee.eas.mm.basedata.ClassGroupInfo;
import com.kingdee.eas.mm.sfc.client.AbstractDisTaskPersonUI;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class DisTaskPersonUI
extends AbstractDisTaskPersonUI {
    private static final Logger logger = CoreUIObject.getLogger(DisTaskPersonUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        AdminOrgUnitInfo workShop = (AdminOrgUnitInfo)this.getUIContext().get("workShop");
        ClassGroupInfo classGroup = (ClassGroupInfo)this.getUIContext().get("classGroup");
        this.prmpDept.setData((Object)workShop);
        this.prmpGroup.setData((Object)classGroup);
        this.getUIContext().put("isCancel", Boolean.TRUE);
    }

    public void onShow() throws Exception {
        super.onShow();
        String disTaskPersonIds = (String)this.getUIContext().get("disTaskPersonIds");
        this.fillData(disTaskPersonIds);
    }

    private void fillData(String disTaskPersonIds) throws BOSException {
        if (this.prmpGroup.getValue() != null) {
            ClassGroupInfo classGroup = (ClassGroupInfo)this.prmpGroup.getValue();
            this.fillDataByClassGroup(classGroup, disTaskPersonIds);
        } else {
            AdminOrgUnitInfo workShop = (AdminOrgUnitInfo)this.prmpDept.getValue();
            this.fillDataByWorkShop(workShop, disTaskPersonIds);
        }
    }

    private void fillDataByClassGroup(ClassGroupInfo classGroup, String disTaskPersonIds) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)classGroup.getId().toString()));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("person.id"));
        view.getSelector().add(new SelectorItemInfo("person.number"));
        view.getSelector().add(new SelectorItemInfo("person.name"));
        ClassGroupEntryCollection ClassGroupEntryCol = ClassGroupEntryFactory.getRemoteInstance().getClassGroupEntryCollection(view);
        if (ClassGroupEntryCol != null) {
            for (ClassGroupEntryInfo classGroupEntry : ClassGroupEntryCol) {
                PersonInfo person = classGroupEntry.getPerson();
                IRow row = this.kdtPerson.addRow();
                row.getCell("id").setValue((Object)person.getId().toString());
                row.getCell("number").setValue((Object)person.getNumber());
                row.getCell("name").setValue((Object)person.getName());
                if (disTaskPersonIds != null && disTaskPersonIds.indexOf(person.getId().toString()) >= 0) {
                    row.getCell("isSelect").setValue((Object)Boolean.TRUE);
                    continue;
                }
                row.getCell("isSelect").setValue((Object)Boolean.FALSE);
            }
        }
    }

    private void fillDataByWorkShop(AdminOrgUnitInfo workShop, String disTaskPersonIds) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("position.adminOrgUnit.id", (Object)workShop.getId().toString()));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("person.id"));
        view.getSelector().add(new SelectorItemInfo("person.number"));
        view.getSelector().add(new SelectorItemInfo("person.name"));
        PositionMemberCollection positionMemberCol = PositionMemberFactory.getRemoteInstance().getPositionMemberCollection(view);
        if (positionMemberCol != null) {
            for (PositionMemberInfo positionMember : positionMemberCol) {
                PersonInfo person = positionMember.getPerson();
                IRow row = this.kdtPerson.addRow();
                row.getCell("id").setValue((Object)person.getId().toString());
                row.getCell("number").setValue((Object)person.getNumber());
                row.getCell("name").setValue((Object)person.getName());
                if (disTaskPersonIds != null && disTaskPersonIds.indexOf(person.getId().toString()) >= 0) {
                    row.getCell("isSelect").setValue((Object)Boolean.TRUE);
                    continue;
                }
                row.getCell("isSelect").setValue((Object)Boolean.FALSE);
            }
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        HashSet<String> idSet = new HashSet<String>();
        HashSet<String> numberSet = new HashSet<String>();
        HashSet<String> nameSet = new HashSet<String>();
        for (int i = 0; i < this.kdtPerson.getRowCount(); ++i) {
            Boolean isSelect = (Boolean)this.kdtPerson.getCell(i, "isSelect").getValue();
            if (!isSelect.booleanValue()) continue;
            String id = (String)this.kdtPerson.getCell(i, "id").getValue();
            String number = (String)this.kdtPerson.getCell(i, "number").getValue();
            String name = (String)this.kdtPerson.getCell(i, "name").getValue();
            idSet.add(id);
            numberSet.add(number);
            nameSet.add(name);
        }
        this.getUIContext().put("disTaskPersonIds", StringUtils.arrayToString((Object[])idSet.toArray(), (String)","));
        this.getUIContext().put("disTaskPersonNumbers", StringUtils.arrayToString((Object[])numberSet.toArray(), (String)","));
        this.getUIContext().put("disTaskPersonNames", StringUtils.arrayToString((Object[])nameSet.toArray(), (String)","));
        this.getUIContext().put("isCancel", Boolean.FALSE);
        this.getUIWindow().close();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("isCancel", Boolean.TRUE);
        this.getUIWindow().close();
    }
}

