/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.sfc.CompletionReportFactory;
import com.kingdee.eas.mm.sfc.ICompletionReport;
import com.kingdee.eas.mm.sfc.InteractionBackflushFacadeFactory;
import com.kingdee.eas.mm.sfc.client.AbstractInteractionBackflushFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.im.inv.IManufactureRecBill;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillFactory;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class InteractionBackflushFilterUI
extends AbstractInteractionBackflushFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(InteractionBackflushFilterUI.class);
    private StorageOrgUnitInfo storageInfo;
    private static final String KEY_STARTDATE = "startDate";
    private static final String KEY_ENDDATE = "endDate";

    public InteractionBackflushFilterUI(StorageOrgUnitInfo storage) throws Exception {
        this.storageInfo = storage;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnitnum", (Component)this.prmtStorageOrgUnit);
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_sfc_interaction");
        mainOrgElement.setDefaultValue((Object)this.storageInfo);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, this.getResource("StorageOrgUnit_IsNotNull")));
        SingleFilterElement adminOrgElement = new SingleFilterElement("adminOrgUnitnum", (Component)this.prmtAdminOrgUnit);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)mainOrgElement);
        elements.add((FilterElement)adminOrgElement);
        UIHelper.registerBizMaterialF7((F7ContextManager)this.f7Manager, (KDBizPromptBox)this.prmptmaterialfrom, null);
        UIHelper.registerBizMaterialF7((F7ContextManager)this.f7Manager, (KDBizPromptBox)this.prmptmaterialto, null);
        SingleFilterElement materialFrom = new SingleFilterElement("materialfrom", (Component)this.prmptmaterialfrom);
        elements.add((FilterElement)materialFrom);
        SingleFilterElement materialTo = new SingleFilterElement("materialto", (Component)this.prmptmaterialto);
        elements.add((FilterElement)materialTo);
        SingleFilterElement recbillfromElement = new SingleFilterElement("recbillfrom", (Component)this.recbillfrom);
        SingleFilterElement recbilltoElement = new SingleFilterElement("recbillto", (Component)this.recbillto);
        elements.add((FilterElement)recbillfromElement);
        elements.add((FilterElement)recbilltoElement);
        SingleFilterElement startdate = new SingleFilterElement("startdatefrom", (Component)this.dateBizDateFrom);
        SingleFilterElement stardateto = new SingleFilterElement("startdateto", (Component)this.dateBizDateTo);
        this.dateBizDateFrom.setTimeEnabled(false);
        this.dateBizDateTo.setTimeEnabled(false);
        startdate.setDefaultValue((Object)this.getSCMQueryTime(null, KEY_STARTDATE));
        stardateto.setDefaultValue((Object)this.getSCMQueryTime(null, KEY_ENDDATE));
        elements.add((FilterElement)startdate);
        elements.add((FilterElement)stardateto);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        StorageOrgUnitInfo storage = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)OrgType.Storage, null);
        this.prmtStorageOrgUnit.setValue((Object)storage);
        this.f7Manager.registerContextChangeF7(this.completionorderNumFrom, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.completionorderNumTo, this.getPropertyOfMainBizOrg());
        SingleFilterElement completionorderNumFromElement = new SingleFilterElement("completionorderNumFrom", (Component)this.completionorderNumFrom);
        SingleFilterElement completionorderNumToElement = new SingleFilterElement("completionorderNumTo", (Component)this.completionorderNumTo);
        this.prmptmaterialfrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                InteractionBackflushFilterUI.this.setMaterialFilter((EventObject)e);
            }
        });
        this.prmptmaterialfrom.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                InteractionBackflushFilterUI.this.setMaterialFilter((EventObject)e);
            }
        });
        this.prmptmaterialto.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                InteractionBackflushFilterUI.this.setMaterialFilter((EventObject)e);
            }
        });
        this.prmptmaterialto.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                InteractionBackflushFilterUI.this.setMaterialFilter((EventObject)e);
            }
        });
        this.prmtAdminOrgUnit.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    InteractionBackflushFilterUI.this.setadminOrgUnitFilter((EventObject)e);
                }
                catch (EASBizException e1) {
                    e1.printStackTrace();
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.prmtAdminOrgUnit.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                try {
                    InteractionBackflushFilterUI.this.setadminOrgUnitFilter((EventObject)e);
                }
                catch (EASBizException e1) {
                    e1.printStackTrace();
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.completionorderNumFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                InteractionBackflushFilterUI.this.setCompletionOrderNumFilter((EventObject)e);
            }
        });
        this.completionorderNumFrom.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                InteractionBackflushFilterUI.this.setCompletionOrderNumFilter((EventObject)e);
            }
        });
        this.completionorderNumTo.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                InteractionBackflushFilterUI.this.setCompletionOrderNumFilter((EventObject)e);
            }
        });
        this.completionorderNumTo.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                InteractionBackflushFilterUI.this.setCompletionOrderNumFilter((EventObject)e);
            }
        });
        this.recbillfrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                InteractionBackflushFilterUI.this.setRecBillNumFilter((EventObject)e);
            }
        });
        this.recbillfrom.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                InteractionBackflushFilterUI.this.setRecBillNumFilter((EventObject)e);
            }
        });
        this.recbillto.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                InteractionBackflushFilterUI.this.setRecBillNumFilter((EventObject)e);
            }
        });
        this.recbillto.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                InteractionBackflushFilterUI.this.setRecBillNumFilter((EventObject)e);
            }
        });
        elements.add((FilterElement)completionorderNumFromElement);
        elements.add((FilterElement)completionorderNumToElement);
        this.addEntityViewForExportWarehouse(this.completionorderNumTo, true);
        this.addEntityViewForExportWarehouse(this.completionorderNumFrom, true);
        this.addEntityViewForExportWarehouse(this.recbillfrom, false);
        this.addEntityViewForExportWarehouse(this.recbillto, false);
    }

    protected void setMaterialFilter(EventObject e) {
        FilterInfo filter = new FilterInfo();
        EntityViewInfo evi = new EntityViewInfo();
        if (this.prmtStorageOrgUnit.getValue() != null) {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1), CompareType.EQUALS));
        evi.setFilter(filter);
        this.prmptmaterialfrom.setEntityViewInfo(evi);
        this.prmptmaterialfrom.getQueryAgent().resetRuntimeEntityView();
        this.prmptmaterialto.setEntityViewInfo(evi);
        this.prmptmaterialto.getQueryAgent().resetRuntimeEntityView();
    }

    protected void setadminOrgUnitFilter(EventObject e) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        EntityViewInfo evi = new EntityViewInfo();
        if (this.prmtStorageOrgUnit.getValue() != null) {
            OrgUnitInfo orgInfo = null;
            orgInfo = (OrgUnitInfo)this.prmtStorageOrgUnit.getValue();
            AdminOrgUnitInfo adminOrgUnitInfo = null;
            this.prmtAdminOrgUnit.setDisplayFormat("$name$");
            this.prmtAdminOrgUnit.setEditFormat("$number$");
            this.prmtAdminOrgUnit.setCommitFormat("$number$;$code$");
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitCollection receiptOrgCol = iUnitRel.getToUnit(orgInfo.getId().toString(), 4, 0);
            HashSet<String> orgIdSet = new HashSet<String>();
            if (receiptOrgCol.size() > 0) {
                int size = receiptOrgCol.size();
                for (int i = 0; i < size; ++i) {
                    adminOrgUnitInfo = (AdminOrgUnitInfo)receiptOrgCol.get(i);
                    orgIdSet.add("'" + adminOrgUnitInfo.getId().toString() + "'");
                }
                filter.getFilterItems().add(new FilterItemInfo("id", orgIdSet, CompareType.INNER));
            }
        }
        evi.setFilter(filter);
        this.prmtAdminOrgUnit.setEntityViewInfo(evi);
        this.prmtAdminOrgUnit.getQueryAgent().resetRuntimeEntityView();
    }

    protected void setRecBillNumFilter(EventObject e) {
        FilterInfo filter = new FilterInfo();
        EntityViewInfo evi = new EntityViewInfo();
        if (this.prmtStorageOrgUnit.getValue() != null) {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(1), CompareType.NOTEQUALS));
        evi.setFilter(filter);
        SorterItemInfo sort = new SorterItemInfo("number");
        sort.setSortType(SortType.DESCEND);
        evi.getSorter().add(sort);
        this.recbillfrom.setEntityViewInfo(evi);
        this.recbillfrom.getQueryAgent().resetRuntimeEntityView();
        this.recbillto.setEntityViewInfo(evi);
        this.recbillto.getQueryAgent().resetRuntimeEntityView();
    }

    protected void setCompletionOrderNumFilter(EventObject e) {
        FilterInfo filter = new FilterInfo();
        EntityViewInfo evi = new EntityViewInfo();
        if (this.prmtStorageOrgUnit.getValue() != null) {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("isBackfrush", (Object)1, CompareType.EQUALS));
        evi.setFilter(filter);
        this.completionorderNumFrom.setEntityViewInfo(evi);
        this.completionorderNumFrom.getQueryAgent().resetRuntimeEntityView();
        this.completionorderNumTo.setEntityViewInfo(evi);
        this.completionorderNumTo.getQueryAgent().resetRuntimeEntityView();
    }

    private void addEntityViewForExportWarehouse(final KDBizPromptBox param, final boolean isCompletion) throws Exception {
        param.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                HashSet excludeSet;
                EntityViewInfo exportWView = new EntityViewInfo();
                FilterInfo exportWfilter = new FilterInfo();
                StorageOrgUnitInfo storage = null;
                AdminOrgUnitInfo admin = null;
                if (InteractionBackflushFilterUI.this.prmtStorageOrgUnit.getValue() instanceof FullOrgUnitInfo) {
                    String storageOrgID = ((FullOrgUnitInfo)InteractionBackflushFilterUI.this.prmtStorageOrgUnit.getValue()).getId().toString();
                    try {
                        if (StorageOrgUnitFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(storageOrgID))) {
                            storage = (StorageOrgUnitInfo)StorageOrgUnitFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(storageOrgID));
                        }
                    }
                    catch (EASBizException eASBizException) {
                    }
                    catch (BOSException bOSException) {}
                } else {
                    storage = (StorageOrgUnitInfo)InteractionBackflushFilterUI.this.prmtStorageOrgUnit.getValue();
                }
                admin = (AdminOrgUnitInfo)InteractionBackflushFilterUI.this.prmtAdminOrgUnit.getValue();
                if (storage != null) {
                    exportWfilter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storage.getId().toString(), CompareType.EQUALS));
                }
                exportWfilter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(4), CompareType.EQUALS));
                HashSet<Integer> set = new HashSet<Integer>();
                set.add(new Integer(3));
                set.add(new Integer(2));
                set.add(new Integer(4));
                if (isCompletion) {
                    if (admin != null) {
                        exportWfilter.getFilterItems().add(new FilterItemInfo("adminDepartMent.id", (Object)admin.getId().toString(), CompareType.EQUALS));
                    }
                    exportWfilter.getFilterItems().add(new FilterItemInfo("isBackfrush", set, CompareType.INCLUDE));
                    try {
                        excludeSet = InteractionBackflushFacadeFactory.getRemoteInstance().getSourceManuOrderErrorSet(true);
                        if (excludeSet != null && excludeSet.size() > 0) {
                            exportWfilter.getFilterItems().add(new FilterItemInfo("id", (Object)excludeSet, CompareType.NOTINCLUDE));
                        }
                    }
                    catch (EASBizException e1) {
                        InteractionBackflushFilterUI.this.handUIException(e1);
                    }
                    catch (BOSException e1) {
                        InteractionBackflushFilterUI.this.handUIException(e1);
                    }
                } else {
                    if (admin != null) {
                        exportWfilter.getFilterItems().add(new FilterItemInfo("entry.adminOrgUnit.id", (Object)admin.getId().toString(), CompareType.EQUALS));
                    }
                    exportWfilter.getFilterItems().add(new FilterItemInfo("isBackFlushSucceed", set, CompareType.INCLUDE));
                    try {
                        excludeSet = InteractionBackflushFacadeFactory.getRemoteInstance().getSourceManuOrderErrorSet(false);
                        if (excludeSet != null && excludeSet.size() > 0) {
                            exportWfilter.getFilterItems().add(new FilterItemInfo("id", (Object)excludeSet, CompareType.NOTINCLUDE));
                        }
                    }
                    catch (EASBizException e1) {
                        InteractionBackflushFilterUI.this.handUIException(e1);
                    }
                    catch (BOSException e1) {
                        InteractionBackflushFilterUI.this.handUIException(e1);
                    }
                }
                exportWView.setFilter(exportWfilter);
                param.setEntityViewInfo(exportWView);
                param.getQueryAgent().resetRuntimeEntityView();
            }
        });
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    private Timestamp getSCMQueryTime(Date d, String s) {
        Calendar calendar = Calendar.getInstance();
        if (d != null) {
            calendar.setTime(d);
        } else {
            calendar.setTime(SCMClientUtils.getServerDate2());
        }
        if (s.equalsIgnoreCase(KEY_STARTDATE)) {
            calendar.add(2, -1);
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
            calendar.set(14, 0);
        } else if (s.equalsIgnoreCase(KEY_ENDDATE)) {
            calendar.add(2, 0);
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
            calendar.set(14, 999);
        }
        return new Timestamp(calendar.getTimeInMillis());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    public String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.mm.sfc.SfcResource", (String)key);
    }

    public boolean verify() {
        boolean result = super.verify();
        if (result && this.dateBizDateTo.getValue() != null && this.dateBizDateFrom.getValue() != null && ((Date)this.dateBizDateTo.getValue()).getTime() < ((Date)this.dateBizDateFrom.getValue()).getTime()) {
            MsgBox.showInfo((String)this.getResource("ENDDATEMUSTBIGSTART"));
            return false;
        }
        return result;
    }

    public void clear() {
        this.getFilterManager().clearAll();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            FilterInfo filter = entityViewInfo.getFilter();
            FilterItemCollection item = filter.getFilterItems();
            for (int i = 0; i < item.size(); ++i) {
                IManufactureRecBill recBill;
                ICompletionReport report;
                CoreBaseCollection items;
                IMaterial material;
                FilterItemInfo itemInfo = item.get(i);
                if (itemInfo.getPropertyName().equals("materialfrom") && itemInfo.getCompareValue() != null) {
                    material = MaterialFactory.getRemoteInstance();
                    items = material.getCollection("select id,name,number where number in ('" + itemInfo.getCompareValue() + "')");
                    this.prmptmaterialfrom.setValue(items != null ? items.get(0) : null);
                }
                if (itemInfo.getPropertyName().equals("materialto") && itemInfo.getCompareValue() != null) {
                    material = MaterialFactory.getRemoteInstance();
                    items = material.getCollection("select id,name,number where number in ('" + itemInfo.getCompareValue() + "')");
                    this.prmptmaterialto.setValue(items != null ? items.get(0) : null);
                }
                if (itemInfo.getPropertyName().equals("completionorderNumFrom") && itemInfo.getCompareValue() != null) {
                    report = CompletionReportFactory.getRemoteInstance();
                    items = report.getCollection("select id,name,number where number in ('" + itemInfo.getCompareValue() + "')");
                    this.completionorderNumFrom.setValue(items != null ? items.get(0) : null);
                }
                if (itemInfo.getPropertyName().equals("completionorderNumTo") && itemInfo.getCompareValue() != null) {
                    report = CompletionReportFactory.getRemoteInstance();
                    items = report.getCollection("select id,name,number where number in ('" + itemInfo.getCompareValue() + "')");
                    this.completionorderNumTo.setValue(items != null ? items.get(0) : null);
                }
                if (itemInfo.getPropertyName().equals("recbillfrom") && itemInfo.getCompareValue() != null) {
                    recBill = ManufactureRecBillFactory.getRemoteInstance();
                    items = recBill.getCollection("select id,name,number where number in ('" + itemInfo.getCompareValue() + "')");
                    this.recbillfrom.setValue(items != null ? items.get(0) : null);
                }
                if (itemInfo.getPropertyName().equals("recbillto") && itemInfo.getCompareValue() != null) {
                    recBill = ManufactureRecBillFactory.getRemoteInstance();
                    items = recBill.getCollection("select id,name,number where number in ('" + itemInfo.getCompareValue() + "')");
                    this.recbillto.setValue(items != null ? items.get(0) : null);
                }
                if (itemInfo.getPropertyName().equals("storageOrgUnitnum") && itemInfo.getCompareValue() != null) {
                    IStorageOrgUnit sou = StorageOrgUnitFactory.getRemoteInstance();
                    items = sou.getCollection("select id,name,number where number in ('" + itemInfo.getCompareValue() + "')");
                    this.prmtStorageOrgUnit.setValue(items != null ? items.get(0) : null);
                }
                if (itemInfo.getPropertyName().equals("adminOrgUnitnum") && itemInfo.getCompareValue() != null) {
                    IAdminOrgUnit aou = AdminOrgUnitFactory.getRemoteInstance();
                    items = aou.getCollection("select id,name,number where number in ('" + itemInfo.getCompareValue() + "')");
                    this.prmtAdminOrgUnit.setValue(items != null ? items.get(0) : null);
                }
                if (itemInfo.getPropertyName().equals("startdatefrom") && itemInfo.getCompareValue() != null) {
                    this.dateBizDateFrom.setValue((Object)df.parse(itemInfo.getCompareValue().toString()));
                }
                if (!itemInfo.getPropertyName().equals("startdateto") || itemInfo.getCompareValue() == null) continue;
                this.dateBizDateTo.setValue((Object)df.parse(itemInfo.getCompareValue().toString()));
            }
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
    }
}

