/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.mm.common.client.KDTableUtils;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.sfc.BackFlushFilterInfo;
import com.kingdee.eas.mm.sfc.BackFlushListResultInfo;
import com.kingdee.eas.mm.sfc.BackFlushSourceTypeEnum;
import com.kingdee.eas.mm.sfc.CompletionReportFactory;
import com.kingdee.eas.mm.sfc.CompletionReportInfo;
import com.kingdee.eas.mm.sfc.ICompletionReport;
import com.kingdee.eas.mm.sfc.IInteractionBackflushFacade;
import com.kingdee.eas.mm.sfc.InteractionBackflushFacadeFactory;
import com.kingdee.eas.mm.sfc.client.AbstractInteractionBackflushFrameUI;
import com.kingdee.eas.mm.sfc.client.InteractionBackflushFilterUI;
import com.kingdee.eas.mm.sfc.client.InteractionBackflushSetUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMCommonProcessor;
import com.kingdee.eas.scm.common.client.SCMPromptBoxFactory;
import com.kingdee.eas.scm.im.inv.IManufactureRecBill;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillFactory;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class InteractionBackflushFrameUI
extends AbstractInteractionBackflushFrameUI {
    private static final Logger logger = CoreUIObject.getLogger(InteractionBackflushFrameUI.class);
    protected IMetaDataPK mainQueryPK;
    public CommonQueryDialog commonQueryDialog = null;
    protected InteractionBackflushFilterUI conditionPanel = null;
    protected HashMap queryCachDataMap = new HashMap();
    BackFlushFilterInfo filterinfoForCach = null;
    private static final String RESOURCEPATH = "com.kingdee.eas.mm.sfc.SfcResource";
    private static StorageOrgUnitInfo storage;
    private static Map precisionMap;
    String[] qtyFieldNames = new String[]{"qty"};

    public InteractionBackflushFrameUI() throws Exception {
        this.btninterbackflush.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_interactbackflush", (Locale)this.getLocale()));
        this.btnbackflush.setIcon(EASResource.getIcon((String)"imgTbtn_backwriting"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionquery_actionPerformed(ActionEvent e) throws Exception {
        CommonQueryDialog dialog = this.initCommonQueryDialog();
        dialog.show();
        EntityViewInfo entityViewInfo = dialog.getEntityViewInfoResult();
        if (entityViewInfo.getFilter() == null) {
            this.abort();
        }
        InteractionBackflushFilterUI filterUI = (InteractionBackflushFilterUI)((Object)dialog.getCommonQueryParam().getPanels().get(0));
        filterUI.loadData(entityViewInfo);
        BackFlushFilterInfo filterinfo = new BackFlushFilterInfo();
        if (filterUI.prmtStorageOrgUnit.getValue() instanceof FullOrgUnitInfo) {
            String storageOrgID = ((FullOrgUnitInfo)filterUI.prmtStorageOrgUnit.getValue()).getId().toString();
            if (StorageOrgUnitFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(storageOrgID))) {
                StorageOrgUnitInfo storage = (StorageOrgUnitInfo)StorageOrgUnitFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(storageOrgID));
                filterinfo.setStorageUnitNum(storage);
            }
        } else {
            filterinfo.setStorageUnitNum((StorageOrgUnitInfo)filterUI.prmtStorageOrgUnit.getValue());
        }
        filterinfo.setAdminOrgUnitNum(filterUI.prmtAdminOrgUnit.getValue() != null ? (AdminOrgUnitInfo)filterUI.prmtAdminOrgUnit.getValue() : null);
        filterinfo.setBizDateFrom(filterUI.dateBizDateFrom.getValue() != null ? (Date)filterUI.dateBizDateFrom.getValue() : null);
        filterinfo.setBizDateTo(filterUI.dateBizDateTo.getValue() != null ? (Date)filterUI.dateBizDateTo.getValue() : null);
        filterinfo.setCompletionFrom(filterUI.completionorderNumFrom.getValue() != null ? (CompletionReportInfo)filterUI.completionorderNumFrom.getValue() : null);
        filterinfo.setCompletionTo(filterUI.completionorderNumTo.getValue() != null ? (CompletionReportInfo)filterUI.completionorderNumTo.getValue() : null);
        filterinfo.setMaterialNumFrom(filterUI.prmptmaterialfrom.getValue() != null ? (MaterialInfo)filterUI.prmptmaterialfrom.getValue() : null);
        filterinfo.setMaterialNumTo(filterUI.prmptmaterialto.getValue() != null ? (MaterialInfo)filterUI.prmptmaterialto.getValue() : null);
        filterinfo.setRecBillFrom(filterUI.recbillfrom.getValue() != null ? (ManufactureRecBillInfo)filterUI.recbillfrom.getValue() : null);
        filterinfo.setRecBillTo(filterUI.recbillto.getValue() != null ? (ManufactureRecBillInfo)filterUI.recbillto.getValue() : null);
        IInteractionBackflushFacade facade = InteractionBackflushFacadeFactory.getRemoteInstance();
        this.filterinfoForCach = filterinfo;
        List queryResult = facade.getRecBillAndCompletionData(filterinfo);
        this.uptable.removeRows();
        if (queryResult.size() > 0) {
            for (int i = 0; i < queryResult.size(); ++i) {
                BackFlushListResultInfo info = (BackFlushListResultInfo)queryResult.get(i);
                this.queryCachDataMap.put(info.getId(), info);
                this.setPrecisionMap(info.getMaterial().getId().toString(), info.getUnit().getId().toString());
                this.initRowData(info);
            }
        }
    }

    private void setPrecisionMap(String materialId, String unitId) throws BOSException {
        StringBuffer sqlWhere = new StringBuffer();
        String key = materialId + unitId;
        if (precisionMap.get(key) == null) {
            sqlWhere.append("(material.id = '").append(materialId).append("' and measureUnit.id = '").append(unitId).append("' ) ");
            MultiMeasureUnitCollection mmuc = MultiMeasureUnitFactory.getRemoteInstance().getMultiMeasureUnitCollection(" where " + sqlWhere.toString());
            int precision = 0;
            for (int i = 0; i < mmuc.size(); ++i) {
                precision = mmuc.get(i).getQtyPrecision();
                precisionMap.put(key, new Integer(precision));
            }
        }
    }

    protected void initRowData(BackFlushListResultInfo os) {
        this.uptable.checkParsed();
        IRow newRow = this.uptable.addRow();
        newRow.getCell("storageorgunit").setValue(os.getStorageUnitNum() != null ? os.getStorageUnitNum().getName() : null);
        if (os.getBilltype() == BackFlushSourceTypeEnum.BACKFLUSH_RECBILL) {
            newRow.getCell("billnumber").setValue((Object)os.getRecBillInfo().getNumber());
        } else {
            newRow.getCell("billnumber").setValue((Object)os.getReportInfo().getNumber());
        }
        newRow.getCell("manuorder").setValue(os.getManuOrder() != null ? os.getManuOrder().getNumber() : null);
        newRow.getCell("operation").setValue(os.getOperation() != null ? os.getOperation().getName() : null);
        newRow.getCell("distatchorder").setValue(os.getDisInfo() != null ? os.getDisInfo().getNumber() : null);
        newRow.getCell("bizdate").setValue((Object)os.getBizDate());
        newRow.getCell("materialnumber").setValue(os.getMaterial() != null ? os.getMaterial().getNumber() : null);
        newRow.getCell("materialname").setValue(os.getMaterial() != null ? os.getMaterial().getName() : null);
        newRow.getCell("spec").setValue(os.getMaterial() != null ? os.getMaterial().getModel() : null);
        newRow.getCell("unit").setValue((Object)os.getUnit());
        newRow.getCell("qty").setValue((Object)os.getQty());
        newRow.getCell("project").setValue((Object)os.getProject());
        newRow.getCell("tracknumber").setValue((Object)os.getTrcknumber());
        newRow.getCell("lot").setValue((Object)os.getLotNumber());
        newRow.getCell("backflushflag").setValue((Object)os.getBackFlushFlag());
        newRow.getCell("billtype").setValue((Object)os.getBilltype());
        newRow.getCell("id").setValue((Object)os.getId());
        this.setRowPrecision(newRow, os);
    }

    private void setRowPrecision(IRow orderRow, String materialId, String unitId) {
        String key = materialId + unitId;
        int precision = 0;
        if (precisionMap.containsKey(key)) {
            precision = (Integer)precisionMap.get(key);
        }
        SCMClientUtils.changeCellPrecision((IRow)orderRow, (String[])this.qtyFieldNames, (int)precision, (boolean)false, (boolean)false);
    }

    private void setRowPrecision(IRow orderRow, BackFlushListResultInfo info) {
        if (info.getMaterial() == null || info.getUnit() == null) {
            return;
        }
        this.setRowPrecision(orderRow, info.getMaterial().getId().toString(), info.getUnit().getId().toString());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        storage = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"mm_sfc_interaction");
        this.uptable.checkParsed();
        this.uptable.getSelectManager().setSelectMode(10);
        this.actionquery_actionPerformed(null);
    }

    public void onShow() throws Exception {
        super.onShow();
        KDTableUtils.setDefaultFreezeCol((KDTable)this.uptable, (int)(this.uptable.getColumnIndex("billnumber") + 1));
        this.uptable.getColumn("bizdate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = this.initMyCommonQueryDialog();
            this.commonQueryDialog.setWidth(450);
            this.commonQueryDialog.setHeight(320);
            try {
                SCMPromptBoxFactory scmF7Factory = new SCMPromptBoxFactory((CustomerQueryPanel)this.getFilterUI(), this.getMainBizOrgType());
                this.commonQueryDialog.setPromptBoxFactory((IPromptBoxFactory)scmF7Factory);
                this.commonQueryDialog.setProcessor((IProcessor)new SCMCommonProcessor());
                this.commonQueryDialog.addUserPanel((KDPanel)this.getFilterUI());
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
        return this.commonQueryDialog;
    }

    protected InteractionBackflushFilterUI getFilterUI() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new InteractionBackflushFilterUI(storage);
        }
        return this.conditionPanel;
    }

    protected CommonQueryDialog initMyCommonQueryDialog() {
        CommonQueryDialog dialog = new CommonQueryDialog();
        if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.mm.mo.app", "OSSourceFilterQuery");
        dialog.setQueryObjectPK(this.mainQueryPK);
        dialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
        dialog.setTitle(this.getUITitle() + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
        dialog.setShowSorter(false);
        dialog.setShowFilter(false);
        return dialog;
    }

    private String getResource(String strKey) {
        return EASResource.getString((String)RESOURCEPATH, (String)strKey);
    }

    @Override
    public void actioninterbackflush_actionPerformed(ActionEvent e) throws Exception {
        if (this.uptable.getRowCount() == 0 || this.uptable.getSelectManager().size() == 0) {
            MsgBox.showInfo((String)this.getResource("NODATA_TOINTERACTIONBACKFLUSH"));
            return;
        }
        if (KDTableUtil.getSelectedRows((KDTable)this.uptable).length > 1) {
            MsgBox.showInfo((String)this.getResource("NOTSELECT_TOINTERACTIONBACKFLUSH"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        int[] index = KDTableUtil.getSelectedRows((KDTable)this.uptable);
        BackFlushListResultInfo info = (BackFlushListResultInfo)this.queryCachDataMap.get(this.uptable.getRow(index[0]).getCell("id").getValue());
        if (info.getBilltype() == BackFlushSourceTypeEnum.BACKFLUSH_COMPLETION) {
            boolean checkResult;
            ICompletionReport report = CompletionReportFactory.getRemoteInstance();
            CompletionReportInfo databaseInfo = info.getReportInfo();
            if (report.exists((IObjectPK)new ObjectUuidPK(info.getReportInfo().getId().toString()))) {
                databaseInfo = (CompletionReportInfo)report.getValue((IObjectPK)new ObjectUuidPK(info.getReportInfo().getId().toString()));
            }
            if (!(checkResult = InteractionBackflushFacadeFactory.getRemoteInstance().getSourceManuOrderStatus(databaseInfo.getId().toString(), true))) {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCEPATH, (String)"MANUORDERISCLOSED"));
                return;
            }
            uiContext.put((Object)"sourceBillID", (Object)info.getReportInfo().getId().toString());
            uiContext.put((Object)"sourceTypeEnum", (Object)BackFlushSourceTypeEnum.BACKFLUSH_COMPLETION);
            int status = databaseInfo.getIsBackfrush().getValue();
            uiContext.put((Object)"backFlushStatus", (Object)new Integer(status));
            uiContext.put((Object)"filterinfo", (Object)this.filterinfoForCach);
        } else {
            boolean checkResult;
            IManufactureRecBill rec = ManufactureRecBillFactory.getRemoteInstance();
            ManufactureRecBillInfo databaseInfo = info.getRecBillInfo();
            if (rec.exists((IObjectPK)new ObjectUuidPK(info.getRecBillInfo().getId().toString()))) {
                databaseInfo = (ManufactureRecBillInfo)rec.getValue((IObjectPK)new ObjectUuidPK(info.getRecBillInfo().getId().toString()));
            }
            if (!(checkResult = InteractionBackflushFacadeFactory.getRemoteInstance().getSourceManuOrderStatus(databaseInfo.getId().toString(), false))) {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCEPATH, (String)"MANUORDERISCLOSED"));
                return;
            }
            uiContext.put((Object)"sourceBillID", (Object)info.getRecBillInfo().getId().toString());
            uiContext.put((Object)"sourceTypeEnum", (Object)BackFlushSourceTypeEnum.BACKFLUSH_RECBILL);
            int status = databaseInfo.getIsBackFlushSucceed().getValue();
            uiContext.put((Object)"backFlushStatus", (Object)new Integer(status));
            uiContext.put((Object)"filterinfo", (Object)this.filterinfoForCach);
        }
        IUIWindow newWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(InteractionBackflushSetUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        newWindow.show();
    }

    @Override
    public void actionbackflush_actionPerformed(ActionEvent e) throws Exception {
        int i;
        if (this.uptable.getRowCount() == 0 || this.uptable.getSelectManager().size() == 0) {
            MsgBox.showInfo((String)this.getResource("NODATA_TOBACKFLUSH"));
            return;
        }
        if (this.uptable.getSelectManager().size() == 0) {
            MsgBox.showInfo((String)this.getResource("NODATA_TOBACKFLUSH"));
            return;
        }
        int[] index = KDTableUtil.getSelectedRows((KDTable)this.uptable);
        boolean isNotsameType = false;
        String[] ids = new String[index.length];
        String[] numbers = new String[index.length];
        BackFlushListResultInfo info = (BackFlushListResultInfo)this.queryCachDataMap.get(this.uptable.getRow(index[0]).getCell("id").getValue());
        for (int i2 = 0; i2 < index.length; ++i2) {
            BackFlushListResultInfo otherInfo = (BackFlushListResultInfo)this.queryCachDataMap.get(this.uptable.getRow(index[i2]).getCell("id").getValue());
            if (info.getBilltype() != otherInfo.getBilltype()) {
                isNotsameType = true;
                break;
            }
            if (otherInfo.getBilltype() == BackFlushSourceTypeEnum.BACKFLUSH_COMPLETION) {
                ids[i2] = otherInfo.getReportInfo().getId().toString();
                numbers[i2] = otherInfo.getReportInfo().getNumber();
                continue;
            }
            ids[i2] = otherInfo.getRecBillInfo().getId().toString();
            numbers[i2] = otherInfo.getRecBillInfo().getNumber();
        }
        if (isNotsameType) {
            MsgBox.showInfo((String)this.getResource("MUSTSELECTSAMETYPE"));
            return;
        }
        IInteractionBackflushFacade facade = InteractionBackflushFacadeFactory.getRemoteInstance();
        BillTypeInfo billType = new BillTypeInfo();
        IObjectPK[] pks = new IObjectPK[ids.length];
        if (info.getBilltype() == BackFlushSourceTypeEnum.BACKFLUSH_COMPLETION) {
            for (i = 0; i < ids.length; ++i) {
                pks[i] = LogUtil.beginLog(null, (String)"_interactionBackFlushForComRpt", (BOSObjectType)new BOSObjectType("DFBE5164"), (IObjectPK)new ObjectUuidPK(ids[i]), (String)numbers[i], (String)"mm_sfc_interactionbackflush");
            }
            billType.setId(BOSUuid.read((String)"HxPKDRdzRpaqr31LD+3SBEY+1VI="));
        } else {
            for (i = 0; i < ids.length; ++i) {
                pks[i] = LogUtil.beginLog(null, (String)"_inStockBackFlush", (BOSObjectType)new BOSObjectType("FA1292B4"), (IObjectPK)new ObjectUuidPK(ids[i]), (String)numbers[i], (String)"mm_sfc_interactionmanufacturerecbill");
            }
            billType.setId(BOSUuid.read((String)"50957179-0105-1000-e000-0167c0a812fd463ED552"));
        }
        StringBuffer msg = new StringBuffer();
        BatchExecuteResult result = facade.backFlush(ids, billType, storage.getId().toString());
        if (result.getExceptions() != null && result.getExceptions().length > 0) {
            for (int i3 = 0; i3 < result.getExceptions().length; ++i3) {
                if (result.getExceptions()[i3] == null) continue;
                msg.append(numbers[i3]).append("   ").append(result.getExceptions()[i3].getMessage()).append("\n");
            }
        }
        StringBuffer noticeMsg = new StringBuffer();
        if (info.getBilltype() == BackFlushSourceTypeEnum.BACKFLUSH_COMPLETION) {
            noticeMsg.append("\u90e8\u5206\u6c47\u62a5\u5355\u5b58\u5728\u5012\u51b2\u5f02\u5e38\uff01");
        } else {
            noticeMsg.append("\u90e8\u5206\u5165\u5e93\u5355\u5b58\u5728\u5012\u51b2\u5f02\u5e38\uff01");
        }
        if (msg.length() > 0) {
            StringBuffer title = new StringBuffer();
            title.append("\u5355\u636e\u7f16\u7801").append("      ").append("\u5f02\u5e38\u4fe1\u606f").append("\n");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)noticeMsg.toString(), (String)title.append(msg).toString(), (int)2);
        }
        for (int i4 = 0; i4 < ids.length; ++i4) {
            LogUtil.afterLog(null, (IObjectPK)pks[i4]);
        }
        this.refresh_actionPerformed(e);
    }

    @Override
    public void refresh_actionPerformed(ActionEvent e) throws Exception {
        IInteractionBackflushFacade facade = InteractionBackflushFacadeFactory.getRemoteInstance();
        List queryResult = facade.getRecBillAndCompletionData(this.filterinfoForCach);
        this.uptable.removeRows();
        if (queryResult.size() > 0) {
            for (int i = 0; i < queryResult.size(); ++i) {
                BackFlushListResultInfo queryInfo = (BackFlushListResultInfo)queryResult.get(i);
                this.queryCachDataMap.put(queryInfo.getId(), queryInfo);
                this.setPrecisionMap(queryInfo.getMaterial().getId().toString(), queryInfo.getUnit().getId().toString());
                this.initRowData(queryInfo);
            }
        }
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        int[] index;
        int i;
        Object orgPK = null;
        String storageId = null;
        int count = this.uptable.getRowCount();
        if (count > 0 && (i = 0) < (index = KDTableUtil.getSelectedRows((KDTable)this.uptable)).length) {
            BackFlushListResultInfo info = (BackFlushListResultInfo)this.queryCachDataMap.get(this.uptable.getRow(index[0]).getCell("id").getValue());
            storageId = info.getStorageUnitNum().getId().toString();
        }
        String actoinName = null;
        if (action != null) {
            actoinName = action.getClass().getName();
        }
        if (actoinName != null && actoinName.indexOf("$") >= 0) {
            actoinName = actoinName.substring(actoinName.indexOf("$") + 1);
        }
        if (actoinName != null && (actoinName.equals("actionbackflush") || actoinName.equals("actioninterbackflush")) && (this.uptable.getRowCount() == 0 || this.uptable.getSelectManager().size() == 0)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        orgPK = storageId != null ? new ObjectUuidPK(storageId) : super.getOrgPK(action);
        return orgPK;
    }

    static {
        precisionMap = new HashMap();
    }
}

