/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.ITransactionType;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.client.KDTableUtils;
import com.kingdee.eas.mm.common.util.TransactionTypeHelper;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.sfc.BackFlushSourceTypeEnum;
import com.kingdee.eas.mm.sfc.BackFrushStatusEnum;
import com.kingdee.eas.mm.sfc.CalculateLotLineValue;
import com.kingdee.eas.mm.sfc.CalculateLotValue;
import com.kingdee.eas.mm.sfc.CalculateParam;
import com.kingdee.eas.mm.sfc.IInteractionBackflushFacade;
import com.kingdee.eas.mm.sfc.InteractionBackFlushInfo;
import com.kingdee.eas.mm.sfc.InteractionBackflushFacadeFactory;
import com.kingdee.eas.mm.sfc.client.AbstractInteractionBackflushSetUI;
import com.kingdee.eas.mm.sfc.client.InteractionBackflushFrameUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class InteractionBackflushSetUI
extends AbstractInteractionBackflushSetUI {
    private static final long serialVersionUID = -5747402600018573644L;
    private static final Logger logger = CoreUIObject.getLogger(InteractionBackflushSetUI.class);
    private static final String TB_NUMBER = "materialnumber";
    private static final String TB_NAME = "materialname";
    private static final String TB_SPEC = "spec";
    private static final String TB_UNIT = "unit";
    private static final String TB_SELECTFLAG = "selectflag";
    private static final String TB_LOT = "lot";
    private static final String TB_QTY = "qty";
    private static final String TB_THISTIMEQTY = "thistimeqty";
    private static final String TB_WAREHOUSE = "warehouse";
    private static final String TB_LOCATION = "location";
    private static final String TB_STOCK = "stock";
    private static final String TB_ORDERNUM = "ordernum";
    private static final String TB_ID = "id";
    private static final String TB_PROJECT = "projectNum";
    private static final String TB_TRACK = "trackNum";
    private static final String TB_MFG = "mfg";
    private static final String TB_EXG = "exg";
    private HashMap backFlushMap = new HashMap();
    private HashMap backViewMap = new HashMap();
    private static BigDecimal ZERO = new BigDecimal("0.00");
    private static final String RESOURCEPATH = "com.kingdee.eas.mm.sfc.SfcResource";
    public static final String TRANSACTIONTYPEID_MANU = "vd9rwnnBQc6LRgyfRruUGLAI3Kc=";
    private HashMap negativeMap = new HashMap();
    private static Map precisionMap = new HashMap();
    String[] qtyFieldNames = new String[]{"qty", "thistimeqty", "stock"};
    private KDTEditAdapter entryKDTEditAdapter;
    private ItemListener chkboxListener = null;
    private String sourceBillID = null;
    private BackFlushSourceTypeEnum sourceTypeEnum = null;
    private BackFrushStatusEnum backFlushStatus = null;

    public InteractionBackflushSetUI() throws Exception {
        this.kDTable1.checkParsed();
        KDCheckBox select_comboBox = new KDCheckBox();
        select_comboBox.setName("removeorder_sourceType_ComboBox");
        select_comboBox.setVisible(true);
        select_comboBox.setEditable(false);
        select_comboBox.setRequired(false);
        KDTDefaultCellEditor select_CellEditor = new KDTDefaultCellEditor((JCheckBox)select_comboBox);
        this.kDTable1.getColumn(TB_SELECTFLAG).setEditor((ICellEditor)select_CellEditor);
        KDFormattedTextField thistimeQTY_TextField = new KDFormattedTextField();
        thistimeQTY_TextField.setName("thistimeQTY_TextField");
        thistimeQTY_TextField.setVisible(true);
        thistimeQTY_TextField.setEditable(true);
        thistimeQTY_TextField.setRequired(true);
        thistimeQTY_TextField.setNegatived(true);
        thistimeQTY_TextField.setDataType(1);
        thistimeQTY_TextField.setMaximumValue((Comparable)SCMClientUtils.MAXVAL);
        thistimeQTY_TextField.setMinimumValue((Comparable)SCMClientUtils.MINVAL);
        thistimeQTY_TextField.setSupportedEmpty(false);
        thistimeQTY_TextField.setRemoveingZeroInDispaly(false);
        thistimeQTY_TextField.setNegatived(true);
        KDTDefaultCellEditor thistimeQty_CellEditor = new KDTDefaultCellEditor((JTextField)thistimeQTY_TextField);
        this.kDTable1.getColumn(TB_THISTIMEQTY).setEditor((ICellEditor)thistimeQty_CellEditor);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        if (!this.checkIsOneBill((String)this.getUIContext().get("sourceBillID")).booleanValue()) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCEPATH, (String)"BILL_IS_LOCK"));
            SysUtil.abort();
        }
        super.onLoad();
    }

    public Boolean checkIsOneBill(String billId) {
        Boolean flag = MutexServiceControlFactory.getRemoteInstance().requestObjIDForUpdate(billId);
        return flag;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.initBackFlushData();
        this.setMergeColumn();
        KDTableUtils.setDefaultFreezeCol((KDTable)this.kDTable1, (int)(this.kDTable1.getColumnIndex(TB_NUMBER) + 1));
        this.kDTable1.getColumn(TB_MFG).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.kDTable1.getColumn(TB_EXG).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
    }

    private void setMergeColumn() {
        this.kDTable1.getGroupManager().group();
        this.kDTable1.getGroupManager().setGroup(true);
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                this.kDTable1.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.kDTable1.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    public String[] getMergeColumnKeys() {
        String[] strArray = new String[]{TB_ORDERNUM, TB_NUMBER, TB_NAME, TB_QTY};
        return strArray;
    }

    protected void initListener() {
        super.initListener();
        this.chkboxListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                try {
                    InteractionBackflushSetUI.this.kdCheckBoxChanged(arg0);
                }
                catch (Exception e) {
                    InteractionBackflushSetUI.this.handUIException(e);
                }
            }
        };
        this.kdcheckbox.addItemListener(this.chkboxListener);
        this.entryKDTEditAdapter = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    InteractionBackflushSetUI.this.kdtEntries_Changed(e);
                }
                catch (Exception exc) {
                    InteractionBackflushSetUI.this.handUIException(exc);
                }
            }
        };
        this.kDTable1.addKDTEditListener((KDTEditListener)this.entryKDTEditAdapter);
    }

    public void kdCheckBoxChanged(ItemEvent arg0) throws Exception {
        if (this.kdcheckbox.isSelected()) {
            this.hideZeroRows(true);
        } else {
            this.hideZeroRows(false);
        }
    }

    private void kdtEntries_Changed(KDTEditEvent e) throws Exception {
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getOldValue(), (Object)e.getValue());
        if (isDiffrent) {
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            String fieldName = this.kDTable1.getColumnKey(colIndex);
            Boolean selectFlag = this.kDTable1.getCell(rowIndex, TB_SELECTFLAG).getValue() != null ? (Boolean)this.kDTable1.getCell(rowIndex, TB_SELECTFLAG).getValue() : new Boolean(false);
            String id = (String)this.kDTable1.getCell(rowIndex, TB_ID).getValue();
            InteractionBackFlushInfo info = (InteractionBackFlushInfo)this.backFlushMap.get(id);
            if (TB_THISTIMEQTY.equalsIgnoreCase(fieldName)) {
                Boolean negative;
                if (e.getValue() == null) {
                    this.kDTable1.getRow(rowIndex).getCell(TB_THISTIMEQTY).setValue(e.getOldValue());
                    return;
                }
                if (selectFlag.booleanValue() && !(negative = (Boolean)this.negativeMap.get(info.getMaterial().getId().toString())).booleanValue() && ((BigDecimal)e.getValue()).compareTo(info.getCurrentStockQty()) > 0) {
                    MsgBox.showInfo((String)this.getResource("BACKQTYNOTBIGERROR"));
                    this.kDTable1.getCell(rowIndex, TB_THISTIMEQTY).setValue(e.getOldValue());
                    return;
                }
            }
        }
    }

    protected void CalculateLot(InteractionBackFlushInfo info) throws Exception {
        if (info.getMaterial() == null) {
            return;
        }
        MaterialInventoryInfo materialInv = MaterialInventoryFactory.getRemoteInstance().getInventoryInfo(info.getMaterial().getId().toString(), info.getStorageorgunitID());
        this.setPrecisionMap(info.getMaterial().getId().toString(), info.getUnit().getId().toString());
        boolean isNegative = materialInv.isIsNegative();
        this.negativeMap.put(info.getMaterial().getId().toString(), new Boolean(isNegative));
        boolean isUpdateByBaseUnit = InvClientUtils.isUpdateInvByBaseUnit((String)info.getStorageorgunitID());
        TransactionTypeInfo transactiontype = null;
        TransactionTypeCollection col = TransactionTypeHelper.getTransactionType4MaterialReqOut(null);
        if (col != null && col.size() == 1) {
            transactiontype = col.get(0);
        }
        ITransactionType transaction = TransactionTypeFactory.getRemoteInstance();
        if (transactiontype == null && transaction.exists((IObjectPK)new ObjectUuidPK(TRANSACTIONTYPEID_MANU))) {
            transactiontype = (TransactionTypeInfo)transaction.getValue((IObjectPK)new ObjectUuidPK(TRANSACTIONTYPEID_MANU));
        }
        if (materialInv.isIsLotNumber()) {
            String billTYpeID = "0rSFjAEeEADgAAyMwKgSQiQHQ1w=";
            StringBuffer keyBuffer = new StringBuffer();
            keyBuffer.append(info.getStorageorgunitID());
            keyBuffer.append(billTYpeID);
            if (info.getMaterial().getId().toString() == null) {
                return;
            }
            keyBuffer.append(info.getMaterial().getId().toString());
            keyBuffer.append(info.getUnit().getId().toString());
            if (info.getWarehouse() != null) {
                keyBuffer.append(info.getWarehouse().getId().toString());
            }
            if (info.getLocation() != null) {
                keyBuffer.append(info.getLocation().getId().toString());
            }
            if (info.getProject() != null) {
                keyBuffer.append(info.getProject().getId().toString());
            }
            if (info.getTrackNumber() != null) {
                keyBuffer.append(info.getTrackNumber().getId().toString());
            }
            String key = keyBuffer.toString();
            String souID = info.getStorageorgunitID();
            String[] materialIDs = new String[1];
            String[] unitIDs = new String[1];
            String[] baseUnitIDs = new String[1];
            String[] warehouseIDs = new String[1];
            String[] locationIDs = new String[1];
            BigDecimal[] qtys = new BigDecimal[1];
            String[] asstattrIDs = new String[1];
            String[] supplierIDs = new String[1];
            String[] customerIDs = new String[1];
            String[] storeTypeIDs = new String[1];
            String[] storeStatusIDs = new String[1];
            String[] projectIDs = new String[1];
            String[] trackNumberIDs = new String[1];
            supplierIDs[0] = null;
            customerIDs[0] = null;
            storeTypeIDs[0] = null;
            storeStatusIDs[0] = null;
            asstattrIDs[0] = null;
            materialIDs[0] = info.getMaterial().getId().toString();
            baseUnitIDs[0] = info.getBaseUnit().getId().toString();
            unitIDs[0] = info.getUnit().getId().toString();
            qtys[0] = info.getBackFlushQty();
            if (info.getWarehouse() != null) {
                warehouseIDs[0] = info.getWarehouse().getId().toString();
            }
            if (info.getLocation() != null) {
                locationIDs[0] = info.getLocation().getId().toString();
            }
            if (info.getProject() != null) {
                projectIDs[0] = info.getProject().getId().toString();
            }
            if (info.getTrackNumber() != null) {
                trackNumberIDs[0] = info.getTrackNumber().getId().toString();
            }
            CalculateParam param = new CalculateParam();
            param.setSouID(souID);
            param.setBillTypeID(billTYpeID);
            param.setTti(transactiontype);
            param.setUpdateByBaseUnit(isUpdateByBaseUnit);
            param.setMaterialIDs(materialIDs);
            param.setUnitIDs(unitIDs);
            param.setBaseUnitIDs(baseUnitIDs);
            param.setWarehouseIDs(warehouseIDs);
            param.setLocationIDs(locationIDs);
            param.setQtys(qtys);
            param.setAsstAttrIDs(asstattrIDs);
            param.setStoreTypeIDs(storeTypeIDs);
            param.setStoreStatusIDs(storeStatusIDs);
            param.setCustomerIDs(customerIDs);
            param.setSupplierIDs(supplierIDs);
            param.setProjectIDs(projectIDs);
            param.setTrackNumberIDs(trackNumberIDs);
            IInteractionBackflushFacade interfaceBackFlush = InteractionBackflushFacadeFactory.getRemoteInstance();
            Map inventoryMap = interfaceBackFlush.getInventoryCollection(param);
            if (inventoryMap == null || inventoryMap.size() == 0) {
                this.initRowData(info, false, !isNegative);
                this.backFlushMap.put(info.getId().toString(), info);
                return;
            }
            if (inventoryMap.containsKey(key)) {
                ArrayList lineValues;
                CalculateLotValue value = (CalculateLotValue)inventoryMap.get(key);
                if (value == null) {
                    return;
                }
                CalculateLotValue matchValue = this.matchLotIssue(value, info.getBackFlushQty());
                boolean enableSelectFlag = false;
                if (matchValue.getSumFlotQty().compareTo(info.getBackFlushQty()) >= 0) {
                    enableSelectFlag = true;
                }
                if ((lineValues = matchValue.getLineValues()) != null && lineValues.size() > 0) {
                    for (int j = 0; j < lineValues.size(); ++j) {
                        SelectorItemCollection sic;
                        CalculateLotLineValue lineValue = (CalculateLotLineValue)lineValues.get(j);
                        if (lineValue == null) continue;
                        InteractionBackFlushInfo infoForView = new InteractionBackFlushInfo();
                        infoForView = (InteractionBackFlushInfo)info.clone();
                        infoForView.setLot(lineValue.getLot());
                        if (lineValue.getMfg() != null) {
                            infoForView.setMfg(new Timestamp(lineValue.getMfg().getTime()));
                        }
                        if (lineValue.getExp() != null) {
                            infoForView.setExg(new Timestamp(lineValue.getExp().getTime()));
                        }
                        infoForView.setThistimeQty(lineValue.getQty());
                        infoForView.setId(BOSUuid.create((BOSObjectType)infoForView.getBOSType()));
                        if (lineValue.getWarehouseID() != null && !lineValue.getWarehouseID().equalsIgnoreCase("EgkAAABc3XG76fiu")) {
                            sic = new SelectorItemCollection();
                            sic.add(new SelectorItemInfo("*"));
                            WarehouseInfo warehouse = WarehouseFactory.getRemoteInstance().getWarehouseInfo((IObjectPK)new ObjectUuidPK(lineValue.getWarehouseID()), sic);
                            infoForView.setWarehouse(warehouse);
                        }
                        if (lineValue.getLocationID() != null && !lineValue.getLocationID().equalsIgnoreCase("EgkAAABc3XMgX/hq")) {
                            sic = new SelectorItemCollection();
                            sic.add(new SelectorItemInfo("*"));
                            LocationInfo location = LocationFactory.getRemoteInstance().getLocationInfo((IObjectPK)new ObjectUuidPK(lineValue.getLocationID()), sic);
                            infoForView.setLocation(location);
                        }
                        if (lineValue.getCurentStockQty() != null) {
                            infoForView.setCurrentStockQty(lineValue.getCurentStockQty());
                        }
                        if (lineValue.getProjectID() != null && !lineValue.getProjectID().equalsIgnoreCase("EgkAAABc3Xza3gXu")) {
                            sic = new SelectorItemCollection();
                            sic.add(new SelectorItemInfo("*"));
                            ProjectInfo project = ProjectFactory.getRemoteInstance().getProjectInfo((IObjectPK)new ObjectUuidPK(lineValue.getProjectID()), sic);
                            infoForView.setProject(project);
                        }
                        if (lineValue.getTrackNumberID() != null && !lineValue.getTrackNumberID().equalsIgnoreCase("EgkAAABc3X0Ibpg9")) {
                            sic = new SelectorItemCollection();
                            sic.add(new SelectorItemInfo("*"));
                            TrackNumberInfo trackNumber = TrackNumberFactory.getRemoteInstance().getTrackNumberInfo((IObjectPK)new ObjectUuidPK(lineValue.getTrackNumberID()), sic);
                            infoForView.setTrackNumber(trackNumber);
                        }
                        this.backFlushMap.put(infoForView.getId().toString(), infoForView);
                        if (lineValue.getQty().compareTo(new BigDecimal(0)) > 0) {
                            this.initRowData(infoForView, enableSelectFlag, !isNegative);
                            continue;
                        }
                        this.initRowData(infoForView, enableSelectFlag, !isNegative);
                    }
                } else {
                    String warehouseID = info.getWarehouse() != null ? info.getWarehouse().getId().toString() : null;
                    String locactionID = info.getLocation() != null ? info.getLocation().getId().toString() : null;
                    String storageOrgUnitID = info.getStorageorgunitID();
                    String baseUnitID = info.getBaseUnit() != null ? info.getBaseUnit().getId().toString() : null;
                    String unitID = info.getUnit() != null ? info.getUnit().getId().toString() : null;
                    String projectID = info.getProject() != null ? info.getProject().getId().toString() : null;
                    String trackNumberID = info.getTrackNumber() != null ? info.getTrackNumber().getId().toString() : null;
                    IInteractionBackflushFacade interfaceBackFlushA = InteractionBackflushFacadeFactory.getRemoteInstance();
                    BigDecimal currentQty = interfaceBackFlushA.checkCurrentStock(info.getMaterial().getId().toString(), storageOrgUnitID, warehouseID, locactionID, unitID, null, projectID, trackNumberID, isUpdateByBaseUnit, baseUnitID, transactiontype);
                    info.setCurrentStockQty(currentQty);
                    info.setThistimeQty(ZERO);
                    this.initRowData(info, false, !isNegative);
                    this.backFlushMap.put(info.getId().toString(), info);
                }
            }
        } else {
            String warehouseID = info.getWarehouse() != null ? info.getWarehouse().getId().toString() : null;
            String locactionID = info.getLocation() != null ? info.getLocation().getId().toString() : null;
            String storageOrgUnitID = info.getStorageorgunitID();
            String baseUnitID = info.getBaseUnit() != null ? info.getBaseUnit().getId().toString() : null;
            String unitID = info.getUnit() != null ? info.getUnit().getId().toString() : null;
            String projectID = info.getProject() != null ? info.getProject().getId().toString() : null;
            String trackNumberID = info.getTrackNumber() != null ? info.getTrackNumber().getId().toString() : null;
            IInteractionBackflushFacade interfaceBackFlush = InteractionBackflushFacadeFactory.getRemoteInstance();
            BigDecimal currentQty = interfaceBackFlush.checkCurrentStock(info.getMaterial().getId().toString(), storageOrgUnitID, warehouseID, locactionID, unitID, null, projectID, trackNumberID, isUpdateByBaseUnit, baseUnitID, transactiontype);
            info.setCurrentStockQty(currentQty);
            if (currentQty.compareTo(info.getBackFlushQty()) >= 0) {
                info.setThistimeQty(info.getBackFlushQty());
                this.initRowData(info, true, !isNegative);
            } else if (isNegative) {
                if (currentQty.compareTo(ZERO) > 0) {
                    info.setThistimeQty(currentQty);
                    this.initRowData(info, false, !isNegative);
                } else if (currentQty.compareTo(ZERO) <= 0) {
                    info.setThistimeQty(ZERO);
                    this.initRowData(info, false, !isNegative);
                }
            } else {
                info.setThistimeQty(currentQty);
                this.initRowData(info, false, !isNegative);
            }
            this.backFlushMap.put(info.getId().toString(), info);
        }
    }

    private void setPrecisionMap(String materialId, String unitId) throws BOSException {
        StringBuffer sqlWhere = new StringBuffer();
        String key = materialId + unitId;
        if (precisionMap.get(key) == null) {
            sqlWhere.append("(material.id = '").append(materialId).append("' and measureUnit.id = '").append(unitId).append("' ) ");
            MultiMeasureUnitCollection mmuc = MultiMeasureUnitFactory.getRemoteInstance().getMultiMeasureUnitCollection(" where " + sqlWhere.toString());
            int precision = 0;
            for (int i = 0; i < mmuc.size(); ++i) {
                precision = mmuc.get(i).getQtyPrecision();
                precisionMap.put(key, new Integer(precision));
            }
        }
    }

    private void setRowPrecision(IRow orderRow, InteractionBackFlushInfo info) {
        if (info.getMaterial() == null || info.getUnit() == null) {
            return;
        }
        this.setRowPrecision(orderRow, info.getMaterial().getId().toString(), info.getUnit().getId().toString());
    }

    private void setRowPrecision(IRow orderRow, String materialId, String unitId) {
        String key = materialId + unitId;
        int precision = 0;
        if (precisionMap.containsKey(key)) {
            precision = (Integer)precisionMap.get(key);
        }
        SCMClientUtils.changeCellPrecision((IRow)orderRow, (String[])this.qtyFieldNames, (int)precision, (boolean)false, (boolean)false);
    }

    public CalculateLotValue matchLotIssue(CalculateLotValue value, BigDecimal qty) throws CloneNotSupportedException {
        CalculateLotValue returnValue = new CalculateLotValue();
        returnValue.setLineValues(new ArrayList());
        BigDecimal sumFlotQty = InvClientUtils.ZERO;
        BigDecimal qtySum = InvClientUtils.ZERO;
        ArrayList lineValues = value.getLineValues();
        for (int i = 0; i < lineValues.size(); ++i) {
            CalculateLotLineValue lineValue = (CalculateLotLineValue)lineValues.get(i);
            BigDecimal thisQty = qtySum.add(lineValue.getQty()).compareTo(qty) <= 0 ? lineValue.getQty() : qty.subtract(qtySum);
            sumFlotQty = sumFlotQty.add(lineValue.getQty());
            qtySum = qtySum.add(thisQty);
            lineValue.setQty(lineValue.getQty().subtract(thisQty));
            CalculateLotLineValue returnLineValue = (CalculateLotLineValue)lineValue.clone();
            returnLineValue.setQty(thisQty);
            returnValue.getLineValues().add(returnLineValue);
        }
        returnValue.setSouID(value.getSouID());
        returnValue.setSumFlotQty(sumFlotQty);
        return returnValue;
    }

    private void initRowData(InteractionBackFlushInfo infoForView, boolean qtygreterSum, boolean neverEnable) {
        IRow newRow = this.kDTable1.addRow();
        this.kDTable1.checkParsed();
        newRow.getCell(TB_NUMBER).setValue(infoForView.getMaterial() != null ? infoForView.getMaterial().getNumber() : null);
        newRow.getCell(TB_NAME).setValue(infoForView.getMaterial() != null ? infoForView.getMaterial().getName() : null);
        newRow.getCell(TB_SPEC).setValue(infoForView.getMaterial() != null ? infoForView.getMaterial().getModel() : null);
        newRow.getCell(TB_UNIT).setValue((Object)infoForView.getUnit().getName());
        if (qtygreterSum) {
            boolean qtyBigZero = infoForView.getThistimeQty().compareTo(ZERO) > 0;
            newRow.getCell(TB_SELECTFLAG).setValue((Object)new Boolean(qtyBigZero));
        } else {
            newRow.getCell(TB_SELECTFLAG).setValue((Object)new Boolean(false));
        }
        if (neverEnable && !qtygreterSum) {
            newRow.getCell(TB_SELECTFLAG).getStyleAttributes().setLocked(neverEnable);
        }
        newRow.getCell(TB_LOT).setValue((Object)infoForView.getLot());
        newRow.getCell(TB_QTY).setValue((Object)infoForView.getBackFlushQty());
        newRow.getCell(TB_THISTIMEQTY).setValue((Object)infoForView.getThistimeQty());
        newRow.getCell(TB_WAREHOUSE).setValue(infoForView.getWarehouse() != null ? infoForView.getWarehouse().getName() : null);
        newRow.getCell(TB_LOCATION).setValue(infoForView.getLocation() != null ? infoForView.getLocation().getName() : null);
        newRow.getCell(TB_STOCK).setValue((Object)infoForView.getCurrentStockQty());
        newRow.getCell(TB_ID).setValue((Object)infoForView.getId().toString());
        newRow.getCell(TB_ORDERNUM).setValue((Object)infoForView.getOrderNum());
        newRow.getCell(TB_MFG).setValue((Object)infoForView.getMfg());
        newRow.getCell(TB_EXG).setValue((Object)infoForView.getExg());
        if (infoForView.getProject() != null) {
            newRow.getCell(TB_PROJECT).setValue((Object)infoForView.getProject().getNumber());
        }
        if (infoForView.getTrackNumber() != null) {
            newRow.getCell(TB_TRACK).setValue((Object)infoForView.getTrackNumber().getNumber());
        }
        this.setRowPrecision(newRow, infoForView);
        if (!this.backViewMap.containsKey(infoForView.getId().toString() + "select")) {
            this.backViewMap.put(infoForView.getId().toString() + "select", new Boolean(qtygreterSum));
        }
        if (!this.backViewMap.containsKey(infoForView.getId().toString() + "neverEnable")) {
            this.backViewMap.put(infoForView.getId().toString() + "neverEnable", new Boolean(neverEnable && !qtygreterSum));
        }
    }

    private void initBackFlushData() throws Exception {
        this.sourceBillID = (String)this.getUIContext().get("sourceBillID");
        this.sourceTypeEnum = (BackFlushSourceTypeEnum)((Object)this.getUIContext().get("sourceTypeEnum"));
        Integer status = (Integer)this.getUIContext().get("backFlushStatus");
        this.backFlushStatus = BackFrushStatusEnum.getEnum(status);
        IInteractionBackflushFacade interfaceBackFlush = InteractionBackflushFacadeFactory.getRemoteInstance();
        List listResult = interfaceBackFlush.getInteractionData(this.sourceBillID, this.sourceTypeEnum, this.backFlushStatus);
        if (listResult != null && listResult.size() > 0) {
            for (int i = 0; i < listResult.size(); ++i) {
                InteractionBackFlushInfo info = (InteractionBackFlushInfo)listResult.get(i);
                this.CalculateLot(info);
            }
            this.hideZeroRows(true);
            this.kdcheckbox.setSelected(true);
        }
    }

    private void hideZeroRows(boolean hideFlag) {
        int count = this.kDTable1.getRowCount();
        for (int i = 0; i < count; ++i) {
            BigDecimal stockQty;
            BigDecimal thisTimeQty = this.kDTable1.getCell(i, TB_THISTIMEQTY).getValue() != null ? (BigDecimal)this.kDTable1.getCell(i, TB_THISTIMEQTY).getValue() : new BigDecimal(0);
            BigDecimal bigDecimal = stockQty = this.kDTable1.getCell(i, TB_STOCK).getValue() != null ? (BigDecimal)this.kDTable1.getCell(i, TB_STOCK).getValue() : new BigDecimal(0);
            if (thisTimeQty.compareTo(ZERO) > 0) continue;
            this.kDTable1.getRow(i).getStyleAttributes().setHided(hideFlag);
        }
    }

    private void syncUiDataToCacah() {
        int count = this.kDTable1.getRowCount();
        for (int i = 0; i < count; ++i) {
            String key = (String)this.kDTable1.getCell(i, TB_ID).getValue();
            Boolean selectFlag = this.kDTable1.getCell(i, TB_SELECTFLAG).getValue() != null ? (Boolean)this.kDTable1.getCell(i, TB_SELECTFLAG).getValue() : new Boolean(false);
            BigDecimal thisTimeQTY = this.kDTable1.getCell(i, TB_THISTIMEQTY).getValue() != null ? (BigDecimal)this.kDTable1.getCell(i, TB_THISTIMEQTY).getValue() : new BigDecimal(0);
            InteractionBackFlushInfo info = (InteractionBackFlushInfo)this.backFlushMap.get(key);
            info.setThistimeQty(thisTimeQTY);
            info.setSelectFlag(selectFlag);
        }
    }

    @Override
    public void actionconfirm_actionPerformed(ActionEvent e) throws Exception {
        this.syncUiDataToCacah();
        int count = this.kDTable1.getRowCount();
        if (count <= 0) {
            MsgBox.showInfo((String)this.getResource("NOTOBACKFLUSHDATA"));
            return;
        }
        boolean hasSelectFlag = false;
        HashMap materialLotMap = new HashMap();
        ArrayList<InteractionBackFlushInfo> materialNoSelectList = new ArrayList<InteractionBackFlushInfo>();
        StringBuffer errorMaterialName = null;
        for (int i = 0; i < count; ++i) {
            boolean MaterialHasSelect = false;
            String id = (String)this.kDTable1.getCell(i, TB_ID).getValue();
            ArrayList<InteractionBackFlushInfo> sameMaterialList = new ArrayList<InteractionBackFlushInfo>();
            InteractionBackFlushInfo info = (InteractionBackFlushInfo)this.backFlushMap.get(id);
            if (info.isSelectFlag()) {
                hasSelectFlag = true;
                sameMaterialList.add(info);
                MaterialHasSelect = true;
                if (info.getThistimeQty().compareTo(new BigDecimal(0)) <= 0) {
                    MsgBox.showInfo((String)this.getResource("BACKFLUSHQTYMUSTBIG"));
                    return;
                }
            }
            for (int z = 0; z < count; ++z) {
                String otherId = (String)this.kDTable1.getCell(z, TB_ID).getValue();
                InteractionBackFlushInfo sameInfo = (InteractionBackFlushInfo)this.backFlushMap.get(otherId);
                if (!sameInfo.isSelectFlag() || id.equalsIgnoreCase(otherId) || !sameInfo.getOrderID().equals(info.getOrderID()) || !sameInfo.getOrderEntryID().equals(info.getOrderEntryID()) || !sameInfo.getMaterial().getId().toString().equalsIgnoreCase(info.getMaterial().getId().toString())) continue;
                sameMaterialList.add(sameInfo);
                MaterialHasSelect = true;
            }
            if (!materialLotMap.containsKey(info.getMaterial().getId().toString())) {
                materialLotMap.put(info.getMaterial().getId().toString(), sameMaterialList);
            }
            if (MaterialHasSelect) continue;
            materialNoSelectList.add(info);
        }
        if (!hasSelectFlag) {
            MsgBox.showInfo((String)this.getResource("NODATABACKFLUSH"));
            return;
        }
        HashMap<String, String> materialNameMap = new HashMap<String, String>();
        for (int i = 0; i < count; ++i) {
            InteractionBackFlushInfo back;
            String key = (String)this.kDTable1.getCell(i, TB_ID).getValue();
            InteractionBackFlushInfo info = (InteractionBackFlushInfo)this.backFlushMap.get(key);
            if (!materialLotMap.containsKey(info.getMaterial().getId().toString())) continue;
            ArrayList list = (ArrayList)materialLotMap.get(info.getMaterial().getId().toString());
            if (list != null && list.size() == 1) {
                back = (InteractionBackFlushInfo)list.get(ZERO.intValue());
                if (back.getBackFlushQty().compareTo(back.getThistimeQty()) == ZERO.intValue() || materialNameMap.containsKey(back.getOrderID() + back.getOrderEntryID() + back.getMaterial().getId().toString())) continue;
                materialNameMap.put(back.getOrderID() + back.getOrderEntryID() + back.getMaterial().getId().toString(), back.getMaterial().getName());
                if (errorMaterialName == null) {
                    errorMaterialName = new StringBuffer();
                    errorMaterialName.append(this.getResource("MANUFACUTRE") + back.getOrderNum() + this.getResource("SMATERIAL") + back.getMaterial().getName());
                    continue;
                }
                errorMaterialName.append(this.getResource("MANUFACUTRE") + back.getOrderNum() + this.getResource("SMATERIAL") + back.getMaterial().getName());
                continue;
            }
            if (list == null || list.size() <= 1) continue;
            back = (InteractionBackFlushInfo)list.get(ZERO.intValue());
            BigDecimal totalQty = back.getBackFlushQty();
            BigDecimal thisSumQty = ZERO;
            for (int c = 0; c < list.size(); ++c) {
                InteractionBackFlushInfo listInfo = (InteractionBackFlushInfo)list.get(c);
                thisSumQty = listInfo.getThistimeQty().add(thisSumQty);
            }
            if (totalQty.compareTo(thisSumQty) == ZERO.intValue() || materialNameMap.containsKey(back.getOrderID() + back.getOrderEntryID() + back.getMaterial().getId().toString())) continue;
            materialNameMap.put(back.getOrderID() + back.getOrderEntryID() + back.getMaterial().getId().toString(), back.getMaterial().getName());
            if (errorMaterialName == null) {
                errorMaterialName = new StringBuffer();
                errorMaterialName.append(this.getResource("MANUFACUTRE") + back.getOrderNum() + this.getResource("SMATERIAL") + back.getMaterial().getName());
                continue;
            }
            errorMaterialName.append(this.getResource("MANUFACUTRE") + back.getOrderNum() + this.getResource("SMATERIAL") + back.getMaterial().getName());
        }
        if (errorMaterialName != null) {
            MsgBox.showInfo((String)(errorMaterialName.toString() + this.getResource("BQTYNOTEQUALSUM")));
            return;
        }
        this.finalCheckStockAndBackFlush(this.kDTable1, materialNoSelectList);
    }

    public void finalCheckStockAndBackFlush(KDTable kdtable, List materialNoSelectList) throws Exception {
        int count = this.kDTable1.getRowCount();
        HashMap<String, InteractionBackFlushInfo> faileMap = new HashMap<String, InteractionBackFlushInfo>();
        ArrayList<InteractionBackFlushInfo> failedList = new ArrayList<InteractionBackFlushInfo>();
        ArrayList<InteractionBackFlushInfo> toBackFlushList = new ArrayList<InteractionBackFlushInfo>();
        ArrayList<String> orderIDlist = new ArrayList<String>();
        HashMap recbillbackFlushMap = new HashMap();
        ArrayList<InteractionBackFlushInfo> allSelectedList = new ArrayList<InteractionBackFlushInfo>();
        StringBuffer errorMEssage = new StringBuffer();
        TransactionTypeInfo transactiontype = null;
        TransactionTypeCollection col = TransactionTypeHelper.getTransactionType4MaterialReqOut(null);
        if (col != null && col.size() == 1) {
            transactiontype = col.get(0);
        }
        ITransactionType transaction = TransactionTypeFactory.getRemoteInstance();
        if (transactiontype == null && transaction.exists((IObjectPK)new ObjectUuidPK(TRANSACTIONTYPEID_MANU))) {
            transactiontype = (TransactionTypeInfo)transaction.getValue((IObjectPK)new ObjectUuidPK(TRANSACTIONTYPEID_MANU));
        }
        for (int i = 0; i < count; ++i) {
            String id = (String)this.kDTable1.getCell(i, TB_ID).getValue();
            InteractionBackFlushInfo info = (InteractionBackFlushInfo)this.backFlushMap.get(id);
            if (!info.isSelectFlag()) continue;
            allSelectedList.add(info);
            IInteractionBackflushFacade interfaceBackFlush = InteractionBackflushFacadeFactory.getRemoteInstance();
            String materialID = info.getMaterial() != null ? info.getMaterial().getId().toString() : null;
            String storageOrgUnitID = info.getStorageorgunitID() != null ? info.getStorageorgunitID() : null;
            String warehouseID = info.getWarehouse() != null ? info.getWarehouse().getId().toString() : null;
            String locationid = info.getLocation() != null ? info.getLocation().getId().toString() : null;
            String unitid = info.getUnit() != null ? info.getUnit().getId().toString() : null;
            String baseUnitid = info.getBaseUnit() != null ? info.getBaseUnit().getId().toString() : null;
            String lot = info.getLot() != null ? info.getLot() : null;
            String projectID = info.getProject() != null ? info.getProject().getId().toString() : null;
            String trackNumberID = info.getTrackNumber() != null ? info.getTrackNumber().getId().toString() : null;
            boolean isUpdateByBaseUnit = InvClientUtils.isUpdateInvByBaseUnit((String)storageOrgUnitID);
            Boolean negative = (Boolean)this.negativeMap.get(info.getMaterial().getId().toString());
            BigDecimal stockQty = interfaceBackFlush.checkCurrentStock(materialID, storageOrgUnitID, warehouseID, locationid, unitid, lot, projectID, trackNumberID, isUpdateByBaseUnit, baseUnitid, transactiontype);
            if (!negative.booleanValue() && stockQty.compareTo(info.getThistimeQty()) < 0) {
                if (!faileMap.containsKey(info.getOrderNum() + "," + info.getMaterial().getName())) {
                    faileMap.put(info.getOrderNum() + "," + info.getMaterial().getName(), info);
                }
                failedList.add(info);
                errorMEssage.append(this.getResource("MANUFACUTRE") + info.getOrderNum() + this.getResource("SMATERIAL") + info.getMaterial().getName() + ",");
                continue;
            }
            toBackFlushList.add(info);
            if (orderIDlist.contains(info.getOrderID())) continue;
            orderIDlist.add(info.getOrderID());
        }
        try {
            if (toBackFlushList.size() > 0) {
                IInteractionBackflushFacade interfaceBackFlush = InteractionBackflushFacadeFactory.getRemoteInstance();
                if (this.sourceTypeEnum == BackFlushSourceTypeEnum.BACKFLUSH_COMPLETION) {
                    InteractionBackFlushInfo[] backFlushArray = toBackFlushList.toArray(new InteractionBackFlushInfo[0]);
                    BillTypeInfo billType = new BillTypeInfo();
                    billType.setId(BOSUuid.read((String)"HxPKDRdzRpaqr31LD+3SBEY+1VI="));
                    interfaceBackFlush.interactionBackFlushForComRpt(backFlushArray, billType);
                } else {
                    for (int i = 0; i < orderIDlist.size(); ++i) {
                        String orderID = (String)orderIDlist.get(i);
                        ArrayList<InteractionBackFlushInfo> sameOrderList = new ArrayList<InteractionBackFlushInfo>();
                        for (int z = 0; z < toBackFlushList.size(); ++z) {
                            InteractionBackFlushInfo flushInfo = (InteractionBackFlushInfo)toBackFlushList.get(z);
                            if (!orderID.equals(flushInfo.getOrderID())) continue;
                            sameOrderList.add(flushInfo);
                        }
                        if (sameOrderList.size() <= 0) continue;
                        recbillbackFlushMap.put(orderID, sameOrderList);
                    }
                    if (recbillbackFlushMap.size() > 0) {
                        BillTypeInfo billType = new BillTypeInfo();
                        billType.setId(BOSUuid.read((String)"50957179-0105-1000-e000-0167c0a812fd463ED552"));
                        interfaceBackFlush.inStockBackFlush(this.sourceBillID, recbillbackFlushMap, billType);
                    }
                }
            }
        }
        catch (EASBizException e) {
            toBackFlushList.clear();
            this.HandleStatusAndData(allSelectedList, materialNoSelectList, toBackFlushList);
            throw e;
        }
        this.HandleStatusAndData(failedList, materialNoSelectList, toBackFlushList);
        HashMap<String, InteractionBackFlushInfo> finalDataMap = new HashMap<String, InteractionBackFlushInfo>();
        if (toBackFlushList.size() > 0) {
            InteractionBackFlushInfo sameMaterialInfo;
            int z;
            for (int i = 0; i < toBackFlushList.size(); ++i) {
                InteractionBackFlushInfo flushInfo = (InteractionBackFlushInfo)toBackFlushList.get(i);
                if (finalDataMap.containsKey(flushInfo.getOrderID() + flushInfo.getOrderEntryID() + flushInfo.getMaterial().getId().toString())) continue;
                finalDataMap.put(flushInfo.getOrderID() + flushInfo.getOrderEntryID() + flushInfo.getMaterial().getId().toString(), flushInfo);
            }
            this.kDTable1.removeRows();
            if (materialNoSelectList.size() > 0) {
                for (z = 0; z < materialNoSelectList.size(); ++z) {
                    sameMaterialInfo = (InteractionBackFlushInfo)materialNoSelectList.get(z);
                    boolean neverEnable = false;
                    if (this.backViewMap.containsKey(sameMaterialInfo.getId().toString() + "neverEnable")) {
                        neverEnable = (Boolean)this.backViewMap.get(sameMaterialInfo.getId().toString() + "neverEnable");
                    }
                    this.initRowData(sameMaterialInfo, false, neverEnable);
                    this.kdcheckbox.setSelected(false);
                }
            }
            if (failedList.size() > 0) {
                for (z = 0; z < failedList.size(); ++z) {
                    sameMaterialInfo = (InteractionBackFlushInfo)failedList.get(z);
                    boolean neverEnable = false;
                    if (this.backViewMap.containsKey(sameMaterialInfo.getId().toString() + "neverEnable")) {
                        neverEnable = (Boolean)this.backViewMap.get(sameMaterialInfo.getId().toString() + "neverEnable");
                    }
                    this.initRowData(sameMaterialInfo, false, neverEnable);
                    this.kdcheckbox.setSelected(false);
                }
            }
        }
        if (errorMEssage.length() > 0) {
            MsgBox.showInfo((String)(errorMEssage.toString() + this.getResource("STOCKERRBACKFLUSHFAIED")));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void HandleStatusAndData(List failedList, List materialNoSelectList, List toBackFlushList) throws BOSException, EASBizException {
        interfaceBackFlush = InteractionBackflushFacadeFactory.getRemoteInstance();
        switch (this.backFlushStatus.getValue()) {
            case 4: {
                if (failedList.size() <= 0 && materialNoSelectList.size() <= 0 || toBackFlushList.size() != 0) ** GOTO lbl8
                interfaceBackFlush.saveInteractionFaiedData(failedList, materialNoSelectList, BackFrushStatusEnum.FAILING, this.sourceTypeEnum, this.sourceBillID, true);
                this.backFlushStatus = BackFrushStatusEnum.FAILING;
                ** GOTO lbl19
lbl8:
                // 1 sources

                if (failedList.size() <= 0 && materialNoSelectList.size() <= 0 || toBackFlushList.size() <= 0) ** GOTO lbl12
                interfaceBackFlush.saveInteractionFaiedData(failedList, materialNoSelectList, BackFrushStatusEnum.PART_SUCCESS, this.sourceTypeEnum, this.sourceBillID, true);
                this.backFlushStatus = BackFrushStatusEnum.PART_SUCCESS;
                ** GOTO lbl19
lbl12:
                // 1 sources

                if (failedList.size() == 0 && toBackFlushList.size() > 0) {
                    if (materialNoSelectList.size() > 0) {
                        interfaceBackFlush.saveInteractionFaiedData(null, materialNoSelectList, BackFrushStatusEnum.PART_SUCCESS, this.sourceTypeEnum, this.sourceBillID, true);
                        this.backFlushStatus = BackFrushStatusEnum.PART_SUCCESS;
                    } else {
                        interfaceBackFlush.saveInteractionFaiedData(null, null, BackFrushStatusEnum.SUCCESS, this.sourceTypeEnum, this.sourceBillID, false);
                        this.backFlushStatus = BackFrushStatusEnum.SUCCESS;
                    }
                }
            }
lbl19:
            // 7 sources

            case 3: {
                if (toBackFlushList.size() > 0 && failedList.size() == 0 && materialNoSelectList.size() == 0) {
                    interfaceBackFlush.saveInteractionFaiedData(null, null, BackFrushStatusEnum.SUCCESS, this.sourceTypeEnum, this.sourceBillID, false);
                    this.backFlushStatus = BackFrushStatusEnum.SUCCESS;
                }
            }
            case 2: {
                if ((failedList.size() > 0 || materialNoSelectList.size() > 0) && toBackFlushList.size() > 0) {
                    interfaceBackFlush.saveInteractionFaiedData(failedList, materialNoSelectList, BackFrushStatusEnum.PART_SUCCESS, this.sourceTypeEnum, this.sourceBillID, false);
                    this.backFlushStatus = BackFrushStatusEnum.PART_SUCCESS;
                    break;
                }
                if (failedList.size() != 0 || materialNoSelectList.size() != 0 || toBackFlushList.size() <= 0) break;
                interfaceBackFlush.saveInteractionFaiedData(null, null, BackFrushStatusEnum.SUCCESS, this.sourceTypeEnum, this.sourceBillID, false);
                this.backFlushStatus = BackFrushStatusEnum.SUCCESS;
            }
        }
    }

    @Override
    public void actioncancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    public boolean destroyWindow() {
        boolean destroy = super.destroyWindow();
        if (this.getUIContext().get("Owner") instanceof InteractionBackflushFrameUI) {
            InteractionBackflushFrameUI parent = (InteractionBackflushFrameUI)((Object)this.getUIContext().get("Owner"));
            try {
                parent.refresh_actionPerformed(null);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return destroy;
    }

    private String getResource(String strKey) {
        return EASResource.getString((String)RESOURCEPATH, (String)strKey);
    }
}

