/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.mm.basedata.CSEntrustTypeEnum;
import com.kingdee.eas.mm.basedata.WorkCenterInfo;
import com.kingdee.eas.mm.common.client.KDTableUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.sfc.IPACBuildFacade;
import com.kingdee.eas.mm.sfc.PACBuildFacadeFactory;
import com.kingdee.eas.mm.sfc.PACDispatchException;
import com.kingdee.eas.mm.sfc.PACSelectModelOfScheduleInfo;
import com.kingdee.eas.mm.sfc.PACViewBurthenInfo;
import com.kingdee.eas.mm.sfc.client.AbstractPACBuildUI;
import com.kingdee.eas.mm.sfc.client.PACFilterUI;
import com.kingdee.eas.mm.sfc.client.PACUpdateDateUI;
import com.kingdee.eas.mm.sfc.client.PACViewBurthenUI;
import com.kingdee.eas.mm.sfc.util.pac.IShortcutQueryImpl;
import com.kingdee.eas.mm.sfc.util.pac.MMTableSelectionHelper;
import com.kingdee.eas.mm.sfc.util.pac.PACParamInfo;
import com.kingdee.eas.mm.sfc.util.pac.PACSaveActionProxy;
import com.kingdee.eas.mm.sfc.util.pac.PACSelectUICreator;
import com.kingdee.eas.mm.sfc.util.pac.PACUtil;
import com.kingdee.eas.mm.sfc.util.pac.TableEditHandler;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.ActionProxyFactory;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.EnumUtils;
import edu.emory.mathcs.backport.java.util.Collections;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class PACBuildUI
extends AbstractPACBuildUI
implements IShortcutQueryImpl {
    private static final Logger logger = CoreUIObject.getLogger(PACBuildUI.class);
    private String[] filterFields;
    private String[] editableColumns;
    private EntityViewInfo currEntityViewInfo = null;
    private KDPromptSelector modelSelector = null;
    private Map exEditFieldMap = null;
    private KDTEditAdapter entryChangeKDTEditAdapter;
    private KDTActiveCellListener entryActiveCellListener = null;
    protected static final String STATUS_EDIT = "EDIT";
    protected static final String STATUS_VIEW = "VIEW";

    @Override
    public void onLoad() throws Exception {
        this.initUICtrl();
        String strParam = (String)this.getUIContext().get("UIClassParam");
        this.initWithMenuParam(strParam);
        this.setOprtState(STATUS_VIEW);
        super.onLoad();
        this.initEditElement();
        KDTableUtils.setDefaultFreezeCol((KDTable)this.kdtMain, (int)(this.kdtMain.getColumnIndex("operation.name") + 1));
    }

    private void initWithMenuParam(String strParam) throws Exception {
        int nParam = Integer.parseInt(strParam);
        this.checkPermission(nParam);
        switch (nParam) {
            case 1: {
                this.setUITitle(EASResource.getString((String)"com.kingdee.eas.mm.sfc.PACResource", (String)"PACBUILD_TITLE"));
                this.filterFields = new String[]{"workDept.name", "workcenter.name"};
                this.filterUI = new PACFilterUI(false, 1);
                this.shortcutPanel = new PACFilterUI(true, 1);
                this.queryInfo = "com.kingdee.eas.mm.sfc.app.MOTechnicsForPACBuildQuery";
                this.editableColumns = new String[]{"workcenter.name", "technics.isKeyOP", "technics.earlistWoktime", "technics.earlistCmpTime", "technics.lastWorktime", "technics.lastCmpTime", "technics.remark", "technics.queuingTime", "technics.prepareTime", "technics.workTime", "technics.waitingTime", "technics.movingTime", "technics.operationRemark"};
                this.exEditableColumns4Build();
                break;
            }
            case 2: {
                this.setUITitle(EASResource.getString((String)"com.kingdee.eas.mm.sfc.PACResource", (String)"PACEDIT_TITLE"));
                this.filterFields = new String[]{"workcenter.name"};
                this.filterUI = new PACFilterUI(false, 2);
                this.shortcutPanel = new PACFilterUI(true, 2);
                this.queryInfo = "com.kingdee.eas.mm.sfc.app.MOTechnicsForPACEditQuery";
                this.editableColumns = new String[]{"workcenter.name", "technics.isKeyOP", "technics.earlistWoktime", "technics.earlistCmpTime", "technics.lastWorktime", "technics.lastCmpTime", "technics.remark", "technics.queuingTime", "technics.prepareTime", "technics.workTime", "technics.waitingTime", "technics.movingTime", "technics.operationRemark"};
                this.actionProcessSchedule.setVisible(false);
                this.actionReleased.setVisible(false);
                this.actionUnReleased.setVisible(false);
                this.actionUpdateOrderDate.setVisible(false);
            }
        }
    }

    private void exEditableColumns4Build() {
        String[] exColumnsName = null;
        if (this.exEditFieldMap != null && this.exEditFieldMap.size() > 0) {
            exColumnsName = new String[this.exEditFieldMap.size()];
            int j = 0;
            for (Map.Entry entry : this.exEditFieldMap.entrySet()) {
                exColumnsName[j++] = (String)entry.getKey();
            }
            String[] temp = new String[this.editableColumns.length + exColumnsName.length];
            System.arraycopy(this.editableColumns, 0, temp, 0, this.editableColumns.length);
            for (String temp[this.editableColumns.length + i] : exColumnsName) {
            }
            this.editableColumns = temp;
        }
    }

    private void checkPermission(int type) throws BOSException, EASBizException {
        boolean havePermission = false;
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        String dopermissionItem = null;
        dopermissionItem = type == 1 ? "mm_sfc_PACBuild" : "mm_sfc_PACAdjust";
        StorageOrgUnitInfo storage = (StorageOrgUnitInfo)PACBuildUI.getDefaultMainBizOrg(this.getMainBizOrgType(), dopermissionItem);
        if (storage == null) {
            if (type == 1) {
                throw new PACDispatchException(PACDispatchException.NO_BUILD_PERMISSION);
            }
            throw new PACDispatchException(PACDispatchException.NO_ADJUST_PERMISSION);
        }
        ObjectUuidPK storagePk = new ObjectUuidPK(storage.getId());
        IPermission ipermission = PermissionFactory.getRemoteInstance();
        try {
            ipermission.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)storagePk, dopermissionItem);
            havePermission = true;
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        if (!havePermission) {
            if (type == 1) {
                throw new PACDispatchException(PACDispatchException.NO_BUILD_CURRENTORG_PERMISSION);
            }
            throw new PACDispatchException(PACDispatchException.NO_ADJUST_CURRENTORG_PERMISSION);
        }
    }

    public static OrgUnitInfo getDefaultMainBizOrg(OrgType orgType, String strStatus) throws EASBizException, BOSException {
        OrgUnitInfo[] mainOrgs = null;
        try {
            mainOrgs = SCMServiceFactory.getPermissionService().getAuthorizedBizOrgUnits((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), orgType, strStatus);
            if (mainOrgs == null || mainOrgs.length == 0) {
                return null;
            }
            if (mainOrgs.length > 0) {
                mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])mainOrgs, (boolean)true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        OrgUnitInfo currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(orgType);
        if (currentMainOrg != null && mainOrgs != null && mainOrgs.length > 0) {
            for (int i = 0; i < mainOrgs.length; ++i) {
                if (!currentMainOrg.getId().toString().equals(mainOrgs[i].getId().toString())) continue;
                return currentMainOrg;
            }
        }
        if (mainOrgs.length > 0) {
            return mainOrgs[0];
        }
        return null;
    }

    @Override
    protected void putHideColumn() {
        this.tHelper.putHideColumn("technics.id");
        this.tHelper.putHideColumn("storageOrgUnit.id");
    }

    protected void initUICtrl() {
        KDTableHelper.releaseEnterAndTab((JComponent)this.kdtMain);
        KDTableHelper.releaseEsc((JComponent)this.kdtMain);
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.kdtMain, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.kdtMain.getSelectManager().setSelectMode(10);
        this.kdtMain.getDataRequestManager().setDataRequestMode(0);
        this.kdtMain.getStyleAttributes().setLocked(true);
    }

    @Override
    protected void initUIHelper() throws BOSException {
        super.initUIHelper();
        this.uiHelper.registerDataFilterHandler(this.kdtMain, this.filterPanel, this.filterFields);
        this.uiHelper.registerTableEditHandler(this.kdtMain, this.editableColumns);
        this.putEditParams();
        try {
            this.uiHelper.registerShortcutQueryHandler(this.kdtMain, this, this.queryPanel, (CustomerQueryPanel)this.shortcutPanel);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    private void putEditParams() throws BOSException {
        PACParamInfo workcenterInfo = new PACParamInfo();
        workcenterInfo.setId("workcenter.id");
        workcenterInfo.setName("workcenter.name");
        workcenterInfo.setNumber("workcenter.number");
        workcenterInfo.setClassName("com.kingdee.eas.mm.basedata.WorkCenterInfo");
        workcenterInfo.setDataType(DataType.OBJECTVALUE);
        PACParamInfo workOrgInfo = new PACParamInfo();
        workOrgInfo.setId("workOrgUnit.id");
        workOrgInfo.setName("workOrgUnit.name");
        workOrgInfo.setNumber("workOrgUnit.number");
        workOrgInfo.setClassName("com.kingdee.eas.basedata.org.StorageOrgUnitInfo");
        workOrgInfo.setDataType(DataType.OBJECTVALUE);
        PACParamInfo workDeptInfo = new PACParamInfo();
        workDeptInfo.setId("workDept.id");
        workDeptInfo.setName("workDept.name");
        workDeptInfo.setNumber("workDept.number");
        workDeptInfo.setClassName("com.kingdee.eas.basedata.org.AdminOrgUnitInfo");
        workDeptInfo.setDataType(DataType.OBJECTVALUE);
        PACParamInfo entrustTypeInfo = new PACParamInfo();
        entrustTypeInfo.setDataType(DataType.ENUM);
        entrustTypeInfo.setEnumMap(CSEntrustTypeEnum.getEnumMap());
        TableEditHandler tableEditHandler = this.uiHelper.getTableEditHandler(this.kdtMain);
        tableEditHandler.addParam("workcenter.name", workcenterInfo);
        tableEditHandler.addParam("workOrgUnit.name", workOrgInfo);
        tableEditHandler.addParam("workDept.name", workDeptInfo);
        tableEditHandler.addParam("technics.entrustType", entrustTypeInfo);
        this.addExParam();
    }

    private void addExParam() throws BOSException {
        if (this.exEditFieldMap != null && this.exEditFieldMap.size() > 0) {
            for (Map.Entry entry : this.exEditFieldMap.entrySet()) {
                PACParamInfo paramInfo = (PACParamInfo)entry.getValue();
                if (paramInfo.getDataType().equals((Object)DataType.ENUM)) {
                    try {
                        Class<?> enumClass = Class.forName(paramInfo.getClassName());
                        paramInfo.setEnumMap(EnumUtils.getEnumMap(enumClass));
                    }
                    catch (ClassNotFoundException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                this.uiHelper.getTableEditHandler(this.kdtMain).addParam((String)entry.getKey(), paramInfo);
            }
        }
    }

    @Override
    public void initBatchActions() throws BOSException {
        super.initBatchActions();
        this.actionManager.setClzIBizFactory(ActionLevelEnum.ENTRY, PACBuildFacadeFactory.class);
        this.getTableSelectionHelper(this.kdtMain).setTablePropertyForBatchAction("id", "technics.id", "number", "technics.operationNo", "storageOrgUnit.id");
        PACSaveActionProxy actionProxy = new PACSaveActionProxy(this.actionSave, "save", ActionLevelEnum.ENTRY, BatchActionEnum.SAVE, this.getLocale());
        actionProxy.addExFields(this.getExEditFieldMap());
        this.actionManager.registerBatchAction((ActionProxy)actionProxy, "actionSave");
        actionProxy.bindTo((AbstractButton)this.btnSave);
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, ManufactureOrderFactory.class);
        ActionProxy releasedProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)new BatchActionEnum("RELEASED"), (ItemAction)this.actionReleased, (String)"released");
        this.actionManager.registerBatchAction(releasedProxy, "actionRelease");
        releasedProxy.bindTo((AbstractButton)this.btnReleased);
        ActionProxy unReleasedProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)new BatchActionEnum("UNRELEASED"), (ItemAction)this.actionUnReleased, (String)"unreleased");
        this.actionManager.registerBatchAction(unReleasedProxy, "actionUnRelease");
        unReleasedProxy.bindTo((AbstractButton)this.btnUnReleased);
    }

    @Override
    protected KDTable getQueryTable() {
        return this.kdtMain;
    }

    @Override
    public boolean isSupportedBatchActions() {
        return true;
    }

    @Override
    protected String[] getEditableColumns() {
        return this.editableColumns;
    }

    @Override
    public void actionGetDispatchTime_actionPerformed(ActionEvent e) throws Exception {
        this.checkModified();
        MMTableSelectionHelper mmTableSelectionHelper = this.getTableSelectionHelper(this.kdtMain);
        List technicsList = mmTableSelectionHelper.getSelectedKeyDataList();
        String orgId = (String)this.kdtMain.getCell(0, "storageOrgUnit.id").getValue();
        String getDispatchTimeType = ParamManager.getParamValue(null, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)orgId)), (String)"GetDispatchTimeType");
        if (getDispatchTimeType.equals("0")) {
            getDispatchTimeType = "10";
        } else if (getDispatchTimeType.equals("1")) {
            getDispatchTimeType = "20";
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("technicsList", technicsList);
        param.put("getDispatchTimeType", getDispatchTimeType);
        IPACBuildFacade remoteFacade = PACBuildFacadeFactory.getRemoteInstance();
        Map result = remoteFacade.getDispatchTime(param);
        if (result == null) {
            return;
        }
        Set set = result.entrySet();
        Iterator it = set.iterator();
        String technicsId = null;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            technicsId = (String)entry.getKey();
            int row = mmTableSelectionHelper.getRowIndex(technicsId);
            if (row == -1) continue;
            Timestamp[] times = (Timestamp[])entry.getValue();
            if ("10".equals(getDispatchTimeType)) {
                if (times[0] != null) {
                    this.kdtMain.getCell(row, "technics.earlistWoktime").setValue((Object)times[0]);
                }
                if (times[1] == null) continue;
                this.kdtMain.getCell(row, "technics.earlistCmpTime").setValue((Object)times[1]);
                continue;
            }
            if (!"20".equals(getDispatchTimeType)) continue;
            if (times[0] != null) {
                this.kdtMain.getCell(row, "technics.lastWorktime").setValue((Object)times[0]);
            }
            if (times[1] == null) continue;
            this.kdtMain.getCell(row, "technics.lastCmpTime").setValue((Object)times[1]);
        }
        super.actionGetDispatchTime_actionPerformed(e);
    }

    private void selectTechnicsOfSameMo() {
        MMTableSelectionHelper mmTableSelectionHelper = this.getTableSelectionHelper(this.kdtMain);
        List technicsList = mmTableSelectionHelper.getSelectedKeyDataList();
        Iterator it = technicsList.iterator();
        HashSet<String> moIdSet = new HashSet<String>();
        String technicsId = null;
        String moId = null;
        while (it.hasNext()) {
            technicsId = (String)it.next();
            int row = mmTableSelectionHelper.getRowIndex(technicsId);
            moId = (String)this.kdtMain.getCell(row, "id").getValue();
            moIdSet.add(moId);
        }
        if (moIdSet.size() < 1) {
            return;
        }
        int rows = this.kdtMain.getRowCount3();
        for (int i = 0; i < rows; ++i) {
            if (!moIdSet.contains((String)this.kdtMain.getCell(i, "id").getValue())) continue;
            this.kdtMain.getCell(i, "isSelected").setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    public void actionProcessSchedule_actionPerformed(ActionEvent e) throws Exception {
        block18: {
            String technicsId;
            Iterator it;
            String getDispatchTimeType;
            MMTableSelectionHelper mmTableSelectionHelper;
            block17: {
                Object[] result;
                this.checkModified();
                if (this.modelSelector == null) {
                    this.modelSelector = PACSelectUICreator.createSelector(this.getPriorityQuery());
                    this.configSelector(this.modelSelector);
                }
                this.modelSelector.show();
                String model = null;
                if (!this.modelSelector.isCanceled()) {
                    result = (Object[])this.modelSelector.getData();
                    if (result[0] == null || !(result[0] instanceof PACSelectModelOfScheduleInfo)) {
                        return;
                    }
                } else {
                    return;
                }
                PACSelectModelOfScheduleInfo info = (PACSelectModelOfScheduleInfo)result[0];
                model = info.getNumber();
                this.selectTechnicsOfSameMo();
                mmTableSelectionHelper = this.getTableSelectionHelper(this.kdtMain);
                List technicsList = mmTableSelectionHelper.getSelectedKeyDataList();
                String orgId = (String)this.kdtMain.getCell(0, "storageOrgUnit.id").getValue();
                HashMap paramMap = ParamManager.getParamHashMap(null, (String[])new String[]{"GetDispatchTimeType"}, (String)orgId);
                getDispatchTimeType = (String)paramMap.get("GetDispatchTimeType");
                if (getDispatchTimeType.equals("0")) {
                    getDispatchTimeType = "10";
                } else if (getDispatchTimeType.equals("1")) {
                    getDispatchTimeType = "20";
                }
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("model", model);
                param.put("technicsList", technicsList);
                param.put("GetDispatchTimeType", getDispatchTimeType);
                param.put("orgId", orgId);
                IPACBuildFacade remoteFacade = PACBuildFacadeFactory.getRemoteInstance();
                Map result2 = remoteFacade.processSchedule(param);
                if (result2 == null) {
                    return;
                }
                Set set = result2.entrySet();
                it = set.iterator();
                technicsId = null;
                if ("NoSchedule".equalsIgnoreCase(model) || "ForwardSchedule".equalsIgnoreCase(model) || "BackwardSchedule".equalsIgnoreCase(model)) {
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        technicsId = (String)entry.getKey();
                        int row = mmTableSelectionHelper.getRowIndex(technicsId);
                        if (row == -1) continue;
                        Timestamp[] times = (Timestamp[])entry.getValue();
                        if (times.length >= 2 && times[0] != null) {
                            this.kdtMain.getCell(row, "technics.earlistWoktime").setValue((Object)times[0]);
                        }
                        if (times.length >= 2 && times[1] != null) {
                            this.kdtMain.getCell(row, "technics.earlistCmpTime").setValue((Object)times[1]);
                        }
                        if (times.length >= 3 && times[2] != null) {
                            this.kdtMain.getCell(row, "technics.lastWorktime").setValue((Object)times[2]);
                        }
                        if (times.length < 4 || times[3] == null) continue;
                        this.kdtMain.getCell(row, "technics.lastCmpTime").setValue((Object)times[3]);
                    }
                    return;
                }
                if (!"10".equals(getDispatchTimeType)) break block17;
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    technicsId = (String)entry.getKey();
                    int row = mmTableSelectionHelper.getRowIndex(technicsId);
                    if (row == -1) continue;
                    Timestamp[] times = (Timestamp[])entry.getValue();
                    if (times.length == 2 && times[0] != null) {
                        this.kdtMain.getCell(row, "technics.earlistWoktime").setValue((Object)times[0]);
                    }
                    if (times[1] == null) continue;
                    this.kdtMain.getCell(row, "technics.earlistCmpTime").setValue((Object)times[1]);
                }
                break block18;
            }
            if (!"20".equals(getDispatchTimeType)) break block18;
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                technicsId = (String)entry.getKey();
                int row = mmTableSelectionHelper.getRowIndex(technicsId);
                if (row == -1) continue;
                Timestamp[] times = (Timestamp[])entry.getValue();
                if (times.length == 2 && times[0] != null) {
                    this.kdtMain.getCell(row, "technics.lastWorktime").setValue((Object)times[0]);
                }
                if (times[1] == null) continue;
                this.kdtMain.getCell(row, "technics.lastCmpTime").setValue((Object)times[1]);
            }
        }
    }

    private void configSelector(KDPromptSelector selector) {
        if (selector instanceof KDCommonPromptDialog) {
            KDCommonPromptDialog dlg = (KDCommonPromptDialog)selector;
            dlg.setEntityViewInfo(new EntityViewInfo());
            dlg.setMainOrgContext(this.getMainOrgContext());
            dlg.setEnabledMultiSelection(false);
            dlg.setReturnValueType(0);
            dlg.setUseCacheObject(false);
        }
    }

    private String getPriorityQuery() {
        return "com.kingdee.eas.mm.sfc.app.PACSelectModelQuery";
    }

    protected OrgUnitCollection getMainBizOrgs() {
        OrgUnitCollection orgs = new OrgUnitCollection();
        orgs.add(this.getMainOrgInfo());
        return orgs;
    }

    @Override
    protected void initDataStatus() {
        super.initDataStatus();
        if (STATUS_VIEW.equals(this.getOprtState())) {
            this.actionSave.setEnabled(false);
            this.actionEdit.setEnabled(true);
            this.actionGetDispatchTime.setEnabled(false);
            this.actionProcessSchedule.setEnabled(false);
            this.actionCheckOperation.setEnabled(true);
            this.actionTaskDispatch.setEnabled(true);
            this.actionReleased.setEnabled(true);
            this.actionUnReleased.setEnabled(true);
            this.actionUpdateOperTime.setEnabled(false);
            this.actionUpdateOrderDate.setEnabled(false);
            this.uiHelper.setColumnEditable(this.kdtMain, false);
        } else if (STATUS_EDIT.equals(this.getOprtState())) {
            this.actionSave.setEnabled(true);
            this.actionEdit.setEnabled(false);
            this.actionGetDispatchTime.setEnabled(true);
            this.actionProcessSchedule.setEnabled(true);
            this.actionCheckOperation.setEnabled(false);
            this.actionTaskDispatch.setEnabled(false);
            this.actionReleased.setEnabled(false);
            this.actionUnReleased.setEnabled(false);
            this.actionUpdateOperTime.setEnabled(true);
            this.actionUpdateOrderDate.setEnabled(true);
            this.uiHelper.setColumnEditable(this.kdtMain, true);
        }
    }

    public void checkModified() throws Exception {
        int result;
        if (this.isModify() && (result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.mm.sfc.SFCAutoGenerateResource", (String)"15_PACBuildUI"))) != 0) {
            SysUtil.abort();
        }
    }

    private boolean isModify() throws BOSException {
        return !STATUS_VIEW.equals(this.getOprtState());
    }

    protected void initWorkButton() {
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnReleased.setIcon(EASResource.getIcon((String)"imgTbtn_makeknown"));
        this.btnUnReleased.setIcon(EASResource.getIcon((String)"imgTbtn_fmakeknown"));
    }

    @Override
    protected String getTableRowKey(KDTable table) {
        return "technics.id";
    }

    @Override
    public void actionFind_actionPerformed(ActionEvent e) throws Exception {
        this.checkModified();
        super.actionFind_actionPerformed(e);
        this.setOprtState(STATUS_VIEW);
        this.initDataStatus();
    }

    @Override
    protected void executeQuery(EntityViewInfo ev) throws Exception {
        super.executeQuery(ev);
        this.currEntityViewInfo = ev;
    }

    @Override
    public void afterAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, int countSuccess) {
        if (bizAction.equals((Object)BatchActionEnum.SAVE)) {
            this.setOprtState(STATUS_VIEW);
            this.initDataStatus();
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.setOprtState(STATUS_EDIT);
        this.initDataStatus();
        this.uiHelper.doRequestData(this.getQueryTable(), this.currEntityViewInfo);
    }

    private String selectModelWindow() throws UIException {
        String uiName = "com.kingdee.eas.mm.sfc.client.PACSelectModelOfScheduleUI";
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"HAndEReportUI", (Object)this);
        UIHelper.openUIWindow((UIContext)uiCtx, (String)uiName);
        String number = (String)this.getUIContext().get("number");
        return number;
    }

    @Override
    public void actionCheckOperation_actionPerformed(ActionEvent e) throws Exception {
        MMTableSelectionHelper mmTableSelectionHelper = this.getTableSelectionHelper(this.kdtMain);
        if (this.kdtMain.getRowCount() < 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.sfc.PACResource", (String)"SELECTED_NOTHING"));
            return;
        }
        String orgId = (String)this.kdtMain.getCell(0, "storageOrgUnit.id").getValue();
        HashMap paramMap = ParamManager.getParamHashMap(null, (String[])new String[]{"GetDispatchTimeType"}, (String)orgId);
        String getDispatchTimeType = (String)paramMap.get("GetDispatchTimeType");
        if (getDispatchTimeType.equals("0")) {
            getDispatchTimeType = "10";
        } else if (getDispatchTimeType.equals("1")) {
            getDispatchTimeType = "20";
        }
        ArrayList<Object> technicsList = new ArrayList<Object>();
        int n = this.kdtMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            technicsList.add(this.kdtMain.getCell(i, "technics.id").getValue());
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("technicsList", technicsList);
        param.put("orgId", orgId);
        param.put("getDispatchTimeType", getDispatchTimeType);
        IPACBuildFacade remoteFacade = PACBuildFacadeFactory.getRemoteInstance();
        List resultList = remoteFacade.checkOperation(param);
        Iterator it = resultList.iterator();
        IRow row = null;
        while (it.hasNext()) {
            String technicsId = (String)it.next();
            int rows = mmTableSelectionHelper.getRowIndex(technicsId);
            if (rows < 0) continue;
            row = this.kdtMain.getRow(rows);
            row.getStyleAttributes().setBackground(Color.YELLOW);
        }
    }

    @Override
    public void actionTaskDispatch_actionPerformed(ActionEvent e) throws Exception {
        MMTableSelectionHelper mmTableSelectionHelper = this.getTableSelectionHelper(this.kdtMain);
        Map map = mmTableSelectionHelper.getSelectedDataMap(new String[]{"workOrgUnit.id", "workDept.number", "workcenter.id", "baseStatus", "workOrgUnit.number", "workOrgUnit.name"});
        HashSet technicsIds = new HashSet();
        HashSet<String> workOrgUnits = new HashSet<String>();
        HashSet<String> workDepts = new HashSet<String>();
        HashSet<String> workcenters = new HashSet<String>();
        String workOrgUnit_id = null;
        String workDept_number = null;
        String workcenter_id = null;
        StorageOrgUnitInfo workOrgUnit = null;
        for (Map.Entry entry : map.entrySet()) {
            Object[] param = (Object[])entry.getValue();
            workOrgUnit_id = (String)param[0];
            workDept_number = (String)param[1];
            workcenter_id = (String)param[2];
            BizEnumValueDTO enumValue = (BizEnumValueDTO)param[3];
            workOrgUnit = (StorageOrgUnitInfo)param[5];
            if (5 != Integer.parseInt((String)enumValue.getValue()) && 4 != Integer.parseInt((String)enumValue.getValue())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.mm.sfc.SFCAutoGenerateResource", (String)"16_PACBuildUI"));
                SysUtil.abort();
            }
            workOrgUnits.add(workOrgUnit_id);
            workDepts.add(workDept_number);
            workcenters.add(workcenter_id);
            technicsIds.add(entry.getKey());
        }
        if (workOrgUnits.size() > 1 || workDepts.size() > 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.mm.sfc.SFCAutoGenerateResource", (String)"17_PACBuildUI"));
            SysUtil.abort();
        }
        OrgUnitInfo workOrg = new OrgUnitInfo();
        workOrg.setId(BOSUuid.read((String)workOrgUnit_id));
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ISPACBuild", (Object)Boolean.TRUE);
        uiContext.put((Object)"WorkOrgID", (Object)workOrgUnit_id);
        uiContext.put((Object)"WorkOrgUnit", (Object)workOrgUnit);
        uiContext.put((Object)"WorkOrg", (Object)workOrg);
        uiContext.put((Object)"WorkDeptNumber", (Object)workDept_number);
        uiContext.put((Object)"Workcenters", workcenters);
        uiContext.put((Object)"TechnicsIds", technicsIds);
        IUIWindow win = null;
        win = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.mm.sfc.client.PACDispatchUI", (Map)uiContext, null, OprtState.VIEW);
        win.show();
    }

    private void initEditElement() {
        this.uiHelper.getTableEditHandler(this.kdtMain).setPromptBoxCellEditor("workcenter.name", "com.kingdee.eas.mm.basedata.app.F7WorkcenterQuery", false, "$name$");
        this.uiHelper.getTableEditHandler(this.kdtMain).setPromptBoxCellEditor("workOrgUnit.name", "com.kingdee.eas.scm.im.inv.app.F7StorageOrgUnitQuery", false, "$name$");
        this.uiHelper.getTableEditHandler(this.kdtMain).setPromptBoxCellEditor("workDept.name", "com.kingdee.eas.sem.mp.app.AdminOrgUnitF7", false, "$name$");
        this.uiHelper.getTableEditHandler(this.kdtMain).setComboBoxCellEditor("technics.entrustType", "com.kingdee.eas.mm.basedata.CSEntrustTypeEnum");
        this.addExEditElement();
    }

    private void addExEditElement() {
        if (this.exEditFieldMap != null && this.exEditFieldMap.size() > 0) {
            for (Map.Entry entry : this.exEditFieldMap.entrySet()) {
                PACParamInfo paramInfo = (PACParamInfo)entry.getValue();
                if (paramInfo.getDataType().equals((Object)DataType.ENUM)) {
                    this.uiHelper.getTableEditHandler(this.kdtMain).setComboBoxCellEditor((String)entry.getKey(), paramInfo.getClassName());
                    continue;
                }
                if (!paramInfo.getDataType().equals((Object)DataType.OBJECTVALUE)) continue;
                this.uiHelper.getTableEditHandler(this.kdtMain).setPromptBoxCellEditor((String)entry.getKey(), paramInfo.getQueryName(), false, "$name$");
            }
        }
    }

    protected void initTecWorkCenterF7(KDTActiveCellEvent e) {
        KDBizPromptBox bizWorkCenter = (KDBizPromptBox)((KDTDefaultCellEditor)this.kdtMain.getColumn("workcenter.name").getEditor()).getComponent();
        int rowIndex = this.kdtMain.getSelectManager().getActiveRowIndex();
        String orgId = null;
        if (this.kdtMain.getCell(rowIndex, "workOrgUnit.name").getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.sfc.SFCAutoGenerateResource", (String)"18_PACBuildUI"));
            return;
        }
        orgId = ((StorageOrgUnitInfo)this.kdtMain.getCell(rowIndex, "workOrgUnit.name").getValue()).getId().toString();
        SelectorItemCollection collection = new SelectorItemCollection();
        collection.add(new SelectorItemInfo("id"));
        collection.add(new SelectorItemInfo("name"));
        collection.add(new SelectorItemInfo("number"));
        collection.add(new SelectorItemInfo("adminOrgUnit.id"));
        collection.add(new SelectorItemInfo("adminOrgUnit.name"));
        collection.add(new SelectorItemInfo("adminOrgUnit.number"));
        bizWorkCenter.getQueryAgent().setSelectorCollection(collection);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (orgId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgId));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(20)));
        view.setFilter(filterInfo);
        bizWorkCenter.setEntityViewInfo(view);
        bizWorkCenter.getQueryAgent().resetRuntimeEntityView();
    }

    protected void initTecWorkDeptF7(KDTActiveCellEvent e) {
        KDBizPromptBox bizWorkDept = (KDBizPromptBox)((KDTDefaultCellEditor)this.kdtMain.getColumn("workDept.name").getEditor()).getComponent();
        int rowIndex = this.kdtMain.getSelectManager().getActiveRowIndex();
        String orgId = null;
        if (this.kdtMain.getCell(rowIndex, "workOrgUnit.name").getValue() != null) {
            orgId = ((StorageOrgUnitInfo)this.kdtMain.getCell(rowIndex, "workOrgUnit.name").getValue()).getId().toString();
        }
        EntityViewInfo view = new EntityViewInfo();
        StringBuffer sql = new StringBuffer();
        sql.append(" Select orgRelation.FTOUnitID ");
        sql.append(" From T_ORG_UnitRelation orgRelation ");
        sql.append(" INNER JOIN T_ORG_TypeRelation typeRelation ON orgRelation.FTypeRelationID = typeRelation.FID ");
        sql.append(" WHERE orgRelation.FFromUnitID = '").append(orgId).append("'");
        sql.append(" \tAND typeRelation.FFromType = 4");
        sql.append(" \tAND typeRelation.FToType = 0");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        view.setFilter(filterInfo);
        bizWorkDept.setEntityViewInfo(view);
        bizWorkDept.getQueryAgent().resetRuntimeEntityView();
    }

    protected void initTecWorkOrgUnitF7(KDTActiveCellEvent e) {
        int rowIndex = this.kdtMain.getSelectManager().getActiveRowIndex();
        Object entrustType = this.kdtMain.getCell(rowIndex, "technics.entrustType").getValue();
        if (entrustType == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.sfc.SFCAutoGenerateResource", (String)"19_PACBuildUI"));
            this.kdtMain.getEditManager().editCellAt(rowIndex, this.kdtMain.getColumnIndex("technics.entrustType"));
        } else if (CSEntrustTypeEnum.NONE.getAlias().equals(entrustType.toString())) {
            this.kdtMain.getCell(rowIndex, "workOrgUnit.name").getStyleAttributes().setLocked(true);
        } else if (CSEntrustTypeEnum.OPERATIONENTRUST.equals(entrustType)) {
            this.kdtMain.getCell(rowIndex, "workOrgUnit.name").getStyleAttributes().setLocked(true);
        } else {
            this.kdtMain.getCell(rowIndex, "workOrgUnit.name").getStyleAttributes().setLocked(false);
        }
        KDBizPromptBox bizWorkOrgUnit = (KDBizPromptBox)((KDTDefaultCellEditor)this.kdtMain.getColumn("workOrgUnit.name").getEditor()).getComponent();
        String orgId = null;
        if (this.kdtMain.getCell(rowIndex, "storageOrgUnit.id").getValue() != null) {
            orgId = (String)this.kdtMain.getCell(rowIndex, "storageOrgUnit.id").getValue();
        }
        EntityViewInfo view = new EntityViewInfo();
        StringBuffer sql = new StringBuffer();
        sql.append("select orgRe.FFromUnitID from T_ORG_UnitRelation orgRe ");
        sql.append("where orgRe.FTOUnitID in ( select orgRe.FTOUnitID ");
        sql.append(" from T_ORG_UnitRelation orgRe where orgRe.FFromUnitID='").append(orgId).append("'");
        sql.append(" and orgRe.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5')");
        sql.append(" and orgRe.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        view.setFilter(filterInfo);
        bizWorkOrgUnit.setEntityViewInfo(view);
        bizWorkOrgUnit.getQueryAgent().resetRuntimeEntityView();
    }

    protected void initTecEntrustType(KDTActiveCellEvent e) {
    }

    protected void changeTecWorkOrgUnitF7(KDTEditEvent e) {
        StorageOrgUnitInfo newValueInfo;
        StorageOrgUnitInfo oldValueInfo = (StorageOrgUnitInfo)e.getOldValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldValueInfo, (Object)(newValueInfo = (StorageOrgUnitInfo)e.getValue()));
        if (!isDiffrent) {
            return;
        }
        int rowIndex = this.kdtMain.getSelectManager().getActiveRowIndex();
        this.kdtMain.getCell(rowIndex, "workOrgUnit.id").setValue(newValueInfo != null ? newValueInfo.getId().toString() : null);
        this.kdtMain.getCell(rowIndex, "workOrgUnit.number").setValue((Object)(newValueInfo != null ? newValueInfo.getNumber() : null));
        this.kdtMain.getCell(rowIndex, "workcenter.name").setValue(null);
        this.kdtMain.getCell(rowIndex, "workDept.name").setValue(null);
    }

    protected void changeTecEntrustType(KDTEditEvent e) {
        Object newValue;
        Object oldValue = e.getOldValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)(newValue = e.getValue()));
        if (!isDiffrent) {
            return;
        }
        int rowIndex = this.kdtMain.getSelectManager().getActiveRowIndex();
        if (CSEntrustTypeEnum.INNERCOOPERATE.getAlias().equals(newValue.toString())) {
            this.kdtMain.getCell(rowIndex, "workOrgUnit.name").setValue(null);
            this.kdtMain.getCell(rowIndex, "workcenter.name").setValue(null);
            this.kdtMain.getCell(rowIndex, "workDept.name").setValue(null);
        }
    }

    protected void changeTecWorkCenterF7(KDTEditEvent e) {
        Object newValue;
        Object oldValue = e.getOldValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)(newValue = e.getValue()));
        if (!isDiffrent) {
            return;
        }
        int rowIndex = this.kdtMain.getSelectManager().getActiveRowIndex();
        WorkCenterInfo info = (WorkCenterInfo)newValue;
        this.kdtMain.getCell(rowIndex, "workDept.name").setValue((Object)info.getAdminOrgUnit());
    }

    protected void initListener() {
        this.entryChangeKDTEditAdapter = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    PACBuildUI.this.kdtEntries_Changed(e);
                }
                catch (Exception exc) {
                    PACBuildUI.this.handUIException(exc);
                }
            }
        };
        if (this.entryActiveCellListener == null) {
            this.entryActiveCellListener = new KDTActiveCellListener(){

                public void activeCellChanged(KDTActiveCellEvent e) {
                    try {
                        PACBuildUI.this.kdtEntries_cellActived(e);
                    }
                    catch (Exception exc) {
                        PACBuildUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.kdtMain.addKDTEditListener((KDTEditListener)this.entryChangeKDTEditAdapter);
        this.kdtMain.addKDTActiveCellListener(this.entryActiveCellListener);
    }

    private void kdtEntries_EditStopping(KDTEditEvent e) {
        String text;
        int colIndex = e.getColIndex();
        String fieldName = this.kdtMain.getColumnKey(colIndex);
        if ("technics.remark".equals(fieldName) && (text = (String)e.getValue()) != null && text.length() > 255) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.mm.sfc.SFCAutoGenerateResource", (String)"20_PACBuildUI"));
            this.kdtMain.getEditManager().editCellAt(e.getRowIndex(), e.getColIndex());
            e.setCancel(true);
            SysUtil.abort();
        }
    }

    protected void kdtEntries_cellActived(KDTActiveCellEvent e) {
        int colIndex = e.getColumnIndex();
        String fieldName = this.kdtMain.getColumnKey(colIndex);
        if ("workcenter.name".equals(fieldName)) {
            this.initTecWorkCenterF7(e);
        }
        if ("workOrgUnit.name".equals(fieldName)) {
            this.initTecWorkOrgUnitF7(e);
        }
        if ("workDept.name".equals(fieldName)) {
            this.initTecWorkDeptF7(e);
        }
        if ("technics.entrustType".equals(fieldName)) {
            this.initTecEntrustType(e);
        }
    }

    protected void kdtEntries_Changed(KDTEditEvent e) {
        int colIndex = e.getColIndex();
        String fieldName = this.kdtMain.getColumnKey(colIndex);
        if ("workOrgUnit.name".equals(fieldName)) {
            this.changeTecWorkOrgUnitF7(e);
        }
        if ("technics.entrustType".equals(fieldName)) {
            this.changeTecEntrustType(e);
        }
        if ("workcenter.name".equals(fieldName)) {
            this.changeTecWorkCenterF7(e);
        }
    }

    @Override
    public boolean beforeAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, ActionEvent event) {
        for (int i = 0; i < this.kdtMain.getRowCount(); ++i) {
            if (this.kdtMain.getCell(i, "technics.remark").getValue() != null && ((String)this.kdtMain.getCell(i, "technics.remark").getValue()).length() > 255) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.mm.sfc.PACResource", (String)"RemarkTooLong"));
                this.kdtMain.getEditManager().editCellAt(i, this.kdtMain.getCell(i, "technics.remark").getColumnIndex());
                return false;
            }
            if (this.kdtMain.getCell(i, "technics.operationRemark").getValue() == null || ((String)this.kdtMain.getCell(i, "technics.operationRemark").getValue()).length() <= 255) continue;
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.mm.sfc.PACResource", (String)"OpRemarkTooLong"));
            this.kdtMain.getEditManager().editCellAt(i, this.kdtMain.getCell(i, "technics.operationRemark").getColumnIndex());
            return false;
        }
        return true;
    }

    @Override
    public void executeShortcutQuery(FilterInfo filter) {
        super.executeShortcutQuery(filter);
        this.currEntityViewInfo.setFilter(filter);
        this.setOprtState(STATUS_VIEW);
        this.initDataStatus();
    }

    @Override
    public void actionUpdateOperTime_actionPerformed(ActionEvent e) throws Exception {
        block4: {
            Timestamp[] times;
            String getDispatchTimeType;
            int[] selectRows;
            block5: {
                MMTableSelectionHelper mmTableSelectionHelper = this.getTableSelectionHelper(this.kdtMain);
                selectRows = mmTableSelectionHelper.getSelectedRows();
                String orgId = (String)this.kdtMain.getCell(0, "storageOrgUnit.id").getValue();
                HashMap paramMap = ParamManager.getParamHashMap(null, (String[])new String[]{"GetDispatchTimeType"}, (String)orgId);
                getDispatchTimeType = (String)paramMap.get("GetDispatchTimeType");
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"PBuildUI", (Object)this);
                uiContext.put((Object)"UIType", (Object)getDispatchTimeType);
                UIHelper.openUIWindow((UIContext)uiContext, (String)PACUpdateDateUI.class.getName());
                times = (Timestamp[])this.getUIContext().get("TIMES");
                if (times == null || times.length != 2) break block4;
                if (!"0".equals(getDispatchTimeType)) break block5;
                for (int i = 0; i < selectRows.length; ++i) {
                    if (selectRows[i] == -1) continue;
                    if (times[0] != null) {
                        this.kdtMain.getCell(selectRows[i], "technics.earlistWoktime").setValue((Object)times[0]);
                    }
                    if (times[1] == null) continue;
                    this.kdtMain.getCell(selectRows[i], "technics.earlistCmpTime").setValue((Object)times[1]);
                }
                break block4;
            }
            if (!"1".equals(getDispatchTimeType)) break block4;
            for (int i = 0; i < selectRows.length; ++i) {
                if (selectRows[i] == -1) continue;
                if (times[0] != null) {
                    this.kdtMain.getCell(selectRows[i], "technics.lastWorktime").setValue((Object)times[0]);
                }
                if (times[1] == null) continue;
                this.kdtMain.getCell(selectRows[i], "technics.lastCmpTime").setValue((Object)times[1]);
            }
        }
    }

    @Override
    public void actionUpdateOrderDate_actionPerformed(ActionEvent e) throws Exception {
        MMTableSelectionHelper mmTableSelectionHelper = new MMTableSelectionHelper(this, this.kdtMain, "id");
        List idList = mmTableSelectionHelper.getSelectedKeyDataList();
        Iterator it = idList.iterator();
        HashSet<String> moIdSet = new HashSet<String>();
        while (it.hasNext()) {
            String id = (String)it.next();
            moIdSet.add(id);
        }
        if (moIdSet.size() < 1) {
            return;
        }
        String getDispatchTimeType = "2";
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"PBuildUI", (Object)this);
        uiContext.put((Object)"UIType", (Object)getDispatchTimeType);
        UIHelper.openUIWindow((UIContext)uiContext, (String)PACUpdateDateUI.class.getName());
        Timestamp[] times = (Timestamp[])this.getUIContext().get("TIMES");
        if (times != null && times.length == 2) {
            for (int i = 0; i < this.kdtMain.getRowCount(); ++i) {
                if (!moIdSet.contains((String)this.kdtMain.getCell(i, "id").getValue())) continue;
                if (times[0] != null) {
                    this.kdtMain.getCell(i, "planBeginDate").setValue((Object)times[0]);
                }
                if (times[1] == null) continue;
                this.kdtMain.getCell(i, "planEndDate").setValue((Object)times[1]);
            }
        }
    }

    @Override
    public void actionViewBurthen_actionPerformed(ActionEvent e) throws Exception {
        MMTableSelectionHelper mmTableSelectionHelper = this.getTableSelectionHelper(this.kdtMain);
        if (this.kdtMain.getRowCount() < 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.sfc.PACResource", (String)"SELECTED_NOTHING"));
            return;
        }
        String orgId = (String)this.kdtMain.getCell(0, "storageOrgUnit.id").getValue();
        String getDispatchTimeType = ParamManager.getParamValue(null, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)orgId)), (String)"GetDispatchTimeType");
        int[] rows = mmTableSelectionHelper.getSelectedRows();
        int length = 0;
        IRow row = null;
        length = rows.length;
        ArrayList<PACViewBurthenInfo> list = new ArrayList<PACViewBurthenInfo>(length);
        length = rows.length;
        ArrayList<Timestamp> startTimeList = new ArrayList<Timestamp>(length);
        length = rows.length;
        ArrayList<Timestamp> endTimeList = new ArrayList<Timestamp>(length);
        length = rows.length;
        ArrayList<String> orgIds = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            row = this.kdtMain.getRow(rows[i]);
            PACViewBurthenInfo info = new PACViewBurthenInfo();
            info.setNumber((String)row.getCell("number").getValue());
            info.setTechnicsId((String)row.getCell("technics.id").getValue());
            info.setWorkCenter((WorkCenterInfo)row.getCell("workcenter.name").getValue());
            info.setMaterialNumber((String)row.getCell("material.number").getValue());
            info.setMaterialName((String)row.getCell("material.name").getValue());
            info.setMaterialModel((String)row.getCell("material.model").getValue());
            info.setOperationNo((Integer)row.getCell("technics.operationNo").getValue());
            info.setOperationName((String)row.getCell("operation.name").getValue());
            info.setQueuingTime((BigDecimal)row.getCell("technics.queuingTime").getValue());
            info.setWorkTime((BigDecimal)row.getCell("technics.workTime").getValue());
            info.setPrepareTime((BigDecimal)row.getCell("technics.prepareTime").getValue());
            info.setWaitingTime((BigDecimal)row.getCell("technics.waitingTime").getValue());
            info.setMovingTime((BigDecimal)row.getCell("technics.movingTime").getValue());
            info.setTimeUnit(Integer.parseInt((String)((BizEnumValueDTO)row.getCell("technics.timeUnit").getValue()).getValue()));
            info.setProcessBatch((BigDecimal)row.getCell("technics.processBatch").getValue());
            info.setQty((BigDecimal)row.getCell("qty").getValue());
            info.setFinishedQty((BigDecimal)row.getCell("finishedQty").getValue());
            info.setWorkOrgUnitId((String)row.getCell("workOrgUnit.id").getValue());
            info.setRemark((String)row.getCell("technics.remark").getValue());
            if (getDispatchTimeType.equals("0")) {
                info.setStartTime(PACUtil.resetTimeForBeginDate((Timestamp)row.getCell("technics.earlistWoktime").getValue()));
                info.setEndTime(PACUtil.resetTimeForBeginDate((Timestamp)row.getCell("technics.earlistCmpTime").getValue()));
                info.setStart((Timestamp)row.getCell("technics.earlistWoktime").getValue());
                info.setEnd((Timestamp)row.getCell("technics.earlistCmpTime").getValue());
            } else if (getDispatchTimeType.equals("1")) {
                info.setStartTime(PACUtil.resetTimeForBeginDate((Timestamp)row.getCell("technics.lastWorktime").getValue()));
                info.setEndTime(PACUtil.resetTimeForBeginDate((Timestamp)row.getCell("technics.lastCmpTime").getValue()));
                info.setStart((Timestamp)row.getCell("technics.lastWorktime").getValue());
                info.setEnd((Timestamp)row.getCell("technics.lastCmpTime").getValue());
            }
            list.add(info);
            startTimeList.add(info.getStartTime());
            endTimeList.add(info.getEndTime());
            orgIds.add(info.getWorkOrgUnitId());
        }
        Collections.sort(startTimeList, (Comparator)new Comparator(){

            public int compare(Object o1, Object o2) {
                Timestamp one = (Timestamp)o1;
                Timestamp other = (Timestamp)o2;
                return one.compareTo(other);
            }
        });
        Collections.sort(endTimeList, (Comparator)new Comparator(){

            public int compare(Object o1, Object o2) {
                Timestamp one = (Timestamp)o1;
                Timestamp other = (Timestamp)o2;
                return one.compareTo(other);
            }
        });
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"PBuildUI", (Object)this);
        uiContext.put((Object)"startTime", (Object)new Timestamp(((Timestamp)startTimeList.get(0)).getTime()));
        uiContext.put((Object)"endTime", (Object)new Timestamp(((Timestamp)endTimeList.get(endTimeList.size() - 1)).getTime()));
        uiContext.put((Object)"pramList", list);
        uiContext.put((Object)"storageOrgUnitId", (Object)orgId);
        uiContext.put((Object)"orgIds", (Object)SQLUtil.arrayToString((Object[])orgIds.toArray()));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(PACViewBurthenUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    public void setExEditFieldMap(Map exEditFieldMap) {
        this.exEditFieldMap = exEditFieldMap;
    }

    public Map getExEditFieldMap() {
        return this.exEditFieldMap;
    }
}

