/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.core.util.PrecisionUtil;
import com.kingdee.eas.base.param.ParamSimpleInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.mm.basedata.ClassGroupInfo;
import com.kingdee.eas.mm.basedata.ClassTeamEntryInfo;
import com.kingdee.eas.mm.basedata.ClassTeamInfo;
import com.kingdee.eas.mm.basedata.FactoryCalendarFactory;
import com.kingdee.eas.mm.basedata.OprTimeUnitEnum;
import com.kingdee.eas.mm.basedata.WorkCenterCollection;
import com.kingdee.eas.mm.basedata.WorkCenterFactory;
import com.kingdee.eas.mm.basedata.WorkCenterInfo;
import com.kingdee.eas.mm.common.client.KDTableUtils;
import com.kingdee.eas.mm.sfc.IPACBuildFacade;
import com.kingdee.eas.mm.sfc.PACBuildFacadeFactory;
import com.kingdee.eas.mm.sfc.PACDispatchException;
import com.kingdee.eas.mm.sfc.PACSelectRuleOfPriorityInfo;
import com.kingdee.eas.mm.sfc.client.AbstractPACDispatchUI;
import com.kingdee.eas.mm.sfc.client.PACFilterUI;
import com.kingdee.eas.mm.sfc.util.pac.PACKDTSortManager;
import com.kingdee.eas.mm.sfc.util.pac.PACSelectUICreator;
import com.kingdee.eas.mm.sfc.util.pac.TaskAssignData;
import com.kingdee.eas.mm.sfc.util.pac.TaskAssignParam;
import com.kingdee.eas.mm.sfc.util.pac.TaskAssignResult;
import com.kingdee.eas.mm.sfc.util.pac.WorkCenterTreeBuilder;
import com.kingdee.eas.mm.sfc.util.pac.WorkCenterTreeNode;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.apache.log4j.Logger;

public class PACDispatchUI
extends AbstractPACDispatchUI {
    private static final Logger logger = CoreUIObject.getLogger(PACDispatchUI.class);
    private WorkCenterTreeBuilder treeBuilder;
    private boolean isViewEqm = false;
    private Map workCenter_dispatched_Burthen = new HashMap();
    private Map workCenter_assigned_Burthen = new HashMap();
    private Map eqm_dispatched_Burthen = new HashMap();
    private Map eqm_assigned_Burthen = new HashMap();
    private Map workCenter_Equipments = new HashMap();
    private WorkCenterTreeNode selectTreeNode = null;
    private Timestamp nextWorkDate;
    private boolean isPACBuild = false;
    private KDPromptSelector prioritySelector = null;

    @Override
    public void onLoad() throws Exception {
        if (this.getUIContext().get("ISPACBuild") != null) {
            this.isPACBuild = (Boolean)this.getUIContext().get("ISPACBuild");
        }
        this.kdtEqm.checkParsed(true);
        this.kdtAssignResult.checkParsed(true);
        this.kdtBurthen.checkParsed(true);
        this.initUICtrl(this.kdtMain);
        this.initUICtrl(this.kdtEqm);
        this.initUICtrl(this.kdtAssignResult);
        this.initUICtrl(this.kdtBurthen);
        this.filterUI = new PACFilterUI(false, 3);
        this.shortcutPanel = new PACFilterUI(true, 3);
        this.queryInfo = "com.kingdee.eas.mm.sfc.app.MOTechnicsForPACDispatchQuery";
        this.initTree();
        super.onLoad();
        if (this.isPACBuild) {
            String workOrgID = (String)this.getUIContext().get("WorkOrgID");
            StorageOrgUnitInfo workOrgUnit = (StorageOrgUnitInfo)this.getUIContext().get("WorkOrgUnit");
            OrgUnitInfo workOrg = (OrgUnitInfo)this.getUIContext().get("WorkOrg");
            workOrg.setName(workOrgUnit.getName());
            String workDeptNumber = (String)this.getUIContext().get("WorkDeptNumber");
            Set technicsIds = (Set)this.getUIContext().get("TechnicsIds");
            this.initUIMainOrgContext(workOrgID);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("workOrgUnit.id", (Object)workOrgID, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("workDept.number", (Object)workDeptNumber, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("technics.id", (Object)technicsIds, CompareType.INCLUDE));
            this.shortcutPanel.getMainBizOrgF7().setData((Object)workOrg);
            this.shortcutPanel.getWorkDeptF7().setText(workDeptNumber);
            this.shortcutPanel.getWorkDeptF7().commitEdit();
            this.executeShortcutQuery(filter);
        }
        this.setTableEditors();
        this.getTableSelectionHelper(this.kdtMain).setTableProperty();
        this.getTableSelectionHelper(this.kdtEqm).setTableProperty();
        this.initTableSortManager();
        this.eqmFilterPanel.setVisible(this.isViewEqm);
        KDTableUtils.setDefaultFreezeCol((KDTable)this.kdtMain, (int)(this.kdtMain.getColumnIndex("operation.name") + 1));
        this.kdtMain.getViewManager().getFreezeCol();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.kdtAssignResult.getColumn("startDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateTimeFormatString());
        this.kdtAssignResult.getColumn("endDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateTimeFormatString());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnGenTaskDispatch.setVisible(false);
        this.btnDispatchEdit.setVisible(false);
        this.btnDispatchList.setVisible(false);
        this.btnWorkCenterDispatchList.setVisible(true);
        this.btnEquipmentDispatchList.setVisible(true);
    }

    private Timestamp getNexWorkDate() throws EASBizException, BOSException {
        if (this.nextWorkDate == null) {
            Date workDate = FactoryCalendarFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext()).findDateFromFCalendar(this.getMainOrgInfo().getId().toString(), new Date(), 1, 1, 2);
            if (workDate == null) {
                throw new PACDispatchException(PACDispatchException.NOTFOUNDFACTORYCALENDAR);
            }
            this.nextWorkDate = new Timestamp(workDate.getTime());
        }
        return this.nextWorkDate;
    }

    private void initTableSortManager() {
        PACKDTSortManager sm = new PACKDTSortManager(this.kdtMain);
        sm.setSortAuto(true);
        sm.setDefaultSorter(new String[]{"workcenter.number"});
        sm.setSelectionHelper(this.uiHelper.getTableSelectionHelper(this.kdtMain));
        this.kdtMain.setSortMange((KDTSortManager)sm);
        this.kdtMain.getColumn("priority").setSortable(true);
    }

    private void setTableEditors() {
        this.uiHelper.getTableEditHandler(this.kdtEqm).setPromptBoxCellEditor("classTeam", "com.kingdee.eas.mm.basedata.app.F7ClassTeamQuery", "storageOrgUnit.id", false);
        ObjectValueRender name_avr = new ObjectValueRender();
        name_avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtEqm.getColumn("person").setRenderer((IBasicRender)name_avr);
        this.kdtEqm.getColumn("classTeamEntry").setRenderer((IBasicRender)name_avr);
        this.kdtAssignResult.getColumn("person").setRenderer((IBasicRender)name_avr);
        this.uiHelper.setColumnEditable(this.kdtMain, true);
        this.uiHelper.setColumnEditable(this.kdtEqm, true);
        this.uiHelper.setColumnEditable(this.kdtAssignResult, true);
        ICellEditor editor = this.kdtMain.getColumn("priority").getEditor();
        if (editor == null) {
            KDFormattedTextField textField = new KDFormattedTextField();
            textField.setVisible(true);
            textField.setEditable(true);
            textField.setHorizontalAlignment(2);
            textField.setDataType(1);
            textField.setNegatived(false);
            textField.setMinimumValue((Comparable)SCMConstant.BIGDECIMAL_ZERO);
            textField.setMaximumValue((Comparable)new BigDecimal("1.0E13"));
            textField.setPrecision(1);
            this.kdtMain.getColumn("priority").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)textField));
            this.kdtMain.getColumn("priority").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)1));
        }
    }

    private void initTree() throws Exception {
        this.treeBuilder = new WorkCenterTreeBuilder(this.getBizInterface());
        this.treeBuilder.buildTree(this.treeWorkCenter);
        this.treeWorkCenter.getSelectionModel().setSelectionMode(1);
        this.treeWorkCenter.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    WorkCenterTreeNode treeNode = (WorkCenterTreeNode)((Object)e.getPath().getLastPathComponent());
                    PACDispatchUI.this.selectTreeNode = treeNode;
                    PACDispatchUI.this.kdtMain.getSelectManager().removeAll();
                    for (int i = 0; i < PACDispatchUI.this.kdtMain.getRowCount(); ++i) {
                        PACDispatchUI.this.kdtMain.getCell(i, "isSelected").setValue((Object)Boolean.FALSE);
                    }
                    if (treeNode.getUserObject() instanceof WorkCenterInfo) {
                        WorkCenterInfo info = (WorkCenterInfo)treeNode.getUserObject();
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("workcenter.name", info.getName());
                        PACDispatchUI.this.uiHelper.doFilterData(PACDispatchUI.this.kdtMain, map);
                        List params = treeNode.getTaskAssignParams();
                        PACDispatchUI.this.loadTaskAssignParamsToKDTEqm(params);
                        String key = info.getId().toString();
                        if (!PACDispatchUI.this.workCenter_Equipments.containsKey(key)) {
                            PACDispatchUI.this.workCenter_Equipments.put(key, params);
                        }
                        PACDispatchUI.this.loadWorkCenterCapability(info);
                    } else if (treeNode.getChildCount() > 0) {
                        PACDispatchUI.this.treeWorkCenter.setSelectionNode((DefaultKingdeeTreeNode)treeNode.getChildAt(0));
                    } else {
                        PACDispatchUI.this.prmtWorkCenter.setValue(null);
                        PACDispatchUI.this.pkStartDate.setValue(null);
                        PACDispatchUI.this.txtDayCapability.setValue(null);
                        PACDispatchUI.this.txtNumberOfDays.setValue(null);
                        PACDispatchUI.this.txtTotalCapability.setValue(null);
                    }
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)PACDispatchUI.this.treeWorkCenter, (Throwable)exc);
                }
            }
        });
    }

    private void loadWorkCenterCapability(WorkCenterInfo workCenter) throws EASBizException, BOSException {
        this.prmtWorkCenter.setValue((Object)workCenter);
        this.pkStartDate.setValue((Object)this.getNexWorkDate());
        this.txtDayCapability.setValue((Object)workCenter.getRatedAbility().setScale(2, 4));
        this.txtNumberOfDays.setValue((Object)workCenter.getEstimatedDays());
    }

    @Override
    protected void putHideColumn() {
        this.tHelper.putHideColumn("technics.id");
        this.tHelper.putHideColumn("storageOrgUnit.id");
        this.tHelper.putHideColumn("processStatus");
        this.tHelper.putHideColumn("pdtMeasureUnit.qtyPrecision");
        this.tHelper.putHideColumn("baseMeasureUnit.qtyPrecision");
    }

    @Override
    public void actionFind_actionPerformed(ActionEvent e) throws Exception {
        this.checkAssignResult();
        this.clearUIData();
        if (this.isPACBuild) {
            this.clearUIContxt();
        }
        super.actionFind_actionPerformed(e);
        this.refreshTree();
    }

    private void clearUIData() {
        this.kdtAssignResult.removeRows(false);
        this.kdtBurthen.removeRows(false);
        this.workCenter_dispatched_Burthen.clear();
        this.workCenter_assigned_Burthen.clear();
        this.eqm_dispatched_Burthen.clear();
        this.eqm_assigned_Burthen.clear();
    }

    private void refreshTree() throws Exception {
        Set workcenters = (Set)this.getUIContext().get("Workcenters");
        WorkCenterTreeNode treeRoot = this.treeBuilder.refreshTreeNode(this.treeWorkCenter, this.getMainOrgInfo(), this.shortcutPanel.getWorkDept(), workcenters);
        this.treeWorkCenter.setSelectionNode((DefaultKingdeeTreeNode)treeRoot);
    }

    protected void initUICtrl(KDTable table) {
        KDTableHelper.releaseEnterAndTab((JComponent)table);
        KDTableHelper.releaseEsc((JComponent)table);
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)table, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        table.getSelectManager().setSelectMode(10);
        table.getDataRequestManager().setDataRequestMode(0);
        table.getStyleAttributes().setLocked(true);
    }

    @Override
    protected void initUIHelper() throws BOSException {
        super.initUIHelper();
        try {
            this.uiHelper.registerShortcutQueryHandler(this.kdtMain, this, this.queryPanel, (CustomerQueryPanel)this.shortcutPanel, 175, 4);
            this.uiHelper.registerDataFilterHandler(this.kdtMain);
            this.uiHelper.registerTableEditHandler(this.kdtMain, this.getEditableFields(this.kdtMain));
            this.uiHelper.registerTableSelectionHelpers(this.kdtEqm, this.getTableRowKey(this.kdtEqm));
            this.uiHelper.registerTableEditHandler(this.kdtEqm, this.getEditableFields(this.kdtEqm));
            this.uiHelper.registerDataFilterHandler(this.kdtAssignResult, this.filterPanel, new String[]{"workCenter", "equipment"});
            this.uiHelper.registerDataFilterHandler(this.kdtEqm, this.eqmFilterPanel, new String[]{"equipment.name"});
            this.uiHelper.registerTableEditHandler(this.kdtAssignResult, this.getEditableFields(this.kdtAssignResult));
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    private String[] getEditableFields(KDTable table) {
        if (table.equals(this.kdtMain)) {
            return new String[]{"priority", "currAassignQty"};
        }
        if (table.equals(this.kdtEqm)) {
            return new String[]{"classGroup", "classTeam", "classTeamEntry", "person"};
        }
        if (table.equals(this.kdtAssignResult)) {
            return new String[]{"assignQty", "startDate", "endDate"};
        }
        return null;
    }

    @Override
    public void initBatchActions() throws BOSException {
        super.initBatchActions();
    }

    @Override
    public boolean isSupportedBatchActions() {
        return false;
    }

    @Override
    protected KDTable getQueryTable() {
        return this.kdtMain;
    }

    private void clearUIContxt() {
        this.getUIContext().remove("ISPACBuild");
        this.getUIContext().remove("WorkOrgID");
        this.getUIContext().remove("WorkOrgNumber");
        this.getUIContext().remove("WorkDeptNumber");
        this.getUIContext().remove("TechnicsIds");
        this.getUIContext().remove("Workcenters");
        this.isPACBuild = false;
    }

    protected void initListener() {
        super.initListener();
        this.ckbEqmVisible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PACDispatchUI.this.ckbEqmVisible.isSelected()) {
                    PACDispatchUI.this.isViewEqm = true;
                } else {
                    PACDispatchUI.this.isViewEqm = false;
                }
                try {
                    if (PACDispatchUI.this.selectTreeNode != null && PACDispatchUI.this.selectTreeNode.getUserObject() instanceof WorkCenterInfo) {
                        List params = PACDispatchUI.this.selectTreeNode.getTaskAssignParams();
                        PACDispatchUI.this.loadTaskAssignParamsToKDTEqm(params);
                    }
                }
                catch (Exception ex) {
                    PACDispatchUI.this.handUIExceptionAndAbort(ex);
                }
                PACDispatchUI.this.uiHelper.setColumnEditable(PACDispatchUI.this.kdtEqm, true);
                PACDispatchUI.this.eqmFilterPanel.setVisible(PACDispatchUI.this.isViewEqm);
            }
        });
        this.kdtMain.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                PACDispatchUI.this.kdtMain_ActiveCellChanged(e);
            }
        });
        this.kdtMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                PACDispatchUI.this.kdtMain_EditStopped(e);
            }
        });
        this.kdtEqm.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                PACDispatchUI.this.kdtEqm_ActiveCellChanged(e);
            }
        });
        this.kdtEqm.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                PACDispatchUI.this.kdtEqm_EditStopped(e);
            }
        });
        this.kdtAssignResult.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                PACDispatchUI.this.kdtAssignResult_SelectChanged(e);
            }
        });
        this.kdtAssignResult.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                PACDispatchUI.this.kdtAssignResult_ActiveCellChanged(e);
            }
        });
        this.kdtAssignResult.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                PACDispatchUI.this.kdtAssignResult_EditStopped(e);
            }
        });
        this.kdTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PACDispatchUI.this.tabSelectedChange();
            }
        });
    }

    private void tabSelectedChange() {
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException e) {
            this.handleControlException();
            this.abort();
        }
        if (this.kdTabbedPane.getSelectedIndex() == 0) {
            this.btnGenTaskDispatch.setVisible(false);
            this.btnDispatchEdit.setVisible(false);
            this.btnDispatchList.setVisible(false);
            this.btnFind.setVisible(true);
            this.btnAssignTask.setVisible(true);
            this.btnPriority.setVisible(true);
            this.btnWorkCenterDispatchList.setVisible(true);
            this.btnEquipmentDispatchList.setVisible(true);
            if (this.selectTreeNode != null && this.selectTreeNode.getUserObject() instanceof WorkCenterInfo) {
                List params = this.selectTreeNode.getTaskAssignParams();
                this.loadTaskAssignParamsToKDTEqm(params);
            }
        } else if (this.kdTabbedPane.getSelectedIndex() == 1) {
            this.btnGenTaskDispatch.setVisible(true);
            this.btnDispatchEdit.setVisible(true);
            this.btnDispatchList.setVisible(true);
            this.btnDispatchList.setEnabled(true);
            this.btnPriority.setVisible(false);
            this.btnAssignTask.setVisible(false);
            this.btnWorkCenterDispatchList.setVisible(false);
            this.btnEquipmentDispatchList.setVisible(false);
            this.btnFind.setVisible(false);
        }
    }

    private void kdtAssignResult_SelectChanged(KDTSelectEvent e) {
        this.kdtBurthen.removeRows(false);
        int rowIndex = e.getSelectBlock().getBeginRow();
        IRow row = this.kdtAssignResult.getRow(rowIndex);
        if (row != null && !row.getStyleAttributes().isHided()) {
            TaskAssignResult obj = (TaskAssignResult)row.getUserObject();
            if (obj.getEquipment() != null) {
                List assignParams = (List)this.workCenter_Equipments.get(obj.getWorkCenter().getId().toString());
                TaskAssignParam param = null;
                int n = assignParams.size();
                for (int i = 0; i < n; ++i) {
                    param = (TaskAssignParam)assignParams.get(i);
                    this.loadKdtBurthenLineFields(this.kdtBurthen.addRow(), param);
                }
                this.kdtBurthen.getColumn("equipment.number").getStyleAttributes().setHided(false);
                this.kdtBurthen.getColumn("equipment.name").getStyleAttributes().setHided(false);
                this.kdtBurthen.getColumn("eqmDispatchBurthen").getStyleAttributes().setHided(false);
                this.kdtBurthen.getColumn("eqmAssignBurthen").getStyleAttributes().setHided(false);
                this.kdtBurthen.getColumn("totalBurthen").getStyleAttributes().setHided(false);
            } else {
                TaskAssignParam param = new TaskAssignParam();
                param.setWorkCenter(obj.getWorkCenter());
                this.loadKdtBurthenLineFields(this.kdtBurthen.addRow(), param);
                this.kdtBurthen.getColumn("equipment.number").getStyleAttributes().setHided(true);
                this.kdtBurthen.getColumn("equipment.name").getStyleAttributes().setHided(true);
                this.kdtBurthen.getColumn("eqmDispatchBurthen").getStyleAttributes().setHided(true);
                this.kdtBurthen.getColumn("eqmAssignBurthen").getStyleAttributes().setHided(true);
                this.kdtBurthen.getColumn("totalBurthen").getStyleAttributes().setHided(true);
            }
        }
    }

    private void loadKdtBurthenLineFields(IRow row, TaskAssignParam param) {
        row.getCell("workCenter.number").setValue((Object)param.getWorkCenter().getNumber());
        row.getCell("workCenter.name").setValue((Object)param.getWorkCenter().getName());
        BigDecimal wcDispatchBurthen = SCMConstant.BIGDECIMAL_ZERO;
        BigDecimal wcAssignBurthen = SCMConstant.BIGDECIMAL_ZERO;
        String key = param.getWorkCenter().getId().toString();
        if (this.workCenter_dispatched_Burthen.containsKey(key)) {
            wcDispatchBurthen = (BigDecimal)this.workCenter_dispatched_Burthen.get(key);
        }
        if (this.workCenter_assigned_Burthen.containsKey(key)) {
            wcAssignBurthen = (BigDecimal)this.workCenter_assigned_Burthen.get(key);
        }
        row.getCell("wcDispatchBurthen").setValue((Object)wcDispatchBurthen);
        row.getCell("wcAssignBurthen").setValue((Object)wcAssignBurthen);
        row.getCell("wcTotalBurthen").setValue((Object)wcDispatchBurthen.add(wcAssignBurthen));
        if (param.getEquipment() != null) {
            BigDecimal eqmDispatchBurthen = SCMConstant.BIGDECIMAL_ZERO;
            BigDecimal eqmAssignBurthen = SCMConstant.BIGDECIMAL_ZERO;
            key = param.getEquipment().getId().toString();
            row.getCell("equipment.number").setValue((Object)param.getEquipment().getNumber());
            row.getCell("equipment.name").setValue((Object)param.getEquipment().getName());
            if (this.eqm_dispatched_Burthen.containsKey(key)) {
                eqmDispatchBurthen = (BigDecimal)this.eqm_dispatched_Burthen.get(key);
            }
            if (this.eqm_assigned_Burthen.containsKey(key)) {
                eqmAssignBurthen = (BigDecimal)this.eqm_assigned_Burthen.get(key);
            }
            row.getCell("eqmDispatchBurthen").setValue((Object)eqmDispatchBurthen);
            row.getCell("eqmAssignBurthen").setValue((Object)eqmAssignBurthen);
            row.getCell("totalBurthen").setValue((Object)eqmDispatchBurthen.add(eqmAssignBurthen));
        }
    }

    private void kdtMain_ActiveCellChanged(KDTActiveCellEvent e) {
        if (e.getColumnIndex() == this.kdtMain.getColumnIndex("currAassignQty")) {
            ICellEditor editor = this.kdtMain.getCell(e.getRowIndex(), e.getColumnIndex()).getEditor();
            Integer precision = (Integer)this.kdtMain.getCell(e.getRowIndex(), "pdtMeasureUnit.qtyPrecision").getValue();
            if (editor == null) {
                KDFormattedTextField textField = new KDFormattedTextField();
                textField.setVisible(true);
                textField.setEditable(true);
                textField.setHorizontalAlignment(2);
                textField.setDataType(1);
                textField.setNegatived(false);
                textField.setMinimumValue((Comparable)SCMConstant.BIGDECIMAL_ZERO);
                textField.setMaximumValue((Comparable)new BigDecimal("1.0E13"));
                textField.setPrecision(precision.intValue());
                this.kdtMain.getCell(e.getRowIndex(), e.getColumnIndex()).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)textField));
            }
        }
    }

    private void kdtAssignResult_ActiveCellChanged(KDTActiveCellEvent e) {
        if (e.getColumnIndex() == this.kdtAssignResult.getColumnIndex("assignQty")) {
            KDFormattedTextField textField;
            ICellEditor editor = this.kdtAssignResult.getCell(e.getRowIndex(), e.getColumnIndex()).getEditor();
            TaskAssignResult result = (TaskAssignResult)this.kdtAssignResult.getRow(e.getRowIndex()).getUserObject();
            if (editor == null) {
                textField = new KDFormattedTextField();
                textField.setVisible(true);
                textField.setEditable(true);
                textField.setHorizontalAlignment(2);
                textField.setDataType(1);
                textField.setNegatived(false);
                textField.setMinimumValue((Comparable)SCMConstant.BIGDECIMAL_ZERO);
                textField.setMaximumValue((Comparable)new BigDecimal("1.0E13"));
                textField.setPrecision(result.getQtyPrecision());
            } else {
                textField = (KDFormattedTextField)editor.getComponent();
                textField.setPrecision(result.getQtyPrecision());
            }
            this.kdtAssignResult.getCell(e.getRowIndex(), e.getColumnIndex()).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)textField));
        }
    }

    private void kdtAssignResult_EditStopped(KDTEditEvent e) {
        if (e.getColIndex() == this.kdtAssignResult.getColumnIndex("assignQty")) {
            BigDecimal assignQty = SCMConstant.BIGDECIMAL_ZERO;
            if (e.getValue() != null) {
                assignQty = (BigDecimal)e.getValue();
            }
            BigDecimal old_assignQty = (BigDecimal)e.getOldValue();
            TaskAssignResult result = (TaskAssignResult)this.kdtAssignResult.getRow(e.getRowIndex()).getUserObject();
            BigDecimal burthen = result.getTaskAssignBurthen().getBurthen(assignQty);
            this.kdtAssignResult.getCell(e.getRowIndex(), "burthen").setValue((Object)burthen);
            this.updateAssignedQty(result.getTechnicsInfo().getId().toString(), assignQty.subtract(old_assignQty));
            BigDecimal assignBurthen = result.getTaskAssignBurthen().getBurthen(assignQty);
            BigDecimal old_assignBurthen = result.getTaskAssignBurthen().getBurthen(old_assignQty);
            this.updateAssignedBurthen(result.getWorkCenter().getId().toString(), result.getEquipment() != null ? result.getEquipment().getId().toString() : null, assignBurthen.subtract(old_assignBurthen));
            int n = this.kdtEqm.getRowCount();
            for (int i = 0; i < n; ++i) {
                IRow row = this.kdtEqm.getRow(i);
                this.setKDTEqm_AssignedBurthen(row);
            }
        }
    }

    private void kdtMain_EditStopped(KDTEditEvent e) {
        if (e.getColIndex() == this.kdtMain.getColumnIndex("currAassignQty")) {
            BigDecimal unDispatchQty = (BigDecimal)this.kdtMain.getCell(e.getRowIndex(), "unDispatchQty").getValue();
            BigDecimal assignedQty = (BigDecimal)this.kdtMain.getCell(e.getRowIndex(), "assignedQty").getValue();
            BigDecimal currAassignQty = (BigDecimal)e.getValue();
            if (currAassignQty.compareTo(unDispatchQty.subtract(assignedQty)) > 0) {
                this.kdtMain.getCell(e.getRowIndex(), "currAassignQty").getStyleAttributes().setFontColor(Color.RED);
            } else {
                this.kdtMain.getCell(e.getRowIndex(), "currAassignQty").getStyleAttributes().setFontColor(Color.BLACK);
            }
        }
    }

    private void kdtEqm_ActiveCellChanged(KDTActiveCellEvent e) {
        if (e.getColumnIndex() == this.kdtEqm.getColumnIndex("classTeamEntry")) {
            if (this.kdtEqm.getCell(e.getRowIndex(), this.kdtEqm.getColumnIndex("classTeam")).getValue() == null) {
                if (!this.kdtEqm.getCell(e.getRowIndex(), "classTeamEntry").getStyleAttributes().isLocked()) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.mm.sfc.SFCAutoGenerateResource", (String)"21_PACDispatchUI"));
                }
                this.kdtEqm.getEditManager().editCellAt(e.getRowIndex(), this.kdtEqm.getColumnIndex("classTeam"));
                SysUtil.abort();
            } else {
                ICellEditor editor = this.kdtEqm.getCell(e.getRowIndex(), this.kdtEqm.getColumnIndex("classTeamEntry")).getEditor();
                KDBizPromptBox f7 = null;
                if (editor != null) {
                    f7 = (KDBizPromptBox)editor.getComponent();
                } else {
                    f7 = new KDBizPromptBox();
                    String displayFormat = "$number$";
                    String editFormat = "$number$";
                    String commitFormat = "$number$";
                    ExtendParser parser = new ExtendParser(f7);
                    f7.setCommitParser((IParser)parser);
                    f7.setDisplayFormat(displayFormat);
                    f7.setEditFormat(editFormat);
                    f7.setCommitFormat(commitFormat);
                }
                f7.setQueryInfo("com.kingdee.eas.mm.basedata.app.F7ClassTeamEntryQuery");
                this.addClassTeamEntryF7SelectorListener(f7, e.getRowIndex());
                this.addClassTeamEntryF7CommitListener(f7, e.getRowIndex());
                this.kdtEqm.getCell(e.getRowIndex(), this.kdtEqm.getColumnIndex("classTeamEntry")).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)f7));
            }
        } else if (e.getColumnIndex() == this.kdtEqm.getColumnIndex("person")) {
            if (this.shortcutPanel.getWorkDept() == null) {
                if (!this.kdtEqm.getCell(e.getRowIndex(), "person").getStyleAttributes().isLocked()) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.mm.sfc.SFCAutoGenerateResource", (String)"22_PACDispatchUI"));
                }
                SysUtil.abort();
            } else {
                ICellEditor editor = this.kdtEqm.getCell(e.getRowIndex(), this.kdtEqm.getColumnIndex("person")).getEditor();
                KDBizPromptBox f7 = null;
                if (editor != null) {
                    f7 = (KDBizPromptBox)editor.getComponent();
                } else {
                    f7 = new KDBizPromptBox();
                    String displayFormat = "$number$";
                    String editFormat = "$number$";
                    String commitFormat = "$number$";
                    ExtendParser parser = new ExtendParser(f7);
                    f7.setCommitParser((IParser)parser);
                    f7.setDisplayFormat(displayFormat);
                    f7.setEditFormat(editFormat);
                    f7.setCommitFormat(commitFormat);
                }
                this.addPersonF7SelectorListener(f7, e.getRowIndex());
                this.addPersonF7CommitListener(f7, e.getRowIndex());
                f7.setEnabledMultiSelection(true);
                this.kdtEqm.getCell(e.getRowIndex(), this.kdtEqm.getColumnIndex("person")).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)f7));
            }
        } else if (e.getColumnIndex() == this.kdtEqm.getColumnIndex("classGroup")) {
            ICellEditor editor = this.kdtEqm.getCell(e.getRowIndex(), this.kdtEqm.getColumnIndex("classGroup")).getEditor();
            KDBizPromptBox f7 = null;
            if (editor != null) {
                f7 = (KDBizPromptBox)editor.getComponent();
            } else {
                f7 = new KDBizPromptBox();
                String displayFormat = "$number$";
                String editFormat = "$number$";
                String commitFormat = "$number$";
                ExtendParser parser = new ExtendParser(f7);
                f7.setCommitParser((IParser)parser);
                f7.setDisplayFormat(displayFormat);
                f7.setEditFormat(editFormat);
                f7.setCommitFormat(commitFormat);
            }
            this.addClassGroupF7SelectorListener(f7, e.getRowIndex());
            this.addClassGroupF7CommitListener(f7, e.getRowIndex());
            f7.setEnabledMultiSelection(false);
            this.kdtEqm.getCell(e.getRowIndex(), this.kdtEqm.getColumnIndex("classGroup")).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)f7));
        }
    }

    private void addClassTeamEntryF7SelectorListener(final KDBizPromptBox f7, final int rowIndex) {
        f7.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                PACDispatchUI.this.setClassTeamEntryF7EntityView(f7, rowIndex);
            }
        });
    }

    private void addClassTeamEntryF7CommitListener(final KDBizPromptBox f7, final int rowIndex) {
        f7.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                PACDispatchUI.this.setClassTeamEntryF7EntityView(f7, rowIndex);
            }
        });
    }

    private void setClassTeamEntryF7EntityView(KDBizPromptBox f7, int rowIndex) {
        ClassTeamInfo classTeam = (ClassTeamInfo)this.kdtEqm.getCell(rowIndex, this.kdtEqm.getColumnIndex("classTeam")).getValue();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)classTeam.getId().toString()));
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
        f7.getQueryAgent().resetRuntimeEntityView();
    }

    private void addPersonF7SelectorListener(final KDBizPromptBox f7, final int rowIndex) {
        f7.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                PACDispatchUI.this.setPersonF7EntityView(f7, rowIndex);
            }
        });
    }

    private void addPersonF7CommitListener(final KDBizPromptBox f7, final int rowIndex) {
        f7.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                PACDispatchUI.this.setPersonF7EntityView(f7, rowIndex);
            }
        });
    }

    private void setPersonF7EntityView(KDBizPromptBox f7, int rowIndex) {
        ClassGroupInfo classGroup = (ClassGroupInfo)this.kdtEqm.getCell(rowIndex, this.kdtEqm.getColumnIndex("classGroup")).getValue();
        OrgUnitInfo workDept = this.shortcutPanel.getWorkDept();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (classGroup != null) {
            f7.setQueryInfo("com.kingdee.eas.mm.sfc.app.F7ClassGroupPersonForPACQuery");
            filter.getFilterItems().add(new FilterItemInfo("ClassGroup.id", (Object)classGroup.getId().toString()));
        } else {
            f7.setQueryInfo("com.kingdee.eas.mm.sfc.app.F7PensonForPACQuery");
            filter.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", (Object)workDept.getId().toString()));
        }
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
        f7.getQueryAgent().resetRuntimeEntityView();
    }

    private void addClassGroupF7SelectorListener(final KDBizPromptBox f7, final int rowIndex) {
        f7.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    PACDispatchUI.this.setClassGroupF7EntityView(f7, rowIndex);
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    private void addClassGroupF7CommitListener(final KDBizPromptBox f7, final int rowIndex) {
        f7.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                try {
                    PACDispatchUI.this.setClassGroupF7EntityView(f7, rowIndex);
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    private void setClassGroupF7EntityView(KDBizPromptBox f7, int rowIndex) throws BOSException {
        String workCenter = this.kdtEqm.getCell(rowIndex, this.kdtEqm.getColumnIndex("workCenter.number")).getValue().toString();
        EntityViewInfo wsView = new EntityViewInfo();
        SelectorItemCollection wsSIC = new SelectorItemCollection();
        wsSIC.add(new SelectorItemInfo("adminOrgUnit.id"));
        wsSIC.add(new SelectorItemInfo("adminOrgUnit.number"));
        wsSIC.add(new SelectorItemInfo("adminOrgUnit.name"));
        wsView.setSelector(wsSIC);
        FilterInfo wsFilter = new FilterInfo();
        wsFilter.getFilterItems().add(new FilterItemInfo("number", (Object)workCenter, CompareType.EQUALS));
        wsView.setFilter(wsFilter);
        WorkCenterCollection wcCol = WorkCenterFactory.getRemoteInstance().getWorkCenterCollection(wsView);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (wcCol != null && wcCol.size() > 0) {
            f7.setQueryInfo("com.kingdee.eas.mm.sfc.app.F7WorkshopForClassGroupQuery");
            filter.getFilterItems().add(new FilterItemInfo("workshop.id", (Object)wcCol.get(0).getAdminOrgUnit().getId().toString()));
        }
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
        f7.getQueryAgent().resetRuntimeEntityView();
    }

    private void kdtEqm_EditStopped(KDTEditEvent e) {
        if (e.getColIndex() == this.kdtEqm.getColumnIndex("classTeam")) {
            if (SCMGroupClientUtils.isDiffrent((Object)e.getOldValue(), (Object)e.getValue())) {
                this.kdtEqm.getCell(e.getRowIndex(), this.kdtEqm.getColumnIndex("classTeamEntry")).setValue(null);
                if (e.getValue() != null) {
                    // empty if block
                }
            }
        } else if (e.getColIndex() == this.kdtEqm.getColumnIndex("classGroup")) {
            if (SCMGroupClientUtils.isDiffrent((Object)e.getOldValue(), (Object)e.getValue())) {
                this.kdtEqm.getCell(e.getRowIndex(), this.kdtEqm.getColumnIndex("person")).setValue(null);
            }
        } else if (e.getColIndex() == this.kdtEqm.getColumnIndex("workCenter.number")) {
            if (SCMGroupClientUtils.isDiffrent((Object)e.getOldValue(), (Object)e.getValue())) {
                this.kdtEqm.getCell(e.getRowIndex(), this.kdtEqm.getColumnIndex("classGroup")).setValue(null);
            }
            if (e.getValue() != null) {
                WorkCenterInfo workCenter = null;
                if (e.getValue() instanceof WorkCenterInfo) {
                    workCenter = (WorkCenterInfo)e.getValue();
                } else {
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)((String)e.getValue()), CompareType.EQUALS));
                    try {
                        if (!WorkCenterFactory.getRemoteInstance().exists(filter)) {
                            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.sfc.SFCAutoGenerateResource", (String)"23_PACDispatchUI"));
                            this.kdtEqm.getEditManager().editCellAt(e.getRowIndex(), e.getColIndex());
                            e.setValue(e.getOldValue());
                            SysUtil.abort();
                        }
                    }
                    catch (EASBizException e1) {
                        this.handUIExceptionAndAbort((Exception)((Object)e1));
                    }
                    catch (BOSException e1) {
                        this.handUIExceptionAndAbort((Exception)((Object)e1));
                    }
                }
                this.dealWorkCenterChange(e.getRowIndex(), workCenter);
            }
        }
    }

    private void dealWorkCenterChange(int rowIndex, WorkCenterInfo workCenter) {
        if (workCenter == null) {
            return;
        }
        FilterInfo filter = this.getDefaultFilter(workCenter);
        try {
            List treeNodes = PACBuildFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).getWorkCenterChildren((OrgUnitInfo)workCenter.getStorageOrgUnit(), (OrgUnitInfo)workCenter.getAdminOrgUnit(), filter);
            if (treeNodes != null && treeNodes.size() > 0) {
                WorkCenterTreeNode treeNode = (WorkCenterTreeNode)((Object)treeNodes.get(0));
                List assignParams = treeNode.getTaskAssignParams();
                this.loadTaskAssignParamsToKDTEqm(this.kdtEqm.getRow(rowIndex), assignParams);
                String key = workCenter.getId().toString();
                if (!this.workCenter_Equipments.containsKey(key)) {
                    this.workCenter_Equipments.put(key, assignParams);
                }
            }
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }

    private FilterInfo getDefaultFilter(WorkCenterInfo workCenter) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)workCenter.getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", (Object)workCenter.getAdminOrgUnit().getId().toString(), CompareType.EQUALS));
        HashSet<String> set = new HashSet<String>();
        set.add(workCenter.getId().toString());
        filter.getFilterItems().add(new FilterItemInfo("workCenter.id", set, CompareType.INCLUDE));
        return filter;
    }

    private void loadTaskAssignParamsToKDTEqm(IRow row, List assignParams) {
        int index = 0;
        if (row != null) {
            index = row.getRowIndex();
            this.kdtEqm.removeRow(index);
        }
        TaskAssignParam obj = null;
        if (this.isViewEqm) {
            int n = assignParams.size();
            for (int i = 0; i < n; ++i) {
                obj = (TaskAssignParam)assignParams.get(i);
                this.cacheDispatchedBurthen(obj);
                this.setDispatchedBurthen(obj);
                this.setAssignedBurthen(obj);
                this.loadKdtEqmLineFields(this.kdtEqm.addRow(index + i), obj);
            }
        } else {
            TaskAssignParam temp = (TaskAssignParam)assignParams.get(0);
            obj = new TaskAssignParam();
            obj.setWorkCenter(temp.getWorkCenter());
            obj.setWorkCenter_dispatched_Burthen(temp.getWorkCenter_dispatched_Burthen());
            this.cacheDispatchedBurthen(obj);
            this.setDispatchedBurthen(obj);
            this.setAssignedBurthen(obj);
            this.loadKdtEqmLineFields(this.kdtEqm.addRow(index), obj);
        }
    }

    private void setAssignedBurthen(TaskAssignParam param) {
        String key = param.getWorkCenter().getId().toString();
        BigDecimal assignedBurthen = SCMConstant.BIGDECIMAL_ZERO;
        if (this.workCenter_assigned_Burthen.containsKey(key)) {
            assignedBurthen = (BigDecimal)this.workCenter_assigned_Burthen.get(key);
        }
        param.setWorkCenter_assigned_Burthen(assignedBurthen);
        if (this.isViewEqm && param.getEquipment() != null) {
            key = param.getEquipment().getId().toString();
            assignedBurthen = SCMConstant.BIGDECIMAL_ZERO;
            if (this.eqm_assigned_Burthen.containsKey(key)) {
                assignedBurthen = (BigDecimal)this.eqm_assigned_Burthen.get(key);
            }
            param.setEqm_assigned_Burthen(assignedBurthen);
        }
    }

    private void setKDTEqm_AssignedBurthen(IRow row) {
        TaskAssignParam param = (TaskAssignParam)row.getUserObject();
        if (param == null || param.getWorkCenter() == null) {
            return;
        }
        String key = param.getWorkCenter().getId().toString();
        BigDecimal assignedBurthen = SCMConstant.BIGDECIMAL_ZERO;
        if (this.workCenter_assigned_Burthen.containsKey(key)) {
            assignedBurthen = (BigDecimal)this.workCenter_assigned_Burthen.get(key);
        }
        row.getCell("wcAssignBurthen").setValue((Object)assignedBurthen);
        row.getCell("wcTotalBurthen").setValue((Object)assignedBurthen.add(param.getWorkCenter_dispatched_Burthen()));
        if (this.isViewEqm && param.getEquipment() != null) {
            key = param.getEquipment().getId().toString();
            assignedBurthen = SCMConstant.BIGDECIMAL_ZERO;
            if (this.eqm_assigned_Burthen.containsKey(key)) {
                assignedBurthen = (BigDecimal)this.eqm_assigned_Burthen.get(key);
            }
            row.getCell("assignBurthen").setValue((Object)assignedBurthen);
            row.getCell("totalBurthen").setValue((Object)assignedBurthen.add(param.getEqm_dispatched_Burthen()));
        }
    }

    private void setDispatchedBurthen(TaskAssignParam param) {
        String key = param.getWorkCenter().getId().toString();
        BigDecimal dispatchBurthen = SCMConstant.BIGDECIMAL_ZERO;
        if (this.workCenter_dispatched_Burthen.containsKey(key)) {
            dispatchBurthen = (BigDecimal)this.workCenter_dispatched_Burthen.get(key);
        }
        param.setWorkCenter_dispatched_Burthen(dispatchBurthen);
        if (this.isViewEqm && param.getEquipment() != null) {
            key = param.getEquipment().getId().toString();
            dispatchBurthen = SCMConstant.BIGDECIMAL_ZERO;
            if (this.eqm_dispatched_Burthen.containsKey(key)) {
                dispatchBurthen = (BigDecimal)this.eqm_dispatched_Burthen.get(key);
            }
            param.setEqm_dispatched_Burthen(dispatchBurthen);
        }
    }

    private void cacheDispatchedBurthen(TaskAssignParam param) {
        String key = param.getWorkCenter().getId().toString();
        if (!this.workCenter_dispatched_Burthen.containsKey(key)) {
            this.workCenter_dispatched_Burthen.put(key, param.getWorkCenter_dispatched_Burthen());
        }
        if (param.getEquipment() != null && !this.eqm_dispatched_Burthen.containsKey(key = param.getEquipment().getId().toString())) {
            this.eqm_dispatched_Burthen.put(key, param.getEqm_dispatched_Burthen());
        }
    }

    @Override
    public void actionAssignTask_actionPerformed(ActionEvent e) throws Exception {
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException ex) {
            this.handleControlException();
            this.abort();
        }
        this.verifyKdtEqm();
        this.storeAssignParams();
        Map assignDatas = this.getAssignDatas();
        List assignResults = PACBuildFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).assignTask(assignDatas, this.getAssignParams());
        this.loadTaskAssignResults(assignResults);
        BigDecimal assignedQty = null;
        for (Map.Entry entry : assignDatas.entrySet()) {
            String key = (String)entry.getKey();
            BigDecimal qty = ((TaskAssignData)entry.getValue()).getAssignQty();
            int rowIndex = this.uiHelper.getTableSelectionHelper(this.kdtMain).getRowIndex(key);
            this.kdtMain.getCell(rowIndex, "isSelected").setValue((Object)Boolean.FALSE);
            assignedQty = (BigDecimal)this.kdtMain.getCell(rowIndex, "assignedQty").getValue();
            this.kdtMain.getCell(rowIndex, "assignedQty").setValue((Object)assignedQty.add(qty));
            this.kdtMain.getCell(rowIndex, "currAassignQty").setValue((Object)new BigDecimal("0.00"));
        }
        int n = this.kdtEqm.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.kdtEqm.getRow(i);
            row.getCell("isSelected").setValue((Object)Boolean.FALSE);
            row.getCell("classGroup").setValue(null);
            row.getCell("classTeam").setValue(null);
            row.getCell("classTeamEntry").setValue(null);
            row.getCell("person").setValue(null);
            this.setKDTEqm_AssignedBurthen(row);
        }
        this.kdTabbedPane.setSelectedIndex(1);
    }

    private void verifyKdtEqm() {
        MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0}{1}{2}");
        int n = this.kdtEqm.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.kdtEqm.getRow(i);
            if (row.getCell("isSelected").getValue() == null || !((Boolean)row.getCell("isSelected").getValue()).booleanValue() || row.getCell("workCenter.number").getValue() != null) continue;
            String msg = format.format(new Object[]{EASResource.getString((String)"com.kingdee.eas.mm.sfc.SFCAutoGenerateResource", (String)"6_BatchReportBillUI"), i + 1, EASResource.getString((String)"com.kingdee.eas.mm.sfc.SFCAutoGenerateResource", (String)"24_PACDispatchUI")});
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            this.kdtEqm.getEditManager().editCellAt(i, this.kdtEqm.getColumnIndex("workCenter.number"));
            SysUtil.abort();
        }
    }

    private void loadTaskAssignResults(List assignResults) {
        TaskAssignResult obj = null;
        IRow row = null;
        int n = assignResults.size();
        for (int i = 0; i < n; ++i) {
            obj = (TaskAssignResult)assignResults.get(i);
            row = this.kdtAssignResult.addRow();
            row.getCell("workCenter").setValue((Object)obj.getWorkCenter().getName());
            row.getCell("equipment").setValue(obj.getEquipment() != null ? obj.getEquipment().getName() : null);
            row.getCell("classGroup").setValue(obj.getClassGroup() != null ? obj.getClassGroup().getName() : null);
            row.getCell("classTeam").setValue(obj.getClassTeam() != null ? obj.getClassTeam().getName() : null);
            row.getCell("classTeamEntry").setValue(obj.getClassTeam() != null ? obj.getClassTeam().getName() : null);
            row.getCell("person").setValue((Object)obj.getPersons());
            row.getCell("moNumber").setValue((Object)obj.getManufactureOrder().getNumber());
            row.getCell("material.number").setValue((Object)obj.getManufactureOrder().getMaterial().getNumber());
            row.getCell("material.name").setValue((Object)obj.getManufactureOrder().getMaterial().getName());
            row.getCell("material.model").setValue((Object)obj.getManufactureOrder().getMaterial().getModel());
            row.getCell("operationNo").setValue((Object)new Integer(obj.getTechnicsInfo().getOperationNo()));
            row.getCell("operation.name").setValue((Object)obj.getTechnicsInfo().getOperation().getName());
            row.getCell("assignQty").setValue((Object)obj.getAssignQty());
            row.getCell("burthen").setValue((Object)obj.getBurthen());
            this.updateAssignedBurthen(obj.getWorkCenter().getId().toString(), obj.getEquipment() != null ? obj.getEquipment().getId().toString() : null, obj.getBurthen());
            row.getCell("startDate").setValue((Object)obj.getWorkBeginTime());
            row.getCell("endDate").setValue((Object)obj.getWorkEndTime());
            row.setUserObject((Object)obj);
        }
        this.uiHelper.getDataFilterHandler(this.kdtAssignResult).doFilterItermRefresh();
        if (this.isViewEqm) {
            this.kdtAssignResult.getColumn("equipment").getStyleAttributes().setHided(false);
        } else {
            this.kdtAssignResult.getColumn("equipment").getStyleAttributes().setHided(true);
        }
    }

    private void loadTaskAssignParamsToKDTEqm(List assignParams) {
        this.kdtEqm.removeRows();
        this.loadTaskAssignParamsToKDTEqm(null, assignParams);
        if (this.isViewEqm) {
            this.kdtEqm.getColumn("equipment.number").getStyleAttributes().setHided(false);
            this.kdtEqm.getColumn("equipment.name").getStyleAttributes().setHided(false);
            this.kdtEqm.getColumn("dispatchBurthen").getStyleAttributes().setHided(false);
            this.kdtEqm.getColumn("assignBurthen").getStyleAttributes().setHided(false);
            this.kdtEqm.getColumn("totalBurthen").getStyleAttributes().setHided(false);
        } else {
            this.kdtEqm.getColumn("equipment.number").getStyleAttributes().setHided(true);
            this.kdtEqm.getColumn("equipment.name").getStyleAttributes().setHided(true);
            this.kdtEqm.getColumn("dispatchBurthen").getStyleAttributes().setHided(true);
            this.kdtEqm.getColumn("assignBurthen").getStyleAttributes().setHided(true);
            this.kdtEqm.getColumn("totalBurthen").getStyleAttributes().setHided(true);
        }
        this.uiHelper.getDataFilterHandler(this.kdtEqm).doFilterItermRefresh();
    }

    private void loadKdtEqmLineFields(IRow row, TaskAssignParam param) {
        row.getCell("isSelected").setValue((Object)Boolean.FALSE);
        row.getCell("workCenter.number").setValue((Object)param.getWorkCenter().getNumber());
        row.getCell("workCenter.name").setValue((Object)param.getWorkCenter().getName());
        row.getCell("classGroup").setValue(null);
        row.getCell("classTeam").setValue(null);
        row.getCell("classTeamEntry").setValue(null);
        row.getCell("person").setValue(null);
        if (this.isViewEqm && param.getEquipment() != null) {
            row.getCell("equipment.number").setValue((Object)param.getEquipment().getNumber());
            row.getCell("equipment.name").setValue((Object)param.getEquipment().getName());
            row.getCell("dispatchBurthen").setValue((Object)param.getEqm_dispatched_Burthen());
            row.getCell("assignBurthen").setValue((Object)param.getEqm_assigned_Burthen());
            row.getCell("totalBurthen").setValue((Object)param.getEqm_dispatched_Burthen().add(param.getEqm_assigned_Burthen()));
        }
        row.getCell("wcDispatchBurthen").setValue((Object)param.getWorkCenter_dispatched_Burthen());
        row.getCell("wcAssignBurthen").setValue((Object)param.getWorkCenter_assigned_Burthen());
        row.getCell("wcTotalBurthen").setValue((Object)param.getWorkCenter_dispatched_Burthen().add(param.getWorkCenter_assigned_Burthen()));
        row.setUserObject((Object)param);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(20), CompareType.EQUALS));
        view.setFilter(filter);
        this.uiHelper.getTableEditHandler(this.kdtEqm).setPromptBoxCellEditor(row.getRowIndex(), "workCenter.number", "com.kingdee.eas.mm.basedata.app.F7WorkcenterQuery", "storageOrgUnit.id", false, view);
        row.getCell("workCenter.number").getStyleAttributes().setLocked(false);
    }

    private Map getAssignDatas() {
        HashMap map = new HashMap();
        String[] dataFields = new String[]{"currAassignQty", "pdtMeasureUnit.qtyPrecision", "baseMeasureUnit.qtyPrecision"};
        Map assignDatas = this.uiHelper.getTableSelectionHelper(this.kdtMain).getSelectedDataMap(dataFields);
        for (Map.Entry entry : assignDatas.entrySet()) {
            Object[] value = (Object[])entry.getValue();
            TaskAssignData assignData = new TaskAssignData();
            assignData.setTechnicsId((String)entry.getKey());
            assignData.setAssignQty((BigDecimal)value[0]);
            assignData.setQtyPrecision((Integer)value[1]);
            assignData.setBaseQtyPrecision((Integer)value[2]);
            map.put(entry.getKey(), assignData);
        }
        return map;
    }

    private List getAssignParams() {
        return this.uiHelper.getTableSelectionHelper(this.kdtEqm).getSelectedUserObjectList();
    }

    @Override
    protected String getTableRowKey(KDTable table) {
        if (table.equals(this.kdtMain)) {
            return "technics.id";
        }
        if (table.equals(this.kdtEqm)) {
            if (this.isViewEqm) {
                return "workCenter.id";
            }
            return "equipment.id";
        }
        return "technics.id";
    }

    private void storeAssignParams() {
        TaskAssignParam param = null;
        ClassGroupInfo classGroup = null;
        ClassTeamInfo classTeam = null;
        ClassTeamEntryInfo classTeamEntry = null;
        Object[] persons = null;
        int n = this.kdtEqm.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.kdtEqm.getRow(i);
            param = (TaskAssignParam)row.getUserObject();
            if (param == null) continue;
            classGroup = (ClassGroupInfo)row.getCell("classGroup").getValue();
            classTeam = (ClassTeamInfo)row.getCell("classTeam").getValue();
            classTeamEntry = (ClassTeamEntryInfo)row.getCell("classTeamEntry").getValue();
            persons = (Object[])row.getCell("person").getValue();
            param.setClassGroup(classGroup);
            param.setClassTeam(classTeam);
            param.setClassTeamEntry(classTeamEntry);
            param.setPersons(persons);
            row.setUserObject((Object)param);
        }
    }

    protected IPACBuildFacade getBizInterface() throws Exception {
        return PACBuildFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public void actionGenTaskDispatch_actionPerformed(ActionEvent e) throws Exception {
        this.verifyAssignQty();
        this.doActionInDaemon(this.actionGenTaskDispatch.getUIObject());
    }

    private void verifyAssignQty() {
        MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0}{1}{2}");
        int n = this.kdtAssignResult.getRowCount();
        for (int i = 0; i < n; ++i) {
            BigDecimal assignQty = (BigDecimal)this.kdtAssignResult.getCell(i, "assignQty").getValue();
            if (new BigDecimal("0").compareTo(assignQty) <= -1) continue;
            String msg = format.format(new Object[]{EASResource.getString((String)"com.kingdee.eas.mm.sfc.SFCAutoGenerateResource", (String)"6_BatchReportBillUI"), i + 1, EASResource.getString((String)"com.kingdee.eas.mm.sfc.SFCAutoGenerateResource", (String)"25_PACDispatchUI")});
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            this.kdtAssignResult.getEditManager().editCellAt(i, this.kdtAssignResult.getColumnIndex("assignQty"));
            SysUtil.abort();
        }
    }

    private void doGenTaskDispatch() throws Exception {
        Map map;
        ArrayList<TaskAssignResult> assignResults = new ArrayList<TaskAssignResult>();
        int n = this.kdtAssignResult.getRowCount();
        for (int i = 0; i < n; ++i) {
            TaskAssignResult result = (TaskAssignResult)this.kdtAssignResult.getRow(i).getUserObject();
            result.setAssignQty((BigDecimal)this.kdtAssignResult.getCell(i, "assignQty").getValue());
            result.setWorkBeginTime((Timestamp)this.kdtAssignResult.getCell(i, "startDate").getValue());
            result.setWorkEndTime((Timestamp)this.kdtAssignResult.getCell(i, "endDate").getValue());
            if (result.isGenTaskDispatch()) continue;
            assignResults.add(result);
        }
        if (assignResults.size() > 0 && (map = this.getBizInterface().genTaskDispatch(assignResults)).size() > 0) {
            this.updateTaskAssignResult(map);
            this.updateBurthen();
        }
    }

    private void updateBurthen() {
        Set workCenterAssignedBurthenSet = this.workCenter_assigned_Burthen.entrySet();
        Iterator it = workCenterAssignedBurthenSet.iterator();
        String id = null;
        BigDecimal burthen = null;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            id = (String)entry.getKey();
            burthen = (BigDecimal)entry.getValue();
            this.workCenter_dispatched_Burthen.put(id, ((BigDecimal)this.workCenter_dispatched_Burthen.get(id)).add(burthen));
            this.workCenter_assigned_Burthen.put(id, SCMConstant.BIGDECIMAL_ZERO);
        }
        Set eqmAssignedBurthenSet = this.eqm_assigned_Burthen.entrySet();
        for (Map.Entry entry : eqmAssignedBurthenSet) {
            id = (String)entry.getKey();
            burthen = (BigDecimal)entry.getValue();
            this.eqm_dispatched_Burthen.put(id, ((BigDecimal)this.eqm_dispatched_Burthen.get(id)).add(burthen));
            this.eqm_assigned_Burthen.put(id, SCMConstant.BIGDECIMAL_ZERO);
        }
    }

    private void updateTaskAssignResult(Map map) {
        int n = this.kdtAssignResult.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.kdtAssignResult.getRow(i);
            TaskAssignResult result = (TaskAssignResult)row.getUserObject();
            if (!map.containsKey(result.getId())) continue;
            result.setGenTaskDispatch(true);
            result.setDisTaskdispatchID((String)map.get(result.getId()));
            row.getStyleAttributes().setBackground(new Color(225, 228, 225));
            row.getCell("assignQty").getStyleAttributes().setLocked(true);
            row.getCell("startDate").getStyleAttributes().setLocked(true);
            row.getCell("endDate").getStyleAttributes().setLocked(true);
        }
    }

    private void doActionInDaemon(final IUIObject uiObjcet) {
        MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0}-->{1}");
        String title = format.format(new Object[]{uiObjcet.getUITitle(), EASResource.getString((String)"com.kingdee.eas.mm.sfc.SFCAutoGenerateResource", (String)"26_PACDispatchUI")});
        final MonitorInfo info = new MonitorInfo(title, null, (Object)this, true);
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                try {
                    PACDispatchUI.this.doGenTaskDispatch();
                }
                catch (Exception e) {
                    this.finished();
                    PACDispatchUI.this.handUIExceptionAndAbort(e);
                }
                return uiObjcet;
            }

            public void finished() {
                ThreadPool.destroyMonitor((MonitorInfo)info);
            }
        };
        info.setWorker(worker);
        ThreadPool.addActionThread((MonitorInfo)info);
        ThreadPool.setBackgroundRunButtonEnabled((boolean)false);
    }

    @Override
    public void actionDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        int i;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdtAssignResult);
        if (selectRows.length == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.mm.sfc.SFCAutoGenerateResource", (String)"27_PACDispatchUI"));
            return;
        }
        for (i = selectRows.length - 1; i >= 0; --i) {
            row = this.kdtAssignResult.getRow(selectRows[i]);
            TaskAssignResult result = (TaskAssignResult)row.getUserObject();
            if (row.getStyleAttributes().isHided() || result.isGenTaskDispatch()) continue;
            this.updateAssignedQty(result.getTechnicsInfo().getId().toString(), result.getAssignQty().negate());
            this.updateAssignedBurthen(result.getWorkCenter().getId().toString(), result.getEquipment() != null ? result.getEquipment().getId().toString() : null, result.getBurthen().negate());
            this.kdtAssignResult.removeRow(selectRows[i]);
        }
        int n = this.kdtEqm.getRowCount();
        for (i = 0; i < n; ++i) {
            row = this.kdtEqm.getRow(i);
            this.setKDTEqm_AssignedBurthen(row);
        }
        int lastRow = this.kdtAssignResult.getSelectManager().getActiveRowIndex();
        if (lastRow < 0) {
            this.kdtBurthen.removeRows();
            return;
        }
    }

    private void updateAssignedQty(String key, BigDecimal qty) {
        int rowIndex = this.uiHelper.getTableSelectionHelper(this.kdtMain).getRowIndex(key);
        BigDecimal assignedQty = (BigDecimal)this.kdtMain.getCell(rowIndex, "assignedQty").getValue();
        this.kdtMain.getCell(rowIndex, "assignedQty").setValue((Object)assignedQty.add(qty));
    }

    private void updateAssignedBurthen(String workCenterId, String equipmentId, BigDecimal burthen) {
        BigDecimal assignedBurthen = SCMConstant.BIGDECIMAL_ZERO;
        if (workCenterId != null) {
            if (this.workCenter_assigned_Burthen.containsKey(workCenterId)) {
                assignedBurthen = (BigDecimal)this.workCenter_assigned_Burthen.get(workCenterId);
            }
            this.workCenter_assigned_Burthen.put(workCenterId, assignedBurthen.add(burthen));
        }
        if (equipmentId != null) {
            assignedBurthen = SCMConstant.BIGDECIMAL_ZERO;
            if (this.eqm_assigned_Burthen.containsKey(equipmentId)) {
                assignedBurthen = (BigDecimal)this.eqm_assigned_Burthen.get(equipmentId);
            }
            this.eqm_assigned_Burthen.put(equipmentId, assignedBurthen.add(burthen));
        }
    }

    @Override
    public void actionPriority_actionPerformed(ActionEvent e) throws Exception {
        Object[] result;
        if (this.prioritySelector == null) {
            this.prioritySelector = PACSelectUICreator.createSelector(this.getPriorityQuery());
            this.configSelector(this.prioritySelector);
        }
        this.prioritySelector.show();
        String rule = null;
        if (!this.prioritySelector.isCanceled()) {
            result = (Object[])this.prioritySelector.getData();
            if (result[0] == null || !(result[0] instanceof PACSelectRuleOfPriorityInfo)) {
                return;
            }
        } else {
            return;
        }
        PACSelectRuleOfPriorityInfo info = (PACSelectRuleOfPriorityInfo)result[0];
        rule = info.getNumber();
        if (this.kdtMain.getRowCount() < 1) {
            return;
        }
        int count = this.kdtMain.getRowCount();
        ArrayList<String> orgList = new ArrayList<String>(count);
        ArrayList<String> paramNumberList = new ArrayList<String>(1);
        for (int i = 0; i < count; ++i) {
            String orgId = (String)this.kdtMain.getCell(i, "storageOrgUnit.id").getValue();
            orgList.add(orgId);
            paramNumberList.add("GetDispatchTimeType");
        }
        ArrayList paramList = ParamManager.getParamListBatch(null, paramNumberList, orgList);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        Iterator iter = paramList.iterator();
        ParamSimpleInfo info2 = null;
        while (iter.hasNext()) {
            info2 = (ParamSimpleInfo)iter.next();
            paramMap.put(info2.getOrgUnitPK().toString(), info2.getParamValue());
        }
        paramMap.put("sortRule", rule);
        this.doActionPriority(paramMap);
        List technicsList = (List)paramMap.get("result");
        for (Map technicsMap : technicsList) {
            this.kdtMain.getCell(Integer.valueOf((String)technicsMap.get("row")).intValue(), "priority").setValue(technicsMap.get("priority"));
        }
        this.kdtMain.getSortMange().sort(this.kdtMain.getColumnIndex("priority"), 0);
    }

    private void doActionPriority(Map paramMap) {
        paramMap.put("SystemTime", new BigDecimal(System.currentTimeMillis()));
        int n = this.kdtMain.getRowCount();
        ArrayList technicsList = new ArrayList(n);
        IRow row = null;
        for (int i = 0; i < n; ++i) {
            row = this.kdtMain.getRow(i);
            if (row.getStyleAttributes().isHided()) continue;
            HashMap<String, Object> technicsMap = new HashMap<String, Object>();
            technicsMap.put("row", Integer.toString(i));
            technicsMap.put("number", this.kdtMain.getCell(i, "number").getValue());
            technicsMap.put("operationNo", this.kdtMain.getCell(i, "technics.operationNo").getValue());
            this.injectSortElement(i, technicsMap, paramMap);
            technicsList.add(technicsMap);
        }
        this.sortPriority(technicsList);
        paramMap.put("result", technicsList);
    }

    private void injectSortElement(int row, Map technicsMap, Map paramMap) {
        String sortRule = (String)paramMap.get("sortRule");
        String orgId = (String)this.kdtMain.getCell(row, "storageOrgUnit.id").getValue();
        String getDispatchTimeType = (String)paramMap.get(orgId);
        BigDecimal SystemTime = (BigDecimal)paramMap.get("SystemTime");
        Timestamp startTime = null;
        Timestamp endTime = null;
        if ("0".equals(getDispatchTimeType)) {
            technicsMap.put("startTime", this.kdtMain.getCell(row, "technics.earlistWoktime").getValue());
            technicsMap.put("endTime", this.kdtMain.getCell(row, "technics.earlistCmpTime").getValue());
        } else if ("1".equals(getDispatchTimeType)) {
            technicsMap.put("startTime", this.kdtMain.getCell(row, "technics.lastWorktime").getValue());
            technicsMap.put("endTime", this.kdtMain.getCell(row, "technics.lastCmpTime").getValue());
        }
        startTime = (Timestamp)technicsMap.get("startTime");
        endTime = (Timestamp)technicsMap.get("endTime");
        if ("SOT".equals(sortRule)) {
            technicsMap.put("sortKey", new BigDecimal(endTime.getTime() - startTime.getTime()));
        } else if ("Ddate".equals(sortRule)) {
            technicsMap.put("sortKey", new BigDecimal(endTime.getTime()));
        } else if ("CR".equals(sortRule)) {
            BizEnumValueDTO o = (BizEnumValueDTO)this.kdtMain.getCell(row, "technics.timeUnit").getValue();
            OprTimeUnitEnum unit = OprTimeUnitEnum.getEnum((int)o.getInt());
            BigDecimal prepareTime = (BigDecimal)this.kdtMain.getCell(row, "technics.prepareTime").getValue();
            BigDecimal workTime = (BigDecimal)this.kdtMain.getCell(row, "technics.workTime").getValue();
            BigDecimal remainingTime = new BigDecimal("0");
            prepareTime = this.transferTime(unit, prepareTime != null ? prepareTime : new BigDecimal("0"));
            workTime = this.transferTime(unit, workTime != null ? workTime : new BigDecimal("0"));
            BigDecimal qty = (BigDecimal)this.kdtMain.getCell(row, "technics.qty").getValue();
            BigDecimal totalDispatchQty = (BigDecimal)this.kdtMain.getCell(row, "technics.finishedQty").getValue();
            BigDecimal processBatch = (BigDecimal)this.kdtMain.getCell(row, "technics.processBatch").getValue();
            remainingTime = processBatch.compareTo(new BigDecimal("0")) == 0 ? workTime.multiply(qty.subtract(totalDispatchQty).divide(qty, 2, 4)) : workTime.multiply(qty.subtract(totalDispatchQty).divide(processBatch, 0, 0));
            if (totalDispatchQty.compareTo(new BigDecimal("0")) == 0) {
                remainingTime = remainingTime.add(prepareTime);
            }
            if (remainingTime.compareTo(new BigDecimal("0")) < 1) {
                remainingTime = new BigDecimal("0.00000001");
            }
            BigDecimal result = new BigDecimal(endTime.getTime()).subtract(SystemTime).divide(remainingTime, 2, 4);
            technicsMap.put("sortKey", result);
        } else if ("STR".equals(sortRule)) {
            BizEnumValueDTO o = (BizEnumValueDTO)this.kdtMain.getCell(row, "technics.timeUnit").getValue();
            OprTimeUnitEnum unit = OprTimeUnitEnum.getEnum((int)o.getInt());
            BigDecimal prepareTime = (BigDecimal)this.kdtMain.getCell(row, "technics.prepareTime").getValue();
            BigDecimal workTime = (BigDecimal)this.kdtMain.getCell(row, "technics.workTime").getValue();
            BigDecimal movingTime = (BigDecimal)this.kdtMain.getCell(row, "technics.movingTime").getValue();
            BigDecimal waitingTime = (BigDecimal)this.kdtMain.getCell(row, "technics.waitingTime").getValue();
            BigDecimal queuingTime = (BigDecimal)this.kdtMain.getCell(row, "technics.queuingTime").getValue();
            BigDecimal remainingTime = new BigDecimal("0");
            prepareTime = this.transferTime(unit, prepareTime != null ? prepareTime : new BigDecimal("0"));
            workTime = this.transferTime(unit, workTime != null ? workTime : new BigDecimal("0"));
            BigDecimal qty = (BigDecimal)this.kdtMain.getCell(row, "technics.qty").getValue();
            BigDecimal totalDispatchQty = (BigDecimal)this.kdtMain.getCell(row, "technics.finishedQty").getValue();
            BigDecimal processBatch = (BigDecimal)this.kdtMain.getCell(row, "technics.processBatch").getValue();
            remainingTime = processBatch.compareTo(new BigDecimal("0")) == 0 ? (totalDispatchQty.compareTo(new BigDecimal("0")) == 0 ? workTime.multiply(qty.subtract(totalDispatchQty).divide(qty, 2, 4)).add(prepareTime).add(waitingTime).add(movingTime).add(queuingTime) : workTime.multiply(qty.subtract(totalDispatchQty).divide(qty, 2, 4)).add(prepareTime).add(waitingTime).add(movingTime)) : (totalDispatchQty.compareTo(new BigDecimal("0")) == 0 ? workTime.multiply(qty.divide(processBatch, 0, 0)).add(prepareTime).add(waitingTime).add(queuingTime) : workTime.multiply(qty.divide(processBatch, 0, 0)).add(prepareTime).multiply(qty.subtract(totalDispatchQty).divide(qty, 2, 4)).add(waitingTime).add(queuingTime));
            if (totalDispatchQty.compareTo(new BigDecimal("0")) == 0) {
                remainingTime = remainingTime.add(prepareTime);
            }
            BigDecimal result = new BigDecimal(endTime.getTime()).subtract(SystemTime).divide(new BigDecimal(3600000), 2, 4).subtract(remainingTime);
            technicsMap.put("sortKey", result);
        } else if ("FCFS".equals(sortRule)) {
            technicsMap.put("sortKey", new BigDecimal("0.00"));
        } else {
            technicsMap.put("sortKey", new BigDecimal("0.00"));
        }
    }

    private void sortPriority(List technicsList) {
        Collections.sort(technicsList, new Comparator(){

            public int compare(Object map1, Object map2) {
                int i = 0;
                i = ((BigDecimal)((Map)map1).get("sortKey")).compareTo((BigDecimal)((Map)map2).get("sortKey"));
                if (i == 0 && (i = ((String)((Map)map1).get("number")).compareTo((String)((Map)map2).get("number"))) == 0) {
                    return ((Integer)((Map)map1).get("operationNo")).compareTo((Integer)((Map)map2).get("operationNo"));
                }
                return i;
            }
        });
        Iterator it = technicsList.iterator();
        float start = -1.0f;
        while (it.hasNext()) {
            Map map = (Map)it.next();
            map.put("priority", new Float(start += 1.0f));
        }
    }

    private BigDecimal transferTime(OprTimeUnitEnum unit, BigDecimal time) {
        if (unit != null && unit.getValue() == 3) {
            return time.divide(new BigDecimal(60), 2, 4);
        }
        if (unit != null && unit.getValue() == 4) {
            return time.divide(new BigDecimal(3600), 2, 4);
        }
        return time;
    }

    @Override
    protected void btnCalcDiff_actionPerformed(ActionEvent e) throws Exception {
        WorkCenterInfo workCenter = (WorkCenterInfo)this.prmtWorkCenter.getValue();
        if (workCenter == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.mm.sfc.SFCAutoGenerateResource", (String)"28_PACDispatchUI"));
            SysUtil.abort();
        }
        Date beginDate = (Date)this.pkStartDate.getValue();
        BigDecimal estimatedDays = this.txtNumberOfDays.getBigDecimalValue();
        BigDecimal[] result = PACBuildFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).getDispatchedBurthen(workCenter, this.getMainOrgInfo().getId().toString(), new Timestamp(beginDate.getTime()), estimatedDays);
        BigDecimal dispatchBurthen = result[0];
        BigDecimal workableDays = result[1];
        BigDecimal capability = workCenter.getRatedAbility().multiply(workableDays).setScale(2, 4);
        this.txtTotalCapability.setValue((Object)capability);
        BigDecimal dispatchDiff = capability.subtract(dispatchBurthen);
        if (dispatchDiff.compareTo(SCMConstant.BIGDECIMAL_ZERO) < 0) {
            this.txtDispatchDiff.setDisabledTextColor(Color.RED);
        } else {
            this.txtDispatchDiff.setDisabledTextColor(Color.BLACK);
        }
        this.txtDispatchDiff.setValue((Object)dispatchDiff);
        BigDecimal assignBurthen = (BigDecimal)this.workCenter_assigned_Burthen.get(workCenter.getId().toString());
        BigDecimal assignDiff = assignBurthen != null ? capability.subtract(dispatchBurthen).subtract(assignBurthen) : capability.subtract(dispatchBurthen);
        if (assignDiff.compareTo(SCMConstant.BIGDECIMAL_ZERO) < 0) {
            this.txtAssignedDiff.setDisabledTextColor(Color.RED);
        } else {
            this.txtAssignedDiff.setDisabledTextColor(Color.BLACK);
        }
        this.txtAssignedDiff.setValue((Object)assignDiff);
        WorkCenterInfo wInfo = this.getSelectedTreeNode();
        wInfo.setEstimatedDays(estimatedDays);
    }

    private WorkCenterInfo getSelectedTreeNode() {
        WorkCenterTreeNode treeNode = (WorkCenterTreeNode)((Object)this.treeWorkCenter.getLastSelectedPathComponent());
        if (treeNode.getUserObject() instanceof WorkCenterInfo) {
            return (WorkCenterInfo)treeNode.getUserObject();
        }
        return null;
    }

    @Override
    public void actionDispatchList_actionPerformed(ActionEvent e) throws Exception {
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.kdtAssignResult);
        if (rows.length == 0) {
            return;
        }
        HashSet<String> ids = new HashSet<String>();
        int n = rows.length;
        for (int i = 0; i < n; ++i) {
            TaskAssignResult result = (TaskAssignResult)this.kdtAssignResult.getRow(rows[i]).getUserObject();
            if (!result.isGenTaskDispatch()) continue;
            ids.add(result.getDisTaskdispatchID());
        }
        if (ids.size() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            this.showDispatchListUI(filter);
        }
    }

    @Override
    public void actionWorkCenterDispatchList_actionPerformed(ActionEvent e) throws Exception {
        if (this.getSelectedTreeNode() == null) {
            return;
        }
        HashSet<String> workCenterIds = new HashSet<String>();
        TaskAssignParam param = null;
        for (int i = 0; i < this.kdtEqm.getRowCount(); ++i) {
            param = (TaskAssignParam)this.kdtEqm.getRow(i).getUserObject();
            if (param == null || param.getWorkCenter() == null) continue;
            workCenterIds.add(param.getWorkCenter().getId().toString());
        }
        this.showDispatchListUI(this.getWorkCenterDispatchFilter(workCenterIds));
    }

    private void showDispatchListUI(FilterInfo filter) throws Exception {
        HashMap<String, Integer> uiCtx = new HashMap<String, Integer>();
        uiCtx.put("BOTPViewStatus", new Integer(1));
        uiCtx.put("PACFilter", (Integer)filter);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.mm.sfc.client.DisTaskDispatchListUI", uiCtx, null, OprtState.VIEW);
        uiWindow.show();
        if (uiWindow instanceof JFrame) {
            ((JFrame)uiWindow).setExtendedState(6);
        }
    }

    private FilterInfo getWorkCenterDispatchFilter(Set workCenterIds) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("entry_workCenter.id", (Object)workCenterIds, CompareType.INCLUDE));
        return filter;
    }

    private FilterInfo getEquipmentDispatchFilter(Set ids) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.getMainOrgInfo().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("equipment.id", (Object)ids, CompareType.INCLUDE));
        return filter;
    }

    @Override
    public void actionEquipmentDispatchList_actionPerformed(ActionEvent e) throws Exception {
        if (this.getSelectedTreeNode() == null) {
            return;
        }
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.kdtEqm);
        if (rows.length == 0) {
            return;
        }
        HashSet<String> ids = new HashSet<String>();
        int n = rows.length;
        for (int i = 0; i < n; ++i) {
            TaskAssignParam param = (TaskAssignParam)this.kdtEqm.getRow(rows[i]).getUserObject();
            if (param.getEquipment() == null) continue;
            ids.add(param.getEquipment().getId().toString());
        }
        if (ids.size() > 0) {
            this.showDispatchListUI(this.getEquipmentDispatchFilter(ids));
        }
    }

    @Override
    public void actionDispatchEdit_actionPerformed(ActionEvent e) throws Exception {
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.kdtAssignResult);
        if (rows.length == 0) {
            return;
        }
        HashSet<String> ids = new HashSet<String>();
        int n = rows.length;
        for (int i = 0; i < n; ++i) {
            TaskAssignResult result = (TaskAssignResult)this.kdtAssignResult.getRow(rows[i]).getUserObject();
            if (!result.isGenTaskDispatch()) continue;
            ids.add(result.getDisTaskdispatchID());
        }
        RealModeIDList idList = RealModeIDList.getEmptyIDList();
        if (ids.size() > 0) {
            Iterator ite = ids.iterator();
            while (ite.hasNext()) {
                idList.add((String)ite.next());
            }
            UIContext map = new UIContext((Object)this);
            idList.setCurrentIndex(0);
            map.put("ID", idList.getCurrentID());
            map.put("IDList", idList);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.mm.sfc.client.DisTaskDispatchEditUI", (Map)map, null, OprtState.VIEW);
            uiWindow.show();
            if (uiWindow instanceof JFrame) {
                ((JFrame)uiWindow).setExtendedState(6);
            }
        }
    }

    @Override
    protected boolean isShowCommonQueryDialog() {
        return !this.isPACBuild;
    }

    protected void checkAssignResult() {
        int n = this.kdtAssignResult.getRowCount();
        for (int i = 0; i < n; ++i) {
            TaskAssignResult assignResult = (TaskAssignResult)this.kdtAssignResult.getRow(i).getUserObject();
            if (assignResult.isGenTaskDispatch()) continue;
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.mm.sfc.SFCAutoGenerateResource", (String)"29_PACDispatchUI"));
            if (result == 0) break;
            SysUtil.abort();
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.kdtEqm.addRow();
        int n = this.kdtEqm.getColumnCount();
        for (int i = 0; i < n; ++i) {
            row.getCell(i).getStyleAttributes().setLocked(true);
        }
        row.getCell("workCenter.number").getStyleAttributes().setLocked(false);
        row.getCell("workCenter.number").setValue((Object)this.getSelectedTreeNode());
        this.dealWorkCenterChange(row.getRowIndex(), this.getSelectedTreeNode());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(20), CompareType.EQUALS));
        view.setFilter(filter);
        this.uiHelper.getTableEditHandler(this.kdtEqm).setPromptBoxCellEditor(row.getRowIndex(), "workCenter.number", "com.kingdee.eas.mm.basedata.app.F7WorkcenterQuery", "storageOrgUnit.id", false, view);
    }

    private void configSelector(KDPromptSelector selector) {
        if (selector instanceof KDCommonPromptDialog) {
            KDCommonPromptDialog dlg = (KDCommonPromptDialog)selector;
            dlg.setEntityViewInfo(new EntityViewInfo());
            dlg.setMainOrgContext(this.getMainOrgContext());
            dlg.setEnabledMultiSelection(false);
            dlg.setReturnValueType(0);
            dlg.setUseCacheObject(false);
        }
    }

    private String getPriorityQuery() {
        return "com.kingdee.eas.mm.sfc.app.PACSelectRuleOfpriorityQuery";
    }

    protected OrgUnitCollection getMainBizOrgs() {
        OrgUnitCollection orgs = new OrgUnitCollection();
        orgs.add(this.getMainOrgInfo());
        return orgs;
    }

    @Override
    public void executeShortcutQuery(FilterInfo filter) {
        this.checkAssignResult();
        this.clearUIData();
        super.executeShortcutQuery(filter);
        try {
            this.refreshTree();
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        if (this.isPACBuild) {
            this.clearUIContxt();
        }
    }
}

