/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.client;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.QueryAgent;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.mm.common.MMBaseStatusEnum;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.sfc.IsKeyOPEnum;
import com.kingdee.eas.mm.sfc.OperationTypeEnum;
import com.kingdee.eas.mm.sfc.ProcessStatusEnum;
import com.kingdee.eas.mm.sfc.client.AbstractPACFilterUI;
import com.kingdee.eas.mm.sfc.util.pac.ISupportShortcutQuery;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.ColConnFilterElement;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class PACFilterUI
extends AbstractPACFilterUI
implements ISupportShortcutQuery {
    private static final Logger logger = CoreUIObject.getLogger(PACFilterUI.class);
    private boolean isShortcut = false;
    private int uiType = 1;
    public static final int PACBuild = 1;
    public static final int PACEdit = 2;
    public static final int PACDispatch = 3;
    protected ColConnFilterElement mainOrgElement;
    protected SingleFilterElement orderDeptElement;
    protected SingleFilterElement otherOrgElement;
    protected SingleFilterElement workDeptElement;
    protected FuzzyQueryFilterElement materialNumberElement;
    protected FuzzyQueryFilterElement materialNameElement;
    protected FuzzyQueryFilterElement materialModelElement;
    protected FuzzyQueryFilterElement pictureNumberElement;
    protected FuzzyQueryFilterElement workCenterElement;
    protected RangeFilterElement planBeginDateElement;
    protected RangeFilterElement planEndDateElement;
    protected SingleFilterElement processStatusElement;
    protected SingleFilterElement orderStatusElement;
    protected SingleFilterElement materialGroupElement;
    protected SingleFilterElement operationTypeElement;
    protected SingleFilterElement isKeyOPElement;
    protected SingleFilterElement trackNumberElement;
    private static final String CLEAR_ITEM = "ClearItem";

    public PACFilterUI() throws Exception {
    }

    public PACFilterUI(boolean isShortcut, int uiType) throws Exception {
        this.isShortcut = isShortcut;
        this.uiType = uiType;
    }

    protected boolean isCustomizedBill() {
        return false;
    }

    protected Date getNextMonthDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 1);
        return calendar.getTime();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initFilterElements();
        if (this.isShortcut) {
            this.setShortcutCondition();
        }
        this.registerF7s();
        this.cmbProcessStatus.getActionMap().remove(CLEAR_ITEM);
        this.cmbOrderStatus.getActionMap().remove(CLEAR_ITEM);
        this.cmbOperationType.getActionMap().remove(CLEAR_ITEM);
        this.cmbIsKeyOP.getActionMap().remove(CLEAR_ITEM);
    }

    private void registerF7s() {
        this.registerMainDeptF7();
        this.registerWorkDeptF7();
        this.registerWorkCenterF7();
        this.registerOtherOrgUnitF7();
        this.registerMaterialGroupF7();
        this.registerMaterialF7();
        this.registerTrackNumberF7();
    }

    protected void initFilterElements() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        this.mainOrgElement = new ColConnFilterElement(this.getPropertyOfMainBizOrg(), (Component)this.getMainBizOrgF7());
        this.mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, this.getMainBizOrgVerifyMessage()));
        this.getMainBizOrgF7().setRequired(true);
        this.getFilterManager().setMainOrgElement((FilterElement)this.mainOrgElement, this.getPropertyOfMainBizOrg());
        elements.add((FilterElement)this.mainOrgElement);
        this.otherOrgElement = new SingleFilterElement(this.getPropertyOfOtherBizOrg(), (Component)this.getOtherBizOrgF7());
        elements.add((FilterElement)this.otherOrgElement);
        this.orderDeptElement = new SingleFilterElement("orderDept.number", (Component)this.prmtMainDept);
        if (this.uiType == 1) {
            this.prmtMainDept.setRequired(true);
            this.orderDeptElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.mm.sfc.PACResource", (String)"MESSAGE_MAINWORKSHOP_REQUIRED")));
        }
        elements.add((FilterElement)this.orderDeptElement);
        this.workDeptElement = new SingleFilterElement("workDept.number", (Component)this.prmtWorkDept);
        if (this.uiType == 2 || this.uiType == 3) {
            this.prmtWorkDept.setRequired(true);
            this.workDeptElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.mm.sfc.PACResource", (String)"MESSAGE_WORKDEPT_REQUIRED")));
        }
        elements.add((FilterElement)this.workDeptElement);
        this.materialGroupElement = new SingleFilterElement("materialGroup.number", (Component)this.prmtMaterialGroup);
        elements.add((FilterElement)this.materialGroupElement);
        this.materialNumberElement = new FuzzyQueryFilterElement("material.number", (Component)this.prmtMaterialNumber);
        elements.add((FilterElement)this.materialNumberElement);
        this.materialNameElement = new FuzzyQueryFilterElement("material.name", (Component)this.txtMaterialName);
        elements.add((FilterElement)this.materialNameElement);
        this.materialModelElement = new FuzzyQueryFilterElement("material.model", (Component)this.txtMaterialModel);
        elements.add((FilterElement)this.materialModelElement);
        this.pictureNumberElement = new FuzzyQueryFilterElement("material.pictureNumber", (Component)this.txtPictureNumber);
        elements.add((FilterElement)this.pictureNumberElement);
        this.workCenterElement = new FuzzyQueryFilterElement("workCenter.number", (Component)this.prmtWorkCenter);
        elements.add((FilterElement)this.workCenterElement);
        Timestamp[] dates = this.getDefaultDateRange(SCMClientUtils.getServerDate2());
        this.planBeginDateElement = new RangeFilterElement("planBeginDate", (Component)this.pkPlanStartFrom, (Component)this.pkPlanStartTo);
        this.planBeginDateElement.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, EASResource.getString((String)"com.kingdee.eas.mm.sfc.PACResource", (String)"MESSAGE_ENDDATE_ERROR")));
        this.planBeginDateElement.setDefaultValue((Object)dates);
        elements.add((FilterElement)this.planBeginDateElement);
        this.planEndDateElement = new RangeFilterElement("planEndDate", (Component)this.pkPlanEndFrom, (Component)this.pkPlanEndTo);
        this.planEndDateElement.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, EASResource.getString((String)"com.kingdee.eas.mm.sfc.PACResource", (String)"MESSAGE_ENDDATE_ERROR")));
        elements.add((FilterElement)this.planEndDateElement);
        if (this.uiType == 3) {
            this.processStatusElement = new SingleFilterElement("processStatus", (Component)this.cmbProcessStatus, (Object)ProcessStatusEnum.ALL);
            this.processStatusElement.setDefaultValue((Object)ProcessStatusEnum.UNASSIGN);
            elements.add((FilterElement)this.processStatusElement);
        } else {
            this.lbProcessStatus.setVisible(false);
        }
        if (this.uiType != 3) {
            this.cmbOrderStatus.removeAllItems();
            Object[] status = new Object[]{MMBaseStatusEnum.AUDIT, MMBaseStatusEnum.RELEASED, MMBaseStatusEnum.NULL};
            this.cmbOrderStatus.addItems(status);
            this.orderStatusElement = new SingleFilterElement("baseStatus", (Component)this.cmbOrderStatus, (Object)MMBaseStatusEnum.NULL);
            this.orderStatusElement.setDefaultValue((Object)MMBaseStatusEnum.AUDIT);
            elements.add((FilterElement)this.orderStatusElement);
        } else {
            this.lbOrderStatus.setVisible(false);
        }
        this.operationTypeElement = new SingleFilterElement("operationType", (Component)this.cmbOperationType, (Object)OperationTypeEnum.ALL);
        this.operationTypeElement.setDefaultValue((Object)OperationTypeEnum.ALL);
        elements.add((FilterElement)this.operationTypeElement);
        this.isKeyOPElement = new SingleFilterElement("keyOP", (Component)this.cmbIsKeyOP, (Object)IsKeyOPEnum.ALL);
        this.isKeyOPElement.setDefaultValue((Object)IsKeyOPEnum.ALL);
        elements.add((FilterElement)this.isKeyOPElement);
        this.trackNumberElement = new SingleFilterElement("trackNumber.number", (Component)this.prmtTrackNumberFrom);
        elements.add((FilterElement)this.trackNumberElement);
        this.getFilterManager().setElement((FilterElement)elements);
    }

    private void setShortcutCondition() {
        this.otherOrgElement.setExclude(true);
        if (this.uiType == 1) {
            this.workDeptElement.setExclude(true);
        } else {
            this.orderDeptElement.setExclude(true);
        }
        if (this.uiType == 2 || this.uiType == 3) {
            this.orderDeptElement.setExclude(true);
        }
        this.materialGroupElement.setExclude(true);
        this.materialNumberElement.setExclude(true);
        this.materialNameElement.setExclude(true);
        this.materialModelElement.setExclude(true);
        this.pictureNumberElement.setExclude(true);
        this.workCenterElement.setExclude(true);
        this.planEndDateElement.setExclude(true);
        this.operationTypeElement.setExclude(true);
        this.isKeyOPElement.setExclude(true);
        this.trackNumberElement.setExclude(true);
    }

    public boolean verify() {
        return super.verify();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        if (this.uiType == 1) {
            return this.prmtStorageOrgUnit;
        }
        return this.prmtWorkOrgUnit;
    }

    public KDBizPromptBox getOtherBizOrgF7() {
        if (this.uiType == 1) {
            return this.prmtWorkOrgUnit;
        }
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getViewPermission() {
        if (this.uiType == 1) {
            return "mm_sfc_PACBuild";
        }
        if (this.uiType == 2) {
            return "mm_sfc_PACAdjust";
        }
        return "mm_sfc_PACDispatch";
    }

    protected String getPropertyOfMainBizOrg() {
        if (this.uiType == 1) {
            return "storageOrgUnit.id";
        }
        return "workOrgUnit.id";
    }

    protected String getPropertyOfOtherBizOrg() {
        if (this.uiType == 1) {
            return "workOrgUnit.number";
        }
        return "storageOrgUnit.number";
    }

    protected String getMainBizOrgVerifyMessage() {
        if (this.uiType == 1) {
            return EASResource.getString((String)"com.kingdee.eas.mm.sfc.PACResource", (String)"STORAGEORGUNIT_BLANK");
        }
        return EASResource.getString((String)"com.kingdee.eas.mm.sfc.PACResource", (String)"WORKORGUNIT_BLANK");
    }

    public void clear() {
        super.clear();
    }

    public Date getCurrentlyDate() {
        return new Date();
    }

    private void performStorageNullCheck() {
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.sfc.PACResource", (String)"STORAGEORGUNIT_BLANK"));
            this.prmtStorageOrgUnit.requestFocus();
            SysUtil.abort();
        }
    }

    private void performWorkOrgNullCheck() {
        if (this.prmtWorkOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.sfc.PACResource", (String)"WORKORGUNIT_BLANK"));
            this.prmtWorkOrgUnit.requestFocus();
            SysUtil.abort();
        }
    }

    private Timestamp[] getDefaultDateRange(Date d) {
        Calendar calendar = Calendar.getInstance();
        Calendar calendarEnd = Calendar.getInstance();
        if (d != null) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        calendarEnd.add(5, 14);
        calendar.add(5, -7);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp[]{new Timestamp(calendar.getTimeInMillis()), new Timestamp(calendarEnd.getTimeInMillis())};
    }

    private void addEntityViewToWorkCenter() {
        IObjectValue[] mfOrgs = null;
        if (this.prmtWorkOrgUnit.getValue() instanceof IObjectValue[]) {
            mfOrgs = (IObjectValue[])this.prmtWorkOrgUnit.getValue();
        } else if (this.prmtWorkOrgUnit.getValue() instanceof Object[]) {
            Object[] objects = (Object[])this.prmtWorkOrgUnit.getValue();
            mfOrgs = new IObjectValue[objects.length];
            System.arraycopy(objects, 0, mfOrgs, 0, objects.length);
        } else if (this.prmtWorkOrgUnit.getValue() instanceof IObjectValue) {
            mfOrgs = new IObjectValue[]{(IObjectValue)this.prmtWorkOrgUnit.getValue()};
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(20)));
        if (mfOrgs != null && mfOrgs.length > 0) {
            HashSet<String> ids = new HashSet<String>();
            int count = mfOrgs.length;
            for (int i = 0; i < count; ++i) {
                ids.add(mfOrgs[i].get("id").toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", ids, CompareType.INCLUDE));
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        this.prmtWorkCenter.setEntityViewInfo(view);
        this.prmtWorkCenter.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    public KDLabelContainer[] getShortcutFilterLabels() {
        if (this.uiType == 1) {
            return new KDLabelContainer[]{this.lbMainDept, this.lbPlanStartFrom, this.lbPlanStartTo};
        }
        if (this.uiType == 2) {
            return new KDLabelContainer[]{this.lbWorkDept, this.lbPlanStartFrom, this.lbPlanStartTo};
        }
        if (this.uiType == 3) {
            return new KDLabelContainer[]{this.lbWorkDept, this.lbPlanStartFrom, this.lbPlanStartTo, this.lbProcessStatus};
        }
        return null;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        try {
            this.prmtWorkOrgUnit.commitEdit();
            this.prmtMainDept.commitEdit();
            this.prmtWorkDept.commitEdit();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public OrgUnitInfo getWorkDept() {
        return (OrgUnitInfo)this.prmtWorkDept.getData();
    }

    public KDBizPromptBox getWorkDeptF7() {
        return this.prmtWorkDept;
    }

    private void registerOtherOrgUnitF7() {
        this.getOtherBizOrgF7().addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                PACFilterUI.this.performMainOrgNullCheck();
                PACFilterUI.this.setOtherOrgUnitFilter();
            }
        });
        this.getOtherBizOrgF7().addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                PACFilterUI.this.performMainOrgNullCheck();
                PACFilterUI.this.setOtherOrgUnitFilter();
            }
        });
    }

    private void performMainOrgNullCheck() {
        if (this.uiType == 1) {
            this.performStorageNullCheck();
        } else {
            this.performWorkOrgNullCheck();
        }
    }

    private void setOtherOrgUnitFilter() {
        IObjectValue[] array = null;
        if (this.getMainBizOrgF7().getValue() instanceof IObjectValue[]) {
            array = (IObjectValue[])this.getMainBizOrgF7().getValue();
        } else if (this.getMainBizOrgF7().getValue() instanceof Object[]) {
            Object[] objects = (Object[])this.getMainBizOrgF7().getValue();
            array = new IObjectValue[objects.length];
            System.arraycopy(objects, 0, array, 0, objects.length);
        } else if (this.getMainBizOrgF7().getValue() instanceof IObjectValue) {
            array = new IObjectValue[]{(IObjectValue)this.getMainBizOrgF7().getValue()};
        }
        if (array != null && array.length > 0) {
            Object[] ids = new String[array.length];
            int count = array.length;
            for (int i = 0; i < count; ++i) {
                ids[i] = array[i].get("id").toString();
            }
            String SQL_WHERE_CONDITION = SQLUtil.arrayToString((Object[])ids);
            EntityViewInfo view = new EntityViewInfo();
            StringBuffer sql = new StringBuffer();
            sql.append("select orgRe.FFromUnitID from T_ORG_UnitRelation orgRe ");
            sql.append("where orgRe.FTOUnitID in ( select orgRe.FTOUnitID ");
            sql.append(" from T_ORG_UnitRelation orgRe where orgRe.FFromUnitID in (").append(SQL_WHERE_CONDITION).append(")");
            sql.append(" and orgRe.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5')");
            sql.append(" and orgRe.ftyperelationid='00000000-0000-0000-0000-0000000000070FE9F8B5'");
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
            view.setFilter(filterInfo);
            this.getOtherBizOrgF7().setEntityViewInfo(view);
            this.getOtherBizOrgF7().getQueryAgent().resetRuntimeEntityView();
        }
    }

    private void registerMainDeptF7() {
        this.prmtMainDept.setCommitParser((IParser)new ExtendParser(this.prmtMainDept));
        UIHelper.registerBizOrgF7((KDBizPromptBox)this.prmtMainDept, null, null, (OrgType)this.getMainBizOrgType(), (OrgType)OrgType.Admin, (boolean)true);
    }

    private void registerWorkDeptF7() {
        this.prmtWorkDept.setCommitParser((IParser)new ExtendParser(this.prmtWorkDept));
        UIHelper.registerBizOrgF7((KDBizPromptBox)this.prmtWorkDept, null, null, (OrgType)this.getMainBizOrgType(), (OrgType)OrgType.Admin, (boolean)true);
    }

    private void registerWorkCenterF7() {
        this.prmtWorkCenter.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                PACFilterUI.this.performWorkOrgNullCheck();
                PACFilterUI.this.addEntityViewToWorkCenter();
            }
        });
        this.prmtWorkCenter.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                PACFilterUI.this.performWorkOrgNullCheck();
                PACFilterUI.this.addEntityViewToWorkCenter();
            }
        });
    }

    private void registerMaterialGroupF7() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("groupStandard.standardType", (Object)new Integer(1)));
        if (!MaterialInfo.isAllowNonLeafGroup()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE));
        }
        view.setFilter(filterInfo);
        this.prmtMaterialGroup.setEntityViewInfo(view);
    }

    private void registerMaterialF7() {
        this.prmtMaterialNumber.setCommitParser((IParser)new FuzzyQueryParser(this.prmtMaterialNumber));
        this.prmtMaterialNumber.setCommitFormat("$number$");
        this.prmtMaterialNumber.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                PACFilterUI.this.setMaterialF7Filter();
            }
        });
        this.prmtMaterialNumber.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                PACFilterUI.this.setMaterialF7Filter();
            }
        });
    }

    private void registerTrackNumberF7() {
        this.prmtTrackNumberFrom.setCommitParser((IParser)new ExtendParser(this.prmtTrackNumberFrom));
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumberFrom);
    }

    private void setMaterialF7Filter() {
        String number;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.prmtMainDept.getData() != null) {
            number = ((DataBaseInfo)this.prmtMainDept.getData()).getNumber();
            filter.getFilterItems().add(new FilterItemInfo("MainDept.number", (Object)number, CompareType.EQUALS));
        }
        if (this.prmtWorkDept.getData() != null) {
            number = ((DataBaseInfo)this.prmtWorkDept.getData()).getNumber();
            filter.getFilterItems().add(new FilterItemInfo("WorkDept.number", (Object)number, CompareType.EQUALS));
        }
        view.setFilter(filter);
        this.prmtMaterialNumber.setEntityViewInfo(view);
        this.prmtMaterialNumber.getQueryAgent().resetRuntimeEntityView();
        this.prmtMaterialNumber.getQueryAgent().setDefaultFilterInfo(null);
    }

    protected void initListener() {
        super.initListener();
        this.prmtStorageOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e.getNewValue() != null) {
                    OrgUnitInfo org = (OrgUnitInfo)e.getNewValue();
                    PACFilterUI.this.setCurrentMainBizOrgUnit4DeptF7(PACFilterUI.this.prmtMainDept, org);
                }
            }
        });
        this.prmtWorkOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e.getNewValue() != null) {
                    OrgUnitInfo org = (OrgUnitInfo)e.getNewValue();
                    PACFilterUI.this.setCurrentMainBizOrgUnit4DeptF7(PACFilterUI.this.prmtWorkDept, org);
                }
            }
        });
    }

    private void setCurrentMainBizOrgUnit4DeptF7(KDBizPromptBox deptF7, OrgUnitInfo org) {
        deptF7.setCurrentMainBizOrgUnit(org, OrgType.Storage);
    }

    class FuzzyQueryParser
    extends KDBizPromptBox.DefaultParser {
        public FuzzyQueryParser(KDBizPromptBox pb) {
            super(pb);
        }

        public FuzzyQueryParser(String CommitFormater, KDBizPromptBox pb) {
            super(CommitFormater, pb);
        }

        public Object stringToValue(String t) {
            if (StringUtil.isEmptyString((String)t)) {
                return null;
            }
            QueryAgent agent = this.prompt.getQueryAgent();
            if (agent == null) {
                return null;
            }
            Object o = this.fuzzyQueryStrToValueImp(t, agent, KDPromptBox.DEFAULTVALUE);
            return o;
        }

        protected Object fuzzyQueryStrToValueImp(String t, QueryAgent agent, Object defaultValue) {
            Object o = defaultValue;
            Map[] maps = this.getConditionMaps(t);
            this.prompt.getQueryAgent().setQueryExecutor(null);
            IRowSet equalRowSet = null;
            if (!this.prompt.getQueryAgent().upgradeEntityViewFromOriginLike(maps)) {
                logger.info((Object)"warning: view set filter failed!");
                return defaultValue;
            }
            int PAGELENGTH = 100;
            equalRowSet = this.prompt.getQueryAgent().executeQuery(0, 100);
            int equalRowSetSize = 0;
            if (equalRowSet != null) {
                equalRowSetSize = equalRowSet.size();
            }
            if (equalRowSetSize == 1) {
                o = this.buildReturnValue(agent, equalRowSet, 1)[0];
                return o;
            }
            if (equalRowSetSize > 1) {
                return t;
            }
            return null;
        }
    }

    class ExtendParser
    extends KDBizPromptBox.DefaultParser {
        public ExtendParser(String str, KDBizPromptBox pb) {
            super(str, pb);
        }

        public ExtendParser(KDBizPromptBox pb) {
            super(pb);
        }

        public Object stringToValue(String t) {
            if (t == null || t.length() < 1) {
                return null;
            }
            QueryAgent agent = this.prompt.getQueryAgent();
            if (agent == null) {
                return null;
            }
            Object o = this.originEqualStrToValueImp(t, agent, t);
            agent.resetRuntimeEntityView();
            return o;
        }

        protected Object originEqualStrToValueImp(String t, QueryAgent agent, Object defaultValue) {
            Object o = defaultValue;
            int PAGELENGTH = 100;
            Map[] maps = this.getConditionMaps(t);
            this.prompt.getQueryAgent().setQueryExecutor(null);
            IRowSet equalRowSet = null;
            if (!this.prompt.getQueryAgent().upgradeEntityViewFromOriginEqual(maps)) {
                logger.info((Object)"warning: view set filter failed!");
                return defaultValue;
            }
            equalRowSet = this.prompt.getQueryAgent().executeQuery(0, 100);
            if (equalRowSet != null && equalRowSet.size() > 0) {
                return this.buildReturnValue(agent, equalRowSet, 1)[0];
            }
            return null;
        }
    }

    class FuzzyQueryFilterElement
    extends SingleFilterElement {
        public FuzzyQueryFilterElement(String id, Component component) {
            super(id, component);
            this.setCompareType(CompareType.LIKE);
            if (component instanceof KDBizPromptBox) {
                // empty if block
            }
        }

        protected String getNumber(Object obj) {
            String nubmer = super.getNumber(obj);
            if (nubmer != null) {
                return "%" + nubmer + "%";
            }
            return null;
        }
    }
}

