/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.event.ActiveContainerEvent;
import com.kingdee.bos.ctrl.swing.event.ActiveContainerListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.mm.basedata.OprTimeUnitEnum;
import com.kingdee.eas.mm.basedata.WorkCenterInfo;
import com.kingdee.eas.mm.sfc.CalendarTypeEnum;
import com.kingdee.eas.mm.sfc.IPACBuildFacade;
import com.kingdee.eas.mm.sfc.PACBuildFacadeFactory;
import com.kingdee.eas.mm.sfc.PACViewBurthenInfo;
import com.kingdee.eas.mm.sfc.client.AbstractPACViewBurthenUI;
import com.kingdee.eas.mm.sfc.util.pac.PACUtil;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class PACViewBurthenUI
extends AbstractPACViewBurthenUI {
    private static final long serialVersionUID = -7960248046318110817L;
    private static final Logger logger = CoreUIObject.getLogger(PACViewBurthenUI.class);
    private Color color = new Color(204, 232, 207);
    private Map workDateSeqMap = new HashMap();
    private Map workCenterTree = new HashMap();
    private Map dateNumber = new HashMap();
    private Map dataMap = new HashMap();
    private final int BURTHENDAYS = 60;
    private final long DAY = 86400000L;
    private static final BigDecimal HOUR_MINUTE_RATE = new BigDecimal(60);
    private static final BigDecimal HOUR_SECOND_RATE = new BigDecimal(3600);
    private ItemListener workCenterItemListener = null;
    private Timestamp startTime;
    Timestamp endTime;

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                PACViewBurthenUI.this.kdtMain_ActiveCellChanged(e);
            }
        });
        this.kDContainer2.addActiveContainerListener(new ActiveContainerListener(){

            public void action(ActiveContainerEvent e) {
                boolean isSpread = false;
                isSpread = e.getType() != 3;
                PACViewBurthenUI.this.showkDContainer1(isSpread);
            }
        });
    }

    private void showkDContainer1(boolean isShow) {
        if (isShow) {
            this.showPlan(true);
        } else {
            this.hiddenPlan(true);
        }
    }

    private void workCenterChange(ItemEvent e) {
        if (e.getItem() != null && this.dataMap.size() > 0) {
            this.dataFilter();
        }
    }

    private void dataFilter() {
        int row = this.tblMain.getRowCount();
        Object o1 = this.cmbWorkCenter.getSelectedItem();
        for (int i = 0; i < row; ++i) {
            Object o2 = this.tblMain.getCell(i, 0).getValue();
            if (o1 != o2 && o1 != "") {
                this.tblMain.getRow(i).getStyleAttributes().setHided(true);
                continue;
            }
            this.tblMain.getRow(i).getStyleAttributes().setHided(false);
        }
    }

    private void kdtMain_ActiveCellChanged(KDTActiveCellEvent e) {
        this.tblDetail.removeRows();
        int column = e.getColumnIndex();
        int row = e.getRowIndex();
        if (this.tblMain.getCell(row, 1) == null) {
            return;
        }
        String workCenterId = (String)this.tblMain.getCell(row, 1).getValue();
        List technicsList = (List)this.workCenterTree.get(workCenterId);
        Iterator it = technicsList.iterator();
        PACViewBurthenInfo info = null;
        while (it.hasNext()) {
            info = (PACViewBurthenInfo)it.next();
            String key = workCenterId + info.getTechnicsId() + "#" + row + "#" + column;
            if (!this.dataMap.containsKey(key)) continue;
            String date = (String)this.dataMap.get(key);
            this.loadBurthenDetail(info, date);
        }
    }

    private void loadBurthenDetail(PACViewBurthenInfo info, String date) {
        IRow row = this.tblDetail.addRow();
        row.getCell("workCenter").setValue((Object)info.getWorkCenter().getName());
        row.getCell("date").setValue((Object)date);
        row.getCell("materialNumber").setValue((Object)info.getMaterialNumber());
        row.getCell("materialName").setValue((Object)info.getMaterialName());
        row.getCell("materialModel").setValue((Object)info.getMaterialModel());
        row.getCell("qty").setValue((Object)info.getQty());
        row.getCell("finishedQty").setValue((Object)info.getFinishedQty());
        row.getCell("operationNo").setValue((Object)String.valueOf(info.getOperationNo()));
        row.getCell("operationName").setValue((Object)info.getOperationName());
        row.getCell("queuingTime").setValue((Object)info.getQueuingTime());
        row.getCell("prepareTime").setValue((Object)info.getPrepareTime());
        row.getCell("workTime").setValue((Object)info.getWorkTime());
        row.getCell("waitingTime").setValue((Object)info.getWaitingTime());
        row.getCell("movingTime").setValue((Object)info.getMovingTime());
        row.getCell("processBatch").setValue((Object)info.getProcessBatch());
        row.getCell("timeUnit").setValue((Object)OprTimeUnitEnum.getEnum((int)info.getTimeUnit()).getAlias());
        row.getCell("startTime").setValue((Object)info.getStart());
        row.getCell("endTime").setValue((Object)info.getEnd());
        row.getCell("remark").setValue((Object)info.getRemark());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblDetail.getStyleAttributes().setLocked(true);
        List paramList = (List)this.getUIContext().get("pramList");
        this.startTime = (Timestamp)this.getUIContext().get("startTime");
        this.endTime = (Timestamp)this.getUIContext().get("endTime");
        String storageOrgUnitId = (String)this.getUIContext().get("storageOrgUnitId");
        String orgIds = (String)this.getUIContext().get("orgIds");
        this.initWorkDateSeqMap(orgIds, this.startTime, this.endTime);
        this.getBurthen(paramList);
        this.initTblMain(null);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblDetail.getColumn("date").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblDetail.getColumn("startTime").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateTimeFormatString());
        this.tblDetail.getColumn("endTime").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateTimeFormatString());
    }

    private void initColumn(CalendarTypeEnum calendarType) {
        Timestamp systemTime = PACUtil.resetTimeForBeginDate(new Timestamp(System.currentTimeMillis()));
        this.startTime.setTime(systemTime.getTime());
        if (this.startTime.compareTo(this.endTime) > 0) {
            this.endTime.setTime(this.startTime.getTime());
        }
        int days = PACUtil.DateMinusDay(this.startTime, this.endTime) + 1;
        int size = 0;
        size = days <= 60 ? days : 60;
        IRow row = this.tblMain.addHeadRow();
        this.tblMain.addColumn();
        row.getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.mm.sfc.SFCAutoGenerateResource", (String)"33_PACViewBurthenUI"));
        this.tblMain.addColumn();
        row.getCell(1).setValue((Object)"workCenterId");
        this.tblMain.getColumn(1).getStyleAttributes().setHided(true);
        if (calendarType == null || calendarType.equals((Object)CalendarTypeEnum.DAY)) {
            this.initDayColumn(size, row);
        } else if (calendarType.equals((Object)CalendarTypeEnum.WEEK)) {
            this.initWeekColumn(size, row);
        } else if (calendarType.equals((Object)CalendarTypeEnum.MONTH)) {
            this.initMonthColumn(size, row);
        }
    }

    private void initDayColumn(int size, IRow row) {
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        String displayName = "";
        for (int i = 2; i <= size + 1; ++i) {
            Timestamp time = new Timestamp(this.startTime.getTime() + 86400000L * (long)(i - 2));
            this.tblMain.addColumn();
            displayName = dtformat.format(time);
            row.getCell(i).setValue((Object)displayName);
            this.tblMain.getColumn(i).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.dateNumber.put(time, new BigDecimal(i));
        }
    }

    private void initWeekColumn(int size, IRow row) {
        int perWeek = 0;
        int week = 0;
        int weekCount = 2;
        String displayName = "";
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        MessageFormat format = BOSLocaleUtil.getMessageFormat((String)EASResource.getString((String)"com.kingdee.eas.mm.sfc.SFCAutoGenerateResource", (String)"34_PACViewBurthenUI"));
        for (int i = 2; i <= size + 1; ++i) {
            Timestamp time = new Timestamp(this.startTime.getTime() + 86400000L * (long)(i - 2));
            if (week == 0) {
                perWeek = week = this.getWeekOfYear(time);
            }
            if (perWeek != (week = this.getWeekOfYear(time))) {
                displayName = weekCount == 2 ? format.format(new Object[]{String.valueOf(perWeek), df.format(this.startTime), df.format(new Timestamp(time.getTime() - 86400000L))}) : (i != size + 1 ? format.format(new Object[]{String.valueOf(perWeek), df.format(new Timestamp(time.getTime() - 604800000L)), df.format(new Timestamp(time.getTime() - 86400000L))}) : format.format(new Object[]{String.valueOf(perWeek), df.format(new Timestamp(time.getTime() - 604800000L)), df.format(this.endTime)}));
                perWeek = week;
                this.tblMain.addColumn().setWidth(200);
                row.getCell(weekCount).setValue((Object)displayName);
                this.tblMain.getColumn(weekCount).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                ++weekCount;
            } else if (i == size + 1) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.endTime);
                cal.set(7, 1);
                displayName = format.format(new Object[]{String.valueOf(week), df.format(cal.getTime()), df.format(this.endTime)});
                this.tblMain.addColumn().setWidth(200);
                row.getCell(weekCount).setValue((Object)displayName);
                this.tblMain.getColumn(weekCount).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
            this.dateNumber.put(time, new BigDecimal(weekCount));
        }
    }

    private void initMonthColumn(int size, IRow row) {
        int perMonth = 0;
        int month = 0;
        int monthCount = 2;
        String displayName = "";
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        MessageFormat format = BOSLocaleUtil.getMessageFormat((String)EASResource.getString((String)"com.kingdee.eas.mm.sfc.SFCAutoGenerateResource", (String)"35_PACViewBurthenUI"));
        for (int i = 2; i <= size + 1; ++i) {
            Timestamp time = new Timestamp(this.startTime.getTime() + 86400000L * (long)(i - 2));
            if (month == 0) {
                perMonth = month = this.getMonthOfYear(time);
            }
            if (perMonth != (month = this.getMonthOfYear(time))) {
                displayName = format.format(new Object[]{String.valueOf(perMonth)});
                perMonth = month;
                this.tblMain.addColumn().setWidth(70);
                row.getCell(monthCount).setValue((Object)displayName);
                this.tblMain.getColumn(monthCount).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                ++monthCount;
            } else if (i == size) {
                displayName = format.format(new Object[]{String.valueOf(month)});
                this.tblMain.addColumn().setWidth(70);
                row.getCell(monthCount).setValue((Object)displayName);
                this.tblMain.getColumn(monthCount).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
            this.dateNumber.put(time, new BigDecimal(monthCount));
        }
    }

    private void initRowBurthenToZero(int row) {
        int column = this.tblMain.getColumnCount();
        for (int j = 2; j < column; ++j) {
            if (this.tblMain.getCell(row, j).getValue() != null) continue;
            this.tblMain.getCell(row, j).setValue((Object)SCMConstant.BIGDECIMAL_ZERO);
        }
    }

    private void reloadWorkCenterBurthen() {
        Set set = this.workCenterTree.entrySet();
        Iterator it = set.iterator();
        PACViewBurthenInfo info2 = null;
        WorkCenterInfo workCenterInfo = null;
        List list = null;
        int rowIndex = 0;
        IRow row = null;
        Timestamp startTime = null;
        Timestamp endTime = null;
        String workOrgUnitId = null;
        BigDecimal index = null;
        BigDecimal burthen = null;
        long oneDay = 86400000L;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            list = (List)entry.getValue();
            block1: for (PACViewBurthenInfo info2 : list) {
                workCenterInfo = info2.getWorkCenter();
                workOrgUnitId = info2.getWorkOrgUnitId();
                startTime = info2.getStartTime();
                endTime = info2.getEndTime();
                burthen = info2.getBurthen();
                row = this.tblMain.getRow(rowIndex) == null ? this.tblMain.addRow(rowIndex) : this.tblMain.getRow(rowIndex);
                row.getCell(0).setValue((Object)workCenterInfo.getName());
                row.getCell(1).setValue((Object)workCenterInfo.getId().toString());
                this.initRowBurthenToZero(row.getRowIndex());
                Timestamp timeTemp = new Timestamp(startTime.getTime());
                while (timeTemp.compareTo(endTime) <= 0) {
                    index = (BigDecimal)this.dateNumber.get(timeTemp);
                    if (index == null) {
                        timeTemp.setTime(timeTemp.getTime() + oneDay);
                        continue;
                    }
                    if (this.tblMain.getColumn(index.intValue()) == null) continue block1;
                    if (!this.workDateSeqMap.containsKey(workOrgUnitId + timeTemp.toString())) {
                        String displayName = (String)this.tblMain.getHeadRow(0).getCell(index.intValue()).getValue();
                        if (!this.contains(displayName, EASResource.getString((String)"com.kingdee.eas.mm.sfc.SFCAutoGenerateResource", (String)"36_PACViewBurthenUI")) && !this.contains(displayName, EASResource.getString((String)"com.kingdee.eas.mm.sfc.SFCAutoGenerateResource", (String)"37_PACViewBurthenUI"))) {
                            row.getCell(index.intValue()).getStyleAttributes().setBackground(this.color);
                        }
                        timeTemp.setTime(timeTemp.getTime() + oneDay);
                        continue;
                    }
                    row.getCell(index.intValue()).setValue((Object)((BigDecimal)row.getCell(index.intValue()).getValue()).add(burthen).setScale(2, 4));
                    if (this.dataMap == null) {
                        this.dataMap = new HashMap();
                    }
                    StringBuffer str = new StringBuffer();
                    str.append(workCenterInfo.getId().toString()).append(info2.getTechnicsId()).append("#").append(row.getRowIndex()).append("#").append(index.intValue());
                    this.dataMap.put(str.toString(), (String)this.tblMain.getHead().getRow(0).getCell(index.intValue()).getValue());
                    timeTemp.setTime(timeTemp.getTime() + oneDay);
                }
            }
            ++rowIndex;
        }
        this.filterUnhidedData(this.tblMain, "workCenter", this.cmbWorkCenter);
    }

    private void initWorkDateSeqMap(String storageOrgUnitId, Timestamp startTime, Timestamp endTime) throws BOSException {
        Timestamp systemTime = PACUtil.resetTimeForBeginDate(new Timestamp(System.currentTimeMillis()));
        Timestamp start = new Timestamp(startTime.getTime());
        Timestamp end = new Timestamp(endTime.getTime());
        if (systemTime.compareTo(endTime) >= 0) {
            end.setTime(systemTime.getTime());
        }
        if (systemTime.compareTo(startTime) <= 0) {
            start.setTime(systemTime.getTime());
        }
        IPACBuildFacade remoteFacade = PACBuildFacadeFactory.getRemoteInstance();
        this.workDateSeqMap = remoteFacade.getPeriodDayPoints(storageOrgUnitId, start, end);
    }

    private void getBurthen(List param) {
        Iterator it = param.iterator();
        PACViewBurthenInfo info = null;
        Timestamp systemTime = PACUtil.resetTimeForBeginDate(new Timestamp(System.currentTimeMillis()));
        Timestamp startTime = null;
        Timestamp endTime = null;
        BigDecimal qty = null;
        BigDecimal finishedQty = null;
        BigDecimal prepareTime = null;
        BigDecimal workTime = null;
        BigDecimal processBatch = null;
        WorkCenterInfo workCenter = null;
        int timeUnit = 0;
        while (it.hasNext()) {
            info = (PACViewBurthenInfo)it.next();
            startTime = new Timestamp(info.getStartTime().getTime());
            endTime = new Timestamp(info.getEndTime().getTime());
            qty = info.getQty();
            finishedQty = info.getFinishedQty();
            prepareTime = info.getPrepareTime();
            workTime = info.getWorkTime();
            timeUnit = info.getTimeUnit();
            processBatch = info.getProcessBatch();
            workCenter = info.getWorkCenter();
            String workCenterId = workCenter.getId().toString();
            String workOrgUnitId = info.getWorkOrgUnitId();
            BigDecimal days = this.getBurthenDays(workOrgUnitId, startTime, endTime, systemTime);
            BigDecimal burthen = this.getBurthenEachDay(days, qty, finishedQty, timeUnit, prepareTime, workTime, processBatch);
            info.setDays(days);
            info.setBurthen(burthen);
            List<PACViewBurthenInfo> operationList = null;
            if (!this.workCenterTree.containsKey(workCenterId)) {
                operationList = new ArrayList<PACViewBurthenInfo>();
                operationList.add(info);
                this.workCenterTree.put(workCenterId, operationList);
                continue;
            }
            operationList = (List)this.workCenterTree.get(workCenterId);
            operationList.add(info);
        }
    }

    private BigDecimal getBurthenEachDay(BigDecimal days, BigDecimal qty, BigDecimal finishedQty, int timeUnit, BigDecimal prepareTime, BigDecimal workTime, BigDecimal processBatch) {
        BigDecimal result = SCMConstant.BIGDECIMAL_ZERO;
        if (days.compareTo(SCMConstant.BIGDECIMAL_ZERO) == 0) {
            return result;
        }
        if (timeUnit == 3) {
            prepareTime = prepareTime.divide(HOUR_MINUTE_RATE, 2, 4);
            workTime = workTime.divide(HOUR_MINUTE_RATE, 2, 4);
        } else if (timeUnit == 4) {
            prepareTime = prepareTime.divide(HOUR_SECOND_RATE, 2, 4);
            workTime = workTime.divide(HOUR_SECOND_RATE, 2, 4);
        }
        result = finishedQty.compareTo(SCMConstant.BIGDECIMAL_ZERO) == 0 ? (processBatch.compareTo(SCMConstant.BIGDECIMAL_ZERO) == 0 ? workTime.add(prepareTime).divide(days, 2, 4) : qty.divide(processBatch, 0, 0).multiply(workTime).add(prepareTime).divide(days, 2, 4)) : (processBatch.compareTo(SCMConstant.BIGDECIMAL_ZERO) == 0 ? qty.subtract(finishedQty).divide(qty, 2, 4).divide(days, 2, 4).multiply(workTime) : qty.subtract(finishedQty).divide(processBatch, 0, 0).divide(days, 2, 4).multiply(workTime));
        if (result.compareTo(SCMConstant.BIGDECIMAL_ZERO) < 0) {
            return SCMConstant.BIGDECIMAL_ZERO;
        }
        return result;
    }

    private BigDecimal getBurthenDays(String workOrgUnitId, Timestamp startTime, Timestamp endTime, Timestamp systemTime) {
        BigDecimal burthenDays = SCMConstant.BIGDECIMAL_ZERO;
        Timestamp start = new Timestamp(startTime.getTime());
        Timestamp end = new Timestamp(endTime.getTime());
        if (systemTime.compareTo(startTime) >= 0) {
            if (systemTime.compareTo(startTime) >= 0 && systemTime.compareTo(endTime) <= 0) {
                start.setTime(systemTime.getTime());
            } else {
                return burthenDays;
            }
        }
        return this.getWorkDays(workOrgUnitId, start, end);
    }

    private BigDecimal getWorkDays(String workOrgUnitId, Timestamp startTime, Timestamp endTime) {
        BigDecimal start = this.getDayPoint(workOrgUnitId, startTime, true);
        BigDecimal end = this.getDayPoint(workOrgUnitId, endTime, false).add(new BigDecimal(1));
        if (start.compareTo(SCMConstant.BIGDECIMAL_ZERO) == 0 || end.compareTo(SCMConstant.BIGDECIMAL_ZERO) == 0) {
            return SCMConstant.BIGDECIMAL_ZERO;
        }
        return end.subtract(start);
    }

    private BigDecimal getDayPoint(String workOrgUnitId, Timestamp time, boolean isStart) {
        int size = this.workDateSeqMap.size();
        int count = 0;
        long oneDay = 0L;
        oneDay = isStart ? 86400000L : -86400000L;
        Timestamp tempTime = new Timestamp(time.getTime());
        do {
            if (this.workDateSeqMap.get(workOrgUnitId + tempTime.toString()) != null) {
                return (BigDecimal)this.workDateSeqMap.get(workOrgUnitId + tempTime.toString());
            }
            tempTime.setTime(tempTime.getTime() + oneDay);
        } while (++count <= size);
        return SCMConstant.BIGDECIMAL_ZERO;
    }

    private int getWeekOfYear(Timestamp time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        return cal.get(3);
    }

    private int getMonthOfYear(Timestamp time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        return cal.get(2) + 1;
    }

    private void filterUnhidedData(KDTable table, String colKey, KDComboBox cmbControl) {
        this.cmbWorkCenter.removeItemListener(this.workCenterItemListener);
        cmbControl.removeAllItems();
        int row = table.getRowCount();
        if (row > 0) {
            TreeSet<Object> itemSet = new TreeSet<Object>(new Comparator(){

                public int compare(Object o1, Object o2) {
                    String ov1 = o1.toString();
                    String ov2 = o2.toString();
                    return ov1.compareTo(ov2);
                }
            });
            for (int i = 0; i < row; ++i) {
                if (table.getCell(i, 0).getValue() == null) continue;
                itemSet.add(table.getCell(i, 0).getValue());
            }
            Iterator it = itemSet.iterator();
            cmbControl.addItem((Object)"");
            while (it.hasNext()) {
                Object item = it.next();
                cmbControl.addItem(item);
            }
        }
        if (this.workCenterItemListener == null) {
            this.workCenterItemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PACViewBurthenUI.this.workCenterChange(e);
                }
            };
        }
        this.cmbWorkCenter.addItemListener(this.workCenterItemListener);
    }

    @Override
    protected void cmbCalendarType_actionPerformed(ActionEvent e) throws Exception {
        CalendarTypeEnum calendarType = (CalendarTypeEnum)((Object)this.cmbCalendarType.getSelectedItem());
        this.initTblMain(calendarType);
    }

    private void initTblMain(CalendarTypeEnum calendarType) {
        this.dateNumber.clear();
        this.dataMap.clear();
        this.tblMain.removeHeadRow(0);
        this.tblMain.removeRows();
        this.tblMain.removeColumns();
        this.initColumn(calendarType);
        this.reloadWorkCenterBurthen();
    }

    private void showPlan(boolean result) {
        if (result) {
            this.kDContainer2.setBounds(new Rectangle(10, 281, 996, 342));
            this.add((Component)this.kDContainer2, new KDLayout.Constraints(10, 281, 996, 342, 46));
            this.kDContainer1.setBounds(new Rectangle(10, 30, 996, 245));
            this.add((Component)this.kDContainer1, new KDLayout.Constraints(10, 30, 996, 245, 77));
            this.kDContainer2.getContentPane().setLayout((LayoutManager)new KDLayout());
            this.kDContainer2.getContentPane().putClientProperty("OriginalBounds", new Rectangle(10, 280, 996, 342));
            this.tblMain.setBounds(new Rectangle(0, 0, 996, 316));
            this.kDContainer1.getContentPane().add((Component)this.tblMain, "Center");
            this.kDContainer2.setVisible(false);
            this.kDContainer2.setVisible(true);
            this.kDContainer2.setState(1);
            this.kDContainer2.updateUI();
        }
    }

    private void hiddenPlan(boolean result) {
        if (result) {
            this.kDContainer2.setBounds(new Rectangle(10, 605, 996, 20));
            this.add((Component)this.kDContainer2, new KDLayout.Constraints(10, 605, 996, 20, 46));
            this.kDContainer1.setBounds(new Rectangle(10, 30, 996, 567));
            this.add((Component)this.kDContainer1, new KDLayout.Constraints(10, 32, 996, 567, 77));
            this.kDContainer2.setVisible(false);
            this.kDContainer2.setVisible(true);
            this.kDContainer2.setState(0);
            this.kDContainer2.setVisibleOfExpandButton(true);
        }
    }

    public boolean contains(String str, String s) {
        return str.indexOf(s) > -1;
    }
}

