/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTDataRequestManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.mm.sfc.client.AbstractPersonF7ListUI;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class PersonF7ListUI
extends AbstractPersonF7ListUI {
    private static final Logger logger = CoreUIObject.getLogger(PersonF7ListUI.class);
    protected F7ContextManager f7Manager = null;
    private DataChangeListener departmentDataChanged;
    protected boolean isCanceled = true;
    private AdminOrgUnitInfo departmentInfo = null;
    private OrgUnitInfo mainOrgInfo = null;
    private ArrayList selectList = null;
    private Set personIds = new HashSet();

    public PersonF7ListUI() throws Exception {
        this.f7Manager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType());
    }

    public void onLoad() throws Exception {
        this.departmentInfo = (AdminOrgUnitInfo)this.getUIContext().get("DEPARTMENT");
        this.mainOrgInfo = (OrgUnitInfo)this.getUIContext().get("ORG");
        HashSet tempPersonIds = (HashSet)this.getUIContext().get("PERSONIDS");
        if (tempPersonIds != null) {
            this.personIds.addAll(tempPersonIds);
        }
        this.initUIMainOrgContext(this.mainOrgInfo.getId().toString());
        this.initDepartmentF7(this.mainOrgInfo);
        this.removeListener();
        this.prmtDepartment.setValue((Object)this.departmentInfo);
        this.prmtDepartment.setEditable(false);
        this.prmtDepartment.setEnabled(false);
        this.addListener();
        super.onLoad();
    }

    private void initDepartmentF7(OrgUnitInfo storageOrgInfo) throws Exception {
        if (storageOrgInfo != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)storageOrgInfo.getCU().getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("isAdminOrgUnit", (Object)"1", CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            this.prmtDepartment.setEntityViewInfo(viewInfo);
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        if (this.personIds != null && this.personIds.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.personIds, CompareType.INNER));
        } else if ((AdminOrgUnitInfo)this.prmtDepartment.getValue() != null) {
            filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)((AdminOrgUnitInfo)this.prmtDepartment.getValue()).getId().toString(), CompareType.EQUALS));
        }
        String name = this.txtName.getText().trim();
        if (name != null && !name.equals("")) {
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + name + "%"), CompareType.LIKE));
        }
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)"2", CompareType.NOTEQUALS));
        return filter;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.setCanceled(false);
        this.disposeUIWindow();
    }

    protected void refresh(ActionEvent e) throws Exception {
        this.checkBeforeQuery();
        EntityViewInfo viewInfo = new EntityViewInfo();
        if (this.mainQuery != null && this.mainQuery.getSorter() != null) {
            viewInfo.setSorter(this.mainQuery.getSorter());
        }
        this.mainQuery = this.getEntityViewInfo(viewInfo);
        viewInfo.setFilter(this.getDefaultFilterForQuery());
        this.execQuery();
        this.removeDoubleClassGroupPerson();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.removeDoubleClassGroupPerson();
    }

    private void removeDoubleClassGroupPerson() {
        if (this.personIds == null || this.personIds.size() < 1) {
            return;
        }
        Map persionIdsMap = this.setToMap(this.personIds);
        Set indexsSet = this.getIndexsOfDoublePersonIds(persionIdsMap);
        this.removeIndexsFromKdtable(indexsSet);
    }

    private Map setToMap(Set set) {
        HashMap map = new HashMap();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            map.put(it.next(), new Integer("0"));
        }
        return map;
    }

    private Set getIndexsOfDoublePersonIds(Map map) {
        if (this.tblMain == null || this.tblMain.getRowCount() < 1) {
            return null;
        }
        String id = null;
        Integer one = new Integer("1");
        TreeSet<Integer> indexsSet = new TreeSet<Integer>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            id = (String)this.tblMain.getRow(i).getCell("id").getValue();
            if (map.get(id) == null) continue;
            Integer count = (Integer)map.get(id);
            if (count.compareTo(one) >= 0) {
                indexsSet.add(new Integer(i));
                continue;
            }
            if (count.compareTo(one) >= 0) continue;
            count = new Integer(count + 1);
            map.put(id, count);
        }
        return indexsSet;
    }

    private void removeIndexsFromKdtable(Set set) {
        int[] rows = new int[set.size()];
        Iterator iter = set.iterator();
        int k = 0;
        while (iter.hasNext()) {
            rows[k] = (Integer)iter.next();
            ++k;
        }
        Arrays.sort(rows);
        for (int i = 0; i < rows.length; ++i) {
            this.tblMain.removeRow(rows[i] - i);
        }
    }

    private void checkBeforeQuery() {
        if (this.prmtDepartment.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.sfc.AssistantTimeReportResource.DepartmentNotNull"));
            SysUtil.abort();
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2) {
            ActionEvent evt = new ActionEvent(this.btnConfirm, 0, "Double Clicked");
            ItemAction actConfirm = this.getActionFromActionEvent(evt);
            actConfirm.actionPerformed(evt);
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    protected void initKeyStroke() {
        this.tblMain.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "Confirm_1");
        this.tblMain.getActionMap().put("Confirm_1", new AbstractAction(){
            private static final long serialVersionUID = -5669325198048189263L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionEvent evt = new ActionEvent(PersonF7ListUI.this.btnConfirm, 0, "Enter");
                ItemAction actConfirm = PersonF7ListUI.this.getActionFromActionEvent(evt);
                actConfirm.actionPerformed(evt);
            }
        });
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PersonFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext());
    }

    public ArrayList getSelectedIdValues() {
        int mode = 0;
        ArrayList blockList = this.tblMain.getSelectManager().getBlocks();
        if (blockList != null && blockList.size() == 1) {
            mode = ((IBlock)this.tblMain.getSelectManager().getBlocks().get(0)).getMode();
        }
        if (this.isIgnoreRowCount() && mode == 8) {
            this.tblMain.setRowCount(this.getRowCountFromDB());
        }
        this.selectList = new ArrayList();
        List selectKeyIdFields = null;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (mode == 8 && selectRows.length >= KDTDataRequestManager.defaultPageRow - 1) {
            selectKeyIdFields = this.getQueryPkList();
        }
        return ListUiHelper.getSelectedIdValues((KDTable)this.tblMain, (String)this.getKeyFieldName(), (ArrayList)this.selectList, selectKeyIdFields);
    }

    protected void prmtDepartment_dataChanged(DataChangeEvent e) {
        try {
            boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getNewValue(), (Object)e.getOldValue());
            if (isDiffrent) {
                this.tblMain.removeRows(false);
                if (this.personIds != null) {
                    this.personIds.clear();
                }
            }
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    public void removeListener() {
        if (this.departmentDataChanged != null) {
            this.prmtDepartment.removeDataChangeListener(this.departmentDataChanged);
        }
    }

    public void addListener() {
        if (this.departmentDataChanged == null) {
            this.departmentDataChanged = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        PersonF7ListUI.this.prmtDepartment_dataChanged(e);
                    }
                    catch (Exception exc) {
                        PersonF7ListUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtDepartment.addDataChangeListener(this.departmentDataChanged);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getEditUIName() {
        return null;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean isCancel) {
        this.isCanceled = isCancel;
    }
}

