/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.client;

import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.mm.sfc.client.AbstractQuerySelectBaseUI;
import com.kingdee.eas.mm.sfc.util.pac.RequestDataHandler;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public abstract class QuerySelectBaseUI
extends AbstractQuerySelectBaseUI {
    private static final Logger logger = CoreUIObject.getLogger(QuerySelectBaseUI.class);
    private IMetaDataLoader loader = null;
    protected int selectedSiteRow = -1;

    public void onLoad() throws Exception {
        this.initUICtrl();
        super.onLoad();
        this.loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        QueryInfo queryInfo = this.loader.getQuery((IMetaDataPK)MetaDataPK.create((String)this.getQueryInfo()));
        RequestDataHandler handler = new RequestDataHandler(this, this.kDTable, queryInfo, null);
        handler.refresh();
    }

    protected void initUICtrl() {
        KDTableHelper.releaseEnterAndTab((JComponent)this.kDTable);
        KDTableHelper.releaseEsc((JComponent)this.kDTable);
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.kDTable, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.kDTable.getSelectManager().setSelectMode(2);
        this.kDTable.getDataRequestManager().setDataRequestMode(0);
        this.kDTable.getStyleAttributes().setLocked(true);
    }

    protected void initListener() {
        super.initListener();
        this.kDTable.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                QuerySelectBaseUI.this.kdtSelectChange(e);
            }
        });
        this.kDTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2 && e.getType() == 1) {
                    QuerySelectBaseUI.this.selectedSiteRow = e.getRowIndex();
                    QuerySelectBaseUI.this.dealDoubleClick(e);
                }
            }
        });
    }

    private void kdtSelectChange(KDTSelectEvent e) {
        this.selectedSiteRow = e.getSelectBlock().getBeginRow() == e.getSelectBlock().getEndRow() ? e.getSelectBlock().getBeginRow() : -1;
    }

    protected abstract void dealDoubleClick(KDTMouseEvent var1);

    protected abstract String getQueryInfo();
}

