/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.util;

import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.agent.AgentException;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.IUILifeCycleListener;
import com.kingdee.eas.framework.client.UILifeCycleEvent;
import com.kingdee.eas.framework.client.UILifeCycleImp;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.framework.client.multiDetail.DetailPanelEvent;
import com.kingdee.eas.framework.client.multiDetail.IDetailPanelListener;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public abstract class SFCDetailPanel
extends JPanel {
    private static final long serialVersionUID = -7615939512779562985L;
    private static final Logger logger = Logger.getLogger(DetailPanel.class);
    protected KDWorkButton btnAddnewLine;
    protected KDWorkButton btnInsertLine;
    protected KDWorkButton btnRemoveLines;
    protected KDPanel controlPanel;
    protected KDTable entryTable;
    protected KDPanel entryPanel;
    protected KDContainer kdConTitle;
    protected HashMap resourceMap = null;
    protected DataBinder dataBinder = null;
    private AbstractObjectValue newDetailInfo = null;
    private Rectangle rect = null;
    private boolean isAgent = false;
    protected CoreUI ui = null;
    protected KDWorkButton[] kdWorkButtons = null;
    protected String[] workButtonNames = null;
    protected String currentWorkButtonName = null;
    protected KDWorkButton[] addKDWorkButtons = null;
    protected String[] addWorkButtonNames = null;
    private Set addListeners = new HashSet();
    private Set removeListeners = new HashSet();
    private Set insertListeners = new HashSet();

    public SFCDetailPanel(CoreUI ui, DataBinder binder, KDTable kdt, AbstractObjectValue newVO, HashMap resourceMap, boolean isAgent, KDWorkButton[] addKDWorkButtons, String[] addWorkButtonNames) throws Exception {
        this(binder, kdt, newVO, resourceMap, isAgent, addKDWorkButtons, addWorkButtonNames);
        this.ui = ui;
        this.ui.getUILifeCycleHandler().addRuleListener((IUILifeCycleListener)new UILifeListener());
        actionBackListener backListener = new actionBackListener();
        this.addAddListener(backListener);
        this.addInsertListener(backListener);
        this.addRemoveListener(backListener);
    }

    public SFCDetailPanel(DataBinder binder, KDTable kdt, AbstractObjectValue newVO, HashMap resourceMap, boolean isAgent, KDWorkButton[] addKDWorkButtons, String[] addWorkButtonNames) throws Exception {
        this.kdWorkButtons = new KDWorkButton[]{this.btnAddnewLine, this.btnInsertLine, this.btnRemoveLines};
        this.workButtonNames = new String[]{"addNewLine", "insertLine", "removeLines"};
        CtrlUIEnv.setKingdeeLAF();
        this.addKDWorkButtons = addKDWorkButtons;
        this.addWorkButtonNames = addWorkButtonNames;
        this.jbInit();
        this.addListeners();
        if (binder == null) {
            logger.debug((Object)"databinder is not null!");
            return;
        }
        this.dataBinder = binder;
        this.entryTable = kdt;
        if (this.entryTable == null) {
            logger.debug((Object)"kdtable is not null!");
            return;
        }
        this.rect = this.entryTable.getBounds();
        this.newDetailInfo = newVO;
        if (this.newDetailInfo == null) {
            logger.debug((Object)"detailinfo is not null!");
        }
        this.resourceMap = resourceMap;
        this.isAgent = isAgent;
        this.initKDWorkButtion();
        this.initUIContentLayout();
    }

    private void addListeners() {
        for (int i = 0; i < this.kdWorkButtons.length; ++i) {
            this.currentWorkButtonName = this.workButtonNames[i];
            if (this.currentWorkButtonName.equalsIgnoreCase("addNewLine")) {
                this.kdWorkButtons[i].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            SFCDetailPanel.this.actionAddnewLine_actionPerformed(e);
                        }
                        catch (Exception e1) {
                            ExceptionHandler.handle((Throwable)e1);
                        }
                    }
                });
                continue;
            }
            if (this.currentWorkButtonName.equalsIgnoreCase("insertLine")) {
                this.kdWorkButtons[i].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            SFCDetailPanel.this.actionInsertLine_actionPerformed(e);
                        }
                        catch (Exception e1) {
                            ExceptionHandler.handle((Throwable)e1);
                        }
                    }
                });
                continue;
            }
            if (this.currentWorkButtonName.equalsIgnoreCase("removeLines")) {
                this.kdWorkButtons[i].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            SFCDetailPanel.this.actionRemoveLine_actionPerformed(e);
                        }
                        catch (Exception e1) {
                            ExceptionHandler.handle((Throwable)e1);
                        }
                    }
                });
                continue;
            }
            this.otherBtnAddActionListener(i);
        }
    }

    public abstract void otherBtnAddActionListener(int var1);

    private void initStatus(String oprtStatus) {
        if (this.ui != null) {
            boolean enabled = false;
            if (!OprtState.VIEW.equals(oprtStatus)) {
                enabled = true;
            }
            for (int i = 0; i < this.kdWorkButtons.length; ++i) {
                this.kdWorkButtons[i].setEnabled(enabled);
            }
        }
    }

    private void jbInit() throws Exception {
        if (this.addKDWorkButtons != null && this.addWorkButtonNames != null) {
            this.kdWorkButtons = this.mergeArrays(this.kdWorkButtons, this.addKDWorkButtons);
            this.workButtonNames = this.mergeArrays(this.workButtonNames, this.addWorkButtonNames);
        }
        this.kdConTitle = new KDContainer();
        this.kdConTitle.setName("kdDetailCon");
        this.kdConTitle.setBounds(0, 5, 100, 24);
        this.kdConTitle.setContainerType(2);
        this.kdConTitle.setTitleStyle(1);
        this.controlPanel = new KDPanel();
        this.entryTable = new KDTable();
        this.entryPanel = new KDPanel();
        for (int i = 0; i < this.kdWorkButtons.length; ++i) {
            this.kdWorkButtons[i] = new KDWorkButton();
            this.kdWorkButtons[i].setName("btn" + this.workButtonNames[i].substring(0, 1).toUpperCase() + this.workButtonNames[i].substring(1, this.workButtonNames[i].length()));
        }
        this.controlPanel.setName("controlPanel");
        this.entryTable.setName("entryTable");
        this.entryPanel.setName("entryPanel");
    }

    public KDWorkButton getAddNewLineButton() {
        return this.btnAddnewLine;
    }

    public KDWorkButton getInsertLineButton() {
        return this.btnInsertLine;
    }

    public KDWorkButton getRemoveLinesButton() {
        return this.btnRemoveLines;
    }

    public KDTable getEntryTable() {
        return this.entryTable;
    }

    public void initKDWorkButtion() {
        for (int i = 0; i < this.kdWorkButtons.length; ++i) {
            if (this.workButtonNames[i].equalsIgnoreCase("addNewLine")) {
                this.kdWorkButtons[i].setToolTipText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Tip_AddLine"));
                this.kdWorkButtons[i].setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
            }
            if (this.workButtonNames[i].equalsIgnoreCase("insertLine")) {
                this.kdWorkButtons[i].setToolTipText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Tip_InsertLine"));
                this.kdWorkButtons[i].setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
            }
            if (!this.workButtonNames[i].equalsIgnoreCase("removeLines")) continue;
            this.kdWorkButtons[i].setToolTipText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Tip_RemoveLine"));
            this.kdWorkButtons[i].setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        }
    }

    public void initUIContentLayout() {
        this.setBounds(this.entryTable.getBounds());
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(0, 0, this.rect.width, this.rect.height));
        this.setBounds(this.entryTable.getBounds());
        Rectangle controlRect = new Rectangle(0, 0, this.rect.width, 24);
        this.controlPanel.setBounds(controlRect);
        this.controlPanel.putClientProperty((Object)"OriginalBounds", (Object)controlRect);
        Rectangle entryRect = new Rectangle(0, 29, this.rect.width, this.rect.height - 29);
        this.entryPanel.setBounds(entryRect);
        this.entryPanel.putClientProperty((Object)"OriginalBounds", (Object)entryRect);
        this.add((Component)this.controlPanel, new KDLayout.Constraints(13, controlRect));
        this.add((Component)this.entryPanel, new KDLayout.Constraints(15, entryRect));
        this.controlPanel.setLayout((LayoutManager)new KDLayout());
        this.controlPanel.add((Component)this.kdConTitle, (Object)new KDLayout.Constraints(0, 5, 100, 19, 5));
        this.controlPanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, this.rect.width, 24));
        for (int i = 0; i < this.kdWorkButtons.length; ++i) {
            this.controlPanel.add((Component)this.kdWorkButtons[i], (Object)new KDLayout.Constraints(this.rect.width - ((this.kdWorkButtons.length - i) * 24 + 7), 5, 22, 19, 9));
        }
        this.entryPanel.setLayout((LayoutManager)new BorderLayout(0, 0));
        this.entryTable.setBounds(entryRect);
        this.entryPanel.add((Component)this.entryTable, (Object)"Center");
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "sdfdfsdf";
        }
        this.kdConTitle.setTitle(title);
    }

    public void loadFields() {
    }

    public void storeFields() {
    }

    public void actionAddnewLine_actionPerformed(ActionEvent e) throws Exception {
        this.addLine(this.entryTable);
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.insertLine(this.entryTable);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        this.removeLine(this.entryTable);
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        if (table == null) {
            return null;
        }
        if (this.isAgent) {
            EntityObjectInfo entity = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(this.newDetailInfo.getBOSType());
            try {
                Class<?> agentClz = Class.forName(entity.getBusinessAgent());
                Method method = agentClz.getMethod("copyOvAsNewAgent", IObjectValue.class);
                Object obj = method.invoke(agentClz, this.newDetailInfo);
                if (obj instanceof IObjectValue) {
                    return (IObjectValue)obj;
                }
                return null;
            }
            catch (InvocationTargetException e) {
                throw new AgentException("Exception at creating agent instance from BOS value object:" + this.newDetailInfo, e.getCause());
            }
            catch (Exception e) {
                throw new AgentException("Exception at creating agent instance from BOS value object:" + this.newDetailInfo, (Throwable)e);
            }
        }
        return (IObjectValue)this.newDetailInfo.clone();
    }

    private boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    protected void addLine(KDTable table) throws Exception {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table);
        this.fireAddLineBeforeAction(detailData);
        IRow row = table.addRow();
        this.loadLineFields(table, row, detailData);
        this.fireAddLineAfterAction(detailData);
    }

    protected void insertLine(KDTable table) throws Exception {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table);
        this.fireInsertLineBeforeAction(detailData);
        IRow row = null;
        if (table.getSelectManager().size() > 0) {
            int top = table.getSelectManager().get().getTop();
            row = this.isTableColumnSelected(table) ? table.addRow() : table.addRow(top);
        } else {
            row = table.addRow();
        }
        this.loadLineFields(table, row, detailData);
        this.fireInsertLineAfterAction(detailData);
    }

    protected void removeLine(KDTable table) throws Exception {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)this, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        int top = table.getSelectManager().get().getTop();
        if (table.getRow(top) == null) {
            MsgBox.showInfo((Component)this, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        IObjectValue detailData = (IObjectValue)table.getRow(top).getUserObject();
        this.fireRemoveLineBeforeAction(detailData);
        table.removeRow(top);
        IObjectCollection collection = (IObjectCollection)table.getUserObject();
        if (collection == null) {
            logger.error((Object)"collection not be binded to table");
        } else if (detailData != null) {
            collection.removeObject(top);
        }
        this.fireRemoveLineAfterAction(detailData);
    }

    protected IObjectCollection getBindData(KDTable table) {
        return (IObjectCollection)table.getUserObject();
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.loadLineFields(table, row, obj);
    }

    protected void storeLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.storeLineFields(table, row, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAddListener(IDetailPanelListener listener) {
        Set set = this.addListeners;
        synchronized (set) {
            this.addListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInsertListener(IDetailPanelListener listener) {
        Set set = this.insertListeners;
        synchronized (set) {
            this.insertListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoveListener(IDetailPanelListener listener) {
        Set set = this.removeListeners;
        synchronized (set) {
            this.removeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAddLineBeforeAction(IObjectValue vo) throws Exception {
        Iterator iterator;
        Set set = this.addListeners;
        synchronized (set) {
            iterator = new HashSet(this.addListeners).iterator();
        }
        DetailPanelEvent event = new DetailPanelEvent((Object)this, vo);
        while (iterator.hasNext()) {
            IDetailPanelListener listener = (IDetailPanelListener)iterator.next();
            listener.beforeEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAddLineAfterAction(IObjectValue vo) throws Exception {
        Iterator iterator;
        Set set = this.addListeners;
        synchronized (set) {
            iterator = new HashSet(this.addListeners).iterator();
        }
        DetailPanelEvent event = new DetailPanelEvent((Object)this, vo);
        while (iterator.hasNext()) {
            IDetailPanelListener listener = (IDetailPanelListener)iterator.next();
            listener.afterEvent(event);
        }
        this.entryTable.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInsertLineBeforeAction(IObjectValue vo) throws Exception {
        Iterator iterator;
        Set set = this.insertListeners;
        synchronized (set) {
            iterator = new HashSet(this.insertListeners).iterator();
        }
        DetailPanelEvent event = new DetailPanelEvent((Object)this, vo);
        while (iterator.hasNext()) {
            IDetailPanelListener listener = (IDetailPanelListener)iterator.next();
            listener.beforeEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInsertLineAfterAction(IObjectValue vo) throws Exception {
        Iterator iterator;
        Set set = this.insertListeners;
        synchronized (set) {
            iterator = new HashSet(this.insertListeners).iterator();
        }
        DetailPanelEvent event = new DetailPanelEvent((Object)this, vo);
        while (iterator.hasNext()) {
            IDetailPanelListener listener = (IDetailPanelListener)iterator.next();
            listener.afterEvent(event);
        }
        this.entryTable.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRemoveLineBeforeAction(IObjectValue vo) throws Exception {
        Iterator iterator;
        Set set = this.removeListeners;
        synchronized (set) {
            iterator = new HashSet(this.removeListeners).iterator();
        }
        DetailPanelEvent event = new DetailPanelEvent((Object)this, vo);
        while (iterator.hasNext()) {
            IDetailPanelListener listener = (IDetailPanelListener)iterator.next();
            listener.beforeEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRemoveLineAfterAction(IObjectValue vo) throws Exception {
        Iterator iterator;
        Set set = this.removeListeners;
        synchronized (set) {
            iterator = new HashSet(this.removeListeners).iterator();
        }
        DetailPanelEvent event = new DetailPanelEvent((Object)this, vo);
        while (iterator.hasNext()) {
            IDetailPanelListener listener = (IDetailPanelListener)iterator.next();
            listener.afterEvent(event);
        }
        this.entryTable.repaint();
    }

    public KDWorkButton[] getKdWorkButtons() {
        return this.kdWorkButtons;
    }

    public void setKdWorkButtons(KDWorkButton[] kdWorkButtons) {
        this.kdWorkButtons = kdWorkButtons;
    }

    public KDWorkButton[] mergeArrays(KDWorkButton[] originalObjs, KDWorkButton[] addObjs) {
        int i;
        KDWorkButton[] resultObjs = new KDWorkButton[originalObjs.length + addObjs.length];
        for (i = 0; i < originalObjs.length; ++i) {
            resultObjs[i] = originalObjs[i];
        }
        for (i = 0; i < addObjs.length; ++i) {
            resultObjs[i + originalObjs.length] = addObjs[i];
        }
        return resultObjs;
    }

    public String[] mergeArrays(String[] originalObjs, String[] addObjs) {
        int i;
        String[] resultObjs = new String[originalObjs.length + addObjs.length];
        for (i = 0; i < originalObjs.length; ++i) {
            resultObjs[i] = originalObjs[i];
        }
        for (i = 0; i < addObjs.length; ++i) {
            resultObjs[i + originalObjs.length] = addObjs[i];
        }
        return resultObjs;
    }

    class UILifeListener
    extends UILifeCycleImp {
        UILifeListener() {
        }

        public void beforeOnload(UILifeCycleEvent event) {
            CoreUI ui = (CoreUI)event.getSource();
            SFCDetailPanel.this.initStatus(ui.getOprtState());
        }

        public void onSetDataObject(UILifeCycleEvent event) {
            this.beforeOnload(event);
        }
    }

    class actionBackListener
    implements IDetailPanelListener {
        actionBackListener() {
        }

        public void beforeEvent(DetailPanelEvent event) throws Exception {
        }

        public void afterEvent(DetailPanelEvent event) throws Exception {
            if (SFCDetailPanel.this.ui == null) {
                return;
            }
            if (SFCDetailPanel.this.ui instanceof EditUI) {
                EditUI editUI = (EditUI)SFCDetailPanel.this.ui;
                editUI.refreshFootROw(SFCDetailPanel.this.entryTable);
            }
        }
    }
}

