/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleFactory;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleInfo;
import com.kingdee.eas.basedata.scm.im.inv.app.LotRuleServerUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.lot.ILotFacade;
import com.kingdee.eas.mm.lot.LotFacadeFactory;
import com.kingdee.eas.mm.lot.LotParamValueInfo;
import com.kingdee.eas.mm.mo.util.LotFrames;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SFCUntil {
    public static FilterItemInfo getFilterInfo(FilterInfo view, String property) {
        if (view != null && view.getFilterItems() != null && view.getFilterItems().size() > 0) {
            FilterItemInfo itemInfo = null;
            for (int i = 0; i < view.getFilterItems().size(); ++i) {
                itemInfo = view.getFilterItems().get(i);
                if (itemInfo == null || itemInfo.getPropertyName().toLowerCase().indexOf(property.toLowerCase()) < 0) continue;
                return itemInfo;
            }
        }
        return null;
    }

    public static void replaceFilterInfo(FilterInfo view, FilterItemInfo replaceInfo, String property) {
        if (view != null && view.getFilterItems() != null && view.getFilterItems().size() > 0) {
            FilterItemInfo itemInfo = null;
            for (int i = 0; i < view.getFilterItems().size(); ++i) {
                itemInfo = view.getFilterItems().get(i);
                if (itemInfo == null || itemInfo.getPropertyName().toLowerCase().indexOf(property.toLowerCase()) < 0) continue;
                view.getFilterItems().set(i, replaceInfo);
            }
        }
    }

    public static Map getMaterialPlanData(Context ctx, MaterialInfo materialInfo, StorageOrgUnitInfo storageOrgUnit) throws BOSException, EASBizException {
        MaterialInventoryInfo materialInv;
        HashMap<String, Object> map = new HashMap<String, Object>();
        String materialID = materialInfo.getId().toString();
        String storageOrgUnitID = storageOrgUnit.getId().toString();
        SCMEntryDataVO vo = new SCMEntryDataVO();
        SCMEntryDataVO voResult = new SCMEntryDataVO();
        vo.setMaterialInfos(new MaterialInfo[]{materialInfo});
        vo.setStorageOrgUnitInfos(new StorageOrgUnitInfo[]{storageOrgUnit});
        vo.setIsLoadingMaterialPlan(true);
        vo.setIsLoadingMaterialInventory(true);
        vo.setIsLoadingMaterialInfo(false);
        voResult = SCMGroupFacadeFactory.getLocalInstance((Context)ctx).loadComplexData(vo);
        String lotnumber = null;
        String param = "false";
        boolean isIsModifiable = false;
        Map miInfoMap = voResult.getMaterialInventoryInfos();
        String key = materialID + storageOrgUnitID;
        if (miInfoMap != null && miInfoMap.get(key) != null && (materialInv = (MaterialInventoryInfo)voResult.getMaterialInventoryInfos().get(key)).isIsLotNumber()) {
            param = "true";
            map.put("param", param);
            LotFrames lotFrame = null;
            Connection conn = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                LotRuleInfo lotRule = SFCUntil.getProperLotRule(ctx, conn, materialID, storageOrgUnitID);
                if (lotRule != null) {
                    long currentSerial = LotRuleServerUtils.updateLotRuleAssign((Context)ctx, (String)materialID, (LotRuleInfo)lotRule);
                    lotFrame = new LotFrames();
                    lotFrame.setLotRule(lotRule);
                    lotFrame.setCurrentSerial(currentSerial);
                    lotFrame.setSysDate(new Date());
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
            if (lotFrame != null) {
                lotnumber = lotFrame.getLotNumber();
                isIsModifiable = lotFrame.getLotRule().isIsModifiable();
                map.put("lotnumber", lotnumber);
                map.put("isIsModifiable", new Boolean(isIsModifiable));
            }
        }
        ILotFacade ilot = null;
        ilot = ctx != null ? LotFacadeFactory.getLocalInstance((Context)ctx) : LotFacadeFactory.getRemoteInstance();
        LotParamValueInfo lotParamInfo = ilot.getLotParamValueByOrg(storageOrgUnit.getId().toString());
        map.put("lotParamInfo", lotParamInfo);
        return map;
    }

    private static LotRuleInfo getProperLotRule(Context ctx, Connection conn, String materialID, String souID) throws BOSException, EASBizException {
        ResultSet rsRuleByMGroup;
        ResultSet rsRuleByMaterial;
        ResultSet rsSou;
        ResultSet rsMaterial;
        PreparedStatement stmtRuleByMGroup;
        PreparedStatement stmtRuleByMaterial;
        PreparedStatement stmtSou;
        PreparedStatement stmtMaterial;
        block15: {
            LotRuleInfo lotRuleInfo;
            String[] souLongNumbers;
            String[] mgLongNumbers;
            block14: {
                LotRuleInfo lotRule;
                String souLongNumber;
                String mgLongNumber;
                block13: {
                    block12: {
                        stmtMaterial = null;
                        stmtSou = null;
                        stmtRuleByMaterial = null;
                        stmtRuleByMGroup = null;
                        rsMaterial = null;
                        rsSou = null;
                        rsRuleByMaterial = null;
                        rsRuleByMGroup = null;
                        StringBuffer sbSqlMaterial = new StringBuffer();
                        sbSqlMaterial.append("SELECT mg.FLongNumber AS mgLongNumber ").append("FROM T_BD_Material m INNER JOIN T_BD_MaterialGroup mg ON m.FMaterialGroupID=mg.FID ").append("WHERE m.FID=?");
                        stmtMaterial = conn.prepareStatement(sbSqlMaterial.toString());
                        stmtMaterial.setString(1, materialID);
                        rsMaterial = stmtMaterial.executeQuery();
                        mgLongNumber = null;
                        if (rsMaterial.next()) {
                            mgLongNumber = rsMaterial.getString("mgLongNumber");
                            break block12;
                        }
                        LotRuleInfo lotRuleInfo2 = null;
                        SQLUtils.cleanup((ResultSet)rsMaterial, (Statement)stmtMaterial);
                        SQLUtils.cleanup(rsSou, stmtSou);
                        SQLUtils.cleanup(rsRuleByMaterial, stmtRuleByMaterial);
                        SQLUtils.cleanup(rsRuleByMGroup, stmtRuleByMGroup);
                        return lotRuleInfo2;
                    }
                    StringBuffer sbSqlSou = new StringBuffer();
                    sbSqlSou.append("SELECT FLongNumber FROM T_ORG_Storage WHERE FID=?");
                    stmtSou = conn.prepareStatement(sbSqlSou.toString());
                    stmtSou.setString(1, souID);
                    rsSou = stmtSou.executeQuery();
                    souLongNumber = null;
                    if (rsSou.next()) {
                        souLongNumber = rsSou.getString("FLongNumber");
                        break block13;
                    }
                    LotRuleInfo lotRuleInfo3 = null;
                    SQLUtils.cleanup((ResultSet)rsMaterial, (Statement)stmtMaterial);
                    SQLUtils.cleanup((ResultSet)rsSou, (Statement)stmtSou);
                    SQLUtils.cleanup(rsRuleByMaterial, stmtRuleByMaterial);
                    SQLUtils.cleanup(rsRuleByMGroup, stmtRuleByMGroup);
                    return lotRuleInfo3;
                }
                mgLongNumbers = SFCUntil.parseLongNumber(mgLongNumber);
                souLongNumbers = SFCUntil.parseLongNumber(souLongNumber);
                StringBuffer sbSqlRuleByMaterial = new StringBuffer();
                sbSqlRuleByMaterial.append("SELECT TOP 1 lr.FID AS ruleID ").append("FROM T_IN_LotRule lr INNER JOIN T_BD_Material m ON lr.FBusinessObjectID = m.FID ").append("INNER JOIN T_ORG_Storage s ON lr.FSouID = s.FID ").append("WHERE FEnabled = 2 AND m.FID='").append(materialID).append("' AND s.FLongNumber IN (");
                for (int i = 0; i < souLongNumbers.length; ++i) {
                    sbSqlRuleByMaterial.append("'").append(souLongNumbers[i]).append("'");
                    if (i == souLongNumbers.length - 1) continue;
                    sbSqlRuleByMaterial.append(",");
                }
                sbSqlRuleByMaterial.append(") ORDER BY s.FLongNumber DESC");
                stmtRuleByMaterial = conn.prepareStatement(sbSqlRuleByMaterial.toString());
                rsRuleByMaterial = stmtRuleByMaterial.executeQuery();
                if (!rsRuleByMaterial.next()) break block14;
                String ruleID = rsRuleByMaterial.getString("ruleID");
                LotRuleInfo lotRuleInfo4 = lotRule = LotRuleFactory.getLocalInstance((Context)ctx).getLotRuleInfo((IObjectPK)new ObjectUuidPK(ruleID));
                SQLUtils.cleanup((ResultSet)rsMaterial, (Statement)stmtMaterial);
                SQLUtils.cleanup((ResultSet)rsSou, (Statement)stmtSou);
                SQLUtils.cleanup((ResultSet)rsRuleByMaterial, (Statement)stmtRuleByMaterial);
                SQLUtils.cleanup(rsRuleByMGroup, stmtRuleByMGroup);
                return lotRuleInfo4;
            }
            try {
                LotRuleInfo lotRule;
                int i;
                StringBuffer sb = new StringBuffer();
                sb.append("SELECT TOP 1 lr.FID AS ruleID ").append("FROM T_IN_LotRule lr INNER JOIN T_BD_MaterialGroup mg ON lr.FBusinessObjectID = mg.FID ").append("INNER JOIN T_ORG_Storage s ").append("ON lr.FSouID = s.FID ").append("WHERE FEnabled = 2 AND mg.FLongNumber IN (");
                for (i = 0; i < mgLongNumbers.length; ++i) {
                    sb.append("'").append(mgLongNumbers[i]).append("'");
                    if (i == mgLongNumbers.length - 1) continue;
                    sb.append(",");
                }
                sb.append(") AND s.FLongNumber IN(");
                for (i = 0; i < souLongNumbers.length; ++i) {
                    sb.append("'").append(souLongNumbers[i]).append("'");
                    if (i == souLongNumbers.length - 1) continue;
                    sb.append(",");
                }
                sb.append(") ORDER BY mg.FLongNumber DESC, s.FLongNumber DESC");
                stmtRuleByMGroup = conn.prepareStatement(sb.toString());
                rsRuleByMGroup = stmtRuleByMGroup.executeQuery();
                if (!rsRuleByMGroup.next()) break block15;
                String ruleID = rsRuleByMGroup.getString("ruleID");
                lotRuleInfo = lotRule = LotRuleFactory.getLocalInstance((Context)ctx).getLotRuleInfo((IObjectPK)new ObjectUuidPK(ruleID));
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rsMaterial, stmtMaterial);
                    SQLUtils.cleanup(rsSou, stmtSou);
                    SQLUtils.cleanup(rsRuleByMaterial, stmtRuleByMaterial);
                    SQLUtils.cleanup(rsRuleByMGroup, stmtRuleByMGroup);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rsMaterial, (Statement)stmtMaterial);
            SQLUtils.cleanup((ResultSet)rsSou, (Statement)stmtSou);
            SQLUtils.cleanup((ResultSet)rsRuleByMaterial, (Statement)stmtRuleByMaterial);
            SQLUtils.cleanup((ResultSet)rsRuleByMGroup, (Statement)stmtRuleByMGroup);
            return lotRuleInfo;
        }
        SQLUtils.cleanup((ResultSet)rsMaterial, (Statement)stmtMaterial);
        SQLUtils.cleanup((ResultSet)rsSou, (Statement)stmtSou);
        SQLUtils.cleanup((ResultSet)rsRuleByMaterial, (Statement)stmtRuleByMaterial);
        SQLUtils.cleanup((ResultSet)rsRuleByMGroup, (Statement)stmtRuleByMGroup);
        return null;
    }

    private static String[] parseLongNumber(String longNumber) {
        if (longNumber == null) {
            return null;
        }
        String split = "!";
        ArrayList<String> list = new ArrayList<String>();
        list.add(longNumber);
        while (longNumber.lastIndexOf(split) >= 0) {
            longNumber = longNumber.substring(0, longNumber.lastIndexOf(split));
            list.add(longNumber);
        }
        String[] longNumbers = new String[list.size()];
        list.toArray(longNumbers);
        return longNumbers;
    }

    public static Map getMaxOperationNo(Context ctx, List orderIdList) throws BOSException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        String sql = "select max(entry.FOPERATIONNO) as MAXNO , entry.FPARENTID as orderID from T_MM_MFTORDERTECHNICS entry where entry.FOPERATIONNO is not null  and entry.FPARENTID IN (" + SQLUtil.arrayToString((Object[])orderIdList.toArray(new String[0])) + ") group by entry.FPARENTID ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs != null && rs.size() > 0) {
            try {
                while (rs.next()) {
                    result.put(rs.getString("orderID"), new Integer(rs.getInt("MAXNO")));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    public static Date floorDateToDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }
}

