/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.util.pac;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.sfc.util.pac.ContainerLayoutUtil;
import com.kingdee.eas.mm.sfc.util.pac.PACConstant;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class DataFilterHandler {
    private KDTable table = null;
    private Map filterControls = new HashMap();
    private Map filterConditions = new HashMap();
    private int columnCount = 3;
    private int columnWidth = 270;

    public DataFilterHandler(KDTable table) {
        this.table = table;
    }

    public void initialize(KDPanel filterPanel, String[] filterFields, String[] fieldNames) {
        KDLabelContainer container;
        ArrayList<KDLabelContainer> list = new ArrayList<KDLabelContainer>();
        int n = filterFields.length;
        for (int i = 0; i < n; ++i) {
            String field = filterFields[i];
            String fieldName = fieldNames[i];
            container = new KDLabelContainer();
            container.setName("kDLabelContainer" + String.valueOf(i));
            container.setBoundLabelText(fieldName);
            container.setBoundLabelLength(100);
            container.setBoundLabelUnderline(true);
            container.setBounds(new Rectangle(10, 10, this.columnWidth, 19));
            KDComboBox comboBox = new KDComboBox();
            comboBox.setName(field);
            this.setDefaultItem(comboBox);
            comboBox.addActionListener((ActionListener)new SelectedItemChangedListener());
            container.setBoundEditor((JComponent)comboBox);
            this.filterControls.put(field, comboBox);
            list.add(container);
        }
        KDPanel filterUI = new KDPanel();
        filterUI.setName("filterConditionPanel");
        filterUI.setBorder((Border)new TitledBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 255), new Color(148, 145, 140)), EASResource.getString((String)"com.kingdee.eas.mm.sfc.PACResource", (String)"DATAFILTER")));
        filterUI.setBounds(new Rectangle(0, 0, 853, 49));
        filterUI.setLayout((LayoutManager)new KDLayout());
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            container = (KDLabelContainer)list.get(i);
            ContainerLayoutUtil.setContainerLayout((Container)filterUI, container, this.columnWidth, this.columnCount, i);
        }
        filterPanel.add((Component)filterUI, (Object)new KDLayout.Constraints(0, 0, 853, 49, 261));
        filterUI.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 853, 49));
        this.initListener();
    }

    private void initListener() {
        this.table.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                DataFilterHandler.this.doFilterItermRefresh();
            }
        });
    }

    public void doFilterItermRefresh() {
        int size = this.table.getRowCount();
        if (size > 0) {
            HashMap<String, Object[]> filterDatas = new HashMap<String, Object[]>();
            for (String filed : this.filterControls.keySet()) {
                HashSet<Object> filterData = new HashSet<Object>();
                for (int j = 0; j < size; ++j) {
                    IRow row = this.table.getRow(j);
                    filterData.add(row.getCell(filed).getValue());
                }
                filterDatas.put(filed, filterData.toArray());
            }
            this.refreshFiletrControls(filterDatas);
        } else {
            this.refreshFiletrControls(null);
        }
    }

    private void doFilter() {
        if (this.table == null || this.table.getRowCount() == 0) {
            return;
        }
        this.table.getSelectManager().removeAll();
        int n = this.table.getRowCount();
        for (int i = 0; i < n; ++i) {
            boolean isHided = this.table.getRow(i).getStyleAttributes().isHided();
            boolean setHide = false;
            for (String field : this.filterConditions.keySet()) {
                Object filterData = this.filterConditions.get(field);
                if (this.compareObject(filterData, this.table.getCell(i, field).getValue())) continue;
                setHide = true;
                break;
            }
            if (isHided == setHide) continue;
            if (setHide && this.table.getCell(i, "isSelected") != null) {
                this.table.getCell(i, "isSelected").setValue((Object)Boolean.FALSE);
            }
            this.table.getRow(i).getStyleAttributes().setHided(setHide);
        }
    }

    private boolean compareObject(Object one, Object other) {
        if (one == null || other == null) {
            return false;
        }
        if (one instanceof CoreBaseInfo && other instanceof CoreBaseInfo) {
            return ((CoreBaseInfo)one).getId().equals((Object)((CoreBaseInfo)other).getId());
        }
        return one.toString().equals(other.toString());
    }

    private void setDefaultItem(KDComboBox comboBox) {
        comboBox.addItem((Object)PACConstant.FILTERITEM_ALL);
    }

    private void refreshFiletrControls(Map filterDatas) {
        this.clearFilterControls();
        if (filterDatas != null && filterDatas.size() > 0) {
            for (String field : filterDatas.keySet()) {
                Object[] filterData = (Object[])filterDatas.get(field);
                KDComboBox comboBox = (KDComboBox)this.filterControls.get(field);
                comboBox.addItems(filterData);
            }
        }
    }

    private void clearFilterControls() {
        for (String field : this.filterControls.keySet()) {
            KDComboBox comboBox = (KDComboBox)this.filterControls.get(field);
            comboBox.removeAllItems();
            this.setDefaultItem(comboBox);
        }
    }

    public void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
    }

    public void setColumnWidth(int columnWidth) {
        this.columnWidth = columnWidth;
    }

    public void doFilter(Map filters) {
        this.filterConditions = filters;
        this.doFilter();
    }

    class SelectedItemChangedListener
    implements ActionListener {
        Object oldItem;

        SelectedItemChangedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KDComboBox cb = (KDComboBox)e.getSource();
            if (cb.getItemCount() == 0) {
                return;
            }
            Object newItem = cb.getSelectedItem();
            boolean same = newItem.equals(this.oldItem);
            if (!same) {
                this.oldItem = newItem;
                if ("comboBoxChanged".equals(e.getActionCommand())) {
                    Object s = newItem;
                    if (!s.toString().equalsIgnoreCase(PACConstant.FILTERITEM_ALL)) {
                        DataFilterHandler.this.filterConditions.put(cb.getName(), newItem);
                    } else {
                        DataFilterHandler.this.filterConditions.remove(cb.getName());
                    }
                }
                DataFilterHandler.this.doFilter();
            }
        }
    }
}

