/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.util.pac;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.mm.sfc.util.pac.IPromptBoxFactory;

public class DefaultPromptBoxFactory
implements IPromptBoxFactory {
    private CoreUI uiObj = null;

    public DefaultPromptBoxFactory(CoreUI uiObj) {
        this.uiObj = uiObj;
    }

    @Override
    public KDBizPromptBox create(String f7QueryName) {
        KDBizPromptBox f7Ctrl = new KDBizPromptBox();
        String displayFormat = "$number$";
        String editFormat = "$number$";
        String commitFormat = "$number$";
        f7Ctrl.setDisplayFormat(displayFormat);
        f7Ctrl.setEditFormat(editFormat);
        f7Ctrl.setCommitFormat(commitFormat);
        if (f7QueryName != null && !f7QueryName.trim().equalsIgnoreCase("")) {
            f7Ctrl.setQueryInfo(f7QueryName);
        }
        return f7Ctrl;
    }

    @Override
    public KDBizPromptBox create(String f7QueryName, String orgProperty) {
        KDBizPromptBox f7Ctrl = this.create(f7QueryName);
        this.addF7SelectorListener(f7Ctrl, orgProperty);
        this.addF7CommitListener(f7Ctrl, orgProperty);
        return f7Ctrl;
    }

    private void addF7SelectorListener(final KDBizPromptBox f7, final String orgProperty) {
        f7.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                DefaultPromptBoxFactory.this.setMainBizOrgs(f7, orgProperty);
            }
        });
    }

    private void addF7CommitListener(final KDBizPromptBox f7, final String orgProperty) {
        f7.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                DefaultPromptBoxFactory.this.setMainBizOrgs(f7, orgProperty);
            }
        });
    }

    private void setMainBizOrgs(KDBizPromptBox f7, String orgProperty) {
        OrgUnitInfo value = this.uiObj.getMainOrgInfo();
        EntityViewInfo view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = this.getFilterInfo(orgProperty, value.getId().toString());
        try {
            if (view.getFilter() != null && view.getFilter().getFilterItems().size() > 0) {
                view.getFilter().mergeFilter(filter, "and");
            } else {
                view.setFilter(filter);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        f7.setEntityViewInfo(view);
        f7.getQueryAgent().resetRuntimeEntityView();
    }

    private FilterInfo getFilterInfo(String orgProperty, String id) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(orgProperty, (Object)id));
        return filterInfo;
    }
}

