/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.util.pac;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntry;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.popup.MenuSection;
import com.kingdee.eas.framework.client.popup.PopupMenuManager;
import com.kingdee.eas.scm.common.action.ISupportBatchAction;
import com.kingdee.eas.scm.common.action.ITableSelectionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

public class MMTableSelectionHelper
implements ITableSelectionHelper {
    private String idColName;
    private String orgIdColName;
    private String numberColName;
    private KDTable tblMain;
    private String entryIdColName;
    private String entrySeqColName;
    private CoreUI uiObj;
    private static final String KEY_ISSELECTED = "isSelected";
    private boolean supportBatchAction;
    private Map idMap;
    private String rowKey;

    public void setTablePropertyForBatchAction(String idColName, String entryIdColName, String numberColName, String entrySeqColName, String orgIdColName) {
        this.idColName = idColName;
        this.entryIdColName = entryIdColName;
        this.numberColName = numberColName;
        this.entrySeqColName = entrySeqColName;
        this.orgIdColName = orgIdColName;
        this.addMenuToTable();
        this.tblMain.getColumn(KEY_ISSELECTED).getStyleAttributes().setLocked(false);
        this.supportBatchAction = true;
    }

    public void setTableProperty() {
        this.addMenuToTable();
        this.tblMain.getColumn(KEY_ISSELECTED).getStyleAttributes().setLocked(false);
        this.supportBatchAction = false;
    }

    protected BatchSelectionEntry getSelectionEntry(IRow row, ActionLevelEnum actionLevel) throws BOSException {
        BatchSelectionEntry entry = new BatchSelectionEntry();
        if (!this.supportBatchAction) {
            return entry;
        }
        entry.setId((String)this.getCellValue(row.getCell(this.idColName)));
        entry.setNumber((String)this.getCellValue(row.getCell(this.numberColName)));
        if (actionLevel.equals((Object)ActionLevelEnum.ENTRY)) {
            String entryId = (String)this.getCellValue(row.getCell(this.entryIdColName));
            if (entryId == null) {
                return null;
            }
            entry.setEntryId(entryId);
            entry.setSeq(((Integer)this.getCellValue(row.getCell(this.entrySeqColName))).intValue());
        }
        entry.setRowNum(row.getRowIndex());
        entry.setOrgId((String)this.getCellValue(row.getCell(this.orgIdColName)));
        return entry;
    }

    public MMTableSelectionHelper(CoreUI uiObj, KDTable table, String rowKey) {
        this.uiObj = uiObj;
        this.tblMain = table;
        this.rowKey = rowKey;
        this.idMap = new HashMap();
        this.initListener();
    }

    private void initListener() {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                MMTableSelectionHelper.this.initIDMap();
            }
        });
    }

    public void initIDMap() {
        this.idMap.clear();
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            String id = (String)this.tblMain.getCell(i, this.rowKey).getValue();
            this.idMap.put(id, new Integer(i));
        }
    }

    public int getRowIndex(String id) {
        Integer index = (Integer)this.idMap.get(id);
        if (index == null) {
            return -1;
        }
        return index;
    }

    private void addMenuToTable() {
        PopupMenuManager mgr = this.uiObj.getPopupMenuManager((JComponent)this.tblMain);
        if (mgr == null) {
            this.uiObj.addCommonMenusToTable(this.tblMain);
        }
        mgr = this.uiObj.getPopupMenuManager((JComponent)this.tblMain);
        MenuSection section = mgr.findMenuSection("edit");
        section.insertAfter((JMenuItem)this.getSelectedMenuItem(this.tblMain));
        section.insertAfter((JMenuItem)this.getCancelSelectedMenuItem(this.tblMain));
    }

    private KDMenuItem getSelectedMenuItem(KDTable table) {
        KDMenuItem item = new KDMenuItem();
        item.setName("selected");
        item.setAction((Action)((Object)new ActionSelected(table)));
        item.setText(EASResource.getString((String)"com.kingdee.eas.mm.sfc.PACResource", (String)"SELECTED"));
        item.setToolTipText(EASResource.getString((String)"com.kingdee.eas.mm.sfc.PACResource", (String)"SELECTED"));
        return item;
    }

    private KDMenuItem getCancelSelectedMenuItem(KDTable table) {
        KDMenuItem item = new KDMenuItem();
        item.setName("cancelSelected");
        item.setAction((Action)((Object)new ActionCancelSelected(table)));
        item.setText(EASResource.getString((String)"com.kingdee.eas.mm.sfc.PACResource", (String)"CANCEL_SELECTED"));
        item.setToolTipText(EASResource.getString((String)"com.kingdee.eas.mm.sfc.PACResource", (String)"CANCEL_SELECTED"));
        return item;
    }

    public void refresh(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, int countSuccess) throws Exception {
        if (this.uiObj instanceof ISupportBatchAction) {
            ((ISupportBatchAction)this.uiObj).refresh(bizAction, selectionEntries, countSuccess);
        }
    }

    protected void selectFirstRow() {
        if (this.tblMain.getRow(0) != null) {
            this.tblMain.getSelectManager().select(0, 0);
        }
    }

    public IObjectPK getOrgPK(ItemAction action) {
        if (!this.supportBatchAction) {
            return null;
        }
        if (this.tblMain == null) {
            return null;
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            Object keyValue;
            int rowIndex = selectRows[0];
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell(this.orgIdColName);
            if (cell == null) {
                MsgBox.showError((String)"TableSelectionHelper: the main orgunit column name is not right.");
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return new ObjectStringPK(keyValue.toString());
            }
        }
        return null;
    }

    public KDTable getTblMain() {
        return this.tblMain;
    }

    protected BatchSelectionEntries getSelectedMultiIDs(Context mainOrgContext, ActionLevelEnum actionLevel, int[] selectRows) throws BOSException {
        BatchSelectionEntries results = new BatchSelectionEntries(actionLevel, selectRows.length);
        HashSet<Object> keySet = new HashSet<Object>();
        for (int i = 0; i < selectRows.length; ++i) {
            BatchSelectionEntry entry;
            IRow row = this.tblMain.getRow(selectRows[i]);
            if (actionLevel.equals((Object)ActionLevelEnum.HEAD)) {
                Object id = this.getCellValue(row.getCell(this.idColName));
                if (keySet.contains(id)) continue;
                keySet.add(id);
            }
            if ((entry = this.getSelectionEntry(row, actionLevel)) == null) continue;
            results.add(entry);
        }
        return results;
    }

    protected final Object getCellValue(ICell cell) throws BOSException {
        if (cell == null) {
            throw new IllegalArgumentException("TableSelectionHelper.setTableProperty: the column name in parameters is incorrect.");
        }
        return cell.getValue();
    }

    public boolean hasSelectedRows(ActionLevelEnum actionLevel) {
        boolean ret = false;
        int[] rows = this.getSelectedRows();
        if (rows.length > 0) {
            ret = true;
        }
        return ret;
    }

    public BatchSelectionEntries getSelectedIDs(Context mainOrgContext, ActionLevelEnum actionLevel) throws BOSException {
        int[] selectRows = this.getSelectedRows();
        return this.getSelectedMultiIDs(mainOrgContext, actionLevel, selectRows);
    }

    public int[] getSelectedRows() {
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException ex) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Control_Error"));
            this.uiObj.setCursorOfDefault(null);
            SysUtil.abort();
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            Boolean isSelected = (Boolean)this.tblMain.getCell(i, KEY_ISSELECTED).getValue();
            if (isSelected == null || !isSelected.booleanValue()) continue;
            list.add(new Integer(i));
        }
        if (list.size() < 1) {
            MsgBox.showInfo((Component)this.uiObj, (String)EASResource.getString((String)"com.kingdee.eas.mm.sfc.PACResource", (String)"SELECTED_NOTHING"));
            SysUtil.abort();
        }
        int[] rows = new int[list.size()];
        int k = 0;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            rows[k] = (Integer)iter.next();
            ++k;
        }
        return rows;
    }

    public List getSelectedDataList(String[] columnNames) {
        ArrayList<Object[]> toDoParams = new ArrayList<Object[]>();
        int[] selectRows = this.getSelectedRows();
        Object[] params = null;
        int rowIndex2 = 0;
        for (int rowIndex2 : selectRows) {
            params = new Object[columnNames.length];
            int m = columnNames.length;
            for (int k = 0; k < m; ++k) {
                Object o;
                params[k] = o = this.tblMain.getCell(rowIndex2, columnNames[k]).getValue();
            }
            toDoParams.add(params);
        }
        return toDoParams;
    }

    public Map getSelectedDataMap(String[] columnNames) {
        HashMap<String, Object[]> toDoParams = new HashMap<String, Object[]>();
        int[] selectRows = this.getSelectedRows();
        Object[] params = null;
        int rowIndex2 = 0;
        for (int rowIndex2 : selectRows) {
            params = new Object[columnNames.length];
            int m = columnNames.length;
            for (int k = 0; k < m; ++k) {
                Object o;
                params[k] = o = this.tblMain.getCell(rowIndex2, columnNames[k]).getValue();
            }
            String id = (String)this.tblMain.getCell(rowIndex2, this.rowKey).getValue();
            toDoParams.put(id, params);
        }
        return toDoParams;
    }

    public List getSelectedKeyDataList() {
        ArrayList<String> toDoParams = new ArrayList<String>();
        int[] selectRows = this.getSelectedRows();
        int rowIndex2 = 0;
        for (int rowIndex2 : selectRows) {
            String id = (String)this.tblMain.getCell(rowIndex2, this.rowKey).getValue();
            toDoParams.add(id);
        }
        return toDoParams;
    }

    public void setRowSelectedStatus(boolean isSelected) {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.tblMain.getCell(i, KEY_ISSELECTED).setValue((Object)isSelected);
        }
    }

    public List getSelectedUserObjectList() {
        ArrayList<Object> toDoParams = new ArrayList<Object>();
        int[] selectRows = this.getSelectedRows();
        int rowIndex2 = 0;
        for (int rowIndex2 : selectRows) {
            toDoParams.add(this.tblMain.getRow(rowIndex2).getUserObject());
        }
        return toDoParams;
    }

    public int getSelectedEntrySize(Context mainOrgContext, ActionLevelEnum actionLevel) throws BOSException {
        return 0;
    }

    private class ActionCancelSelected
    extends ItemAction {
        private KDTable t;

        public ActionCancelSelected(KDTable t) {
            this.t = t;
        }

        public void actionPerformed(ActionEvent e) {
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.t);
            int n = selectRows.length;
            for (int i = 0; i < n; ++i) {
                this.t.getCell(selectRows[i], MMTableSelectionHelper.KEY_ISSELECTED).setValue((Object)Boolean.FALSE);
            }
        }
    }

    private class ActionSelected
    extends ItemAction {
        private KDTable t;

        public ActionSelected(KDTable t) {
            this.t = t;
        }

        public void actionPerformed(ActionEvent e) {
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.t);
            int n = selectRows.length;
            for (int i = 0; i < n; ++i) {
                if (this.t.getRow(selectRows[i]).getStyleAttributes().isHided()) continue;
                this.t.getCell(selectRows[i], MMTableSelectionHelper.KEY_ISSELECTED).setValue((Object)Boolean.TRUE);
            }
        }
    }
}

