/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.util.pac;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.extendcontrols.util.BosHelper;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.PropertyRefCollection;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.QueryFieldCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.QueryPKInfo;
import com.kingdee.bos.metadata.query.QuerySorterItemCollection;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class RequestDataHandler {
    private KDTable table = null;
    private boolean refresh = false;
    private EntityViewInfo currViewInfo;
    private QueryInfo queryInfo = null;
    private IQueryExecutor queryExecutor = null;
    private String[] tablePks = null;
    private IRowSet rowSet;
    private SorterItemCollection defaultSorter;

    public RequestDataHandler(CoreUI owner, KDTable table, QueryInfo queryInfo, String[] pks) {
        this.table = table;
        this.queryInfo = queryInfo;
        if (pks != null) {
            this.tablePks = pks;
        } else {
            this.initTablePKs();
        }
        this.initTableHead();
        this.initTableListener(owner);
    }

    protected boolean isRefresh() {
        return this.refresh;
    }

    protected void setRefresh(boolean refresh2) {
        this.refresh = refresh2;
    }

    public void doRequestData(EntityViewInfo view) {
        this.currViewInfo = view;
        this.refresh();
    }

    public void refresh() {
        this.clearTable();
        this.setRefresh(true);
        this.table.refresh();
        this.setRefresh(false);
    }

    private void clearTable() {
        this.table.removeRows(false);
    }

    private void initTableHead() {
        QueryFieldInfo field;
        SelectorInfo selector = this.queryInfo.getSelector();
        int size = selector.getFields().size();
        String[] bindContents = new String[size];
        Map exProperties = null;
        for (int i = 0; i < size; ++i) {
            String sTemp;
            IColumn col = this.table.addColumn(i);
            field = (QueryFieldInfo)selector.getFields().get(i);
            exProperties = field.getExtendedProperties();
            try {
                ConstDataType cdt = field.getReturnType();
                if (cdt != null) {
                    if (cdt.equals((Object)ConstDataType.INT) || cdt.equals((Object)ConstDataType.NUMBER)) {
                        col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    }
                    if (cdt.equals((Object)ConstDataType.INT) && this.isEnumField(field)) {
                        col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
                    }
                    if (cdt.equals((Object)ConstDataType.NUMBER)) {
                        col.getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
                    }
                    if (cdt.equals((Object)ConstDataType.TIMESTAMP)) {
                        col.getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateTimeFormatString());
                    }
                }
            }
            catch (BOSException cdt) {
                // empty catch block
            }
            bindContents[i] = field.getName();
            col.setKey(bindContents[i]);
            if (exProperties == null) continue;
            Object visible = exProperties.get("isVisibleForKDTable");
            if (visible instanceof Boolean) {
                col.getStyleAttributes().setHided((Boolean)visible == false);
            } else if (visible instanceof String) {
                col.getStyleAttributes().setHided(!KDCommonPromptDialog.stringToboolean((String)((String)visible)));
            }
            Object colWidth = exProperties.get("ColWidthInKDTable");
            if (colWidth == null) {
                colWidth = exProperties.get("colWidthInKDTable");
            }
            if (colWidth != null) {
                if (colWidth instanceof Integer) {
                    col.setWidth(((Integer)colWidth).intValue());
                } else if (colWidth instanceof String) {
                    col.setWidth(KDCommonPromptDialog.stringToint((String)((String)colWidth)));
                }
            } else {
                col.setWidth(100);
            }
            Object colFormat = exProperties.get("displayFormat");
            if (!(colFormat instanceof String) || StringUtil.isEmptyString((String)(sTemp = (String)colFormat))) continue;
            col.getStyleAttributes().setNumberFormat(sTemp);
        }
        this.table.putBindContents("query", bindContents);
        this.table.setFormatXml("");
        this.table.checkParsed(true);
        IRow row = this.table.addHeadRow();
        for (int i = 0; i < size; ++i) {
            field = (QueryFieldInfo)selector.getFields().get(i);
            String displayName = field.getDisplayName(SysContext.getSysContext().getLocale());
            row.getCell(i).setValue((Object)displayName);
        }
    }

    private boolean isEnumField(QueryFieldInfo qfi) {
        OwnPropertyInfo opi;
        boolean isEnum = false;
        PropertyRefCollection pfc = qfi.getPropertyRefs();
        PropertyRefInfo pri = pfc.get(0);
        PropertyInfo pi = pri.getRefProperty();
        if (pi instanceof OwnPropertyInfo && (opi = (OwnPropertyInfo)pi).getDataType().equals((Object)DataType.ENUM)) {
            isEnum = true;
        }
        return isEnum;
    }

    private void initTableListener(final CoreUI owner) {
        this.table.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
                try {
                    RequestDataHandler.this.kdtTable_doRequestRowSet(e);
                }
                catch (BOSException ex) {
                    owner.handUIExceptionAndAbort((Exception)((Object)ex));
                }
            }
        });
    }

    private void kdtTable_doRequestRowSet(RequestRowSetEvent e) throws BOSException {
        if (!this.isRefresh()) {
            return;
        }
        int start = (Integer)e.getParam1();
        int length = (Integer)e.getParam2() - start + 1;
        if (this.queryExecutor == null) {
            MetaDataPK metaDataPK = MetaDataPK.create((String)this.queryInfo.getPackage(), (String)this.queryInfo.getName());
            this.queryExecutor = BosHelper.createQueryExecutor((MetaDataPK)metaDataPK);
        }
        if (this.currViewInfo != null && this.currViewInfo.getSorter() != null && this.currViewInfo.getSorter().size() > 0) {
            this.queryExecutor.option().isIgnoreOrder = true;
            this.defaultSorter = this.currViewInfo.getSorter();
        } else {
            this.queryExecutor.option().isIgnoreOrder = false;
            this.defaultSorter = this.getDefaultSorterFromQueryInfo();
        }
        this.queryExecutor.option().isAutoIgnoreZero = false;
        this.queryExecutor.setObjectView(this.currViewInfo);
        this.rowSet = this.queryExecutor.executeQuery(start, length);
        this.customFormatRowSet();
        e.setRowSet(this.rowSet);
        this.table.setRowCount(this.queryExecutor.getRowCount());
    }

    private void customFormatRowSet() {
    }

    private SorterItemCollection getDefaultSorterFromQueryInfo() {
        SorterItemCollection sorter = new SorterItemCollection();
        QuerySorterItemCollection querySorter = this.queryInfo.getDefaultSorters();
        int n = querySorter.size();
        for (int i = 0; i < n; ++i) {
            sorter.add((SorterItemInfo)querySorter.get(i));
        }
        return sorter;
    }

    public boolean isModify(String[] columnNames) throws BOSException {
        Object o;
        int k;
        int m;
        HashMap<Object, Object[]> tableDatas = new HashMap<Object, Object[]>();
        Object[] params = null;
        String pk = null;
        int n = this.table.getRowCount();
        for (int i = 0; i < n; ++i) {
            params = new Object[columnNames.length];
            m = columnNames.length;
            for (k = 0; k < m; ++k) {
                params[k] = o = this.table.getCell(i, columnNames[k]).getValue();
            }
            pk = this.tablePks[0];
            tableDatas.put(this.table.getCell(i, pk).getValue(), params);
        }
        try {
            for (Vector vecRows : this.rowSet.toCollection()) {
                params = (Object[])tableDatas.get(vecRows.get(this.rowSet.findColumn(pk) - 1));
                m = columnNames.length;
                for (k = 0; k < m; ++k) {
                    o = vecRows.get(this.rowSet.findColumn(columnNames[k]) - 1);
                    if (!this.isDiffrent(o, params[k])) continue;
                    return true;
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private void initTablePKs() {
        QueryPKInfo pkInfo = this.queryInfo.getQueryPK();
        QueryFieldCollection fieldCol = pkInfo.getKeyPropertys();
        this.tablePks = new String[fieldCol.size()];
        int n = fieldCol.size();
        for (int i = 0; i < n; ++i) {
            QueryFieldInfo fieldInfo = fieldCol.get(i);
            this.tablePks[i] = fieldInfo.getName();
        }
    }

    public String[] getTablePks() {
        return this.tablePks;
    }

    public void setTablePks(String[] tablePks) {
        this.tablePks = tablePks;
    }

    private boolean isDiffrent(Object arg0, Object arg1) {
        boolean isChanged = false;
        if (arg0 == null && arg1 != null || arg0 != null && arg1 == null) {
            isChanged = true;
        } else if (arg0 != null && arg1 != null) {
            isChanged = arg0 instanceof CoreBaseInfo && arg1 instanceof CoreBaseInfo ? !((CoreBaseInfo)arg0).getId().toString().equals(((CoreBaseInfo)arg1).getId().toString()) : !arg0.equals(arg1);
        }
        return isChanged;
    }

    public String[] getFieldNames(String[] filterFields) {
        int size = filterFields.length;
        IRow row = this.table.getHeadRow(0);
        String[] fieldNames = new String[size];
        for (int i = 0; i < size; ++i) {
            fieldNames[i] = (String)row.getCell(filterFields[i]).getValue();
        }
        return fieldNames;
    }

    public void changedQueryInfo(QueryInfo queryInfo, String[] pks) {
        this.queryInfo = queryInfo;
        MetaDataPK metaDataPK = MetaDataPK.create((String)queryInfo.getPackage(), (String)queryInfo.getName());
        this.queryExecutor = BosHelper.createQueryExecutor((MetaDataPK)metaDataPK);
        if (pks != null) {
            this.tablePks = pks;
        } else {
            this.initTablePKs();
        }
        this.table.removeColumns();
        this.initTableHead();
    }

    public SorterItemCollection getDefaultSorter() {
        return this.defaultSorter;
    }
}

