/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.util.pac;

import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTAbstractCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellValueParse;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.mm.sfc.util.pac.IPromptBoxFactory;
import com.kingdee.eas.mm.sfc.util.pac.PACParamInfo;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;

public class TableEditHandler {
    private KDTable table = null;
    private String[] editableFields = null;
    private IPromptBoxFactory PromptBoxFactory;
    private Map editMap;

    public TableEditHandler(KDTable table, String[] editableFields, IPromptBoxFactory PromptFactory) {
        this.table = table;
        this.editableFields = editableFields;
        this.PromptBoxFactory = PromptFactory;
        this.addDefaultEditor();
        this.initListener();
    }

    public void addParam(String key, PACParamInfo param) {
        if (this.editMap == null) {
            this.editMap = new HashMap();
        }
        this.editMap.put(key, param);
    }

    public PACParamInfo getParam(String key) {
        return (PACParamInfo)this.editMap.get(key);
    }

    public void setColumnEditable(boolean editable) {
        for (int i = 0; i < this.editableFields.length; ++i) {
            String key = this.editableFields[i];
            this.table.getColumn(key).getStyleAttributes().setLocked(!editable);
        }
    }

    private void addDefaultEditor() {
        KDDatePicker datePicker = new KDDatePicker();
        datePicker.setVisible(true);
        datePicker.setEditable(true);
        datePicker.setTimeEnabled(true);
        KDTDateTimeCellEditor cellEditor = new KDTDateTimeCellEditor(datePicker);
        this.table.putDefaultEditor(Timestamp.class, (ICellEditor)cellEditor);
        KDFormattedTextField qty_TextField = new KDFormattedTextField();
        qty_TextField.setVisible(true);
        qty_TextField.setEditable(true);
        qty_TextField.setHorizontalAlignment(2);
        qty_TextField.setDataType(1);
        qty_TextField.setMinimumValue((Comparable)new BigDecimal("-1.0E13"));
        qty_TextField.setMaximumValue((Comparable)new BigDecimal("1.0E13"));
        qty_TextField.setNegatived(false);
        qty_TextField.setPrecision(2);
        KDTDefaultCellEditor kdtTechnics_qty_CellEditor = new KDTDefaultCellEditor((JTextField)qty_TextField);
        this.table.putDefaultEditor(BigDecimal.class, (ICellEditor)kdtTechnics_qty_CellEditor);
    }

    public void setPromptBoxCellEditor(String key, String f7QueryName, String orgProperty, boolean isEnabledMultiSelection, String formatStr) {
        KDBizPromptBox f7Ctrl = this.PromptBoxFactory.create(f7QueryName, orgProperty);
        f7Ctrl.setEnabledMultiSelection(isEnabledMultiSelection);
        this.table.getColumn(key).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)f7Ctrl));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat(formatStr));
        this.table.getColumn(key).setRenderer((IBasicRender)avr);
    }

    public void setPromptBoxCellEditor(String key, String f7QueryName, String orgProperty, boolean isEnabledMultiSelection) {
        this.setPromptBoxCellEditor(key, f7QueryName, orgProperty, isEnabledMultiSelection, "$name$");
    }

    public void setPromptBoxCellEditor(String key, String f7QueryName, boolean isEnabledMultiSelection, String formatStr) {
        KDBizPromptBox f7Ctrl = this.PromptBoxFactory.create(f7QueryName);
        f7Ctrl.setEnabledMultiSelection(isEnabledMultiSelection);
        this.table.getColumn(key).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)f7Ctrl));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat(formatStr));
        this.table.getColumn(key).setRenderer((IBasicRender)avr);
    }

    public void setPromptBoxCellEditor(String key, String f7QueryName, boolean isEnabledMultiSelection) {
        this.setPromptBoxCellEditor(key, f7QueryName, isEnabledMultiSelection, "$name$");
    }

    public void setPromptBoxCellEditor(int rowIndex, String key, String f7QueryName, String orgProperty, boolean isEnabledMultiSelection, EntityViewInfo view) {
        KDBizPromptBox f7Ctrl = this.PromptBoxFactory.create(f7QueryName, orgProperty);
        f7Ctrl.setEnabledMultiSelection(isEnabledMultiSelection);
        this.table.getCell(rowIndex, key).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)f7Ctrl));
        f7Ctrl.setEntityViewInfo(view);
        f7Ctrl.getQueryAgent().resetRuntimeEntityView();
    }

    public void setComboBoxCellEditor(String key, String className) {
        KDComboBox bizComboBox = new KDComboBox();
        bizComboBox.setName(key + "_ComboBox");
        bizComboBox.setVisible(true);
        bizComboBox.addItems(EnumUtils.getEnumList((String)className).toArray());
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JComboBox)bizComboBox);
        this.table.getColumn(key).setEditor((ICellEditor)cellEditor);
    }

    private void initListener() {
        this.table.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    TableEditHandler.this.initIDMap();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void initIDMap() throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Set paramSet = this.editMap.entrySet();
        Iterator it = paramSet.iterator();
        PACParamInfo param = null;
        String key = null;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            key = (String)entry.getKey();
            param = (PACParamInfo)entry.getValue();
            if (param.getDataType().equals((Object)DataType.ENUM)) {
                Map enumMap = param.getEnumMap();
                int n = this.table.getRowCount();
                for (int i = 0; i < n; ++i) {
                    BizEnumValueDTO value = (BizEnumValueDTO)this.table.getCell(i, key).getValue();
                    this.table.getCell(i, key).setValue(enumMap.get(value.getName()));
                }
                continue;
            }
            if (!param.getDataType().equals((Object)DataType.OBJECTVALUE)) continue;
            Class<?> clazz = Class.forName(param.getClassName());
            Constructor<?> c = clazz.getConstructor(null);
            int n = this.table.getRowCount();
            for (int i = 0; i < n; ++i) {
                Object info = c.newInstance(null);
                if (info instanceof DataBaseInfo) {
                    ((DataBaseInfo)info).setId(BOSUuid.read((String)((String)this.table.getCell(i, param.getId()).getValue())));
                    ((DataBaseInfo)info).setName((String)this.table.getCell(i, param.getName()).getValue());
                    ((DataBaseInfo)info).setNumber((String)this.table.getCell(i, param.getNumber()).getValue());
                } else if (info instanceof CoreBillBaseInfo) {
                    ((DataBaseInfo)info).setId(BOSUuid.read((String)((String)this.table.getCell(i, param.getId()).getValue())));
                    ((DataBaseInfo)info).setNumber((String)this.table.getCell(i, param.getNumber()).getValue());
                } else {
                    ((DataBaseInfo)info).setId(BOSUuid.read((String)((String)this.table.getCell(i, param.getId()).getValue())));
                    ((DataBaseInfo)info).setNumber((String)this.table.getCell(i, param.getNumber()).getValue());
                }
                this.table.getCell(i, key).setValue(info);
            }
        }
    }

    private class KDTDateTimeCellEditor
    extends KDTAbstractCellEditor
    implements ICellValueParse {
        protected KDDatePicker comp;
        protected int clickCountToStart = 1;

        public KDTDateTimeCellEditor(KDDatePicker editor) {
            this.comp = editor;
        }

        public String getText() {
            return null;
        }

        public void setText(String text) {
        }

        public Object getValue() {
            try {
                this.comp.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return this.comp.getTimestamp();
        }

        public void setValue(Object value) {
            if (value != null && value instanceof Date) {
                this.comp.setValue(value);
            } else if (value != null && value instanceof Timestamp) {
                this.comp.setValue(value);
            } else {
                this.comp.setValue(null);
            }
        }

        public Component prepareComponent(Object value, Object expandValue, Style style, EventObject anEvent) {
            this.comp.setOpaque(true);
            this.comp.setBorder(null);
            this.comp.setBackground(this.getBackgroundColor(style.getBackground()));
            this.comp.setForeground(style.getFontColor());
            this.comp.setFont((Font)style.getKDFont());
            this.comp.setToolTipText(null);
            this.setValue(value);
            JComponent tempC = this.comp.getEditor().getEditorComponent();
            if (tempC != null) {
                tempC.setBorder(null);
            }
            return this.comp;
        }

        public Component getFocusComponent() {
            if (this.comp.isEditable()) {
                return this.comp.getEditor().getEditorComponent();
            }
            return this.comp;
        }

        public Component getComponent() {
            return this.comp;
        }

        public void setBounds(int x, int y, int width, int height) {
            this.comp.setBounds(x, y, width, height);
            this.comp.validate();
        }

        private Color getBackgroundColor(Color color) {
            if (color.getAlpha() == 0) {
                return Color.WHITE;
            }
            return color;
        }

        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent == null) {
                return true;
            }
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= this.clickCountToStart;
            }
            return false;
        }

        public Object parseValue(Object src) {
            block5: {
                if (src instanceof String) {
                    try {
                        JComponent editComp = this.comp.getEditor().getEditorComponent();
                        if (editComp instanceof JFormattedTextField) {
                            JFormattedTextField ftf = (JFormattedTextField)editComp;
                            JFormattedTextField.AbstractFormatter format = ftf.getFormatter();
                            return format.stringToValue(src.toString());
                        }
                        break block5;
                    }
                    catch (ParseException pe) {
                        return null;
                    }
                }
                if (src instanceof Date) {
                    return src;
                }
            }
            return null;
        }
    }
}

