/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.util.pac;

import com.kingdee.eas.scm.common.util.SCMConstant;
import java.io.Serializable;
import java.math.BigDecimal;

public class TaskAssignBurthen
implements Serializable {
    private int timeUnit;
    private BigDecimal prepareTime;
    private BigDecimal workTime;
    private BigDecimal processBatch;
    private static final BigDecimal HOUR_MINUTE_RATE = new BigDecimal(60);
    private static final BigDecimal HOUR_SECOND_RATE = new BigDecimal(3600);

    public int getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(int timeUnit) {
        this.timeUnit = timeUnit;
    }

    public BigDecimal getPrepareTime() {
        return this.prepareTime;
    }

    public void setPrepareTime(BigDecimal prepareTime) {
        this.prepareTime = prepareTime;
    }

    public BigDecimal getWorkTime() {
        return this.workTime;
    }

    public void setWorkTime(BigDecimal workTime) {
        this.workTime = workTime;
    }

    public BigDecimal getProcessBatch() {
        return this.processBatch;
    }

    public void setProcessBatch(BigDecimal processBatch) {
        this.processBatch = processBatch;
    }

    public BigDecimal getBurthen(BigDecimal qty) {
        BigDecimal curr_prepareTime = this.prepareTime;
        BigDecimal curr_workTime = this.workTime;
        if (this.timeUnit == 3) {
            curr_prepareTime = this.prepareTime.divide(HOUR_MINUTE_RATE, 2, 4);
            curr_workTime = this.workTime.divide(HOUR_MINUTE_RATE, 2, 4);
        } else if (this.timeUnit == 4) {
            curr_prepareTime = this.prepareTime.divide(HOUR_SECOND_RATE, 2, 4);
            curr_workTime = this.workTime.divide(HOUR_SECOND_RATE, 2, 4);
        }
        if (this.processBatch.compareTo(SCMConstant.BIGDECIMAL_ZERO) > 0) {
            curr_workTime = curr_workTime.multiply(qty.divide(this.processBatch, 0, 0)).setScale(2);
        }
        return curr_prepareTime.add(curr_workTime.multiply(SCMConstant.BIGDECIMAL_ONE)).setScale(2);
    }
}

