/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionEvent;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.cal.CalCostCheckItemCollection;
import com.kingdee.eas.ncm.cal.CalCostCheckItemFactory;
import com.kingdee.eas.ncm.cal.CalCostCheckItemInfo;
import com.kingdee.eas.ncm.cal.ICalCostCheckItem;
import com.kingdee.eas.ncm.cal.client.AbstractCostCalCheckOptionUI;
import com.kingdee.eas.ncm.cal.utils.CostCalUtils;
import com.kingdee.eas.ncm.common.task.client.CostTaskClientUtils;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class CostCalCheckOptionUI
extends AbstractCostCalCheckOptionUI {
    private static final Logger logger = CoreUIObject.getLogger(CostCalCheckOptionUI.class);
    public static final String CHECK_ITEM_SHARE_CO_ID = "8RybwGlAnE2RyCcmyggqlBTDwsw=";
    private static final String KEY_CHECK_PREFIX = "checkItem_check_";
    private Map checkTypes = new TreeMap();
    private Set companyIds;

    public CostCalCheckOptionUI() throws Exception {
        this.checkTypes.put("100", new CalCostCheckTypeInfo("100", "\u57fa\u7840\u8d44\u6599\u68c0\u67e5"));
        this.checkTypes.put("200", new CalCostCheckTypeInfo("200", "\u6570\u636e\u73af\u5883\u68c0\u67e5"));
        this.checkTypes.put("210", new CalCostCheckTypeInfo("210", "\u6295\u5165\u4ea7\u51fa\u76f8\u5173\u68c0\u67e5"));
        this.checkTypes.put("220", new CalCostCheckTypeInfo("220", "\u5206\u914d\u8ba1\u7b97\u524d\u76f8\u5173\u68c0\u67e5"));
        this.checkTypes.put("230", new CalCostCheckTypeInfo("230", "\u5206\u7c7b\u6cd5\u6210\u672c\u76f8\u5173\u68c0\u67e5"));
        this.checkTypes.put("240", new CalCostCheckTypeInfo("240", "\u8f85\u52a9\u670d\u52a1\u6838\u7b97\u76f8\u5173\u68c0\u67e5"));
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("check").getStyleAttributes().setLocked(false);
        this.tblMain.getStyleAttributes().setWrapText(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.companyIds = (Set)this.getUIContext().get("companyIds");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("checkStatus", (Object)"0"));
        filter.getFilterItems().add(new FilterItemInfo("calType", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("stage", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)CHECK_ITEM_SHARE_CO_ID, CompareType.NOTEQUALS));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("name");
        selector.add("type");
        selector.add("seq");
        selector.add("isNeed");
        selector.add("description");
        view.setSelector(selector);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("type"));
        sorter.add(new SorterItemInfo("seq"));
        view.setSorter(sorter);
        ICalCostCheckItem iCalCostCheckItem = CalCostCheckItemFactory.getRemoteInstance();
        CalCostCheckItemCollection coll = iCalCostCheckItem.getCalCostCheckItemCollection(view);
        HashMap<String, ArrayList<CalCostCheckItemInfo>> checkItemsMap = new HashMap<String, ArrayList<CalCostCheckItemInfo>>();
        for (int i = 0; i < coll.size(); ++i) {
            CalCostCheckItemInfo checkItem = coll.get(i);
            if (checkItem.getType() == null) continue;
            ArrayList<CalCostCheckItemInfo> checkItems = (ArrayList<CalCostCheckItemInfo>)checkItemsMap.get(checkItem.getType());
            if (checkItems == null) {
                checkItems = new ArrayList<CalCostCheckItemInfo>();
                checkItemsMap.put(checkItem.getType(), checkItems);
            }
            checkItems.add(checkItem);
        }
        this.tblMain.removeRows();
        for (String type : this.checkTypes.keySet()) {
            CalCostCheckTypeInfo checkType = (CalCostCheckTypeInfo)this.checkTypes.get(type);
            this.addRow(checkType);
            List checkItems = (List)checkItemsMap.get(type);
            if (checkItems == null) continue;
            for (int i = 0; i < checkItems.size(); ++i) {
                CalCostCheckItemInfo calCostCheckItem = (CalCostCheckItemInfo)checkItems.get(i);
                this.addRow(calCostCheckItem);
            }
        }
        this.tblMain.setBeforeAction(new BeforeActionListener(){

            public void beforeAction(BeforeActionEvent e) {
                if (e != null && e.getType() == 7) {
                    e.setCancel(true);
                }
            }
        });
    }

    private void addRow(CalCostCheckTypeInfo checkType) {
        IRow row = this.tblMain.addRow();
        row.getCell("id").setValue((Object)checkType.type);
        row.getCell("check").setValue((Object)Boolean.TRUE);
        row.getCell("seq").setValue((Object)checkType.type);
        row.getCell("name").setValue((Object)checkType);
        row.getCell("desc").setValue((Object)"");
        if (checkType.color != null) {
            row.getCell("name").getStyleAttributes().setBackground(checkType.color);
        } else {
            row.getCell("name").getStyleAttributes().setBold(true);
        }
    }

    private void addRow(CalCostCheckItemInfo checkItem) {
        IRow row = this.tblMain.addRow();
        row.getCell("id").setValue((Object)checkItem.getId().toString());
        row.getCell("check").setValue((Object)Boolean.TRUE);
        row.getCell("type").setValue((Object)checkItem.getType());
        row.getCell("seq").setValue((Object)String.valueOf(checkItem.getSeq()));
        row.getCell("name").setValue((Object)checkItem);
        row.getCell("desc").setValue((Object)checkItem.getDescription());
    }

    public Map getParams() {
        HashMap params = new HashMap();
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            String key = this.tblMain.getCell(i, "id").getValue().toString();
            String value = this.tblMain.getCell(i, "check").getValue().toString();
            if (key == null || value == null || !value.equals("true")) continue;
            ids.add(key);
        }
        params.put("checkItem_ids", ids);
        return params;
    }

    protected void setDefaultValue() {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.tblMain.getCell(i, "check").setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        if (colIndex == this.tblMain.getColumn("check").getColumnIndex()) {
            Object currentValue = row.getCell("name").getValue();
            if (currentValue instanceof CalCostCheckTypeInfo) {
                Object value;
                for (int i = rowIndex + 1; i < this.tblMain.getRowCount() && (value = this.tblMain.getCell(i, "name").getValue()) instanceof CalCostCheckItemInfo; ++i) {
                    this.tblMain.getCell(i, "check").setValue(row.getCell("check").getValue());
                }
            } else if (currentValue instanceof CalCostCheckItemInfo) {
                Object value;
                int parentIndex;
                CalCostCheckItemInfo checkItem = (CalCostCheckItemInfo)currentValue;
                CalCostCheckTypeInfo checkType = null;
                for (parentIndex = 0; parentIndex < this.tblMain.getRowCount(); ++parentIndex) {
                    Object value2 = this.tblMain.getCell(parentIndex, "name").getValue();
                    if (!(value2 instanceof CalCostCheckTypeInfo)) continue;
                    checkType = (CalCostCheckTypeInfo)value2;
                    if (checkType.type.equals(checkItem.getType())) break;
                }
                int selectCount = 0;
                int deleteCount = 0;
                for (int i = parentIndex + 1; i < this.tblMain.getRowCount() && !((value = this.tblMain.getCell(i, "name").getValue()) instanceof CalCostCheckTypeInfo); ++i) {
                    if ("true".equals(this.tblMain.getCell(i, "check").getValue().toString())) {
                        ++selectCount;
                        continue;
                    }
                    ++deleteCount;
                }
                if (selectCount == 0) {
                    this.tblMain.getCell(parentIndex, "check").setValue((Object)Boolean.FALSE);
                }
                if (deleteCount == 0) {
                    this.tblMain.getCell(parentIndex, "check").setValue((Object)Boolean.TRUE);
                }
            }
        }
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        this.tblMain.getEditManager().stopEditing();
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.setDefaultValue();
    }

    @Override
    protected void btnDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.tblMain.getCell(i, "check").setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    protected void btnCheck_actionPerformed(ActionEvent e) throws Exception {
        Map source = this.getParams();
        Set checkItem_ids = (Set)source.get("checkItem_ids");
        if (checkItem_ids == null || checkItem_ids.size() == 0) {
            MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u68c0\u67e5\u9879\u3002");
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.companyIds, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        view.setSelector(selector);
        CompanyOrgUnitCollection companyColl = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        HashMap<String, PeriodInfo> periods = new HashMap<String, PeriodInfo>();
        for (int i = 0; i < companyColl.size(); ++i) {
            CompanyOrgUnitInfo company = companyColl.get(i);
            if (!NCMUtils.isStart(null, (String)company.getId().toString())) {
                MsgBox.showInfo((String)("\u8d22\u52a1\u7ec4\u7ec7 [" + company.getName() + "] \u6210\u672c\u7ba1\u7406\u6a21\u5757\u6ca1\u6709\u5b8c\u6210\u521d\u59cb\u5316\u5de5\u4f5c\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u76f8\u5173\u6570\u636e\u5904\u7406\uff0c\u8bf7\u60a8\u5148\u8fdb\u884c\u521d\u59cb\u5316\u5de5\u4f5c"));
                return;
            }
            PeriodInfo period = NCMUtils.GetCurrentPeriod(null, (String)company.getId().toString());
            periods.put(company.getId().toString(), period);
        }
        ArrayList<Map> params = new ArrayList<Map>(companyColl.size());
        for (int i = 0; i < companyColl.size(); ++i) {
            CompanyOrgUnitInfo company = companyColl.get(i);
            PeriodInfo period = (PeriodInfo)periods.get(company.getId().toString());
            source.put("company", company);
            source.put("period", period);
            source.put("user", SysContext.getSysContext().getCurrentUserInfo());
            Map param = CostCalUtils.buildCheckParam(source);
            params.add(param);
        }
        CostTaskClientUtils.execute(params, (CoreUIObject)((CoreUIObject)this.getUIContext().get("Owner")), (CoreUIObject)this, (boolean)true);
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    class CalCostCheckTypeInfo {
        public String type;
        public String name;
        public Color color;

        public CalCostCheckTypeInfo(String type, String name) {
            this(type, name, null);
        }

        public CalCostCheckTypeInfo(String type, String name, Color color) {
            this.type = type;
            this.name = name;
            this.color = color;
        }

        public String toString() {
            return this.name;
        }
    }
}

