/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ncm.bill.EopWipAdjustFactory;
import com.kingdee.eas.ncm.cal.client.AbstractCostCalEopWipExReportUI;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class CostCalEopWipExReportUI
extends AbstractCostCalEopWipExReportUI {
    private static final Logger logger = CoreUIObject.getLogger(CostCalEopWipExReportUI.class);
    private String companyId = null;
    private String periodId = null;

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnGen.setIcon(EASResource.getIcon((String)"imgTbtn_createcatalog"));
        this.menuItemGen.setIcon(EASResource.getIcon((String)"imgTbtn_createcatalog"));
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    CostCalEopWipExReportUI.this.tblMain_tableClicked(e);
                }
                catch (Exception exc) {
                    CostCalEopWipExReportUI.this.handUIException(exc);
                }
            }
        });
        this.actionQuery.setEnabled(false);
        this.actionQuery.setVisible(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("check").getStyleAttributes().setLocked(false);
        Map parentParam = (Map)this.getUIContext().get("param");
        if (parentParam == null) {
            parentParam = (Map)this.getUIContext().get("key.cost.task.entry.param");
        }
        this.companyId = (String)parentParam.get("companyId");
        this.periodId = NCMUtils.GetCurrentPeriod(null, (String)this.companyId).getId().toString();
        this.refresh();
    }

    private void refresh() throws Exception {
        this.tblMain.removeRows();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("companyId", this.companyId);
        params.put("periodId", this.periodId);
        Map result = EopWipAdjustFactory.getRemoteInstance().getAdjustRpt(params);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)result.get("company");
        if (company == null) {
            return;
        }
        StringBuffer format = new StringBuffer();
        for (int i = 0; i < company.getBaseCurrency().getPrecision(); ++i) {
            format.append("0");
        }
        String amountFormat = "0." + format.toString();
        this.tblMain.getColumn("ciEopWipAmount").getStyleAttributes().setNumberFormat(amountFormat);
        this.prmtCompany.setValue((Object)company);
        PeriodInfo period = (PeriodInfo)result.get("period");
        this.prmtPeriod.setValue((Object)period);
        IRowSet rowSet = (IRowSet)result.get("rowSet");
        if (rowSet == null) {
            return;
        }
        while (rowSet.next()) {
            IRow row = this.tblMain.addRow();
            String adjustId = rowSet.getString("FAdjustID");
            if (adjustId != null && adjustId.length() > 0) {
                row.getCell("check").getStyleAttributes().setLocked(true);
                row.getCell("check").getStyleAttributes().setFontColor(new Color(0, 128, 0));
                row.getCell("check").setValue((Object)"\u221a");
            } else {
                row.getCell("check").setValue((Object)rowSet.getBoolean("FCheck"));
            }
            row.getCell("coDataId").setValue((Object)rowSet.getString("FCODataID"));
            row.getCell("costCenterNumber").setValue((Object)rowSet.getString("FCostCenterNumber"));
            row.getCell("costCenterName").setValue((Object)rowSet.getString("FCostCenterName"));
            row.getCell("costObjectNumber").setValue((Object)rowSet.getString("FCostObjectNumber"));
            row.getCell("costObjectName").setValue((Object)rowSet.getString("FCostObjectName"));
            row.getCell("orderNumber").setValue((Object)rowSet.getString("FOrderNumber"));
            row.getCell("lot").setValue((Object)rowSet.getString("FLot"));
            row.getCell("model").setValue((Object)rowSet.getString("FModel"));
            row.getCell("unitName").setValue((Object)rowSet.getString("FUnitName"));
            int precision = rowSet.getInt("FCOEopWIPQtyPrecision");
            if (precision == 0) {
                precision = 4;
            }
            row.getCell("coEopWipQty").setValue((Object)rowSet.getBigDecimal("FCOEopWipQty"));
            row.getCell("coEopWipQty").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)precision));
            row.getCell("ciEopWipQty").setValue((Object)rowSet.getBigDecimal("FCIEopWipQty"));
            row.getCell("ciEopWipAmount").setValue((Object)rowSet.getBigDecimal("FCIEopWipAmount"));
            row.getCell("adjustId").setValue((Object)adjustId);
            row.getCell("adjustNumber").setValue((Object)rowSet.getString("FAdjustNumber"));
        }
    }

    @Override
    public void actionGen_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("companyId", this.companyId);
        params.put("periodId", this.periodId);
        params.put("userId", SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        HashSet<String> coDataIds = new HashSet<String>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            String check = this.tblMain.getCell(i, "check").getValue().toString();
            if (check == null || !check.equals("true")) continue;
            String coDataId = this.tblMain.getCell(i, "coDataId").getValue().toString();
            coDataIds.add(coDataId);
        }
        if (coDataIds.size() == 0) {
            return;
        }
        params.put("coDataIds", coDataIds);
        EopWipAdjustFactory.getRemoteInstance().genAdjustBill(params);
        this.refresh();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refresh();
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            Object value = this.tblMain.getCell(i, "check").getValue();
            if (value == null || !(value instanceof Boolean) || ((Boolean)value).booleanValue()) continue;
            this.tblMain.getCell(i, "check").setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    public void actionDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            Object value = this.tblMain.getCell(i, "check").getValue();
            if (value == null || !(value instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
            this.tblMain.getCell(i, "check").setValue((Object)Boolean.FALSE);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            IRow row = this.tblMain.getRow(e.getRowIndex());
            if (row == null || row.getCell("adjustId").getValue() == null) {
                return;
            }
            String adjustId = row.getCell("adjustId").getValue().toString();
            if (adjustId == null || adjustId.length() == 0) {
                return;
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)adjustId);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.ncm.bill.client.EopWipAdjustEditUI", (Map)uiContext, null, "VIEW");
            uiWindow.show();
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }
}

