/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.ncm.cal.CostCalReccLogCollection;
import com.kingdee.eas.ncm.cal.CostCalReccLogFactory;
import com.kingdee.eas.ncm.cal.CostCalReccLogInfo;
import com.kingdee.eas.ncm.cal.client.AbstractCostCalReccLogUI;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.log4j.Logger;

public class CostCalReccLogUI
extends AbstractCostCalReccLogUI {
    private static final Logger logger = CoreUIObject.getLogger(CostCalReccLogUI.class);
    private Map parentParam = null;
    private String companyId = null;
    private String periodId = null;
    private String companyName = null;
    private String periodNumber = null;
    private String checkItemId = null;

    public void onLoad() throws Exception {
        CompanyOrgUnitInfo company;
        super.onLoad();
        this.parentParam = (Map)this.getUIContext().get("param");
        if (this.parentParam == null) {
            this.parentParam = (Map)this.getUIContext().get("key.cost.task.entry.param");
        }
        this.companyId = (String)this.parentParam.get("companyId");
        this.periodId = (String)this.parentParam.get("periodId");
        this.companyName = (String)this.parentParam.get("companyName");
        this.periodNumber = (String)this.parentParam.get("periodNumber");
        if (this.companyName == null) {
            company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.companyId));
            this.companyName = company.getName();
        }
        if (this.periodNumber == null) {
            PeriodInfo period = PeriodFactory.getRemoteInstance().getPeriodInfo((IObjectPK)new ObjectUuidPK(this.periodId));
            this.periodNumber = String.valueOf(period.getNumber());
        }
        this.checkItemId = (String)this.parentParam.get("checkItemId");
        this.kDTable.checkParsed();
        company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.companyId));
        CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId()));
        int amtPrecision = currency.getPrecision();
        this.kDTable.getColumn("reqAmount").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)amtPrecision));
        this.kDTable.getColumn("auxAmount").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)amtPrecision));
        this.kDTable.getColumn("allocAmount").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)amtPrecision));
        this.kDTable.getColumn("diffAmount").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)amtPrecision));
        this.fillReportData();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kDTable);
        this.kDTable.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kDTable);
        this.kDTable.getPrintManager().printPreview();
    }

    private void fillReportData() {
        try {
            this.txtCompany.setText(this.companyName);
            this.txtPeriod.setText(this.periodNumber);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyId));
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)this.periodId));
            filter.getFilterItems().add(new FilterItemInfo("checkItem.id", (Object)this.checkItemId));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("costCenter.name");
            selector.add("costItem.name");
            selector.add("reqAmount");
            selector.add("auxAmount");
            selector.add("allocAmount");
            view.setSelector(selector);
            SorterItemCollection sorter = new SorterItemCollection();
            sorter.add(new SorterItemInfo("costCenter.name"));
            sorter.add(new SorterItemInfo("costItem.name"));
            view.setSorter(sorter);
            CostCalReccLogCollection coll = CostCalReccLogFactory.getRemoteInstance().getCostCalReccLogCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                BigDecimal allocAmount;
                BigDecimal auxAmount;
                CostCalReccLogInfo reccLog = coll.get(i);
                IRow row = this.kDTable.addRow();
                row.getCell("costCenter.name").setValue((Object)(reccLog.getCostCenter() != null ? reccLog.getCostCenter().getName() : ""));
                row.getCell("costItem.name").setValue((Object)(reccLog.getCostItem() != null ? reccLog.getCostItem().getName() : ""));
                BigDecimal reqAmount = reccLog.getReqAmount();
                if (reqAmount == null) {
                    reqAmount = SysConstant.BIGZERO;
                }
                if ((auxAmount = reccLog.getAuxAmount()) == null) {
                    auxAmount = SysConstant.BIGZERO;
                }
                if ((allocAmount = reccLog.getAllocAmount()) == null) {
                    allocAmount = SysConstant.BIGZERO;
                }
                BigDecimal diffAmount = allocAmount.subtract(reqAmount.add(auxAmount));
                row.getCell("reqAmount").setValue((Object)reqAmount);
                row.getCell("auxAmount").setValue((Object)auxAmount);
                row.getCell("allocAmount").setValue((Object)allocAmount);
                row.getCell("diffAmount").setValue((Object)diffAmount);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }
}

