/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.client;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ncm.cal.client.AbstractCostRecoveryUI;
import com.kingdee.eas.ncm.cal.client.CostCalUI;
import com.kingdee.eas.ncm.cal.client.CostRecoveryOptionUI;
import com.kingdee.eas.ncm.cal.utils.CostCalUtils;
import com.kingdee.eas.ncm.common.task.client.CostTaskClientUtils;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class CostRecoveryUI
extends AbstractCostRecoveryUI {
    private static final Logger logger = CoreUIObject.getLogger(CostRecoveryUI.class);
    private static final ImageIcon iconCalc = new ImageIcon(CostCalUI.class.getResource("/com/kingdee/eas/ncm/common/resource/pic/ncm_calc.png"));
    private IUIWindow uiWindow = null;
    private CostRecoveryOptionUI optionUI = null;
    private Map param = null;

    public CostRecoveryUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        this.lbPicture.setIcon((Icon)iconCalc);
        this.prmtCompany.setEnabled(false);
        this.lbSetting.getBoundLabel().setForeground(Color.BLUE);
        this.lbSetting.setUnderlineColor(Color.BLUE);
        this.lbSetting.setCursor(new Cursor(12));
        this.lbSetting.getBoundLabel().setHorizontalAlignment(0);
        this.lbSetting.getBoundLabel().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Map temp = CostRecoveryUI.this.showOptionUI();
                    if (temp != null) {
                        CostRecoveryUI.this.param = temp;
                    }
                }
                catch (Exception exc) {
                    CostRecoveryUI.this.handUIException(exc);
                }
            }
        });
        this.param = new HashMap();
        this.param.put("ReInitBop", "false");
        this.param.put("RecoveryCheck", "true");
        this.param.put("GenReportData", "true");
        this.param.put("GenVoucherData", "true");
        this.param.put("GenCOByPurInWarehsBill", "false");
    }

    @Override
    protected String getCostTaskNumber() {
        return "FactCostCalRecovery";
    }

    public Map showOptionUI() throws Exception {
        if (this.uiWindow == null) {
            HashMap param = new HashMap();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"param", param);
            this.uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CostRecoveryOptionUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            this.optionUI = (CostRecoveryOptionUI)((Object)param.get("ui"));
        }
        this.optionUI.init(this.param);
        ((UIModelDialog)this.uiWindow).setVisible(true);
        return this.optionUI.getParam();
    }

    @Override
    protected void btnCal_actionPerformed(ActionEvent e) throws Exception {
        Set companyIds = this.getSelectedCompanyIds();
        if (companyIds.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.task.CostRecoveryResource", (String)"CHOOSE_COMPANY_EMPTY"));
            return;
        }
        HashMap<String, Object> source = this.param;
        if (source == null) {
            source = new HashMap<String, Object>();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)companyIds, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        view.setSelector(selector);
        CompanyOrgUnitCollection companys = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        HashMap<String, PeriodInfo> periods = new HashMap<String, PeriodInfo>();
        for (int i = 0; i < companys.size(); ++i) {
            CompanyOrgUnitInfo company = companys.get(i);
            if (!NCMUtils.isStart(null, (String)company.getId().toString())) {
                MsgBox.showInfo((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ncm.cal.task.CostRecoveryResource", (String)"COST_NOT_ON"), company.getName()));
                return;
            }
            PeriodInfo period = NCMUtils.GetCurrentPeriod(null, (String)company.getId().toString());
            periods.put(company.getId().toString(), period);
        }
        ArrayList<Map> params = new ArrayList<Map>(companys.size());
        for (int i = 0; i < companys.size(); ++i) {
            CompanyOrgUnitInfo company = companys.get(i);
            PeriodInfo period = (PeriodInfo)periods.get(company.getId().toString());
            source.put("company", company);
            source.put("period", period);
            source.put("user", SysContext.getSysContext().getCurrentUserInfo());
            Map param = CostCalUtils.buildRecoveryParam(source);
            params.add(param);
        }
        CostTaskClientUtils.execute(params, (CoreUIObject)this, (boolean)true);
    }
}

