/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.ncm.bill.client.MaterialAllocEditUI;
import com.kingdee.eas.ncm.cal.MatAllocResultVoucheredFactory;
import com.kingdee.eas.ncm.cal.VoucherDAPTransImpl;
import com.kingdee.eas.ncm.cal.client.AbstractMaterialAllocVoucherListUI;
import com.kingdee.eas.ncm.cal.client.MaterialAllocVoucherFilterUI;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMCommonQueryProcessor;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.client.MaterialReqBillEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class MaterialAllocVoucherListUI
extends AbstractMaterialAllocVoucherListUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialAllocVoucherListUI.class);
    private static final String Col_ID = "id";
    private static final String Col_EntryID = "entry.id";
    private CompanyOrgUnitInfo _company;
    private PeriodInfo _period;
    private static final String QtyCol = "entry.qty";
    private static final String CommQtyCol = "entry.baseQty";
    private static final String AssisQtyCol = "entry.assistQty";
    private static final String PriceCol = "entry.unitActualCost";
    private static final String AmtCol = "entry.actualCost";
    private FilterInfo _currFilterInfo = null;
    private CommonQueryDialog dialog = null;
    private MaterialAllocVoucherFilterUI filterUI = null;

    public MaterialAllocVoucherListUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        NCMClientUtils.checkIsStart();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionLocate.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionStartWorkFlow.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionView.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.menuEdit.setVisible(false);
        this.menuWorkFlow.setVisible(false);
        this.menuBiz.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.btnViewBill.setIcon(this.btnTraceUp.getIcon());
        this.actionAuditResult.setVisible(false);
        this.actionVoucher.setVisible(false);
        this.actionVoucher.setEnabled(false);
        this.auditAction.setVisible(false);
        this.unauditAction.setVisible(false);
    }

    public void onLoad() throws Exception {
        this._company = this.getCompanyOrgInfoWithDefault();
        this._period = this.GetCurrentPeriod();
        super.onLoad();
        this.initFormatTable();
    }

    protected void initDapButtons() throws Exception {
        super.initDapButtons();
        this.actionVoucher.setVisible(false);
        this.actionVoucher.setEnabled(false);
        Object period = this.filterUI.prmtPeriod.getValue();
        if (period != null && period instanceof PeriodInfo) {
            String periodID = ((PeriodInfo)period).getId().toString();
            if (!this._period.getId().toString().equals(periodID)) {
                this.actionByAll.setEnabled(false);
                this.actionByBill.setEnabled(false);
                this.actionDelVoucher.setEnabled(false);
            } else {
                this.actionByAll.setEnabled(true);
                this.actionByBill.setEnabled(true);
                this.actionDelVoucher.setEnabled(true);
            }
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.actionAuditResult.setVisible(false);
        this.actionTraceDown.setVisible(true);
        this.actionDelVoucher.setVisible(true);
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.ncm.bill.client.MaterialAllocEditUI";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MaterialReqBillFactory.getRemoteInstance();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnByAll.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.btnByBill.setIcon(EASResource.getIcon((String)"imgTbtn_flowexample"));
        this.btnViewAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuItemAutoAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.menuItemManuAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_flowexample"));
        this.menuItemViewAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.menuItemViewLog.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        try {
            PeriodInfo period = this.GetCurrentPeriod();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)String.valueOf(4)));
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.getCompanyOrgInfoWithDefault().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("entry.costCenterOrgUnit.costCenterType", (Object)this.getCostCenterType(), CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("transactionType.isManuCostCalculate", (Object)String.valueOf(true)));
            FilterItemInfo newItem = null;
            newItem = new FilterItemInfo("entry.IsAdmeasure", (Object)1, CompareType.EQUALS, false);
            filter.getFilterItems().add(newItem);
            try {
                if (ev.getFilter() != null) {
                    ev.getFilter().mergeFilter(filter, "and");
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("year", (Object)String.valueOf(period.getPeriodYear()), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("period", (Object)String.valueOf(period.getPeriodNumber()), CompareType.EQUALS));
                    ev.setFilter(filter);
                }
                this._currFilterInfo = (FilterInfo)ev.getFilter().clone();
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private PeriodInfo GetCurrentPeriod() throws BOSException, EASBizException {
        return NCMUtils.GetCurrentPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog == null) {
            this.dialog = super.initCommonQueryDialog();
        }
        NCMCommonQueryProcessor cmcq = new NCMCommonQueryProcessor();
        cmcq.set("companyOrg", (Object)this.getCompanyOrgInfoWithDefault().getId().toString());
        cmcq.set("query", (Object)"MaterialAllocQuery");
        this.dialog.setProcessor((IProcessor)cmcq);
        return this.dialog;
    }

    protected CustomerQueryPanel getFilterUI() {
        if (this.filterUI == null) {
            try {
                this.filterUI = new MaterialAllocVoucherFilterUI();
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
        }
        return this.filterUI;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return new FilterInfo();
    }

    private void setMergeColumn() {
        this.tblMain.checkParsed();
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn("number").setGroup(true);
        this.tblMain.getColumn("number").setMergeable(true);
        this.tblMain.getColumn("fiVouchered").setGroup(true);
        this.tblMain.getColumn("fiVouchered").setMergeable(true);
        this.tblMain.getColumn("vouchernumber").setGroup(true);
        this.tblMain.getColumn("vouchernumber").setMergeable(true);
        this.tblMain.getColumn("baseStatus").setGroup(true);
        this.tblMain.getColumn("baseStatus").setMergeable(true);
        this.tblMain.getColumn("transactionType.name").setGroup(true);
        this.tblMain.getColumn("transactionType.name").setMergeable(true);
        this.tblMain.getColumn("bizDate").setGroup(true);
        this.tblMain.getColumn("bizDate").setMergeable(true);
        this.tblMain.getColumn("costCenterOrgUnit.number").setGroup(true);
        this.tblMain.getColumn("costCenterOrgUnit.number").setMergeable(true);
        this.tblMain.getColumn("costCenterOrgUnit.name").setGroup(true);
        this.tblMain.getColumn("costCenterOrgUnit.name").setMergeable(true);
        this.tblMain.getColumn("companyOrg.name").setGroup(true);
        this.tblMain.getColumn("companyOrg.name").setMergeable(true);
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        int amoutPre = 2;
        int priceprec = 8;
        int baseUnitprce = 8;
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                baseUnitprce = rowSet.getInt("baseUnit.qtyPrecision");
                priceprec = rowSet.getInt("material.pricePrecision");
                amoutPre = rowSet.getInt("baseCurrency.precision");
                NCMClientUtils.iniColumnsPrecision((int)baseUnitprce, (String[])new String[]{QtyCol}, (IRowSet)rowSet);
                NCMClientUtils.iniColumnsPrecision((int)priceprec, (String[])new String[]{PriceCol}, (IRowSet)rowSet);
                NCMClientUtils.iniColumnsPrecision((int)amoutPre, (String[])new String[]{AmtCol}, (IRowSet)rowSet);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    public void initFormatTable() throws Exception {
        this.tblMain.getColumn(QtyCol).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(PriceCol).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(AmtCol).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat("yyyy-MM-dd HH:mm:ss");
        String[] cols = new String[]{QtyCol, PriceCol, AmtCol};
        NCMClientUtils.setTableColumnsFormat((KDTable)this.tblMain, (String[])cols, (String)"%{0.##########}f");
        this.setMergeColumn();
        this.tblMain.getSelectManager().setSelectMode(10);
        String[] a = new String[]{QtyCol, CommQtyCol, AssisQtyCol, PriceCol, AmtCol};
        NCMClientUtils.setTableColumnsFormat((KDTable)this.tblMain, (String[])a, (String)"%{###,###,###.##########}f");
    }

    private FilterInfo GetManuFilter(FilterInfo filter) {
        int top = this.tblMain.getSelectManager().get(0).getBeginRow();
        String id = this.tblMain.getRow(top).getCell(Col_ID).getValue().toString();
        String entryId = this.tblMain.getRow(top).getCell(Col_EntryID).getValue().toString();
        FilterInfo ret = new FilterInfo();
        try {
            FilterInfo addfilter = new FilterInfo();
            addfilter.getFilterItems().add(new FilterItemInfo(Col_ID, (Object)id));
            addfilter.getFilterItems().add(new FilterItemInfo(Col_EntryID, (Object)entryId));
            try {
                ret.mergeFilter(filter, "and ");
                ret.mergeFilter(addfilter, "and");
                return ret;
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return ret;
    }

    @Override
    public void actionByAll_actionPerformed(ActionEvent e) throws Exception {
        this.check();
        BOTMappingInfo botMappingInfo = VoucherDAPTransImpl.getBotpInfo((CoreUI)this, null, "ADC37CB3", this.getCompanyOrgInfoWithDefault());
        if (botMappingInfo != null) {
            MatAllocResultVoucheredFactory.getRemoteInstance().addVoucherByAll(this.getSelectedIdValues(), this.getCompanyOrgInfoWithDefault().getId().toString(), this._period.getId().toString(), botMappingInfo);
            this.showWindow(botMappingInfo);
            this.refresh(e);
        }
    }

    @Override
    public void actionByBill_actionPerformed(ActionEvent e) throws Exception {
        this.check();
        BOTMappingInfo botMappingInfo = VoucherDAPTransImpl.getBotpInfo((CoreUI)this, null, "ADC37CB3", this.getCompanyOrgInfoWithDefault());
        if (botMappingInfo != null) {
            MatAllocResultVoucheredFactory.getRemoteInstance().addVoucherByBill(this.getSelectedIdValues(), this.getCompanyOrgInfoWithDefault().getId().toString(), this._period.getId().toString(), botMappingInfo);
            this.showWindow(botMappingInfo);
            this.refresh(e);
        }
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    @Override
    public void actionViewAlloc_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewAlloc_actionPerformed(e);
        this.showAllocEditUI("VIEW");
    }

    private void showAllocEditUI(String operType) throws Exception {
        this.checkSelected();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("companyId", this.getCompanyOrgInfoWithDefault().getId().toString());
        param.put("periodId", this._period.getId().toString());
        param.put("companyName", this.getCompanyOrgInfoWithDefault().getName().toString());
        param.put("periodNumber", String.valueOf(this._period.getNumber()));
        param.put("filterInfo", (String)this.GetManuFilter(this._currFilterInfo));
        MaterialAllocEditUI.showAllocEditUI((CoreUIObject)this, param, (String)operType, (KDTable)this.tblMain);
    }

    public void check() throws Exception {
        this.checkSelected();
        ISystemStatusCtrol ctrol = SystemStatusCtrolFactory.getRemoteInstance();
        if (!NCMUtils.isEquals((PeriodInfo)ctrol.getCacheCurrentPeriod(6, this.getCompanyOrgInfoWithDefault().getId().toString()), (PeriodInfo)this._period)) {
            throw new CMBillException(CMBillException.NOTEQUALS_VOUCHER);
        }
    }

    protected ArrayList getSelectedIdValues() {
        return super.getSelectedIdValues();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.checkVoucherPermission("material_viewAlloc");
            this.actionViewAlloc_actionPerformed(null);
        }
    }

    protected void initKeyStroke() {
        this.tblMain.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "View_1");
        this.tblMain.getActionMap().put("View_1", new AbstractAction(){
            private static final long serialVersionUID = -5669325198048189263L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionEvent evt = new ActionEvent(MaterialAllocVoucherListUI.this.btnViewAlloc, 0, "Enter");
                ItemAction actView = MaterialAllocVoucherListUI.this.getActionFromActionEvent(evt);
                actView.actionPerformed(evt);
            }
        });
    }

    private boolean checkVoucherPermission(String printPermission) throws Exception {
        boolean bPermission = false;
        if (!printPermission.equals("")) {
            PermissionHelper.checkFunctionPermission(null, null, (String)printPermission);
            bPermission = true;
        }
        return bPermission;
    }

    @Override
    public void actionViewBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MaterialReqBillEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private void showWindow(BOTMappingInfo botMappingInfo) throws Exception {
        if (botMappingInfo == null || botMappingInfo.isEmpty()) {
            return;
        }
        ArrayList ids = this.getSelectedIdValues();
        if (ids == null || ids.isEmpty()) {
            return;
        }
        String id = ids.get(0).toString();
        MaterialReqBillInfo reqBillInfo = MaterialReqBillFactory.getRemoteInstance().getMaterialReqBillInfo((IObjectPK)new ObjectUuidPK(id));
        if (reqBillInfo.getVoucher() == null || reqBillInfo.getVoucher().getId() == null) {
            return;
        }
        ArrayList<String> voucherIdList = new ArrayList<String>();
        voucherIdList.add(reqBillInfo.getVoucher().getId().toString());
        HashMap<String, String> param = new HashMap<String, String>();
        IUIWindow uiWindow = null;
        if (botMappingInfo.getIsShowEditUI() == 1) {
            RealModeIDList idList = RealModeIDList.getEmptyIDList();
            int size = voucherIdList.toArray().length;
            for (int i = 0; i < size; ++i) {
                idList.add(voucherIdList.toArray()[i].toString());
                param.put("ID", idList.getCurrentID());
                param.put("IDList", (String)idList);
            }
            try {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.VoucherEditUI", param, null, OprtState.EDIT);
            }
            catch (UIException e) {
                throw new BOSException((Throwable)e);
            }
        } else if (botMappingInfo.getIsShowEditUI() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.btp.btpResource.transSuccess"));
            return;
        }
        if (uiWindow != null) {
            uiWindow.show();
        }
        if (uiWindow instanceof JFrame) {
            ((JFrame)uiWindow).setExtendedState(6);
        }
    }

    protected boolean isEnableMultiOrgSupport() {
        return true;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor test = super.getQueryExecutor(queryPK, viewInfo);
        return test;
    }

    public void afterFilterUIMainOrgChanged(ChangeEvent e) {
        try {
            this._period = NCMUtils.GetCurrentPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        }
        catch (EASBizException e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
        catch (BOSException e2) {
            ExceptionHandler.handle((Throwable)e2);
        }
    }

    protected Set getCostCenterType() {
        HashSet<Integer> ccoTypeSet = new HashSet<Integer>();
        ccoTypeSet.add(0);
        ccoTypeSet.add(1);
        return ccoTypeSet;
    }
}

