/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.client;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.ncm.cal.client.AbstractRecoveryStep4UI;
import com.kingdee.eas.ncm.cal.utils.CalculateUtil;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class RecoveryStep4UI
extends AbstractRecoveryStep4UI {
    private static final Logger logger = CoreUIObject.getLogger(RecoveryStep4UI.class);

    public RecoveryStep4UI() throws Exception {
        this.initUIContentLayout();
        this.lblProgress.setVisible(false);
    }

    public void CreateProgressTree(KDTree tree, int totalRank, Map progressData) {
        if (tree == null) {
            return;
        }
        tree.removeAll();
        String StatusCompleted = CalculateUtil.getClientCalResource("Recovery_Calc_Progress_status_Completed");
        String StatusDoing = CalculateUtil.getClientCalResource("Recovery_Calc_Progress_status_Doing");
        String rootNodeStr = MessageFormat.format(CalculateUtil.getClientCalResource("Recovery_Calc_Progress_Boot"), String.valueOf(totalRank));
        String rankNodeFormat = CalculateUtil.getClientCalResource("Recovery_Calc_Progress_Rank");
        KDTreeNode root = new KDTreeNode((Object)rootNodeStr);
        KDTreeNode lastRankNode = null;
        Object lastDispRank = null;
        for (Map.Entry e : progressData.entrySet()) {
            String dispRank = e.getKey().toString();
            String[] detailInfo = (String[])e.getValue();
            String rankNodeStr = MessageFormat.format(rankNodeFormat, dispRank, StatusCompleted);
            KDTreeNode rankNode = new KDTreeNode((Object)rankNodeStr);
            for (int i = 0; i < detailInfo.length; ++i) {
                String info = detailInfo[i];
                KDTreeNode detailNode = new KDTreeNode((Object)info);
                rankNode.add((MutableTreeNode)detailNode);
            }
            root.add((MutableTreeNode)rankNode);
            lastRankNode = rankNode;
        }
        if (lastRankNode != null) {
            lastRankNode.setText(MessageFormat.format(rankNodeFormat, lastDispRank, StatusDoing));
        }
        KingdeeTreeModel model = new KingdeeTreeModel((TreeNode)root);
        tree.setModel((TreeModel)model);
        KDTreeNode rootNode = (KDTreeNode)((KingdeeTreeModel)tree.getModel()).getRoot();
        if (rootNode.getChildCount() > 0) {
            tree.setSelectionNode((DefaultKingdeeTreeNode)((KDTreeNode)rootNode.getLastChild()));
        } else {
            tree.setSelectionNode((DefaultKingdeeTreeNode)rootNode);
        }
    }

    public void ShowProgress(boolean toShow) {
        this.kDProgressBar.setVisible(toShow);
        this.pnlProgress.setVisible(toShow);
        this.cbGenVoucherData.setEnabled(!toShow);
    }
}

