/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ncm.cal.CalCostFacadeFactory;
import com.kingdee.eas.ncm.cal.ICalCostFacade;
import com.kingdee.eas.ncm.cal.client.AbstractRecoveryWizard;
import com.kingdee.eas.ncm.cal.client.RecoveryStep1UI;
import com.kingdee.eas.ncm.cal.client.RecoveryStep2UI;
import com.kingdee.eas.ncm.cal.client.RecoveryStep3UI;
import com.kingdee.eas.ncm.cal.client.RecoveryStep4UI;
import com.kingdee.eas.ncm.cal.client.RecoveryStep5UI;
import com.kingdee.eas.ncm.cal.client.ReportListElement;
import com.kingdee.eas.ncm.cal.utils.CalculateUtil;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.NCMCommonFacadeFactory;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.common.utils.client.OrgUnitClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LowTimer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class RecoveryWizard
extends AbstractRecoveryWizard {
    private static final Logger logger = CoreUIObject.getLogger(RecoveryWizard.class);
    private String opertPermItemName = "";
    private String strTitle1 = MessageFormat.format(CalculateUtil.getClientCalResource("RecoveryStepTitle"), "1", "5");
    private String strTitle2 = MessageFormat.format(CalculateUtil.getClientCalResource("RecoveryStepTitle"), "2", "5");
    private String strTitle3 = MessageFormat.format(CalculateUtil.getClientCalResource("RecoveryStepTitle"), "3", "5");
    private String strTitle4 = MessageFormat.format(CalculateUtil.getClientCalResource("RecoveryStepTitle"), "4", "5");
    private String strTitle5 = MessageFormat.format(CalculateUtil.getClientCalResource("RecoveryStepTitle"), "5", "5");
    private Map BaseInfoForWizardForm;
    private RecoveryStep1UI step1UI;
    private RecoveryStep2UI step2UI;
    private RecoveryStep3UI step3UI;
    private RecoveryStep4UI step4UI;
    private RecoveryStep5UI step5UI;
    private CompanyOrgUnitInfo companyOrg = null;
    private PeriodInfo currPeriod = null;
    private boolean isRunning = false;
    private boolean bCanContinueRecovery = true;

    public RecoveryWizard() throws Exception {
        NCMClientUtils.menuUpgradeHint();
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        this.companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        if (!this.companyOrg.isIsBizUnit()) {
            this.companyOrg = (CompanyOrgUnitInfo)this.getBizOrgUnitInfo();
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("companyId", this.companyOrg.getId().toString());
        this.BaseInfoForWizardForm = NCMCommonFacadeFactory.getRemoteInstance().getBaseInfoForWizardForm(param);
        this.BaseInfoForWizardForm.put("CompanyOrg", this.companyOrg);
        if (String.valueOf(false).compareTo(this.BaseInfoForWizardForm.get("IsCostStart").toString()) == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CheckResource.IS_NOT_START"));
            SysUtil.abort();
        }
        if (String.valueOf(false).compareTo(this.BaseInfoForWizardForm.get("IsCostStart").toString()) == 0) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        this.currPeriod = (PeriodInfo)this.BaseInfoForWizardForm.get("currPeriod");
        this.step1UI = new RecoveryStep1UI();
        this.step2UI = new RecoveryStep2UI();
        this.step3UI = new RecoveryStep3UI();
        this.step4UI = new RecoveryStep4UI();
        this.step5UI = new RecoveryStep5UI();
        this.lblImage.setIcon(EASResource.getIcon((String)"imgGuide_pic260"));
    }

    protected OrgUnitInfo getBizOrgUnitInfo() {
        if (this.opertPermItemName == null) {
            return null;
        }
        OrgType orgType = this.getMainBizOrgType();
        Context mainOrgContext = new Context();
        this.getUIContext().put(orgType, SysContext.getSysContext().getCurrentOrgUnit(orgType));
        OrgUnitInfo org = SysContext.getSysContext().getCurrentOrgUnit(orgType);
        if (org != null && org.getId() != null) {
            this.initUIMainOrgContextnNew(org.getId().toString(), mainOrgContext);
        }
        return OrgUnitClientUtils.getBizOrgUnitInfo((String)this.opertPermItemName, (OrgType)orgType, (Context)mainOrgContext);
    }

    private void initUIMainOrgContextnNew(String orgID, Context mainOrgContext) {
        if (mainOrgContext == null) {
            mainOrgContext = new Context();
        }
        try {
            FrameWorkUtils.switchOrg((Context)mainOrgContext, (String)orgID);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.step1UI.InitCompanyAndPeriodInfo(this.BaseInfoForWizardForm);
        NCMClientUtils.requestMutex((CoreUI)this, (String)this.companyOrg.getId().toString());
    }

    public boolean destroyWindow() {
        NCMClientUtils.releaseMutex((CoreUI)this, (String)this.companyOrg.getId().toString());
        return super.destroyWindow();
    }

    protected boolean checkBeforeWindowClosing() {
        return !this.isRunning;
    }

    public String getUITitle() {
        return this.strTitle1;
    }

    public void setStrTitle(String str) {
        super.setUITitle(str);
    }

    @Override
    public void initUIContentLayout() {
        this.setPreferredSize(new Dimension(475, 350));
        super.initUIContentLayout();
        this.getUIMenuBar().setVisible(false);
        this.kDPanel1.setVisible(true);
        this.kDPanel1.add((Component)((Object)this.step1UI), (Object)"Center");
        this.kDPanel1.add((Component)((Object)this.step2UI), (Object)"Center");
        this.kDPanel1.add((Component)((Object)this.step3UI), (Object)"Center");
        this.kDPanel1.add((Component)((Object)this.step4UI), (Object)"Center");
        this.kDPanel1.add((Component)((Object)this.step5UI), (Object)"Center");
        this.setStep(1);
    }

    @Override
    protected void kDButtonPer2_actionPerformed(ActionEvent e) throws Exception {
        super.kDButtonPer1_actionPerformed(e);
        this.setStep(1);
    }

    @Override
    protected void kDButtonNext1_actionPerformed(ActionEvent e) throws Exception {
        if (this.step1UI.prmtCompany.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CalResource.COMPANY_PERIOD_ISNULL"));
            SysUtil.abort();
        }
        if (this.step1UI.prmtCalculatePeriod.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CalResource.COMPANY_PERIOD_ISNULL"));
            SysUtil.abort();
        }
        super.kDButtonNext1_actionPerformed(e);
        this.setStep(2);
    }

    @Override
    protected void kDButtonPer3_actionPerformed(ActionEvent e) throws Exception {
        super.kDButtonPer1_actionPerformed(e);
        this.setStep(2);
    }

    @Override
    protected void kDButtonNext2_actionPerformed(ActionEvent e) throws Exception {
        super.kDButtonNext2_actionPerformed(e);
        if (this.step2UI.cbRecoveryCheck.getSelected() == 16) {
            this.step3UI.setState(1);
            this.setStep(3);
        } else {
            this.runCheckThread();
        }
    }

    @Override
    protected void kDButtonPer4_actionPerformed(ActionEvent e) throws Exception {
        super.kDButtonPer1_actionPerformed(e);
        this.setStep(3);
    }

    @Override
    protected void kDButtonNext3_actionPerformed(ActionEvent e) throws Exception {
        super.kDButtonNext1_actionPerformed(e);
        this.setStep(4);
    }

    @Override
    protected void kDButtonPer5_actionPerformed(ActionEvent e) throws Exception {
        super.kDButtonPer1_actionPerformed(e);
        this.setStep(4);
    }

    @Override
    protected void kDButtonNext4_actionPerformed(ActionEvent e) throws Exception {
        super.kDButtonNext2_actionPerformed(e);
        if (this.step4UI.cbRecoveryCalc.getSelected() == 16 && this.step4UI.cbGenReportData.getSelected() == 16 && this.step4UI.cbGenVoucherData.getSelected() == 16) {
            MsgBox.showInfo((String)CalculateUtil.getClientCalResource("RecoveryNeedToPick"));
            SysUtil.abort();
        }
        if (!this.bCanContinueRecovery) {
            MsgBox.showInfo((String)CalculateUtil.getClientCalResource("RecoveryWizard_CanContinueRecovery"));
            SysUtil.abort();
        }
        this.runCalThread();
    }

    @Override
    protected void kDButtonCancel_actionPerformed(ActionEvent e) throws Exception {
        super.kDButtonCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    protected void kDButtonEnd_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    protected void runCheckThread() {
        logger.debug((Object)String.valueOf(0));
        RunCheckThread runAllocThread = new RunCheckThread();
        runAllocThread.setDaemon(true);
        runAllocThread.start();
        Date nowEnd = new Date();
        logger.debug((Object)("RunCheckThread end at : " + nowEnd));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCheck() {
        this.kDButtonNext2.setEnabled(false);
        this.kDButtonPer2.setEnabled(false);
        this.kDButtonCancel.setEnabled(false);
        LowTimer st = new LowTimer();
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        ComponentUtil.setWindowsCursorOfWair((Window)window);
        String getcalcHMSString = "";
        long endTime = 0L;
        try {
            this.isRunning = true;
            this.step3UI.lstReportList.removeAllElements();
            this.step2UI.ShowProgress(true);
            if (this.step2UI.cbRecoveryCheck.getSelected() == 32) {
                this.step2UI.kDProgressBar.setStringPainted(true);
                this.step2UI.kDProgressBar.setString(CalculateUtil.getClientCalResource("RecoveryWiz_Checking"));
                this.step2UI.lblProgress.setText(CalculateUtil.getClientCalResource("RecoveryWiz_Checking"));
                this.step2UI.kDProgressBar.setIndeterminate(true);
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("companyId", this.companyOrg.getId().toString());
                param.put("companyName", this.companyOrg.getName().toString());
                param.put("periodId", this.currPeriod.getId().toString());
                param.put("periodDispNumber", String.valueOf(this.currPeriod.getNumber()));
                param.put("periodNumber", String.valueOf(this.currPeriod.getPeriodNumber()));
                param.put("periodYear", String.valueOf(this.currPeriod.getPeriodYear()));
                UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
                param.put("userId", user.getId().toString());
                param.put("ReInitBop", String.valueOf(this.step1UI.kDCheckBoxReInitBop.getSelected() == 32));
                ICalCostFacade iCalCostFacade = CalCostFacadeFactory.getRemoteInstance();
                Map resultMap = iCalCostFacade.CostRecoveryCheck(param);
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("companyId", this.companyOrg.getId().toString());
                data.put("companyName", this.companyOrg.getName().toString());
                data.put("periodId", this.currPeriod.getId().toString());
                data.put("periodDispNumber", String.valueOf(this.currPeriod.getNumber()));
                data.put("logData", (String)resultMap.get("logData"));
                ReportListElement item = new ReportListElement(CalculateUtil.getClientCalResource("RecoveryWizCheckReport"), data);
                this.step3UI.lstReportList.addElement((Object)item);
                if (resultMap.get("HasError").equals(String.valueOf(true))) {
                    this.step3UI.setState(3);
                } else {
                    this.step3UI.setState(2);
                }
                if (resultMap.get("CanContinueRecovery").equals(String.valueOf(false))) {
                    this.bCanContinueRecovery = false;
                }
            }
            this.setStep(3);
            endTime = st.msValue();
            getcalcHMSString = CalculateUtil.getcalcHMSString((int)endTime);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
        finally {
            String costTime = CalculateUtil.getClientCalResource("COSTIME");
            this.step2UI.kDProgressBar.setIndeterminate(false);
            this.step2UI.kDProgressBar.setValue(this.step2UI.kDProgressBar.getMaximum());
            this.step2UI.kDProgressBar.setString(CalculateUtil.getClientCalResource("Recovery_Check_COMPLETE") + " " + costTime + getcalcHMSString);
            this.step3UI.lblSpendTime.setText(costTime + getcalcHMSString);
            this.step2UI.lblProgress.setText(CalculateUtil.getClientCalResource("Recovery_Check_COMPLETE"));
            ComponentUtil.setWindowCursorOfDefault((Window)window);
            this.step2UI.ShowProgress(false);
            this.kDButtonCancel.setEnabled(true);
            this.kDButtonNext2.setEnabled(true);
            this.kDButtonPer2.setEnabled(true);
            this.isRunning = false;
        }
    }

    protected void runCalThread() {
        logger.debug((Object)String.valueOf(0));
        RunCalThread runCalThread = new RunCalThread();
        runCalThread.setDaemon(true);
        runCalThread.start();
        Date nowEnd = new Date();
        logger.debug((Object)("RunCalThread end at : " + nowEnd));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCal() {
        this.isRunning = true;
        this.kDButtonNext4.setEnabled(false);
        this.kDButtonPer4.setEnabled(false);
        this.kDButtonCancel.setEnabled(false);
        LowTimer st = new LowTimer();
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        ComponentUtil.setWindowsCursorOfWair((Window)window);
        String getcalcHMSString = "";
        String currHint = "";
        long endTime = 0L;
        boolean isHalt = false;
        boolean hasError = false;
        try {
            this.step5UI.lstReportList.removeAllElements();
            this.step4UI.ShowProgress(true);
            currHint = CalculateUtil.getClientCalResource("Recovery_Calc_ING");
            this.step4UI.kDProgressBar.setStringPainted(true);
            this.step4UI.kDProgressBar.setString(currHint);
            this.step4UI.lblProgress.setText(currHint);
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("companyId", this.companyOrg.getId().toString());
            param.put("periodId", this.currPeriod.getId().toString());
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            param.put("userId", user.getId().toString());
            param.put("companyName", this.companyOrg.getName().toString());
            param.put("periodDispNumber", String.valueOf(this.currPeriod.getNumber()));
            param.put("periodNumber", String.valueOf(this.currPeriod.getPeriodNumber()));
            param.put("periodYear", String.valueOf(this.currPeriod.getPeriodYear()));
            param.put("ReInitBop", String.valueOf(this.step1UI.kDCheckBoxReInitBop.getSelected() == 32));
            param.put("GenReportData", String.valueOf(this.step4UI.cbGenReportData.getSelected() == 32));
            param.put("GenVoucherData", String.valueOf(this.step4UI.cbGenVoucherData.getSelected() == 32));
            param.put("GenCOByPurInWarehsBill", String.valueOf(this.step4UI.checkBoxGenCO.getSelected() == 32));
            param.put("rank", String.valueOf(-1));
            param.put("dispRank", String.valueOf(-1));
            ICalCostFacade iCalCostFacade = CalCostFacadeFactory.getRemoteInstance();
            int lowestRank = iCalCostFacade.getLowestRankFromCalcResult(this.companyOrg.getId().toString(), this.currPeriod.getId().toString());
            int totalRank = lowestRank + 1;
            this.step4UI.kDProgressBar.setMaximum((totalRank + 2) * 100);
            currHint = CalculateUtil.getClientCalResource("Recovery_Calc_PreProcess");
            this.step4UI.kDProgressBar.setStringPainted(true);
            this.step4UI.kDProgressBar.setString(currHint);
            this.step4UI.lblProgress.setText(currHint);
            String instanceDetail = param.get("companyName") + " " + param.get("periodYear") + EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"18_AccountClosingUI") + param.get("periodNumber") + EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"19_CostResultRptUI");
            IObjectPK logPK = LogUtil.beginLog(null, (String)"CostRecovery", (BOSObjectType)iCalCostFacade.getType(), null, (String)instanceDetail, (String)"RecoveryCalCost_calc");
            iCalCostFacade.CostRecoveryPreProcess(param);
            this.step4UI.kDProgressBar.setValue(100);
            int dispRank = 0;
            Map resultMap = null;
            for (int rank = lowestRank; rank >= 0; --rank) {
                param.put("rank", String.valueOf(rank));
                param.put("dispRank", String.valueOf(++dispRank));
                currHint = MessageFormat.format(CalculateUtil.getClientCalResource("Recovery_Calc_CurrRank"), String.valueOf(dispRank), String.valueOf(totalRank));
                this.step4UI.kDProgressBar.setStringPainted(true);
                this.step4UI.kDProgressBar.setString(currHint);
                this.step4UI.lblProgress.setText(currHint);
                resultMap = iCalCostFacade.CostRecovery(param);
                this.step4UI.kDProgressBar.setValue((dispRank + 1) * 100);
            }
            currHint = CalculateUtil.getClientCalResource("Recovery_Calc_EndProcess");
            this.step4UI.kDProgressBar.setStringPainted(true);
            this.step4UI.kDProgressBar.setString(currHint);
            this.step4UI.lblProgress.setText(currHint);
            iCalCostFacade.CostRecoveryEndProcess(param);
            LogUtil.afterLog(null, (IObjectPK)logPK);
            this.step4UI.lblProgress.setText(CalculateUtil.getClientCalResource("Recovery_Calc_Complete"));
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("companyId", this.companyOrg.getId().toString());
            data.put("periodId", this.currPeriod.getId().toString());
            data.put("companyName", this.companyOrg.getName());
            data.put("periodDispNumber", String.valueOf(this.currPeriod.getNumber()));
            if (resultMap.containsKey("logData")) {
                data.put("logData", (String)resultMap.get("logData"));
            }
            ReportListElement item = new ReportListElement(CalculateUtil.getClientCalResource("Recovery_Calc_Report"), data);
            this.step5UI.lstReportList.addElement((Object)item);
            if (resultMap.get("HasError").equals(String.valueOf(true))) {
                hasError = true;
            }
            this.setStep(5);
            endTime = st.msValue();
            getcalcHMSString = CalculateUtil.getcalcHMSString((int)endTime);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
        finally {
            if (hasError) {
                this.step5UI.setState(2);
            } else {
                this.step5UI.setState(1);
            }
            String costTime = CalculateUtil.getClientCalResource("COSTIME");
            this.step4UI.kDProgressBar.setValue(this.step4UI.kDProgressBar.getMaximum());
            this.step4UI.kDProgressBar.setString(CalculateUtil.getClientCalResource("COST_CAL_COMPLETE") + " " + costTime + getcalcHMSString);
            ComponentUtil.setWindowCursorOfDefault((Window)window);
            this.kDButtonEnd.setEnabled(true);
            this.kDButtonCancel.setEnabled(true);
            this.kDButtonNext4.setEnabled(true);
            this.kDButtonPer4.setEnabled(true);
            this.step4UI.ShowProgress(false);
            this.isRunning = false;
        }
    }

    private void setStep(int step) {
        this.step1UI.setVisible(step == 1);
        this.step2UI.setVisible(step == 2);
        this.step3UI.setVisible(step == 3);
        this.step4UI.setVisible(step == 4);
        this.step5UI.setVisible(step == 5);
        this.kDButtonPer1.setVisible(step == 1);
        this.kDButtonPer1.setEnabled(false);
        this.kDButtonPer2.setVisible(step == 2);
        this.kDButtonPer2.setEnabled(step == 2);
        this.kDButtonPer3.setVisible(step == 3);
        this.kDButtonPer3.setEnabled(step == 3);
        this.kDButtonPer4.setVisible(step == 4);
        this.kDButtonPer4.setEnabled(step == 4);
        this.kDButtonPer5.setVisible(step == 5);
        this.kDButtonPer5.setEnabled(step == 5);
        this.kDButtonNext1.setVisible(step == 1);
        this.kDButtonNext1.setEnabled(step == 1);
        this.kDButtonNext2.setVisible(step == 2);
        this.kDButtonNext2.setEnabled(step == 2);
        this.kDButtonNext3.setVisible(step == 3);
        this.kDButtonNext3.setEnabled(step == 3);
        this.kDButtonNext4.setVisible(step == 4);
        this.kDButtonNext4.setEnabled(step == 4);
        this.kDButtonNext5.setVisible(step == 5);
        this.kDButtonNext5.setEnabled(false);
        this.kDButtonEnd.setVisible(true);
        this.kDButtonEnd.setEnabled(step == 5);
        switch (step) {
            case 1: {
                this.setStrTitle(this.strTitle1);
                break;
            }
            case 2: {
                this.setStrTitle(this.strTitle2);
                break;
            }
            case 3: {
                this.setStrTitle(this.strTitle3);
                break;
            }
            case 4: {
                this.setStrTitle(this.strTitle4);
                break;
            }
            case 5: {
                this.setStrTitle(this.strTitle5);
                break;
            }
        }
    }

    @Override
    protected void kDButtonViewReport_mouseClicked(MouseEvent e) throws Exception {
        super.kDButtonViewReport_mouseClicked(e);
        UIContext uiContext = new UIContext((Object)this);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create("com.kingdee.eas.ncm.cal.client.LogReportPickUI", (Map)uiContext, null);
        window.show();
    }

    class RunCalThread
    extends Thread {
        @Override
        public void run() {
            RecoveryWizard.this.runCal();
        }
    }

    class RunCheckThread
    extends Thread {
        @Override
        public void run() {
            RecoveryWizard.this.runCheck();
        }
    }
}

