/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.birpt.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.ncm.cal.report.birpt.client.AbstractStructureAnalyseFixFilterUI;
import com.kingdee.eas.ncm.cal.report.client.ReportSpinnerUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Container;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import org.apache.log4j.Logger;

public class StructureAnalyseFixFilterUI
extends AbstractStructureAnalyseFixFilterUI {
    private static final long serialVersionUID = 7484159906140449709L;
    private static final Logger logger = CoreUIObject.getLogger(StructureAnalyseFixFilterUI.class);
    protected Object[][] periods = null;
    private static final String rptPeriodsKey = "RPT_PERIODS_KEY";

    public Object[][] getPeriods() {
        if (this.periods == null) {
            return null;
        }
        return (Object[][])this.periods.clone();
    }

    public void setPeriods(Object[][] period) {
        this.periods = period == null ? (Object[][])null : (Object[][])period.clone();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.filterOrder(this.prmtOrder);
        this.filterProject(this.prmtProject);
        this.filterTrack(this.prmtTrack);
        this.filterMaterial(this.prmtMaterial);
        super.registerPeriodComponents(this.spinnerYearFrom, this.spinnerMonthFrom, this.spinnerYearTo, this.spinnerMonthTo, this.btnSPPeriod, "getPeriods", "setPeriods");
    }

    public void clear() {
        super.clear();
        try {
            this.periods = null;
            super.registerPeriodComponents(this.spinnerYearFrom, this.spinnerMonthFrom, this.spinnerYearTo, this.spinnerMonthTo, this.btnSPPeriod, "getPeriods", "setPeriods");
            this.prmtCostCenter.setData(null);
            this.prmtCostObject.setData(null);
            this.prmtCostItem.setData(null);
            this.prmtOrder.setData(null);
            this.prmtProject.setData(null);
            this.prmtTrack.setData(null);
            this.prmtMaterial.setData(null);
            this.tfBatch.setText("");
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    @Override
    public RptParams getCustomCondition() {
        RptConditionManager rm = new RptConditionManager();
        rm.recordAllStatus((Container)((Object)this));
        rm.setProperty(rptPeriodsKey, (Object)this.periods);
        return rm.toRptParams();
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            this.setParam(RptParamsUtil.getFromCustomerParams((CustomerParams)cp));
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.common.CommonResource", (String)"QueryFail"));
        }
    }

    @Override
    public void setCustomCondition(RptParams rptParams) {
        try {
            RptConditionManager rm = new RptConditionManager(rptParams);
            rm.restoreAllStatus((Container)((Object)this));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        Object periodsParam = rptParams.getObject(rptPeriodsKey);
        if (periodsParam instanceof Object[][]) {
            this.periods = (Object[][])periodsParam;
            this.spinnerYearFrom.setEnabled(false);
            this.spinnerMonthFrom.setEnabled(false);
            this.spinnerYearTo.setEnabled(false);
            this.spinnerMonthTo.setEnabled(false);
            this.spinnerYearFrom.setModel((SpinnerModel)new SpinnerListModel(new Object[]{null}));
            this.spinnerMonthFrom.setModel((SpinnerModel)new SpinnerListModel(new Object[]{null}));
            this.spinnerYearTo.setModel((SpinnerModel)new SpinnerListModel(new Object[]{null}));
            this.spinnerMonthTo.setModel((SpinnerModel)new SpinnerListModel(new Object[]{null}));
        } else {
            this.periods = null;
            this.spinnerYearFrom.setEnabled(true);
            this.spinnerMonthFrom.setEnabled(true);
            this.spinnerYearTo.setEnabled(true);
            this.spinnerMonthTo.setEnabled(true);
            try {
                super.registerPeriodComponents(this.spinnerYearFrom, this.spinnerMonthFrom, this.spinnerYearTo, this.spinnerMonthTo, this.btnSPPeriod, "getPeriods", "setPeriods", this.getInitPeriods(rptParams, new String[]{"spinnerYearFrom.value", "spinnerMonthFrom.value", "spinnerYearTo.value", "spinnerMonthTo.value"}));
            }
            catch (Exception exc) {
                ExceptionHandler.handle((Throwable)exc);
            }
        }
    }

    @Override
    public boolean verify() {
        if (this.spinnerYearFrom.isEnabled() && this.spinnerMonthFrom.isEnabled() && this.spinnerYearTo.isEnabled() && this.spinnerMonthTo.isEnabled()) {
            int to;
            Integer yearFrom = this.spinnerYearFrom.getIntegerVlaue();
            Integer periodFrom = this.spinnerMonthFrom.getIntegerVlaue();
            Integer yearTo = this.spinnerYearTo.getIntegerVlaue();
            Integer periodTo = this.spinnerMonthTo.getIntegerVlaue();
            int from = ReportSpinnerUtil.getNumberOfPeriod(yearFrom, periodFrom);
            if (from > (to = ReportSpinnerUtil.getNumberOfPeriod(yearTo, periodTo))) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.birpt.CostAnalyseResource", (String)"PERIOD_ERROR"));
                return false;
            }
        }
        return super.verify();
    }
}

