/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.ncm.client.MaterialF7TreeListSelector;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.ncm.cal.report.client.AbstractCostBatchTotalReportFilterUI;
import com.kingdee.eas.ncm.cal.report.client.NCMReportFilterUI;
import com.kingdee.eas.ncm.cal.report.client.SingleSpinnerFilterElement;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.SpinnerUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashSet;
import javax.swing.JSpinner;
import org.apache.log4j.Logger;

public class CostBatchTotalReportFilterUI
extends AbstractCostBatchTotalReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CostBatchTotalReportFilterUI.class);
    private PeriodInfo currentPeriod;
    private PeriodInfo startPeriod;
    private PeriodInfo maxPeriod = null;
    private CustomerParams cp = null;
    private CompanyOrgUnitInfo companyOrg;

    public CostBatchTotalReportFilterUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        NCMClientUtils.checkIsStart();
        this.companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        this.currentPeriod = sysctrol.getCacheCurrentPeriod(1001, this.companyOrg.getId().toString());
        if (this.currentPeriod == null) {
            throw new CMBillException(CMBillException.NCMDIRECTSHOWMESG, new Object[]{EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"182_CCFeeTotalReportFilterUI")});
        }
        this.startPeriod = sysctrol.getStartPeriod(1001, this.companyOrg.getId().toString());
        this.maxPeriod = NCMUtils.getMaxPeriod((CompanyOrgUnitInfo)this.companyOrg, (PeriodInfo)this.currentPeriod);
        this.prmtCostObjectFrom.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.prmtCostObjectFrom, Boolean.TRUE);
        this.prmtCostObjectFrom.setSelector((KDPromptSelector)arg0);
        this.prmtCostObjectTo.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg1 = new CostObjectF7UISelector((Object)this, this.prmtCostObjectTo, Boolean.TRUE);
        this.prmtCostObjectTo.setSelector((KDPromptSelector)arg1);
    }

    @Override
    protected FilterElement getFilterElement() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        NCMReportFilterUI.SingleComPromptFilterElement filterElement = new NCMReportFilterUI.SingleComPromptFilterElement(this, "companyorg", this.prmtCompanyOrg);
        filterElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"183_CCFeeTotalReportFilterUI")));
        elements.add((FilterElement)filterElement);
        SingleSpinnerFilterElement element = new SingleSpinnerFilterElement("yearFrom", (Component)this.spYearFrom);
        elements.add((FilterElement)element);
        element = new SingleSpinnerFilterElement("yearTo", (Component)this.spYearTo);
        elements.add((FilterElement)element);
        element = new SingleSpinnerFilterElement("periodFrom", (Component)this.spPeriodFrom);
        elements.add((FilterElement)element);
        element = new SingleSpinnerFilterElement("periodTo", (Component)this.spPeriodTo);
        elements.add((FilterElement)element);
        elements.add((FilterElement)new SingleFilterElement("costcenterFrom", (Component)this.prmtCostCenterFrom));
        elements.add((FilterElement)new SingleFilterElement("costcenterTo", (Component)this.prmtCostCenterTo));
        elements.add((FilterElement)new SingleFilterElement("costobjectFrom", (Component)this.prmtCostObjectFrom));
        elements.add((FilterElement)new SingleFilterElement("costobjectTo", (Component)this.prmtCostObjectTo));
        elements.add((FilterElement)new SingleFilterElement("productFrom", (Component)this.prmtProductFrom));
        elements.add((FilterElement)new SingleFilterElement("productTo", (Component)this.prmtProductTo));
        elements.add((FilterElement)new SingleFilterElement("batchFrom", (Component)this.txtBatchFrom));
        elements.add((FilterElement)new SingleFilterElement("batchTo", (Component)this.txtBatchTo));
        elements.add((FilterElement)new SingleFilterElement("orderNumberFrom", (Component)this.prmtOrderNumberFrom));
        elements.add((FilterElement)new SingleFilterElement("orderNumberTo", (Component)this.prmtOrderNumberTo));
        return elements;
    }

    public void filterCostObject(KDBizPromptBox f7) {
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyOrg.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("COSTOBJECT.calculateMode", (Object)"4", CompareType.EQUALS));
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void clear() {
        this.getFilterManager().clearAll();
        this.setDefaultValue();
    }

    @Override
    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrg;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    public KDBizPromptBox getCompanyF7() {
        return this.prmtCompanyOrg;
    }

    @Override
    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    @Override
    protected void registerF7() throws Exception {
        super.registerF7();
        this.f7ContextManager.registerCostCenterF7(this.prmtCostCenterFrom);
        this.f7ContextManager.registerCostCenterF7(this.prmtCostCenterTo);
        this.f7ContextManager.registerCostObjectF7(this.prmtCostObjectFrom, true);
        this.f7ContextManager.registerCostObjectF7(this.prmtCostObjectTo, true);
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> statuses = new HashSet<Integer>();
        statuses.add(5);
        statuses.add(8);
        statuses.add(7);
        statuses.add(11);
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", statuses, CompareType.INCLUDE));
        this.f7ContextManager.registerManufactureOrderF7(this.prmtOrderNumberFrom, filter);
        this.f7ContextManager.registerManufactureOrderF7(this.prmtOrderNumberTo, filter);
        this.prmtOrderNumberFrom.setDisplayFormat("$number$");
        this.prmtOrderNumberTo.setDisplayFormat("$number$");
        this.f7ContextManager.registerMaterialTreeF7(this.prmtProductFrom, null);
        MaterialF7TreeListSelector selector1 = new MaterialF7TreeListSelector((Object)this, this.prmtProductFrom);
        this.prmtProductFrom.setSelector((KDPromptSelector)selector1);
        this.f7ContextManager.registerMaterialTreeF7(this.prmtProductTo, null);
        selector1 = new MaterialF7TreeListSelector((Object)this, this.prmtProductTo);
        this.prmtProductTo.setSelector((KDPromptSelector)selector1);
    }

    @Override
    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            try {
                this.prmtCostCenterFrom.setValue(null);
                this.prmtCostCenterTo.setValue(null);
                this.prmtCostObjectFrom.setValue(null);
                this.prmtCostObjectTo.setValue(null);
                this.prmtOrderNumberFrom.setValue(null);
                this.prmtOrderNumberTo.setValue(null);
                this.prmtProductFrom.setValue(null);
                this.prmtProductTo.setValue(null);
                this.txtBatchFrom.setText(null);
                this.txtBatchTo.setText(null);
                this.initPeriod(this.getCompanyOrgInfoWithDefault());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private void initPeriod(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        this.maxPeriod = NCMUtils.getMaxPeriod((CompanyOrgUnitInfo)company, (PeriodInfo)this.currentPeriod);
        this.startPeriod = NCMUtils.GetStartPeriod(null, (String)company.getId().toString());
        this.currentPeriod = NCMUtils.GetCurrentPeriod(null, (String)company.getId().toString());
        if (this.currentPeriod == null) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        if (this.startPeriod == null) {
            return;
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)this.currentPeriod);
    }

    @Override
    protected String getReportViewPermissionItem() {
        return "CostBatchTotalReportView";
    }

    @Override
    protected String getReportPrintPermissionItem() {
        return "CostBatchTotalReportPrint";
    }

    private boolean VerifyPeriod() {
        Integer periodTo;
        Integer yearTo;
        Integer periodFrom;
        boolean isOK = true;
        Integer yearFrom = (Integer)this.spYearFrom.getValue();
        if (yearFrom.compareTo(0) <= 0 || yearFrom.compareTo(1900) < 0 || yearFrom.compareTo(9998) > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"185_CostBatchTotalReportFilterUI"));
            isOK = false;
        }
        if ((periodFrom = (Integer)this.spPeriodFrom.getValue()).compareTo(0) <= 0 || periodFrom.compareTo(12) > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"186_CostBatchTotalReportFilterUI"));
            isOK = false;
        }
        if ((yearTo = (Integer)this.spYearTo.getValue()).compareTo(0) <= 0 || yearTo.compareTo(1900) < 0 || yearTo.compareTo(9998) > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"187_CostBatchTotalReportFilterUI"));
            isOK = false;
        }
        if ((periodTo = (Integer)this.spPeriodTo.getValue()).compareTo(0) <= 0 || periodTo.compareTo(12) > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"188_CostBatchTotalReportFilterUI"));
            isOK = false;
        }
        if (yearTo.compareTo(yearFrom) < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"184_CCFeeTotalReportFilterUI"));
            isOK = false;
        } else if (yearTo.compareTo(yearFrom) == 0 && periodTo.compareTo(periodFrom) < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"184_CCFeeTotalReportFilterUI"));
            isOK = false;
        }
        Integer curYear = this.currentPeriod.getPeriodYear();
        Integer curNumber = this.currentPeriod.getPeriodNumber();
        Integer startYear = this.startPeriod.getPeriodYear();
        Integer startNumber = this.startPeriod.getPeriodNumber();
        if (yearFrom.compareTo(startYear) < 0 || yearFrom.compareTo(startYear) == 0 && periodFrom.compareTo(startNumber) < 0) {
            this.spYearFrom.setValue((Object)startYear);
            this.spPeriodFrom.setValue((Object)startNumber);
        }
        if (yearTo.compareTo(startYear) < 0 || yearTo.compareTo(startYear) == 0 && periodTo.compareTo(startNumber) < 0) {
            this.spYearTo.setValue((Object)startYear);
            this.spPeriodTo.setValue((Object)startNumber);
        }
        if (yearFrom.compareTo(curYear) > 0 || yearFrom.compareTo(curYear) == 0 && periodFrom.compareTo(curNumber) > 0) {
            this.spYearFrom.setValue((Object)curYear);
            this.spPeriodFrom.setValue((Object)curNumber);
        }
        if (yearTo.compareTo(curYear) > 0 || yearTo.compareTo(curYear) == 0 && periodTo.compareTo(curNumber) > 0) {
            this.spYearTo.setValue((Object)curYear);
            this.spPeriodTo.setValue((Object)curNumber);
        }
        return isOK;
    }

    @Override
    protected void setDefaultValue() {
        CompanyOrgUnitInfo companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.prmtCompanyOrg.setValue((Object)companyOrg);
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)this.currentPeriod);
        this.prmtCostCenterFrom.setValue(null);
        this.prmtCostCenterTo.setValue(null);
        this.prmtCostObjectFrom.setValue(null);
        this.prmtCostObjectTo.setValue(null);
        this.prmtProductFrom.setValue(null);
        this.prmtProductTo.setValue(null);
        this.txtBatchFrom.setText("");
        this.txtBatchTo.setText("");
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    @Override
    protected KDSpinner[] getPeriodSpinner() {
        return new KDSpinner[]{this.spYearFrom, this.spYearTo, this.spPeriodFrom, this.spPeriodTo};
    }

    @Override
    protected KDBizPromptBox[] getCostCenterF7() {
        return new KDBizPromptBox[]{this.prmtCostCenterFrom, this.prmtCostCenterTo};
    }

    @Override
    protected KDBizPromptBox[] getCostObjectF7() {
        return new KDBizPromptBox[]{this.prmtCostObjectFrom, this.prmtCostObjectTo};
    }

    @Override
    protected KDBizPromptBox[] getOrderNumberF7() {
        return new KDBizPromptBox[]{this.prmtOrderNumberFrom, this.prmtOrderNumberTo};
    }

    @Override
    protected KDBizPromptBox[] getMaterialF7() {
        return new KDBizPromptBox[]{this.prmtProductFrom, this.prmtProductTo};
    }

    @Override
    protected KDTextField[] getBatchNumberCtrls() {
        return new KDTextField[]{this.txtBatchFrom, this.txtBatchTo};
    }

    @Override
    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CustomerParams params = this.cp;
        if (params != null) {
            this.loadPeriod(params);
        }
    }

    private void loadPeriod(CustomerParams params) {
        PeriodInfo initPeriodFrom = this.currentPeriod;
        PeriodInfo initPeriodTo = this.currentPeriod;
        String initYearFrom = params.getCustomerParam("spYearFrom");
        String initMonthFrom = params.getCustomerParam("spPeriodFrom");
        String initYearTo = params.getCustomerParam("spYearTo");
        String initMonthTo = params.getCustomerParam("spPeriodTo");
        try {
            if (!StringUtils.isEmpty((String)initYearFrom) && !StringUtils.isEmpty((String)initMonthFrom)) {
                initPeriodFrom = new PeriodInfo();
                initPeriodFrom.setPeriodYear(Integer.parseInt(initYearFrom));
                initPeriodFrom.setPeriodNumber(Integer.parseInt(initMonthFrom));
            }
            if (!StringUtils.isEmpty((String)initYearTo) && !StringUtils.isEmpty((String)initMonthTo)) {
                initPeriodTo = new PeriodInfo();
                initPeriodTo.setPeriodYear(Integer.parseInt(initYearTo));
                initPeriodTo.setPeriodNumber(Integer.parseInt(initMonthTo));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)initPeriodFrom, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)initPeriodTo);
    }
}

