/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.ncm.client.MaterialF7TreeListSelector;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.ncm.cal.report.client.AbstractCostCalTotalDetailReportFilterUI;
import com.kingdee.eas.ncm.cal.report.client.CheckBoxFilterElement;
import com.kingdee.eas.ncm.cal.report.client.SpinnerFilterElement;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.SpinnerUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class CostCalTotalDetailReportFilterUI
extends AbstractCostCalTotalDetailReportFilterUI
implements ActionListener {
    private static final Logger logger = CoreUIObject.getLogger(CostCalTotalDetailReportFilterUI.class);
    private PeriodInfo currentPeriod;
    private PeriodInfo startPeriod;
    private PeriodInfo maxPeriod = null;
    private CustomerParams cp = null;

    public CostCalTotalDetailReportFilterUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        NCMClientUtils.checkIsStart();
    }

    @Override
    public void onLoad() throws Exception {
        this.formatUI();
        super.onLoad();
        this.isDisplayYearSum.setVisible(false);
        this.isYearSum.setVisible(false);
    }

    private void formatUI() throws Exception {
        CompanyOrgUnitInfo companyOrg = this.getCompanyOrgInfoWithDefault();
        this.initPeriod(companyOrg);
        this.prmtCompanyOrg.setValue((Object)companyOrg);
        this.prmtCostObjectFrom.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.prmtCostObjectFrom, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, companyOrg.getId().toString());
        this.prmtCostObjectFrom.setSelector((KDPromptSelector)arg0);
        this.prmtCostObjectTo.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg1 = new CostObjectF7UISelector((Object)this, this.prmtCostObjectTo, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, companyOrg.getId().toString());
        this.prmtCostObjectTo.setSelector((KDPromptSelector)arg1);
        this.filterProject(this.prmtProjectFrom);
        this.filterProject(this.prmtProjectTo);
        this.filterTrack(this.prmtTrackFrom);
        this.filterTrack(this.prmtTrackTo);
        FilterInfo costItemFilterInfo = this.getCostItemFilter();
        this.setFilterInfoF7(this.prmtCostItemFrom, costItemFilterInfo);
        this.setFilterInfoF7(this.prmtCostItemTo, costItemFilterInfo);
        this.cbBaseUnit.addActionListener((ActionListener)this);
        this.cbStatUnit.addActionListener((ActionListener)this);
    }

    @Override
    protected FilterElement getFilterElement() {
        CompositeFilterElement elements = (CompositeFilterElement)super.getFilterElement();
        SpinnerFilterElement element = null;
        this.spCostObjectNum.setModel((SpinnerModel)new SpinnerNumberModel(20, 1, 1000, 1));
        element = new SpinnerFilterElement("costobjectPerPage", (Component)this.spCostObjectNum);
        element.setDefaultValue(20);
        elements.add((FilterElement)element);
        elements.add((FilterElement)new CheckBoxFilterElement("isYearSum", this.isYearSum));
        elements.add((FilterElement)new CheckBoxFilterElement("isShowBaseUnit", this.cbBaseUnit));
        elements.add((FilterElement)new CheckBoxFilterElement("isShowStatUnit", this.cbStatUnit));
        elements.add((FilterElement)new CheckBoxFilterElement("isDisplayYearSum", this.isDisplayYearSum));
        return elements;
    }

    private void initPeriod(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        this.maxPeriod = NCMUtils.getMaxPeriod((CompanyOrgUnitInfo)company, (PeriodInfo)this.currentPeriod);
        this.startPeriod = NCMUtils.GetStartPeriod(null, (String)company.getId().toString());
        this.currentPeriod = NCMUtils.GetCurrentPeriod(null, (String)company.getId().toString());
        if (this.currentPeriod == null) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        if (this.startPeriod == null) {
            return;
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)this.currentPeriod);
    }

    protected void filterProject(KDBizPromptBox prmt) throws Exception {
        FilterInfo filter = ProjectFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), "id", "CU.id");
        EntityViewInfo view = null;
        view = prmt.getEntityViewInfo() != null ? prmt.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        prmt.setEntityViewInfo(view);
    }

    protected void filterTrack(KDBizPromptBox prmt) throws Exception {
        FilterInfo filter = TrackNumberFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), "id", "CU.id");
        EntityViewInfo view = null;
        view = prmt.getEntityViewInfo() != null ? prmt.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        prmt.setEntityViewInfo(view);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cbBaseUnit) {
            if (!this.cbBaseUnit.isSelected() && !this.cbStatUnit.isSelected()) {
                this.cbStatUnit.setSelected(true);
            }
        } else if (e.getSource() == this.cbStatUnit && !this.cbBaseUnit.isSelected() && !this.cbStatUnit.isSelected()) {
            this.cbBaseUnit.setSelected(true);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrg;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    public boolean verify() {
        boolean isOK = super.verify();
        isOK = this.VerifyPeriod();
        return isOK;
    }

    private boolean VerifyPeriod() {
        Integer periodTo;
        Integer yearTo;
        Integer periodFrom;
        boolean isOK = true;
        Integer yearFrom = (Integer)this.spYearFrom.getValue();
        if (yearFrom.compareTo(0) <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"199_CostCalTotalDetailReportFilterUI"));
            isOK = false;
        }
        if (yearFrom.compareTo(1900) < 0 || yearFrom.compareTo(9998) > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"185_CostBatchTotalReportFilterUI"));
            isOK = false;
        }
        if ((periodFrom = (Integer)this.spPeriodFrom.getValue()).compareTo(0) <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"200_CostCalTotalDetailReportFilterUI"));
            isOK = false;
        }
        if ((yearTo = (Integer)this.spYearTo.getValue()).compareTo(0) <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"201_CostCalTotalDetailReportFilterUI"));
            isOK = false;
        }
        if (yearTo.compareTo(1900) < 0 || yearTo.compareTo(9998) > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"187_CostBatchTotalReportFilterUI"));
            isOK = false;
        }
        if ((periodTo = (Integer)this.spPeriodTo.getValue()).compareTo(0) <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"202_CostCalTotalDetailReportFilterUI"));
            isOK = false;
        }
        if (yearTo.compareTo(yearFrom) < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"184_CCFeeTotalReportFilterUI"));
            isOK = false;
        } else if (yearTo.compareTo(yearFrom) == 0 && periodTo.compareTo(periodFrom) < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"184_CCFeeTotalReportFilterUI"));
            isOK = false;
        }
        Integer curYear = this.currentPeriod.getPeriodYear();
        Integer curNumber = this.currentPeriod.getPeriodNumber();
        Integer startYear = this.startPeriod.getPeriodYear();
        Integer startNumber = this.startPeriod.getPeriodNumber();
        if (yearFrom.compareTo(startYear) < 0 || yearFrom.compareTo(startYear) == 0 && periodFrom.compareTo(startNumber) < 0) {
            this.spYearFrom.setValue((Object)startYear);
            this.spPeriodFrom.setValue((Object)startNumber);
        }
        if (yearTo.compareTo(startYear) < 0 || yearTo.compareTo(startYear) == 0 && periodTo.compareTo(startNumber) < 0) {
            this.spYearTo.setValue((Object)startYear);
            this.spPeriodTo.setValue((Object)startNumber);
        }
        if (yearFrom.compareTo(curYear) > 0 || yearFrom.compareTo(curYear) == 0 && periodFrom.compareTo(curNumber) > 0) {
            this.spYearFrom.setValue((Object)curYear);
            this.spPeriodFrom.setValue((Object)curNumber);
        }
        if (yearTo.compareTo(curYear) > 0 || yearTo.compareTo(curYear) == 0 && periodTo.compareTo(curNumber) > 0) {
            this.spYearTo.setValue((Object)curYear);
            this.spPeriodTo.setValue((Object)curNumber);
        }
        return isOK;
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    @Override
    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.prmtCompanyOrg.setValue((Object)this.getCompanyOrgInfoWithDefault());
        CustomerParams params = this.cp;
        if (params != null) {
            this.loadPeriod(params);
        }
    }

    private void loadPeriod(CustomerParams params) {
        PeriodInfo initPeriodFrom = this.currentPeriod;
        PeriodInfo initPeriodTo = this.currentPeriod;
        String initYearFrom = params.getCustomerParam("spYearFrom");
        String initMonthFrom = params.getCustomerParam("spPeriodFrom");
        String initYearTo = params.getCustomerParam("spYearTo");
        String initMonthTo = params.getCustomerParam("spPeriodTo");
        try {
            if (!StringUtils.isEmpty((String)initYearFrom) && !StringUtils.isEmpty((String)initMonthFrom)) {
                initPeriodFrom = new PeriodInfo();
                initPeriodFrom.setPeriodYear(Integer.parseInt(initYearFrom));
                initPeriodFrom.setPeriodNumber(Integer.parseInt(initMonthFrom));
            }
            if (!StringUtils.isEmpty((String)initYearTo) && !StringUtils.isEmpty((String)initMonthTo)) {
                initPeriodTo = new PeriodInfo();
                initPeriodTo.setPeriodYear(Integer.parseInt(initYearTo));
                initPeriodTo.setPeriodNumber(Integer.parseInt(initMonthTo));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)initPeriodFrom, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)initPeriodTo);
    }

    @Override
    protected void setDefaultValue() {
        CompanyOrgUnitInfo companyOrg = this.getCompanyOrgInfoWithDefault();
        this.prmtCompanyOrg.setValue((Object)companyOrg);
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearFrom, (JSpinner)this.spPeriodFrom, (PeriodInfo)this.currentPeriod, (JSpinner)this.spYearTo, (JSpinner)this.spPeriodTo, (PeriodInfo)this.currentPeriod);
        this.prmtCostCenterFrom.setValue(null);
        this.prmtCostCenterTo.setValue(null);
        this.prmtCostObjectFrom.setValue(null);
        this.prmtCostObjectTo.setValue(null);
        this.prmtCostItemFrom.setValue(null);
        this.prmtCostItemTo.setValue(null);
        this.isYearSum.setSelected(false);
        this.cbBaseUnit.setSelected(true);
        this.cbStatUnit.setSelected(false);
        this.isDisplayYearSum.setSelected(false);
    }

    @Override
    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    @Override
    protected FilterInfo getCostItemFilter() throws Exception {
        return CostItemFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
    }

    @Override
    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    protected String getAdminCUFieldName() {
        return "adminCU.id";
    }

    private void setFilterInfoF7(KDBizPromptBox f7, FilterInfo filter) {
        EntityViewInfo view = f7.getEntityViewInfo() != null ? f7.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    @Override
    public KDBizPromptBox getCompanyF7() {
        return this.prmtCompanyOrg;
    }

    @Override
    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    @Override
    protected void registerF7() throws Exception {
        super.registerF7();
        this.f7ContextManager.registerCostCenterF7(this.prmtCostCenterFrom);
        this.f7ContextManager.registerCostCenterF7(this.prmtCostCenterTo);
        this.f7ContextManager.registerCostObjectF7(this.prmtCostObjectFrom, false);
        this.f7ContextManager.registerCostObjectF7(this.prmtCostObjectTo, false);
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> statuses = new HashSet<Integer>();
        statuses.add(5);
        statuses.add(8);
        statuses.add(7);
        statuses.add(11);
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", statuses, CompareType.INCLUDE));
        this.f7ContextManager.registerManufactureOrderF7(this.prmtOrderNumberFrom, filter);
        this.f7ContextManager.registerManufactureOrderF7(this.prmtOrderNumberTo, filter);
        this.f7ContextManager.registerMaterialTreeF7(this.prmtMaterialFrom, null);
        MaterialF7TreeListSelector selector = new MaterialF7TreeListSelector((Object)this, this.prmtMaterialFrom);
        this.prmtMaterialFrom.setSelector((KDPromptSelector)selector);
        this.f7ContextManager.registerMaterialTreeF7(this.prmtMaterialTo, null);
        selector = new MaterialF7TreeListSelector((Object)this, this.prmtMaterialTo);
        this.prmtMaterialTo.setSelector((KDPromptSelector)selector);
    }

    @Override
    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            try {
                this.prmtCostCenterFrom.setData(null);
                this.prmtCostCenterTo.setData(null);
                this.prmtCostObjectFrom.setData(null);
                this.prmtCostObjectTo.setData(null);
                this.prmtOrderNumberFrom.setData(null);
                this.prmtOrderNumberTo.setData(null);
                this.prmtOrderNumberFrom.setDisplayFormat("$number$");
                this.prmtOrderNumberTo.setDisplayFormat("$number$");
                this.prmtMaterialFrom.setData(null);
                this.prmtMaterialTo.setData(null);
                this.initPeriod(this.getCompanyOrgInfoWithDefault());
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    @Override
    protected String getReportViewPermissionItem() {
        return "CostCalTotalDetailReportView";
    }

    @Override
    protected String getReportPrintPermissionItem() {
        return "CostCalTotalDetailReportPrint";
    }

    @Override
    protected KDSpinner[] getPeriodSpinner() {
        return new KDSpinner[]{this.spYearFrom, this.spYearTo, this.spPeriodFrom, this.spPeriodTo};
    }

    @Override
    protected KDSpinner getDisplayCountSpinner() {
        return this.spCostObjectNum;
    }

    @Override
    protected KDBizPromptBox[] getCostCenterF7() {
        return new KDBizPromptBox[]{this.prmtCostCenterFrom, this.prmtCostCenterTo};
    }

    @Override
    protected KDBizPromptBox[] getCostObjectF7() {
        return new KDBizPromptBox[]{this.prmtCostObjectFrom, this.prmtCostObjectTo};
    }

    @Override
    protected KDBizPromptBox[] getMaterialF7() {
        return new KDBizPromptBox[]{this.prmtMaterialFrom, this.prmtMaterialTo};
    }

    @Override
    protected KDBizPromptBox[] getCostItemF7() {
        return new KDBizPromptBox[]{this.prmtCostItemFrom, this.prmtCostItemTo};
    }

    @Override
    protected KDBizPromptBox[] getOrderNumberF7() {
        return new KDBizPromptBox[]{this.prmtOrderNumberFrom, this.prmtOrderNumberTo};
    }

    @Override
    protected KDTextField[] getBatchNumberCtrls() {
        return new KDTextField[]{this.txtBatchFrom, this.txtBathcTo};
    }

    @Override
    protected KDBizPromptBox[] getProjectNumberF7() {
        return new KDBizPromptBox[]{this.prmtProjectFrom, this.prmtProjectTo};
    }

    @Override
    protected KDBizPromptBox[] getTrackNumberF7() {
        return new KDBizPromptBox[]{this.prmtTrackFrom, this.prmtTrackTo};
    }
}

