/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.cal.report.client.AbstractCostRestorationDetailReportFilterUI;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.SpinnerUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.text.ParseException;
import javax.swing.JSpinner;
import org.apache.log4j.Logger;

public class CostRestorationDetailReportFilterUI
extends AbstractCostRestorationDetailReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CostRestorationDetailReportFilterUI.class);
    private CompanyOrgUnitInfo companyOrg = null;
    private PeriodInfo currentPeriod;
    private PeriodInfo startPeriod;
    private PeriodInfo maxPeriod = null;
    private CustomerParams cp = null;

    public CostRestorationDetailReportFilterUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        NCMClientUtils.checkIsStart();
        this.companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        this.currentPeriod = sysctrol.getCacheCurrentPeriod(1001, this.companyOrg.getId().toString());
        if (this.currentPeriod == null) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        this.startPeriod = sysctrol.getStartPeriod(1001, this.companyOrg.getId().toString());
        this.maxPeriod = NCMUtils.getMaxPeriod((CompanyOrgUnitInfo)this.companyOrg, (PeriodInfo)this.currentPeriod);
        this.prmtcompanyorg.setValue((Object)this.companyOrg);
        this.prmtcostobjectfrom.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.prmtcostobjectfrom, Boolean.TRUE);
        this.prmtcostobjectfrom.setSelector((KDPromptSelector)arg0);
        this.prmtcostobjectto.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg1 = new CostObjectF7UISelector((Object)this, this.prmtcostobjectto, Boolean.TRUE);
        this.prmtcostobjectto.setSelector((KDPromptSelector)arg1);
    }

    @Override
    protected FilterElement getFilterElement() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleBizPromptFilterElement filterElement = new SingleBizPromptFilterElement("companyorg", this.prmtcompanyorg);
        filterElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"183_CCFeeTotalReportFilterUI")));
        elements.add((FilterElement)filterElement);
        SpinnerFilterElement element = new SpinnerFilterElement("yearfrom", (Component)this.spyearfrom);
        element.setDefaultValue(this.currentPeriod.getPeriodYear());
        elements.add((FilterElement)element);
        element = new SpinnerFilterElement("periodfrom", (Component)this.spperiodfrom);
        element.setDefaultValue(this.currentPeriod.getPeriodNumber());
        elements.add((FilterElement)element);
        elements.add((FilterElement)new SingleFilterElement("costcenterfrom", (Component)this.prmtcostcenterfrom));
        elements.add((FilterElement)new SingleFilterElement("costcenterto", (Component)this.prmtcostcenterto));
        elements.add((FilterElement)new SingleFilterElement("costobjectfrom", (Component)this.prmtcostobjectfrom));
        elements.add((FilterElement)new SingleFilterElement("costobjectto", (Component)this.prmtcostobjectto));
        return elements;
    }

    @Override
    public boolean verify() {
        return super.verify();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    @Override
    protected KDSpinner[] getPeriodSpinner() {
        return new KDSpinner[]{this.spyearfrom, null, this.spperiodfrom, null};
    }

    @Override
    protected KDBizPromptBox[] getCostCenterF7() {
        return new KDBizPromptBox[]{this.prmtcostcenterfrom, this.prmtcostcenterto};
    }

    @Override
    protected KDBizPromptBox[] getCostObjectF7() {
        return new KDBizPromptBox[]{this.prmtcostobjectfrom, this.prmtcostobjectto};
    }

    @Override
    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        CustomerParams params = this.cp;
        if (params != null) {
            this.loadPeriod(params);
        }
    }

    @Override
    protected void setDefaultValue() {
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spyearfrom, (JSpinner)this.spperiodfrom, (PeriodInfo)this.currentPeriod);
        this.prmtcostcenterfrom.setValue(null);
        this.prmtcostcenterto.setValue(null);
        this.prmtcostobjectfrom.setValue(null);
        this.prmtcostobjectto.setValue(null);
    }

    private void loadPeriod(CustomerParams params) {
        PeriodInfo initPeriod = this.currentPeriod;
        String initYearFrom = params.getCustomerParam("spyearfrom");
        String initMonthFrom = params.getCustomerParam("spperiodfrom");
        try {
            if (!StringUtils.isEmpty((String)initYearFrom) && !StringUtils.isEmpty((String)initMonthFrom)) {
                initPeriod = new PeriodInfo();
                initPeriod.setPeriodYear(Integer.parseInt(initYearFrom));
                initPeriod.setPeriodNumber(Integer.parseInt(initMonthFrom));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spyearfrom, (JSpinner)this.spperiodfrom, (PeriodInfo)initPeriod);
    }

    @Override
    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtcompanyorg;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    public KDBizPromptBox getCompanyF7() {
        return this.prmtcompanyorg;
    }

    @Override
    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    @Override
    protected void registerF7() throws Exception {
        super.registerF7();
        this.f7ContextManager.registerCostCenterF7(this.prmtcostcenterfrom);
        this.f7ContextManager.registerCostCenterF7(this.prmtcostcenterto);
        this.f7ContextManager.registerCostObjectF7(this.prmtcostobjectfrom, true);
        this.f7ContextManager.registerCostObjectF7(this.prmtcostobjectto, true);
    }

    @Override
    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            try {
                this.prmtcostcenterfrom.setValue(null);
                this.prmtcostcenterto.setValue(null);
                this.prmtcostobjectfrom.setValue(null);
                this.prmtcostobjectto.setValue(null);
                this.initPeriod(this.getCompanyOrgInfoWithDefault());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private void initPeriod(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        this.maxPeriod = NCMUtils.getMaxPeriod((CompanyOrgUnitInfo)company, (PeriodInfo)this.currentPeriod);
        this.startPeriod = NCMUtils.GetStartPeriod(null, (String)company.getId().toString());
        this.currentPeriod = NCMUtils.GetCurrentPeriod(null, (String)company.getId().toString());
        if (this.currentPeriod == null) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        if (this.startPeriod == null) {
            return;
        }
        SpinnerUtils.initSpinner((PeriodInfo)this.startPeriod, (PeriodInfo)this.maxPeriod, (PeriodInfo)this.currentPeriod, (JSpinner)this.spyearfrom, (JSpinner)this.spperiodfrom, (PeriodInfo)this.currentPeriod);
    }

    @Override
    protected String getReportViewPermissionItem() {
        return "CostRestorationDetailReportView";
    }

    @Override
    protected String getReportPrintPermissionItem() {
        return "CostRestorationDetailReportPrint";
    }

    static class SpinnerFilterElement
    extends SingleFilterElement {
        private KDSpinner spinner;

        public SpinnerFilterElement(String id, Component component) {
            super(id, component);
            this.spinner = (KDSpinner)component;
        }

        protected void setNumber(Object obj, String value) {
            this.spinner.setValue((Object)Integer.valueOf(value));
        }

        protected String getName(Object obj) {
            return ((Component)obj).getName();
        }

        protected void setData(Component obj, Object value) {
            this.spinner.setValue(value);
        }
    }

    static class SingleBizPromptFilterElement
    extends SingleFilterElement {
        KDBizPromptBox prmt;

        public SingleBizPromptFilterElement(String id, KDBizPromptBox component) {
            super(id, (Component)component);
            this.prmt = component;
        }

        public void addRptParams(RptParams cp) {
            Object object = this.prmt.getValue();
            if (object == null) {
                try {
                    this.prmt.commitEdit();
                }
                catch (ParseException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                object = this.prmt.getValue();
            }
            if (object instanceof Object[]) {
                object = ((Object[])object)[0];
            }
            cp.setObject(this.getId(), object);
        }
    }
}

