/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.CommRptResourceUtil;
import com.kingdee.eas.ncm.cal.report.client.ReportPeriodEntity;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ReportSpinnerUtil {
    private static final int PERIOD_MAX_MONTH = 13;

    public static void setPeriodRange(CompanyOrgUnitInfo companyOrg, KDSpinner fromYear, KDSpinner fromPeriod, KDSpinner toYear, KDSpinner toPeriod, boolean unLimit) throws EASBizException, BOSException {
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection ccColl = iOUR.getFromUnit(companyOrg.getId().toString(), 1, 5);
        int ccSize = ccColl.size();
        if (ccSize == 0) {
            MsgBox.showWarning((String)NCMClientUtils.getNcmBillResource((String)"NoCostCenterDelegateThisCompanyOrg"));
            SysUtil.abort();
        }
        ReportPeriodEntity pe = ReportPeriodEntity.requestReportPeriodEntity(companyOrg);
        ReportSpinnerUtil.managePeriodRange(pe, fromYear, fromPeriod, toYear, toPeriod, unLimit);
    }

    public static void setPeriodRange(CompanyOrgUnitInfo companyOrg, KDSpinner fromYear, KDSpinner fromPeriod, boolean unLimit) throws EASBizException, BOSException {
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection ccColl = iOUR.getFromUnit(companyOrg.getId().toString(), 1, 5);
        int ccSize = ccColl.size();
        if (ccSize == 0) {
            MsgBox.showWarning((String)NCMClientUtils.getNcmBillResource((String)"NoCostCenterDelegateThisCompanyOrg"));
            SysUtil.abort();
        }
        ReportPeriodEntity pe = ReportPeriodEntity.requestReportPeriodEntity(companyOrg);
        ReportSpinnerUtil.managePeriodRange(pe, fromYear, fromPeriod, unLimit);
    }

    public static void managePeriodRange(ReportPeriodEntity pe, KDSpinner fromYear, KDSpinner fromPeriod, boolean unLimit) {
        int i;
        ReportPeriodEntity peTo = null;
        peTo = unLimit ? pe.getQueryPeriod() : pe.getUsedPeriod();
        int maxYear = peTo.getMaxYear();
        int curYear = peTo.getCurrentYear();
        int cuePeriod = peTo.getCurrentPeriod();
        fromYear.setModel((SpinnerModel)new SpinnerNumberExModel(curYear, pe.getUsedPeriod().getMinYear(), maxYear, 1));
        fromPeriod.setModel((SpinnerModel)new SpinnerNumberExModel(cuePeriod, pe.getUsedPeriod().getMinPeriod(curYear), peTo.getMaxPeriod(curYear), 1));
        for (i = 0; i < fromYear.getChangeListeners().length; ++i) {
            if (!(fromYear.getChangeListeners()[i] instanceof FourSpinnerLimiter)) continue;
            fromYear.removeChangeListener(fromYear.getChangeListeners()[i]);
        }
        for (i = 0; i < fromPeriod.getChangeListeners().length; ++i) {
            if (!(fromPeriod.getChangeListeners()[i] instanceof FourSpinnerLimiter)) continue;
            fromPeriod.removeChangeListener(fromPeriod.getChangeListeners()[i]);
        }
    }

    public static void managePeriodRange(ReportPeriodEntity pe, KDSpinner fromYear, KDSpinner fromPeriod, KDSpinner toYear, KDSpinner toPeriod, boolean unLimit) {
        int i;
        ReportPeriodEntity peFrom = null;
        ReportPeriodEntity peTo = null;
        peTo = unLimit ? pe.getQueryPeriod() : pe.getUsedPeriod();
        peFrom = peTo;
        int maxYear = peTo.getMaxYear();
        int curYear = peTo.getCurrentYear();
        int cuePeriod = peTo.getCurrentPeriod();
        toYear.setModel((SpinnerModel)new SpinnerNumberExModel(curYear, pe.getUsedPeriod().getMinYear(), maxYear, 1));
        fromYear.setModel((SpinnerModel)new SpinnerNumberExModel(curYear, pe.getUsedPeriod().getMinYear(), maxYear, 1));
        fromPeriod.setModel((SpinnerModel)new SpinnerNumberExModel(cuePeriod, pe.getUsedPeriod().getMinPeriod(curYear), peTo.getMaxPeriod(curYear), 1));
        toPeriod.setModel((SpinnerModel)new SpinnerNumberExModel(cuePeriod, pe.getUsedPeriod().getMinPeriod(curYear), peTo.getMaxPeriod(curYear), 1));
        for (i = 0; i < fromYear.getChangeListeners().length; ++i) {
            if (!(fromYear.getChangeListeners()[i] instanceof FourSpinnerLimiter)) continue;
            fromYear.removeChangeListener(fromYear.getChangeListeners()[i]);
        }
        for (i = 0; i < toYear.getChangeListeners().length; ++i) {
            if (!(toYear.getChangeListeners()[i] instanceof FourSpinnerLimiter)) continue;
            toYear.removeChangeListener(toYear.getChangeListeners()[i]);
        }
        for (i = 0; i < fromPeriod.getChangeListeners().length; ++i) {
            if (!(fromPeriod.getChangeListeners()[i] instanceof FourSpinnerLimiter)) continue;
            fromPeriod.removeChangeListener(fromPeriod.getChangeListeners()[i]);
        }
        for (i = 0; i < toPeriod.getChangeListeners().length; ++i) {
            if (!(toPeriod.getChangeListeners()[i] instanceof FourSpinnerLimiter)) continue;
            toPeriod.removeChangeListener(toPeriod.getChangeListeners()[i]);
        }
        fromYear.addChangeListener((ChangeListener)new FourSpinnerLimiter(1, peFrom, peTo, fromYear, fromPeriod, toYear, toPeriod));
        fromPeriod.addChangeListener((ChangeListener)new FourSpinnerLimiter(2, peFrom, peTo, fromYear, fromPeriod, toYear, toPeriod));
        toYear.addChangeListener((ChangeListener)new FourSpinnerLimiter(3, peFrom, peTo, fromYear, fromPeriod, toYear, toPeriod));
        toPeriod.addChangeListener((ChangeListener)new FourSpinnerLimiter(4, peFrom, peTo, fromYear, fromPeriod, toYear, toPeriod));
    }

    public static void initSpinnerPeriod(CompanyOrgUnitInfo companyOrg, boolean unLimit, KDSpinner spYearFrom, KDSpinner spMonthFrom, KDSpinner spYearTo, KDSpinner spMonthTo) throws EASBizException, BOSException {
        ReportSpinnerUtil.initSpinnerPeriod(companyOrg, unLimit, spYearFrom, spMonthFrom, -1, -1, spYearTo, spMonthTo, -1, -1);
    }

    public static void initSpinnerPeriod(CompanyOrgUnitInfo companyOrg, boolean unLimit, KDSpinner spYearFrom, KDSpinner spMonthFrom, int initYearFrom, int initMonthFrom, KDSpinner spYearTo, KDSpinner spMonthTo, int initYearTo, int initMonthTo) throws EASBizException, BOSException {
        ReportSpinnerUtil.checkCompany(companyOrg);
        ReportPeriodEntity pe = ReportPeriodEntity.requestReportPeriodEntity(companyOrg);
        pe = unLimit ? pe.getQueryPeriod() : pe.getUsedPeriod();
        int minYear = pe.getMinYear();
        int minMonth = pe.getMinPeriod2(minYear);
        int maxYear = pe.getMaxYear();
        int maxMonth = pe.getMaxPeriod(maxYear);
        int defYear = pe.getCurrentYear();
        int defMonth = pe.getCurrentPeriod();
        ReportSpinnerUtil.initSpinnerPeriod(minYear, minMonth, maxYear, maxMonth, defYear, defMonth, (JSpinner)spYearFrom, (JSpinner)spMonthFrom, initYearFrom, initMonthFrom, (JSpinner)spYearTo, (JSpinner)spMonthTo, initYearTo, initMonthTo);
    }

    public static void initSpinnerPeriod(int minYear, int minMonth, int maxYear, int maxMonth, int defYear, int defMonth, JSpinner spYearFrom, JSpinner spMonthFrom, int initYearFrom, int initMonthFrom, JSpinner spYearTo, JSpinner spMonthTo, int initYearTo, int initMonthTo) throws EASBizException, BOSException {
        int toPeriod;
        int minPeriod = ReportSpinnerUtil.getNumberOfPeriod(minYear, minMonth);
        int maxPeriod = ReportSpinnerUtil.getNumberOfPeriod(maxYear, maxMonth);
        int defPeriod = ReportSpinnerUtil.getNumberOfPeriod(defYear, defMonth);
        if (minPeriod > maxPeriod || defPeriod < minPeriod || defPeriod > maxPeriod) {
            throw new IllegalArgumentException(EASResource.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"205_ReportSpinnerUtil"));
        }
        int fromPeriod = ReportSpinnerUtil.getNumberOfPeriod(initYearFrom, initMonthFrom);
        if (fromPeriod > (toPeriod = ReportSpinnerUtil.getNumberOfPeriod(initYearFrom, initMonthFrom)) || fromPeriod < minPeriod || fromPeriod > maxPeriod || toPeriod < minPeriod || toPeriod > maxPeriod) {
            initYearFrom = defYear;
            initMonthFrom = defMonth;
            initYearTo = defYear;
            initMonthTo = defMonth;
        }
        ReportSpinnerUtil.initSpinnerPeriod(minYear, minMonth, maxYear, maxMonth, spYearFrom, spMonthFrom, initYearFrom, initMonthFrom, spYearTo, spMonthTo, initYearTo, initMonthTo);
    }

    private static void initSpinnerPeriod(final int minYear, final int minMonth, final int maxYear, final int maxMonth, final JSpinner spYearFrom, final JSpinner spMonthFrom, int initYearFrom, int initMonthFrom, final JSpinner spYearTo, final JSpinner spMonthTo, int initYearTo, int initMonthTo) throws EASBizException, BOSException {
        SpinnerNumberModel spYearFromSNM = new SpinnerNumberModel(){

            public Comparable getMinimum() {
                return Integer.valueOf(minYear);
            }

            public Comparable getMaximum() {
                return Integer.valueOf(maxYear);
            }

            @Override
            public Object getNextValue() {
                int curYear = (Integer)spYearFrom.getValue();
                int curMonth = (Integer)spMonthFrom.getValue();
                if (curYear == maxYear) {
                    return null;
                }
                if (curYear + 1 == maxYear && curMonth > maxMonth) {
                    spMonthFrom.setValue(maxMonth);
                }
                return curYear + 1;
            }

            @Override
            public Object getPreviousValue() {
                int curYear = (Integer)spYearFrom.getValue();
                int curMonth = (Integer)spMonthFrom.getValue();
                if (curYear == minYear) {
                    return null;
                }
                if (curYear - 1 == minYear && curMonth < minMonth) {
                    spMonthFrom.setValue(minMonth);
                }
                return curYear - 1;
            }

            @Override
            public Number getStepSize() {
                return 1;
            }

            @Override
            public void setValue(Object value) {
                int oldValue = (Integer)spYearFrom.getValue();
                int newValue = (Integer)value;
                super.setValue(value);
                if (newValue > oldValue) {
                    this.syncPeriodTo();
                }
            }

            private void syncPeriodTo() {
                int fromYear = (Integer)spYearFrom.getValue();
                int fromMonth = (Integer)spMonthFrom.getValue();
                int toYear = (Integer)spYearTo.getValue();
                int toMonth = (Integer)spMonthTo.getValue();
                if (ReportSpinnerUtil.getNumberOfPeriod(fromYear, fromMonth) > ReportSpinnerUtil.getNumberOfPeriod(toYear, toMonth)) {
                    spYearTo.setValue(spYearFrom.getValue());
                    spMonthTo.setValue(spMonthFrom.getValue());
                }
            }
        };
        SpinnerNumberModel spMonthFromSNM = new SpinnerNumberModel(){

            public Comparable getMinimum() {
                if ((Integer)spYearFrom.getValue() == minYear) {
                    return Integer.valueOf(minMonth);
                }
                return Integer.valueOf(1);
            }

            public Comparable getMaximum() {
                if ((Integer)spYearFrom.getValue() == maxYear) {
                    return Integer.valueOf(maxMonth);
                }
                return Integer.valueOf(13);
            }

            @Override
            public Object getNextValue() {
                int curYear = (Integer)spYearFrom.getValue();
                int curMonth = (Integer)spMonthFrom.getValue();
                if (curMonth == 13 && curYear < maxYear) {
                    spMonthFrom.setValue(1);
                    spYearFrom.setValue(curYear + 1);
                    return null;
                }
                if (curMonth == (Integer)this.getMaximum()) {
                    return null;
                }
                return curMonth + 1;
            }

            @Override
            public Object getPreviousValue() {
                int curYear = (Integer)spYearFrom.getValue();
                int curMonth = (Integer)spMonthFrom.getValue();
                if (curMonth == 1 && curYear > minYear) {
                    spYearFrom.setValue(curYear - 1);
                    return 13;
                }
                if (curMonth == (Integer)this.getMinimum()) {
                    return null;
                }
                return curMonth - 1;
            }

            @Override
            public Number getStepSize() {
                return 1;
            }

            @Override
            public void setValue(Object value) {
                int oldValue = (Integer)spMonthFrom.getValue();
                int newValue = (Integer)value;
                super.setValue(value);
                if (newValue > oldValue) {
                    this.syncPeriodTo();
                }
            }

            private void syncPeriodTo() {
                int fromYear = (Integer)spYearFrom.getValue();
                int fromMonth = (Integer)spMonthFrom.getValue();
                int toYear = (Integer)spYearTo.getValue();
                int toMonth = (Integer)spMonthTo.getValue();
                if (ReportSpinnerUtil.getNumberOfPeriod(fromYear, fromMonth) > ReportSpinnerUtil.getNumberOfPeriod(toYear, toMonth)) {
                    spYearTo.setValue(spYearFrom.getValue());
                    spMonthTo.setValue(spMonthFrom.getValue());
                }
            }
        };
        SpinnerNumberModel spYearToSNM = new SpinnerNumberModel(){

            public Comparable getMinimum() {
                return Integer.valueOf(minYear);
            }

            public Comparable getMaximum() {
                return Integer.valueOf(maxYear);
            }

            @Override
            public Object getNextValue() {
                int curYear = (Integer)spYearTo.getValue();
                int curMonth = (Integer)spMonthTo.getValue();
                if (curYear == maxYear) {
                    return null;
                }
                if (curYear + 1 == maxYear && curMonth > maxMonth) {
                    spMonthTo.setValue(maxMonth);
                }
                return curYear + 1;
            }

            @Override
            public Object getPreviousValue() {
                int curYear = (Integer)spYearTo.getValue();
                int curMonth = (Integer)spMonthTo.getValue();
                if (curYear == minYear) {
                    return null;
                }
                if (curYear - 1 == minYear && curMonth < minMonth) {
                    spMonthTo.setValue(minMonth);
                }
                return curYear - 1;
            }

            @Override
            public Number getStepSize() {
                return 1;
            }

            @Override
            public void setValue(Object value) {
                int oldValue = (Integer)spYearTo.getValue();
                int newValue = (Integer)value;
                super.setValue(value);
                if (newValue < oldValue) {
                    this.syncPeriodFrom();
                }
            }

            private void syncPeriodFrom() {
                int fromYear = (Integer)spYearFrom.getValue();
                int fromMonth = (Integer)spMonthFrom.getValue();
                int toYear = (Integer)spYearTo.getValue();
                int toMonth = (Integer)spMonthTo.getValue();
                if (ReportSpinnerUtil.getNumberOfPeriod(fromYear, fromMonth) > ReportSpinnerUtil.getNumberOfPeriod(toYear, toMonth)) {
                    spYearFrom.setValue(spYearTo.getValue());
                    spMonthFrom.setValue(spMonthTo.getValue());
                }
            }
        };
        SpinnerNumberModel spMonthToSNM = new SpinnerNumberModel(){

            public Comparable getMinimum() {
                if ((Integer)spYearTo.getValue() == minYear) {
                    return Integer.valueOf(minMonth);
                }
                return Integer.valueOf(1);
            }

            public Comparable getMaximum() {
                if ((Integer)spYearTo.getValue() == maxYear) {
                    return Integer.valueOf(maxMonth);
                }
                return Integer.valueOf(13);
            }

            @Override
            public Object getNextValue() {
                int curYear = (Integer)spYearTo.getValue();
                int curMonth = (Integer)spMonthTo.getValue();
                if (curMonth == 13 && curYear < maxYear) {
                    spYearTo.setValue(curYear + 1);
                    return 1;
                }
                if (curMonth == (Integer)this.getMaximum()) {
                    return null;
                }
                return curMonth + 1;
            }

            @Override
            public Object getPreviousValue() {
                int curYear = (Integer)spYearTo.getValue();
                int curMonth = (Integer)spMonthTo.getValue();
                if (curMonth == 1 && curYear > minYear) {
                    spMonthTo.setValue(13);
                    spYearTo.setValue(curYear - 1);
                    return null;
                }
                if (curMonth == (Integer)this.getMinimum()) {
                    return null;
                }
                return curMonth - 1;
            }

            @Override
            public Number getStepSize() {
                return 1;
            }

            @Override
            public void setValue(Object value) {
                int oldValue = (Integer)spMonthTo.getValue();
                int newValue = (Integer)value;
                super.setValue(value);
                if (newValue < oldValue) {
                    this.syncPeriodFrom();
                }
            }

            private void syncPeriodFrom() {
                int fromYear = (Integer)spYearFrom.getValue();
                int fromMonth = (Integer)spMonthFrom.getValue();
                int toYear = (Integer)spYearTo.getValue();
                int toMonth = (Integer)spMonthTo.getValue();
                if (ReportSpinnerUtil.getNumberOfPeriod(fromYear, fromMonth) > ReportSpinnerUtil.getNumberOfPeriod(toYear, toMonth)) {
                    spYearFrom.setValue(spYearTo.getValue());
                    spMonthFrom.setValue(spMonthTo.getValue());
                }
            }
        };
        spYearFrom.setModel(spYearFromSNM);
        spMonthFrom.setModel(spMonthFromSNM);
        spYearTo.setModel(spYearToSNM);
        spMonthTo.setModel(spMonthToSNM);
        spYearFrom.setValue(initYearFrom);
        spMonthFrom.setValue(initMonthFrom);
        spYearTo.setValue(initYearTo);
        spMonthTo.setValue(initMonthTo);
    }

    private static void checkCompany(CompanyOrgUnitInfo companyOrg) throws EASBizException, BOSException {
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection ccColl = iOUR.getFromUnit(companyOrg.getId().toString(), 1, 5);
        int ccSize = ccColl.size();
        if (ccSize == 0) {
            MsgBox.showWarning((String)NCMClientUtils.getNcmBillResource((String)"NoCostCenterDelegateThisCompanyOrg"));
            SysUtil.abort();
        }
    }

    public static int getNumberOfPeriod(int periodYear, int periodNumber) {
        if (periodYear < 0 || periodYear > 9999) {
            periodYear = 0;
        }
        periodYear *= 100;
        if (periodNumber < 0 || periodNumber > 13) {
            periodNumber = 0;
        }
        return periodYear + periodNumber;
    }

    private static class FourSpinnerLimiter
    implements ChangeListener {
        private int tag;
        private KDSpinner fromYear;
        private KDSpinner fromPeriod;
        private KDSpinner toYear;
        private KDSpinner toPeriod;
        private ReportPeriodEntity peFrom;
        private ReportPeriodEntity peTo;

        public FourSpinnerLimiter(int tag, ReportPeriodEntity peFrom, ReportPeriodEntity peTo, KDSpinner fromYear, KDSpinner fromPeriod, KDSpinner toYear, KDSpinner toPeriod) {
            this.tag = tag;
            this.peFrom = peFrom;
            this.peTo = peTo;
            this.fromYear = fromYear;
            this.fromPeriod = fromPeriod;
            this.toYear = toYear;
            this.toPeriod = toPeriod;
        }

        private int getValue(KDSpinner spn) {
            return (Integer)spn.getValue();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int year1 = this.getValue(this.fromYear);
            int year2 = this.getValue(this.toYear);
            int period1 = this.getValue(this.fromPeriod);
            int period2 = this.getValue(this.toPeriod);
            switch (this.tag) {
                case 1: {
                    if (year1 > year2) {
                        this.toYear.setValue(this.fromYear.getValue());
                    }
                    this.suitPeriodOnYearChanged(true, ((SpinnerNumberExModel)this.fromYear.getModel()).isUp());
                    break;
                }
                case 2: {
                    if (year1 != year2 || period1 <= period2) break;
                    this.toPeriod.setValue(this.fromPeriod.getValue());
                    break;
                }
                case 3: {
                    if (year2 < year1) {
                        this.fromYear.setValue(this.toYear.getValue());
                    }
                    this.suitPeriodOnYearChanged(false, ((SpinnerNumberExModel)this.toYear.getModel()).isUp());
                    break;
                }
                case 4: {
                    if (year1 != year2 || period2 >= period1) break;
                    this.fromPeriod.setValue(this.toPeriod.getValue());
                }
            }
        }

        private void suitPeriodOnYearChanged(boolean formChanged, boolean yearUp) {
            int min1;
            int year1 = this.getValue(this.fromYear);
            int year2 = this.getValue(this.toYear);
            int period1 = this.getValue(this.fromPeriod);
            int period2 = this.getValue(this.toPeriod);
            int max1 = this.peFrom.getMaxPeriod(year1);
            if (year1 == this.peFrom.getCurrentYear()) {
                max1 = this.peFrom.getCurrentPeriod();
            }
            if (period1 < (min1 = this.peFrom.getMinPeriod(year1)) || period1 > max1) {
                period1 = yearUp ? min1 : max1;
            }
            int max2 = this.peTo.getMaxPeriod(year2);
            int min2 = this.peTo.getMinPeriod(year2);
            if (period2 < min2 || period2 > max2) {
                period2 = yearUp ? min2 : max2;
            }
            if (year1 == year2 && period1 > period2) {
                if (formChanged) {
                    period2 = period1;
                } else {
                    period1 = period2;
                }
            }
            this.fromPeriod.setModel((SpinnerModel)new SpinnerNumberExModel(period1, min1, max1, 1));
            this.toPeriod.setModel((SpinnerModel)new SpinnerNumberExModel(period2, min2, max2, 1));
        }
    }

    private static class TwoSpinnerLimiter
    implements ChangeListener {
        private KDSpinner from;
        private KDSpinner to;

        TwoSpinnerLimiter(int min, int max, KDSpinner from, KDSpinner to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int fromValue = this.getValue(this.from);
            int toValue = this.getValue(this.to);
            if (e.getSource() == this.from) {
                if (toValue < fromValue) {
                    this.to.setValue((Object)fromValue);
                }
            } else if (fromValue > toValue) {
                this.from.setValue((Object)toValue);
            }
        }

        private int getValue(KDSpinner spinner) {
            return (Integer)spinner.getValue();
        }
    }

    private static class SpinnerNumberExModel
    extends SpinnerNumberModel {
        private Object lastValue = null;

        public SpinnerNumberExModel(int value, int minimum, int maximum, int stepSize) {
            super(value, minimum, maximum, stepSize);
            this.lastValue = value;
        }

        @Override
        public void setValue(Object value) {
            Object curValue = this.getValue();
            super.setValue(value);
            if (curValue != value) {
                this.lastValue = value;
            }
        }

        public int getLastValue() {
            if (this.lastValue == null) {
                throw new RuntimeException(CommRptResourceUtil.getRes((String)"not_init"));
            }
            return (Integer)this.lastValue;
        }

        public int getIntValue() {
            return (Integer)this.getValue();
        }

        public boolean isUp() {
            return this.getIntValue() > this.getLastValue();
        }
    }
}

