/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.IMethodBatchQuery;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.ICalculator;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ncm.cal.report.formula.CompanyPeriodInfo;
import com.kingdee.eas.ncm.cal.report.formula.FormulaTypeEnum;
import com.kingdee.eas.ncm.cal.report.formula.INCMRptFormulaFacade;
import com.kingdee.eas.ncm.cal.report.formula.NCMBatchCalculator;
import com.kingdee.eas.ncm.cal.report.formula.NCMRptFormulaFacadeFactory;
import com.kingdee.eas.ncm.cal.report.formula.PhysicalTblNameInfo;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class GetCostItemDataBatchCalculator
extends NCMBatchCalculator
implements ICalculator,
IMethodBatchQuery {
    private static Logger logger = Logger.getLogger((String)GetCostItemDataBatchCalculator.class.getName());
    Map companyPeriodMap = new HashMap();
    Map costCalPrdDetailResultTblMap = new HashMap();
    Map balanceTblMap = new HashMap();
    Map balanceEntryTblMap = new HashMap();
    Map balanceMatDetailTblMap = new HashMap();
    int finalStartPeriod = 0;
    int finalEndPeriod = 0;

    public BigDecimal getCostItemData(String companyNum, String year, String period, String[] costCenterNum, String[] costObjectNum, String[] costItemNum, String dataType) throws BOSException, EASBizException {
        return null;
    }

    @Override
    public void initCalculateContext(ICalculateContextProvider context) {
        super.initCalculateContext(context);
    }

    @Override
    public boolean batchQuery(Map methods) {
        super.batchQuery(methods);
        for (Map.Entry e : methods.entrySet()) {
            String method = (String)e.getKey();
            SortedParameterArray param = (SortedParameterArray)e.getValue();
            this.execute(param);
        }
        return true;
    }

    public void execute(SortedParameterArray params) {
        String companyNumber = null;
        String year = null;
        String period = null;
        String[] costCenterNumbers = null;
        String[] costObjectNumbers = null;
        String[] costItemNumbers = null;
        String formulaType = null;
        INCMRptFormulaFacade facade = null;
        try {
            facade = NCMRptFormulaFacadeFactory.getLocalInstance(this.serverCtx);
        }
        catch (BOSException e1) {
            logger.error((Object)e1);
        }
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"214_GetCostItemDataBatchCalculator", (Locale)this.serverCtx.getLocale()) + params.size() + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"215_GetCostItemDataBatchCalculator", (Locale)this.serverCtx.getLocale()) + ts));
        for (int i = 0; i < params.size(); ++i) {
            Timestamp ts1 = new Timestamp(System.currentTimeMillis());
            this.param = params.getParameter(i);
            Object[] args = this.param.getArgs();
            companyNumber = args[0].toString();
            year = args[1].toString();
            period = args[2].toString();
            costCenterNumbers = args[3].toString().split(";");
            costObjectNumbers = args[4].toString().split(";");
            costItemNumbers = args[5].toString().split(";");
            formulaType = args[6].toString();
            if (StringUtils.isEmpty((String)companyNumber) || StringUtils.isEmpty((String)year) || StringUtils.isEmpty((String)period) || costCenterNumbers == null || costCenterNumbers.length == 0 || costObjectNumbers == null || costObjectNumbers.length == 0 || StringUtils.isEmpty((String)formulaType)) {
                this.param.setValue((Object)Constants.ZERO);
                continue;
            }
            this.sheetStartYear = this.getSheet_StartYear();
            this.sheetEndYear = this.getSheet_EndYear();
            this.sheetStartPeriod = this.getSheet_StartPeriod();
            this.sheetEndPeriod = this.getSheet_EndPeriod();
            this.sheetCurrencyNumber = this.getSheet_Currency();
            CompanyPeriodInfo companyPeriodInfo = null;
            if (!this.companyPeriodMap.containsKey(companyNumber)) {
                try {
                    String companyId = this.getCompanyIdByCompanyNumber(this.serverCtx, companyNumber);
                    PeriodInfo startPeriodInfo = NCMUtils.GetStartPeriod((Context)this.serverCtx, (String)companyId);
                    if (startPeriodInfo == null) {
                        this.param.setValue((Object)Constants.ZERO);
                        continue;
                    }
                    CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                    company.setId(BOSUuid.read((String)companyId));
                    PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.serverCtx, (SystemEnum)SystemEnum.COSTMANAGEMENT, (CompanyOrgUnitInfo)company);
                    companyPeriodInfo = new CompanyPeriodInfo();
                    companyPeriodInfo.setCompanyId(companyId);
                    companyPeriodInfo.setStartPeriodInfo(startPeriodInfo);
                    companyPeriodInfo.setCurrentPeriodInfo(currentPeriodInfo);
                    this.companyPeriodMap.put(companyNumber, companyPeriodInfo);
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                catch (EASBizException e) {
                    logger.error((Object)"", (Throwable)e);
                }
            } else {
                companyPeriodInfo = (CompanyPeriodInfo)((Object)this.companyPeriodMap.get(companyNumber));
            }
            this.processPeriod(year, period, companyPeriodInfo.getStartPeriodInfo(), companyPeriodInfo.getCurrentPeriodInfo(), formulaType);
            try {
                this.processDynamicTbl(this.serverCtx, companyPeriodInfo.getCompanyId(), companyPeriodInfo.getStartPeriodInfo().getNumber(), companyPeriodInfo.getCurrentPeriodInfo().getNumber());
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
            }
            HashMap<String, Object> sheetParams = new HashMap<String, Object>();
            sheetParams.put("sheetStartYear", this.getSheet_StartYear());
            sheetParams.put("sheetEndYear", this.getSheet_EndYear());
            sheetParams.put("sheetStartPeriod", this.getSheet_StartPeriod());
            sheetParams.put("sheetEndPeriod", this.getSheet_EndPeriod());
            sheetParams.put("startPeriod", this.finalStartPeriod);
            sheetParams.put("endPeriod", this.finalEndPeriod);
            sheetParams.put("companyPeriodMap", this.companyPeriodMap);
            sheetParams.put("costCalPrdDetailResultTblMap", this.costCalPrdDetailResultTblMap);
            sheetParams.put("balanceTblMap", this.balanceTblMap);
            sheetParams.put("balanceEntryTblMap", this.balanceEntryTblMap);
            sheetParams.put("balanceMatDetailTblMap", this.balanceMatDetailTblMap);
            this.serverCtx.put((Object)"NCM_getCostItemData_Params", sheetParams);
            try {
                BigDecimal valueReturn = (BigDecimal)facade.getCostItemData(this.context, companyNumber, year, period, costCenterNumbers, costObjectNumbers, costItemNumbers, formulaType);
                this.param.setValue((Object)valueReturn);
            }
            catch (Exception e) {
                this.param.setValue((Object)e.getMessage());
            }
            Timestamp ts2 = new Timestamp(System.currentTimeMillis());
            long diff = ts2.getTime() - ts1.getTime();
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"216_GetCostItemDataBatchCalculator", (Locale)this.serverCtx.getLocale()) + i + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"217_GetCostItemDataBatchCalculator", (Locale)this.serverCtx.getLocale()) + diff));
        }
        long diff = System.currentTimeMillis() - ts.getTime();
        ts = new Timestamp(System.currentTimeMillis());
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"218_GetCostItemDataBatchCalculator", (Locale)this.serverCtx.getLocale()) + params.size() + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"219_GetCostItemDataBatchCalculator", (Locale)this.serverCtx.getLocale()) + ts + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"220_GetCostItemDataBatchCalculator", (Locale)this.serverCtx.getLocale()) + diff));
    }

    @Override
    protected String getCalculateSheetName() {
        return this.param.getSheetName();
    }

    private String getCompanyIdByCompanyNumber(Context ctx, String companyNumber) throws BOSException {
        IRowSet rst;
        block4: {
            String string;
            rst = null;
            try {
                rst = DbUtil.executeQuery((Context)ctx, (String)" select FID from T_ORG_Company where FNumber = ? ", (Object[])new String[]{companyNumber});
                if (!rst.next()) break block4;
                string = rst.getString("FID");
            }
            catch (Exception ex) {
                try {
                    logger.error((Object)ex);
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst);
            return string;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return null;
    }

    private void processPeriod(String year, String period, PeriodInfo sysStartPeriodInfo, PeriodInfo curPeriodInfo, String formulaType) {
        int startYear = 0;
        int startMonth = 0;
        int endYear = 0;
        int endMonth = 0;
        int formulaYear = Integer.parseInt(year);
        int formulaMonth = Integer.parseInt(period);
        endYear = formulaYear <= 10 ? (this.sheetStartYear <= 10 ? formulaYear + this.sheetStartYear + this.reportYear : formulaYear + this.sheetStartYear) : formulaYear;
        endMonth = formulaMonth <= 0 ? (this.sheetStartPeriod <= 0 ? formulaMonth + this.sheetStartPeriod + this.reportPeriod : formulaMonth + this.sheetStartPeriod) : formulaMonth;
        if (FormulaTypeEnum.curPeriodConsumeQty.getValue().equals(formulaType) || FormulaTypeEnum.curPeriodConsumeAmt.getValue().equals(formulaType) || FormulaTypeEnum.curPeriodFinishQty.getValue().equals(formulaType)) {
            startYear = endYear;
            startMonth = endMonth;
        } else if (FormulaTypeEnum.curYearConsumeQty.getValue().equals(formulaType) || FormulaTypeEnum.curYearConsumeAmt.getValue().equals(formulaType) || FormulaTypeEnum.curYearFinishQty.getValue().equals(formulaType)) {
            startYear = endYear;
            startMonth = sysStartPeriodInfo.getPeriodYear() != endYear ? 1 : sysStartPeriodInfo.getPeriodNumber();
        } else if (FormulaTypeEnum.lastYearCurPriodConsumeQty.getValue().equals(formulaType) || FormulaTypeEnum.lastYearCurPriodConsumeAmt.getValue().equals(formulaType) || FormulaTypeEnum.lastYearCurPriodFinishQty.getValue().equals(formulaType)) {
            endYear = startYear = endYear - 1;
            startMonth = endMonth;
        } else if (FormulaTypeEnum.lastYearAddConsumeQty.getValue().equals(formulaType) || FormulaTypeEnum.lastYearAddConsumeAmt.getValue().equals(formulaType) || FormulaTypeEnum.lastYearAddFinishQty.getValue().equals(formulaType)) {
            endYear = startYear = endYear - 1;
            startMonth = 1;
        }
        this.finalStartPeriod = Integer.parseInt(String.valueOf(startYear) + this.appendPeriod(String.valueOf(startMonth)));
        this.finalEndPeriod = Integer.parseInt(String.valueOf(endYear) + this.appendPeriod(String.valueOf(endMonth)));
    }

    private void processDynamicTbl(Context ctx, String companyId, int startPeriod, int currentPeriod) throws EASBizException, BOSException, SQLException {
        String key = companyId + "|" + "T_NCM_CostCalPrdDetailResult" + "|" + this.finalStartPeriod + "|" + this.finalEndPeriod;
        if (!this.costCalPrdDetailResultTblMap.containsKey(key)) {
            PhysicalTblNameInfo physicalTblNameInfo = this.getPhysicalTblNameForReport(ctx, companyId, "T_NCM_CostCalPrdDetailResult", this.finalStartPeriod, this.finalEndPeriod, currentPeriod);
            this.costCalPrdDetailResultTblMap.put(key, physicalTblNameInfo);
        }
        if (!this.balanceTblMap.containsKey(key = companyId + "|" + "T_NCM_Balance" + "|" + startPeriod + "|" + startPeriod)) {
            String balanceTblName = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyId, (String)"T_NCM_Balance", (int)startPeriod, (int)startPeriod);
            this.balanceTblMap.put(key, balanceTblName);
        }
        if (!this.balanceEntryTblMap.containsKey(key = companyId + "|" + "T_NCM_BalanceEntry" + "|" + startPeriod + "|" + startPeriod)) {
            String balanceEntryTblName = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyId, (String)"T_NCM_BalanceEntry", (int)startPeriod, (int)startPeriod);
            this.balanceEntryTblMap.put(key, balanceEntryTblName);
        }
        if (!this.balanceMatDetailTblMap.containsKey(key = companyId + "|" + "T_NCM_BalanceMatDetail" + "|" + startPeriod + "|" + startPeriod)) {
            String balanceMatDetailTblName = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyId, (String)"T_NCM_BalanceMatDetail", (int)startPeriod, (int)startPeriod);
            this.balanceMatDetailTblMap.put(key, balanceMatDetailTblName);
        }
    }

    public PhysicalTblNameInfo getPhysicalTblNameForReport(Context ctx, String companyId, String busiTblName, int fromPeriod, int toPeriod, int currentPeriod) throws BOSException, SQLException, EASBizException {
        int flag = 1;
        flag = currentPeriod == toPeriod && currentPeriod == fromPeriod ? 1 : (fromPeriod < currentPeriod && toPeriod < currentPeriod ? 2 : 3);
        PhysicalTblNameInfo info = new PhysicalTblNameInfo();
        if (flag == 1) {
            String tblName = NCMDynamicTableManager.TransTBL((String)busiTblName, (int)flag);
            String physicalTblName = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)tblName);
            info.setCurrentTblName(physicalTblName);
        } else if (flag == 2) {
            String tblName = NCMDynamicTableManager.TransTBL((String)busiTblName, (int)flag);
            String physicalTblName = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)tblName);
            info.setHistoryTblName(physicalTblName);
        } else {
            String tblName = NCMDynamicTableManager.TransTBL((String)busiTblName, (int)1);
            String physicalTblName = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)tblName);
            info.setCurrentTblName(physicalTblName);
            tblName = NCMDynamicTableManager.TransTBL((String)busiTblName, (int)2);
            physicalTblName = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)tblName);
            info.setHistoryTblName(physicalTblName);
        }
        return info;
    }

    private String appendPeriod(String month) {
        int intMount = 0;
        try {
            intMount = Integer.parseInt(month);
        }
        catch (Exception ex) {
            return month;
        }
        if (intMount > 0 && intMount < 10) {
            return "0" + month;
        }
        return month;
    }
}

