/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.report.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.IMethodBatchQuery;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.util.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.ICalculator;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class NCMBatchCalculator
implements ICalculator,
IMethodBatchQuery {
    private static Logger logger = Logger.getLogger((String)NCMBatchCalculator.class.getName());
    protected ICalculateContextProvider context;
    protected Context serverCtx = null;
    protected Parameter param = null;
    protected String reportCompanyNumber = null;
    protected String reportCurrencyNumber = null;
    protected Date reportStartDate = null;
    protected Date reportEndDate = null;
    protected int reportYear;
    protected int reportPeriod;
    protected int periodType;
    protected int sheetStartYear;
    protected int sheetEndYear;
    protected int sheetStartPeriod;
    protected int sheetEndPeriod;
    protected String sheetCurrencyNumber = null;

    public void initCalculateContext(ICalculateContextProvider context) {
        this.context = context;
        this.serverCtx = context.getServerContext();
    }

    protected void initReportParams() {
        String reportCompanyId = (String)this.context.getReportAdapter().getReportProperty("Company.ID");
        try {
            this.reportCompanyNumber = CompanyOrgUnitFactory.getLocalInstance((Context)this.serverCtx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(reportCompanyId)).getNumber();
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        this.reportCurrencyNumber = (String)this.context.getReportAdapter().getReportProperty("Currency.Number");
        this.reportStartDate = (Date)this.context.getReportAdapter().getReportProperty("Report_StartDate");
        this.reportEndDate = (Date)this.context.getReportAdapter().getReportProperty("Report_EndDate");
        this.reportYear = (Integer)this.context.getReportAdapter().getReportProperty("Report.Year");
        this.reportPeriod = (Integer)this.context.getReportAdapter().getReportProperty("Report.Period");
        this.periodType = (Integer)this.context.getReportAdapter().getReportProperty("PeriodType");
        RptPeriodTypeEnum type = RptPeriodTypeEnum.getEnum((int)this.periodType);
        if (this.reportStartDate == null) {
            this.reportStartDate = PeriodUtils.getPeriodFirstDate((int)this.reportYear, (int)this.reportPeriod, (int)type.getValue());
        }
        if (this.reportEndDate == null) {
            this.reportEndDate = PeriodUtils.getPeriodLastDate((int)this.reportYear, (int)this.reportPeriod, (int)type.getValue());
        }
    }

    public boolean batchQuery(Map methods) {
        this.initReportParams();
        return false;
    }

    protected int getSheet_StartYear() {
        ReportVariables vs = this.context.getReportVariables();
        if (vs == null) {
            return 0;
        }
        return vs.getIntValue("StartYear", this.getCalculateSheetName(), 0);
    }

    protected int getSheet_EndYear() {
        ReportVariables vs = this.context.getReportVariables();
        if (vs == null) {
            return 0;
        }
        return vs.getIntValue("EndYear", this.getCalculateSheetName(), 0);
    }

    protected int getSheet_StartPeriod() {
        ReportVariables vs = this.context.getReportVariables();
        if (vs == null) {
            return 0;
        }
        return vs.getIntValue("StartPeriod", this.getCalculateSheetName(), 0);
    }

    protected int getSheet_EndPeriod() {
        ReportVariables vs = this.context.getReportVariables();
        if (vs == null) {
            return 0;
        }
        return vs.getIntValue("EndPeriod", this.getCalculateSheetName(), 0);
    }

    protected String getSheet_Currency() {
        ReportVariables vs = this.context.getReportVariables();
        if (vs == null) {
            return "";
        }
        return vs.getStringValue("Currency", this.getCalculateSheetName());
    }

    protected abstract String getCalculateSheetName();
}

