/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.rpt.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.ncm.cal.rpt.client.AbstractMaterialCostStatRptUI;
import com.kingdee.eas.ncm.cal.rpt.client.MaterialCostStatRptFilter2UI;
import com.kingdee.eas.ncm.cal.rpt.client.MaterialCostStatRptFilterUI;
import com.kingdee.eas.ncm.common.asynrpt.client.BaseAsynRptFilterUI;
import java.awt.Color;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class MaterialCostStatRptUI
extends AbstractMaterialCostStatRptUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialCostStatRptUI.class);
    String lbCompanyPrefix = this.lbCompany.getText();
    String lbPeriodPrefix = this.lbPeriod.getText();
    String lbOrderPrefix = this.lbOrder.getText();
    String lbCostCenterPrefix = this.lbCostCenter.getText();
    String lbCostObjectPrefix = this.lbCostObject.getText();
    String lbCostItemPrefix = this.lbCostItem.getText();
    String lbBatchPrefix = this.lbBatch.getText();
    String lbProjectPrefix = this.lbProject.getText();
    String lbTrackPrefix = this.lbTrack.getText();
    String lbProductPrefix = this.lbProduct.getText();

    protected String getReportId() {
        return "uNc46vCUN02vmswiUAeZ0eLNv3s=";
    }

    protected String[] getMergeColumnKeys() {
        return new String[]{"FCompanyOrg", "FPeriodNumber", "FCostCenterNumber", "FCostCenterName", "FCostObjNumber", "FCostObjName", "FOrderNumber", "FProductLot", "FProjectNumber", "FTrackNumber", "FProductNumber", "FProductName", "FProductModel", "FProductShortName", "FUnitName", "FObjQ", "FCostItemNumber", "FCostItemName"};
    }

    protected BaseAsynRptFilterUI[] getCustomerFilterUIs() throws Exception {
        return new BaseAsynRptFilterUI[]{new MaterialCostStatRptFilterUI(), new MaterialCostStatRptFilter2UI()};
    }

    protected void fillRptHeader(RptParams summary) throws Exception {
        RptParams params = (RptParams)summary.getObject("params");
        this.lbCompany.setText(this.lbCompanyPrefix + params.getString("companyName"));
        this.lbPeriod.setText(this.lbPeriodPrefix + this.buildPeriodRange(params));
        this.lbOrder.setText(this.lbOrderPrefix + this.buildFilterRange(params.getString("prmtOrderNumberFrom"), params.getString("prmtOrderNumberTo")));
        this.lbCostCenter.setText(this.lbCostCenterPrefix + this.buildFilterRange(params.getString("prmtCostCenterFrom"), params.getString("prmtCostCenterTo")));
        this.lbCostObject.setText(this.lbCostObjectPrefix + this.buildFilterRange(params.getString("prmtCostObjectFrom"), params.getString("prmtCostObjectTo")));
        this.lbCostItem.setText(this.lbCostItemPrefix + this.buildFilterRange(params.getString("prmtCostItemFrom"), params.getString("prmtCostItemTo")));
        this.lbBatch.setText(this.lbBatchPrefix + this.buildFilterRange(params.getString("txtBatchFrom"), params.getString("txtBatchTo")));
        this.lbProject.setText(this.lbProjectPrefix + this.buildFilterRange(params.getString("prmtProjectFrom"), params.getString("prmtProjectTo")));
        this.lbTrack.setText(this.lbTrackPrefix + this.buildFilterRange(params.getString("prmtTrackFrom"), params.getString("prmtTrackTo")));
        this.lbProduct.setText(this.lbProductPrefix + this.buildFilterRange(params.getString("prmtMaterialFrom"), params.getString("prmtMaterialTo")));
    }

    protected void fillRow(RptRowSet rs, RptTableHeader tblHeader, IRow row) throws Exception {
        super.fillRow(rs, tblHeader, row);
        BigDecimal bd = rs.getBigDecimal("FTotalRow2");
        if (bd != null) {
            if (bd.compareTo(new BigDecimal(90)) >= 0 && bd.compareTo(new BigDecimal(104)) <= 0) {
                row.getStyleAttributes().setBackground(new Color(255, 255, 164));
            } else if (bd.compareTo(new BigDecimal(105)) == 0) {
                row.getStyleAttributes().setBackground(new Color(190, 250, 198));
            }
        }
    }

    protected void fillCell(RptRowSet rs, RptTableColumn column, String columnName, ICell cell) throws Exception {
        if ("FObjQ".equals(columnName)) {
            String formatString = this.getNumericFormatString(rs, column, "FCoQtyPrecision", 4);
            BigDecimal value = rs.getBigDecimal(columnName);
            cell.setValue((Object)value);
            cell.getStyleAttributes().setNumberFormat(formatString);
        } else if ("FBefAdjBoPCommonQty".equals(columnName) || "FAdjBoPCommonQty".equals(columnName) || "FBoPCommonQty".equals(columnName) || "FCurInputCommonQ".equals(columnName) || "FTotalInputCommonQ".equals(columnName) || "FFinishedCommonQ".equals(columnName) || "FBefAdjWIPCommonQ".equals(columnName) || "FAdjWIPCommonQ".equals(columnName) || "FWIPCommonQ".equals(columnName) || "FUnitCostCommonQ".equals(columnName)) {
            BigDecimal value = rs.getBigDecimal(columnName);
            if (value != null && value.compareTo(SysConstant.BIGZERO) != 0) {
                cell.setValue((Object)value);
                String formatString = this.getNumericFormatString(rs, column, "FMatCommonQtyPrecision", 4);
                cell.getStyleAttributes().setNumberFormat(formatString);
            }
        } else if ("FBefAdjBoPQty".equals(columnName) || "FAdjBoPQty".equals(columnName) || "FBoPQty".equals(columnName) || "FCurInputQ".equals(columnName) || "FTotalInputQ".equals(columnName) || "FFinishedQ".equals(columnName) || "FBefAdjWIPQ".equals(columnName) || "FAdjWIPQ".equals(columnName) || "FWIPQ".equals(columnName) || "FUnitCostQ".equals(columnName)) {
            BigDecimal value = rs.getBigDecimal(columnName);
            if (value != null && value.compareTo(SysConstant.BIGZERO) != 0) {
                cell.setValue((Object)value);
                String formatString = this.getNumericFormatString(rs, column, "FMatQtyPrecision", 4);
                cell.getStyleAttributes().setNumberFormat(formatString);
            }
        } else if ("FBefAdjBoPAssistQty".equals(columnName) || "FAdjBoPAssistQty".equals(columnName) || "FBoPAssistQty".equals(columnName) || "FCurInputAssistQ".equals(columnName) || "FTotalInputAssistQ".equals(columnName) || "FFinishedAssistQ".equals(columnName) || "FBefAdjWIPAssistQ".equals(columnName) || "FAdjWIPAssistQ".equals(columnName) || "FWIPAssistQ".equals(columnName) || "FUnitCostAssistQ".equals(columnName)) {
            BigDecimal value = rs.getBigDecimal(columnName);
            if (value != null && value.compareTo(SysConstant.BIGZERO) != 0) {
                cell.setValue((Object)value);
                String formatString = this.getNumericFormatString(rs, column, "FMatAssistQtyPrecision", 4);
                cell.getStyleAttributes().setNumberFormat(formatString);
            }
        } else if ("FBefAdjBoPAmount".equals(columnName) || "FAdjBoPAmount".equals(columnName) || "FBoPAmount".equals(columnName) || "FCurInputA".equals(columnName) || "FTotalInputA".equals(columnName) || "FFinishedA".equals(columnName) || "FBefAdjWIPA".equals(columnName) || "FAdjWIPA".equals(columnName) || "FWIPA".equals(columnName) || "FUnitCostRatio".equals(columnName)) {
            BigDecimal value = rs.getBigDecimal(columnName);
            if (value != null && value.compareTo(SysConstant.BIGZERO) != 0) {
                cell.setValue((Object)value);
                String formatString = this.getNumericFormatString(rs, column, "FAmountPrecision", 4);
                cell.getStyleAttributes().setNumberFormat(formatString);
            }
        } else if ("FUnitCostA".equals(columnName)) {
            BigDecimal value = rs.getBigDecimal(columnName);
            if (value != null && value.compareTo(SysConstant.BIGZERO) != 0) {
                cell.setValue((Object)value);
                String formatString = this.getNumericFormatString(rs, column, "FMaterialPrecision", 4);
                cell.getStyleAttributes().setNumberFormat(formatString);
            }
        } else {
            super.fillCell(rs, column, columnName, cell);
        }
    }
}

