/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.rpt.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.ncm.cal.rpt.client.AbstractYearSumRptUI;
import com.kingdee.eas.ncm.cal.rpt.client.YearSumRptFilter2UI;
import com.kingdee.eas.ncm.cal.rpt.client.YearSumRptFilterUI;
import com.kingdee.eas.ncm.common.asynrpt.client.BaseAsynRptFilterUI;
import java.awt.Color;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class YearSumRptUI
extends AbstractYearSumRptUI {
    private static final Logger logger = CoreUIObject.getLogger(YearSumRptUI.class);
    String lbCompanyPrefix = this.lbCompany.getText();
    String lbPeriodPrefix = this.lbPeriod.getText();
    String lbCostCenterPrefix = this.lbCostCenter.getText();
    String lbCostObjectPrefix = this.lbCostObject.getText();
    String lbCostItemPrefix = this.lbCostItem.getText();
    String lbBatchPrefix = this.lbBatch.getText();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected BaseAsynRptFilterUI[] getCustomerFilterUIs() throws Exception {
        return new BaseAsynRptFilterUI[]{new YearSumRptFilterUI(), new YearSumRptFilter2UI()};
    }

    protected String getReportId() {
        return "wBpV8H2ou0yJgkhLB0ue3OLNv3s=";
    }

    protected void fillRow(RptRowSet rs, RptTableHeader tblHeader, IRow row) throws Exception {
        super.fillRow(rs, tblHeader, row);
        BigDecimal bd = rs.getBigDecimal("FTotalRow");
        if (bd != null) {
            if (bd.compareTo(new BigDecimal(90)) >= 0 && bd.compareTo(new BigDecimal(104)) <= 0) {
                row.getStyleAttributes().setBackground(new Color(255, 255, 164));
            } else if (bd.compareTo(new BigDecimal(105)) == 0) {
                row.getStyleAttributes().setBackground(new Color(190, 250, 198));
            }
        }
    }

    protected String[] getMergeColumnKeys() {
        return new String[]{"FCompanyOrg", "FPeriodNumber", "FCostCenterNumber", "FCostCenterName", "FCostObjNumber", "FCostObjName"};
    }

    protected void fillRptHeader(RptParams summary) throws Exception {
        RptParams params = (RptParams)summary.getObject("params");
        this.lbCompany.setText(this.lbCompanyPrefix + params.getString("companyName"));
        this.lbPeriod.setText(this.lbPeriodPrefix + this.buildPeriodRange(params));
        this.lbCostCenter.setText(this.lbCostCenterPrefix + this.buildFilterRange(params.getString("prmtCostCenterFrom"), params.getString("prmtCostCenterTo")));
        this.lbCostObject.setText(this.lbCostObjectPrefix + this.buildFilterRange(params.getString("prmtCostObjectFrom"), params.getString("prmtCostObjectTo")));
        this.lbCostItem.setText(this.lbCostItemPrefix + this.buildFilterRange(params.getString("prmtCostItemFrom"), params.getString("prmtCostItemTo")));
        this.lbBatch.setText(this.lbBatchPrefix + this.buildFilterRange(params.getString("txtBatchFrom"), params.getString("txtBatchTo")));
    }

    protected void fillCell(RptRowSet rs, RptTableColumn column, String columnName, ICell cell) throws Exception {
        if ("FYearSumInQty".equals(columnName) || "FYearSumComQty".equals(columnName)) {
            String formatString = this.getNumericFormatString(rs, column, "FQtyPrecision", 6);
            BigDecimal value = rs.getBigDecimal(columnName);
            cell.setValue((Object)value);
            cell.getStyleAttributes().setNumberFormat(formatString);
        } else if ("FYearSumInAmount".equals(columnName) || "FYearSumComAmount".equals(columnName)) {
            String formatString = this.getNumericFormatString(rs, column, "FAmountPrecision", 4);
            BigDecimal value = rs.getBigDecimal(columnName);
            cell.setValue((Object)value);
            cell.getStyleAttributes().setNumberFormat(formatString);
        } else {
            super.fillCell(rs, column, columnName, cell);
        }
    }
}

