/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.asynrpt.client;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTextPane;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeBorders;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.common.asynrpt.AsynRptSchemeCollection;
import com.kingdee.eas.ncm.common.asynrpt.AsynRptSchemeFactory;
import com.kingdee.eas.ncm.common.asynrpt.AsynRptSchemeInfo;
import com.kingdee.eas.ncm.common.asynrpt.client.AsynRptListener;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.Assert;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;

public class AsynRptProgressUI
extends KDDialog
implements Runnable {
    private static Logger logger = Logger.getLogger(AsynRptProgressUI.class);
    private KDLabel lbProgress;
    private KDProgressBar pbProgress;
    private KDButton btnMsg;
    private KDButton btnBack;
    private Box boxMsg;
    private KDWorkButton btnClear;
    private KDTextPane tpMsg;
    private int INIT_WIDTH = 300;
    private Dimension INIT_SIZE = null;
    private boolean showDetail = false;
    private Thread thread = null;
    private boolean runBack = false;
    private int intervalTime = 200;
    private int progress = 0;
    private RptParams params = null;
    private AsynRptListener listener = null;

    private AsynRptProgressUI(Frame owner, RptParams params, AsynRptListener listener) {
        super(owner, "\u8fdb\u5ea6\u4fe1\u606f", true);
        this.init(params, listener);
    }

    private AsynRptProgressUI(Dialog owner, RptParams params, AsynRptListener listener) {
        super(owner, "\u8fdb\u5ea6\u4fe1\u606f", true);
        this.init(params, listener);
    }

    private void init(RptParams params, AsynRptListener listener) {
        this.params = params;
        this.listener = listener;
        Assert.that((boolean)params.containsKey("asynrpt#key.scheme.id"));
        this.jbInit();
    }

    protected void jbInit() {
        int totalHeight = 10;
        JPanel contentPane = new JPanel(){
            private static final long serialVersionUID = 3844671767898500030L;

            @Override
            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                if (e.isControlDown() && pressed && e.getKeyCode() == 69) {
                    e.consume();
                    AsynRptProgressUI.this.btnMsg.doClick();
                    return true;
                }
                return super.processKeyBinding(ks, e, condition, pressed);
            }
        };
        this.setContentPane(contentPane);
        contentPane.setLayout(new BorderLayout());
        Box boxMain = Box.createVerticalBox();
        boxMain.setBorder(new EmptyBorder(10, 10, 10, 10));
        totalHeight += 10;
        contentPane.add((Component)boxMain, "Center");
        Box boxProgress = Box.createVerticalBox();
        boxProgress.setAlignmentX(0.0f);
        boxMain.add(boxProgress);
        int progressHeight = 0;
        boxProgress.add(Box.createVerticalStrut(5));
        this.lbProgress = new KDLabel("\u6b63\u5728\u8fdb\u884c\u5904\u7406...");
        this.lbProgress.setAlignmentX(0.0f);
        boxProgress.add((Component)this.lbProgress);
        boxProgress.add(Box.createVerticalStrut(5));
        this.pbProgress = new KDProgressBar();
        this.pbProgress.setStringPainted(true);
        this.pbProgress.setPreferredSize(new Dimension(200, 20));
        this.pbProgress.setAlignmentX(0.0f);
        boxProgress.add((Component)this.pbProgress);
        progressHeight += 50;
        boxProgress.add(Box.createVerticalStrut(15));
        Box progressBtnBox = Box.createHorizontalBox();
        progressBtnBox.setMaximumSize(new Dimension(Integer.MAX_VALUE, 22));
        progressBtnBox.setPreferredSize(new Dimension(400, 22));
        progressBtnBox.setMinimumSize(new Dimension(400, 22));
        progressBtnBox.setAlignmentX(0.0f);
        boxProgress.add(progressBtnBox);
        progressBtnBox.add(Box.createHorizontalGlue());
        progressBtnBox.add(Box.createHorizontalStrut(5));
        this.btnMsg = new KDButton("\u4fe1\u606f");
        this.btnMsg.setMargin(new Insets(1, 1, 1, 1));
        progressBtnBox.add((Component)this.btnMsg);
        this.btnMsg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AsynRptProgressUI.this.btnMsgActionPerformed(e);
            }
        });
        this.btnMsg.setVisible(false);
        progressBtnBox.add(Box.createHorizontalStrut(20));
        this.btnBack = new KDButton("\u540e\u53f0\u8fd0\u884c");
        this.btnBack.setActionCommand("close");
        this.btnBack.setMargin(new Insets(1, 1, 1, 1));
        progressBtnBox.add((Component)this.btnBack);
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AsynRptProgressUI.this.btnBacklActionPerformed(e);
            }
        });
        boxProgress.setMaximumSize(new Dimension(Integer.MAX_VALUE, progressHeight += 27));
        boxProgress.setPreferredSize(new Dimension(400, progressHeight));
        boxProgress.setMinimumSize(new Dimension(400, progressHeight));
        totalHeight += progressHeight;
        this.boxMsg = Box.createVerticalBox();
        this.boxMsg.setAlignmentX(0.0f);
        this.boxMsg.add(Box.createVerticalStrut(10));
        this.boxMsg.setVisible(false);
        boxMain.add(this.boxMsg);
        Box boxMsgContent = Box.createVerticalBox();
        boxMsgContent.setBorder(KingdeeBorders.createEditorBorder());
        this.boxMsg.add(boxMsgContent);
        boxMsgContent.add(Box.createVerticalStrut(2));
        KDToolBar msgToolBar = new KDToolBar(){
            private static final long serialVersionUID = 5751821512503771177L;

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(new Color(231, 237, 242));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        msgToolBar.setOpaque(true);
        msgToolBar.removeAll();
        msgToolBar.setLayout((LayoutManager)new BoxLayout((Container)msgToolBar, 0));
        msgToolBar.add(Box.createHorizontalGlue());
        msgToolBar.setMaximumSize(new Dimension(Integer.MAX_VALUE, 22));
        msgToolBar.setPreferredSize(new Dimension(400, 22));
        msgToolBar.setMinimumSize(new Dimension(400, 22));
        boxMsgContent.add((Component)msgToolBar);
        this.btnClear = new KDWorkButton();
        this.btnClear.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnClear.setToolTipText("\u6e05\u7a7a");
        this.btnClear.setMargin(new Insets(1, 1, 1, 1));
        this.btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AsynRptProgressUI.this.btnClearActionPerformed(e);
            }
        });
        msgToolBar.add((Component)this.btnClear);
        boxMsgContent.add(Box.createVerticalStrut(2));
        KDSeparator sp = new KDSeparator();
        sp.setPreferredSize(new Dimension(1, 2));
        sp.setMaximumSize(new Dimension(Integer.MAX_VALUE, 2));
        boxMsgContent.add((Component)sp);
        KDScrollPane scrollPane = new KDScrollPane();
        this.tpMsg = new KDTextPane();
        this.tpMsg.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        this.tpMsg.setEditable(false);
        this.tpMsg.setBackground(new Color(231, 237, 242));
        scrollPane.setViewportView((Component)this.tpMsg);
        boxMsgContent.add((Component)scrollPane);
        this.setResizable(true);
        this.INIT_SIZE = new Dimension(this.INIT_WIDTH, totalHeight);
        ((JPanel)this.getContentPane()).setPreferredSize(this.INIT_SIZE);
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void btnMsgActionPerformed(ActionEvent e) {
        if (this.showDetail) {
            this.showDetail = false;
            Dimension oldSize = ((JPanel)this.getContentPane()).getSize();
            Dimension newSize = new Dimension();
            newSize.width = oldSize.width;
            newSize.height = oldSize.height > this.INIT_SIZE.height ? this.INIT_SIZE.height : oldSize.height;
            ((JPanel)this.getContentPane()).setPreferredSize(newSize);
            this.boxMsg.setVisible(false);
            this.pack();
        } else {
            this.showDetail = true;
            Dimension oldSize = ((JPanel)this.getContentPane()).getSize();
            Dimension newSize = new Dimension();
            newSize.width = oldSize.width;
            newSize.height = oldSize.height > this.INIT_SIZE.height + 200 ? oldSize.height : this.INIT_SIZE.height + 200;
            ((JPanel)this.getContentPane()).setPreferredSize(newSize);
            this.boxMsg.setVisible(true);
            this.pack();
        }
    }

    private void btnClearActionPerformed(ActionEvent e) {
        this.tpMsg.setText("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(String msg) {
        if (!StringUtils.isEmpty((String)msg)) {
            Color color = Color.BLACK;
            SimpleAttributeSet attrset = new SimpleAttributeSet();
            StyleConstants.setForeground(attrset, color);
            Document docs = this.tpMsg.getDocument();
            try {
                AsynRptProgressUI asynRptProgressUI = this;
                synchronized (asynRptProgressUI) {
                    if (!StringUtils.isEmpty((String)msg)) {
                        docs.insertString(docs.getLength(), msg + "\n", attrset);
                    }
                }
            }
            catch (BadLocationException ble) {
                logger.error((Object)"", (Throwable)ble);
            }
            this.tpMsg.setSelectionStart(this.tpMsg.getDocument().getLength());
        }
    }

    public void refresh() {
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread(this);
        this.thread.start();
    }

    @Override
    public void run() {
        boolean finished = true;
        Exception ex = null;
        String schemeId = this.params.getString("asynrpt#key.scheme.id");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)schemeId));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("progress");
        selector.add("hint");
        selector.add("status");
        view.setSelector(selector);
        try {
            Thread.sleep(200L);
            AsynRptSchemeInfo scheme = null;
            while (true) {
                if (this.runBack) {
                    finished = false;
                } else {
                    AsynRptSchemeCollection coll = AsynRptSchemeFactory.getRemoteInstance().getAsynRptSchemeCollection(view);
                    if (coll.size() > 0) {
                        scheme = coll.get(0);
                        this.pbProgress.setValue(scheme.getProgress());
                        if (scheme.getStatus() < 2) {
                            if (scheme.getProgress() != this.progress) {
                                this.progress = scheme.getProgress();
                                this.intervalTime = 200;
                            }
                            if (this.intervalTime < 5000) {
                                Thread.sleep(this.intervalTime);
                                this.intervalTime = (int)((double)this.intervalTime + (double)this.intervalTime * 0.5);
                                continue;
                            }
                            Thread.sleep(5000L);
                            continue;
                        }
                    }
                }
                break;
            }
        }
        catch (InterruptedException ignore) {
            finished = false;
        }
        catch (Exception e) {
            ex = e;
        }
        this.setVisible(false);
        this.dispose();
        if (this.listener != null) {
            if (ex != null) {
                this.listener.onError(ex);
            } else {
                this.listener.onBack(finished);
            }
        }
    }

    private synchronized void btnBacklActionPerformed(ActionEvent e) {
        this.btnBack.setEnabled(false);
        this.runBack = true;
        this.thread.interrupt();
        this.setVisible(false);
        this.dispose();
    }

    public static void show(Component comp, RptParams params, AsynRptListener listener) throws Exception {
        Window ownerWindow = ComponentUtil.getOwnerWindow((Component)comp);
        AsynRptProgressUI hintUI = ownerWindow instanceof Frame ? new AsynRptProgressUI((Frame)ownerWindow, params, listener) : (ownerWindow instanceof Dialog ? new AsynRptProgressUI((Dialog)ownerWindow, params, listener) : new AsynRptProgressUI((Frame)null, params, listener));
        hintUI.refresh();
        hintUI.show();
    }

    public static void main(String[] args) throws Exception {
        KingdeeLookAndFeel lnf = new KingdeeLookAndFeel();
        UIManager.setLookAndFeel((LookAndFeel)lnf);
        AsynRptProgressUI.show(null, new RptParams(), null);
    }
}

