/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.asynrpt.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.ncm.common.asynrpt.client.AbstractBasePageAsynRptUI;
import com.kingdee.eas.ncm.common.asynrpt.client.AsynRptProgressUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class BasePageAsynRptUI
extends AbstractBasePageAsynRptUI {
    private static final Logger logger = CoreUIObject.getLogger(BasePageAsynRptUI.class);
    private List pages = null;
    private int pageIndex = -1;
    private Map tmpTables = new HashMap();
    private Map rowCounts = new HashMap();
    private Map tblHeaders = new HashMap();
    protected static List backPages = null;
    private static int backPageIndex = -1;
    private static Map backTmpTables = null;
    private static Map backRowCounts = null;
    private static Map backTblHeaders = null;
    private boolean isBack = false;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoadBack() throws Exception {
        this.pages = backPages;
        backPages = null;
        this.pageIndex = backPageIndex;
        backPageIndex = -1;
        this.tmpTables = backTmpTables;
        backTmpTables = null;
        this.rowCounts = backRowCounts;
        backRowCounts = null;
        this.tblHeaders = backTblHeaders;
        backTblHeaders = null;
        this.setPageBtn();
    }

    @Override
    protected void build() {
        try {
            HashSet set = new HashSet();
            set.addAll(this.tmpTables.values());
            this.params.setObject("asynrpt#key.tmp.table", set);
            this.tblHeaders.clear();
            this.tmpTables.clear();
            this.rowCounts.clear();
            RptParams result = this.getRemoteInstance().build(this.params);
            this.pages = (List)result.getObject("pages");
            this.actionFirst_actionPerformed(null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void buildPage() throws Exception {
        this.isBuilding = true;
        this.setPageBtn();
        if (this.tmpTables.containsKey(this.pageIndex)) {
            this.isBuilding = false;
            this.onFinished();
        } else if (this.pageIndex >= 0 && this.pageIndex < this.pages.size()) {
            this.params.setObject("page", this.pages.get(this.pageIndex));
            RptParams result = this.getRemoteInstance().build(this.params);
            this.params.setString("asynrpt#key.scheme.id", result.getString("asynrpt#key.scheme.id"));
            AsynRptProgressUI.show((Component)((Object)this), this.params, this);
        }
    }

    private void setPageBtn() {
        this.actionFirst.setEnabled(true);
        this.actionPrev.setEnabled(true);
        this.actionNext.setEnabled(true);
        this.actionLast.setEnabled(true);
        if (this.pageIndex <= 0) {
            this.actionFirst.setEnabled(false);
            this.actionPrev.setEnabled(false);
        } else if (this.pageIndex >= this.pages.size() - 1) {
            this.actionNext.setEnabled(false);
            this.actionLast.setEnabled(false);
        }
    }

    @Override
    public void onBack(boolean finished) {
        if (finished) {
            this.isBuilding = false;
            this.onFinished();
            return;
        }
        this.isBack = true;
        backPages = this.pages;
        backPageIndex = this.pageIndex;
        backTmpTables = this.tmpTables;
        backRowCounts = this.rowCounts;
        backTblHeaders = this.tblHeaders;
        try {
            this.actionExitCurrent_actionPerformed(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void querySummary() throws Exception {
        int rowCount;
        if (this.tmpTables.containsKey(this.pageIndex)) {
            RptTableHeader tblHeader = (RptTableHeader)this.tblHeaders.get(this.pageIndex);
            if (tblHeader == null && this.tblHeaders.size() > 0) {
                tblHeader = (RptTableHeader)this.tblHeaders.get(0);
            }
            rowCount = (Integer)this.rowCounts.get(this.pageIndex);
        } else {
            this.summary = this.getRemoteInstance().querySummary(this.params);
            RptTableHeader tblHeader = (RptTableHeader)this.summary.getObject("tblHeader");
            this.tblHeaders.put(this.pageIndex, tblHeader);
            String tmpTable = this.summary.getString("asynrpt#key.tmp.table");
            this.tmpTables.put(this.pageIndex, tmpTable);
            rowCount = this.summary.getInt("rowCount");
            this.rowCounts.put(this.pageIndex, rowCount);
        }
        this.fillTblHeader(this.summary);
        this.getTableForReport().setRowCount(rowCount);
    }

    @Override
    protected void queryData(int from, int len) throws Exception {
        String tmpTable = (String)this.tmpTables.get(this.pageIndex);
        this.params.setString("asynrpt#key.tmp.table", tmpTable);
        RptParams rpt = this.getRemoteInstance().queryData(this.params);
        RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
        if (rs == null) {
            return;
        }
    }

    @Override
    public boolean destroyWindow() {
        try {
            if (!this.isBack) {
                HashSet set = new HashSet();
                set.addAll(this.tmpTables.values());
                this.params.setObject("asynrpt#key.tmp.table", set);
                this.tmpTables.clear();
            }
            this.getRemoteInstance().release(this.params);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return super.destroyWindow();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.params != null) {
            this.params.remove("page");
        }
        super.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.params != null) {
            this.params.remove("page");
        }
        super.actionQuery_actionPerformed(e);
    }

    @Override
    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        this.pageIndex = 0;
        this.buildPage();
    }

    @Override
    public void actionPrev_actionPerformed(ActionEvent e) throws Exception {
        --this.pageIndex;
        this.buildPage();
    }

    @Override
    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        ++this.pageIndex;
        this.buildPage();
    }

    @Override
    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        this.pageIndex = this.pages.size() - 1;
        this.buildPage();
    }

    @Override
    public void actionMoveto_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveto_actionPerformed(e);
    }
}

