/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.asynrpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.client.context.OrgContextManager;
import com.kingdee.eas.framework.client.context.f7.IF7ContextChange;
import com.kingdee.eas.framework.client.context.f7.IF7Register;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.NCMCommonFacadeFactory;
import com.kingdee.eas.ncm.common.asynrpt.client.AbstractNCMMultiOrgRptFilterUI;
import com.kingdee.eas.ncm.common.client.NCMF7ContextManager;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.OrgUnitClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public abstract class NCMMultiOrgRptFilterUI
extends AbstractNCMMultiOrgRptFilterUI
implements IMultiOrgSupport {
    private static final Logger logger = CoreUIObject.getLogger(NCMMultiOrgRptFilterUI.class);
    protected OrgContextManager orgContextManager = null;
    protected NCMF7ContextManager f7ContextManager;
    private IMetaDataPK metaDataPKForPemmission = null;
    private IMetaDataPK metaDataPKForPemmissionByUI = null;
    private static Map permissionItemMap = new HashMap();
    private String permissionItem = null;
    private boolean mainOrgChangeCanceling = false;

    public NCMMultiOrgRptFilterUI() throws Exception {
        BDCMClientUtils.checkLoginCompanyOrgIsVirtual();
        this.isStart();
    }

    protected void isStart() throws Exception {
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        if (!sysctrol.isStart(1001, SysContext.getSysContext().getCurrentFIUnit().getId().toString())) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initOrgContextManager();
    }

    @Override
    public void clear() {
        this.setDefaultValue();
    }

    @Override
    protected void setDefaultValue() {
        if (this.getCompanyF7() != null) {
            this.getCompanyF7().setData((Object)this.getCompanyOrgInfoWithDefault());
        }
        if (this.getCostCenterF7() != null && this.getCostCenterF7().length == 2) {
            this.getCostCenterF7()[0].setData(null);
            this.getCostCenterF7()[1].setData(null);
        }
        if (this.getCostObjectF7() != null && this.getCostObjectF7().length == 2) {
            this.getCostObjectF7()[0].setData(null);
            this.getCostObjectF7()[1].setData(null);
        }
        if (this.getMaterialF7() != null && this.getMaterialF7().length == 2) {
            this.getMaterialF7()[0].setData(null);
            this.getMaterialF7()[1].setData(null);
        }
        if (this.getCostItemF7() != null && this.getCostItemF7().length == 2) {
            this.getCostItemF7()[0].setData(null);
            this.getCostItemF7()[1].setData(null);
        }
    }

    @Override
    public void loadData(RptParams params) {
        super.loadData(params);
        if (params != null) {
            if (this.getCompanyF7() != null) {
                this.loadCompany(params);
            }
            if (this.getCostCenterF7() != null && this.getCostCenterF7().length == 2) {
                this.loadCostCenter(params);
            }
            if (this.getCostObjectF7() != null && this.getCostObjectF7().length == 2) {
                this.loadCostObject(params);
            }
            if (this.getMaterialF7() != null && this.getMaterialF7().length == 2) {
                this.loadMaterial(params);
            }
            if (this.getCostItemF7() != null && this.getCostItemF7().length == 2) {
                this.loadCostItem(params);
            }
            if (this.getOrderNumberF7() != null && this.getOrderNumberF7().length == 2) {
                this.loadOrderNumber(params);
            }
            if (this.getBatchNumberCtrls() != null && this.getBatchNumberCtrls().length == 2) {
                this.loadBatchNumber(params);
            }
            if (this.getProjectNumberF7() != null && this.getProjectNumberF7().length == 2) {
                this.loadProjectNumber(params);
            }
            if (this.getTrackNumberF7() != null && this.getTrackNumberF7().length == 2) {
                this.loadTrackNumber(params);
            }
        }
        this.LoadCustomerParams2Panel(params);
    }

    protected void LoadCustomerParams2Panel(RptParams params) {
    }

    protected void initOrgContextManager() throws EASBizException, BOSException {
        this.orgContextManager = new OrgContextManager((IMultiOrgSupport)this, ContextTypeEnum.INQUERYING, null);
        this.orgContextManager.init(this.getUIContext());
        if (this.getCompanyF7() != null) {
            this.getCompanyF7().setSelector(null);
            if (this.isEnableMultiOrgSupport()) {
                this.getCompanyF7().setEnabled(true);
                this.getCompanyF7().setRequired(true);
                if (this.getCompanyF7().getQueryInfo() == null || this.getCompanyF7().getQueryInfo().trim().length() == 0) {
                    this.getCompanyF7().setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
                }
                OrgUnitClientUtils.setMainBizOrgF7(this.getCompanyF7(), OrgType.Company, new String[]{this.getReportViewPermissionItem()});
                if (this.getCompanyF7().getData() == null) {
                    this.getCompanyF7().setData((Object)this.getCompanyOrgInfoWithDefault());
                }
                this.getF7Register();
                try {
                    this.registerF7();
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
        }
    }

    protected void registerF7() throws Exception {
    }

    public OrgType getMainOrgType() {
        return OrgType.Company;
    }

    public KDBizPromptBox getMainOrg() {
        return this.getCompanyF7();
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        if (this.mainOrgChangeCanceling) {
            return;
        }
        if (chgVo.isDiffrent()) {
            try {
                CompanyOrgUnitInfo companyOrg;
                if (chgVo.getNewOrg() != null && chgVo.getNewOrg() instanceof CompanyOrgUnitInfo && !NCMUtils.isStart(null, (companyOrg = (CompanyOrgUnitInfo)chgVo.getNewOrg()).getId().toString())) {
                    throw new CMBillException(CMBillException.COST_NOTON);
                }
            }
            catch (Exception e) {
                MsgBox.showInfo((String)e.getMessage());
                if (this.getCompanyF7() != null) {
                    try {
                        this.mainOrgChangeCanceling = true;
                        this.getCompanyF7().setData(chgVo.getOldOrg());
                    }
                    finally {
                        this.mainOrgChangeCanceling = false;
                    }
                    this.getCompanyF7().requestFocus();
                }
                SysUtil.abort();
            }
        }
    }

    public String getPermissionItem() {
        if (this.permissionItem == null && this.metaDataPKForPemmissionByUI != null) {
            try {
                String permissionItemKey = "" + MetaDataTypeList.UIOBJECT + this.metaDataPKForPemmissionByUI;
                if (!permissionItemMap.containsKey(permissionItemKey)) {
                    MetaDataPK actionPK = new MetaDataPK("ActionOnLoad");
                    this.permissionItem = NCMCommonFacadeFactory.getRemoteInstance().getUIPermissiionItem(this.metaDataPKForPemmissionByUI, (IMetaDataPK)actionPK);
                    permissionItemMap.put(permissionItemKey, this.permissionItem);
                } else {
                    this.permissionItem = (String)permissionItemMap.get(permissionItemKey);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return this.permissionItem;
    }

    public IF7ContextChange getF7ContextManager() {
        return (NCMF7ContextManager)this.getF7Register();
    }

    public IF7Register getF7Register() {
        if (this.f7ContextManager == null) {
            this.f7ContextManager = new NCMF7ContextManager((Component)((Object)this), OrgType.Company, ContextTypeEnum.INQUERYING, 0);
        }
        return this.f7ContextManager;
    }

    public String getMainOrgKeyForCustomerParams(OrgType orgType) {
        return "company.id";
    }

    public boolean isSupportMultiOrgs() {
        return false;
    }

    public boolean isSupportVirturalOrgs() {
        return false;
    }

    public void setMetaDataPKForPemmission(IMetaDataPK metaDataPKForPemmission) {
        this.metaDataPKForPemmission = metaDataPKForPemmission;
    }

    public void setMetaDataPKForPemmissionByUI(IMetaDataPK metaDataPKForPemmissionByUI) {
        this.metaDataPKForPemmissionByUI = metaDataPKForPemmissionByUI;
    }

    public boolean isEnableMultiOrgSupport() {
        return false;
    }

    public OrgContextManager orgContextManager() {
        return this.orgContextManager;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.getCompanyF7();
    }

    public boolean verify() {
        if (this.isEnableMultiOrgSupport()) {
            if (this.getCompanyF7().getData() == null) {
                MsgBox.showInfo((String)SCMGroupClientUtils.getMainOrgNullMsg((OrgType)OrgType.Company));
                this.getCompanyF7().requestFocus();
                SysUtil.abort();
            }
            try {
                if (!NCMUtils.isStart(null, ((CompanyOrgUnitInfo)this.getCompanyF7().getData()).getId().toString())) {
                    throw new CMBillException(CMBillException.COST_NOTON);
                }
            }
            catch (Exception e) {
                MsgBox.showInfo((String)e.getMessage());
                this.getCompanyF7().requestFocus();
                SysUtil.abort();
            }
        }
        return super.verify();
    }

    protected String getReportViewPermissionItem() {
        return null;
    }

    protected String getReportPrintPermissionItem() {
        return null;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(this.getCompanyOrgInfoWithDefault().getId());
    }

    protected void loadCompany(RptParams params) {
        block9: {
            String companyNumber = "";
            if (params.getString(this.getSpecialCustomerParamKey(this.getCompanyF7().getName())) != null) {
                companyNumber = params.getString(this.getSpecialCustomerParamKey(this.getCompanyF7().getName()));
            }
            if ("".equals(companyNumber)) {
                return;
            }
            try {
                String osql = "where number = '" + companyNumber + "'";
                CompanyOrgUnitInfo companyOrg = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo(osql);
                if (companyOrg == null) break block9;
                try {
                    if (!SCMGroupClientUtils.isAuthoriedForOrg((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)OrgType.Company, (IObjectPK)new ObjectStringPK(companyOrg.getId().toString()), (String)this.getReportViewPermissionItem())) {
                        MsgBox.showInfo((String)"\u6ca1\u6709\u8be5\u65b9\u6848\u6240\u9009\u8d22\u52a1\u7ec4\u7ec7\u7684\u6743\u9650");
                        SysUtil.abort();
                    }
                }
                catch (EASBizException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                this.getCompanyF7().setData((Object)companyOrg);
            }
            catch (BOSException e) {
                this.getCompanyF7().setData(null);
                logger.error((Object)"", (Throwable)e);
            }
            catch (EASBizException e) {
                this.getCompanyF7().setData(null);
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    protected void loadCompany(String companyNumber) {
        block8: {
            if ("".equals(companyNumber)) {
                return;
            }
            try {
                String osql = "where number = '" + companyNumber + "'";
                CompanyOrgUnitInfo companyOrg = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo(osql);
                if (companyOrg == null) break block8;
                try {
                    if (!SCMGroupClientUtils.isAuthoriedForOrg((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)OrgType.Company, (IObjectPK)new ObjectStringPK(companyOrg.getId().toString()), (String)this.getReportViewPermissionItem())) {
                        MsgBox.showInfo((String)"\u6ca1\u6709\u8be5\u65b9\u6848\u6240\u9009\u8d22\u52a1\u7ec4\u7ec7\u7684\u6743\u9650");
                        SysUtil.abort();
                    }
                }
                catch (EASBizException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                this.getCompanyF7().setData((Object)companyOrg);
            }
            catch (BOSException e) {
                this.getCompanyF7().setData(null);
                logger.error((Object)"", (Throwable)e);
            }
            catch (EASBizException e) {
                this.getCompanyF7().setData(null);
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    protected KDSpinner[] getPeriodSpinner() {
        return null;
    }

    protected KDSpinner getDisplayCountSpinner() {
        return null;
    }

    protected JComponent[] getOtherComponent() {
        return null;
    }
}

