/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ncm.common.client.AbstractAdvanceOptionUI;
import com.kingdee.eas.ncm.common.client.AdvanceOptionInfo;
import com.kingdee.eas.ncm.common.client.AdvanceOptionListener;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class AdvanceOptionUI
extends AbstractAdvanceOptionUI {
    private static final Logger logger = CoreUIObject.getLogger(AdvanceOptionUI.class);
    private AdvanceOptionListener listener;

    public void onLoad() throws Exception {
        if (!NCMClientUtils.isLogin((Component)((Object)this))) {
            this.abort();
        }
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("value").getStyleAttributes().setLocked(false);
        this.listener = (AdvanceOptionListener)this.getUIContext().get("listener");
        this.init();
    }

    private void init() {
        if (this.listener == null) {
            return;
        }
        List options = this.listener.getAdvanceOptions();
        if (options == null || options.size() == 0) {
            return;
        }
        for (int i = 0; i < options.size(); ++i) {
            AdvanceOptionInfo option = (AdvanceOptionInfo)options.get(i);
            IRow row = this.tblMain.addRow();
            row.getCell("key").setValue((Object)option);
            row.getCell("name").setValue((Object)option.getName());
            row.getCell("desc").setValue((Object)option.getDesc());
            if (option.getClazz() == null || option.getClazz() == String.class) {
                row.getCell("value").setValue((Object)this.getString(option.getValue()));
                continue;
            }
            if (option.getClazz() == Boolean.class) {
                row.getCell("value").setValue((Object)this.getBoolean(option.getValue()));
                continue;
            }
            if (option.getClazz() == Integer.class) {
                KDFormattedTextField colTxtField = new KDFormattedTextField();
                colTxtField.setDataType(0);
                row.getCell("value").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)colTxtField));
                row.getCell("value").setValue((Object)this.getInteger(option.getValue()));
                continue;
            }
            row.getCell("value").setValue((Object)this.getString(option.getValue()));
        }
    }

    private Boolean getBoolean(Object value) {
        if (value == null) {
            return Boolean.FALSE;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.valueOf(value.toString());
    }

    private String getString(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    private Integer getInteger(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            return 0;
        }
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        ((UIModelDialog)this.getUIWindow()).setVisible(false);
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            AdvanceOptionInfo option = (AdvanceOptionInfo)this.tblMain.getRow(i).getCell("key").getValue();
            if (option.getClazz() == null || option.getClazz() == String.class) {
                option.setValue(this.getString(this.tblMain.getRow(i).getCell("value").getValue()));
                continue;
            }
            if (option.getClazz() == Boolean.class) {
                option.setValue(this.getBoolean(this.tblMain.getRow(i).getCell("value").getValue()));
                continue;
            }
            if (option.getClazz() == Integer.class) {
                option.setValue(this.getInteger(this.tblMain.getRow(i).getCell("value").getValue()));
                continue;
            }
            option.setValue(this.getString(this.tblMain.getRow(i).getCell("value").getValue()));
        }
        if (this.listener != null && this.listener.verify()) {
            this.listener.onOk();
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        ((UIModelDialog)this.getUIWindow()).setVisible(false);
        if (this.listener != null) {
            this.listener.onCancel();
        }
    }

    public static void show(Object owner, AdvanceOptionListener listener) throws Exception {
        UIContext uiContext = new UIContext(owner);
        uiContext.put((Object)"listener", (Object)listener);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AdvanceOptionUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }
}

