/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.uistatemanage.ActionManager;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.CMBillBaseInfo;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.ICMBillBase;
import com.kingdee.eas.ncm.common.client.AbstractCMBillBaseEditUI;
import com.kingdee.eas.ncm.common.client.CMBillBaseListUI;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.PermissionUtils;
import com.kingdee.eas.ncm.common.utils.client.ClientHelper;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.common.utils.client.OrgUnitClientUtils;
import com.kingdee.eas.ncm.common.verify.VerifyManager;
import com.kingdee.eas.scm.common.client.KDTableUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public abstract class CMBillBaseEditUI
extends AbstractCMBillBaseEditUI {
    private static final Logger logger = CoreUIObject.getLogger(CMBillBaseEditUI.class);
    private VerifyManager verifyManager = new VerifyManager();
    protected boolean addnew_and_save = false;
    private KDTextField txtNumber;
    protected KDBizPromptBox prmtCompany;
    protected KDBizPromptBox prmtPeriod;
    private KDDatePicker pkDate;
    protected KDTable kdtEntries;
    private ClientHelper clientHelper = new ClientHelper(this);
    private String addNewPermItemName = null;
    protected RuleStatus ruleStatus = null;
    private int billStatus = -1;
    private ActionManager actionManager = null;

    public CMBillBaseEditUI() throws Exception {
        BDCMClientUtils.checkLoginCompanyOrgIsVirtual();
        this.isStart();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.isStartSet();
        this.actionSetup();
        KDTableHelper.downArrowAutoAddRow((KDTable)this.kdtEntries, (boolean)true, null);
    }

    protected void actionSetup() {
        ItemAction[] actList = new ItemAction[]{this.actionAttachment, this.actionAuditResult, this.actionCancel, this.actionCancelCancel, this.actionCopy, this.actionCopyFrom, this.actionCreateFrom, this.actionCreateTo, this.actionDelVoucher, this.actionFirst, this.actionPre, this.actionNext, this.actionLast, this.actionMultiapprove, this.actionNextPerson, this.actionSignature, this.actionStartWorkFlow, this.actionTraceDown, this.actionTraceUp, this.actionVoucher, this.actionWorkFlowG, this.actionWorkflowList, this.actionRemove};
        NCMClientUtils.setActionVisible(false, actList);
        if ("VIEW".equals(this.getOprtState())) {
            ItemAction[] actListView = new ItemAction[]{this.actionAddNew, this.actionSave, this.actionSubmit, this.actionAddLine, this.actionRemoveLine, this.actionInsertLine, this.auditAction};
            NCMClientUtils.setActionEnabled(false, actListView);
        }
        if ("ADDNEW".equals(this.getOprtState())) {
            this.actionAddNew.setVisible(true);
        }
        if ("EDIT".equals(this.getOprtState())) {
            this.actionAddNew.setVisible(false);
            this.actionEdit.setVisible(false);
        }
        this.menuBiz.setVisible(false);
        this.menuTable1.setVisible(false);
        this.menuWorkflow.setVisible(false);
        this.menuEdit.setVisible(false);
        this.menuView.setVisible(false);
        this.kDMenuItemSendMessage.setVisible(false);
        ((KDPromptBox)this.dataBinder.getComponetByField("creator")).setEnabled(false);
        ((KDDatePicker)this.dataBinder.getComponetByField("createTime")).setEnabled(false);
        ((KDPromptBox)this.dataBinder.getComponetByField("lastUpdateUser")).setEnabled(false);
        ((KDDatePicker)this.dataBinder.getComponetByField("lastUpdateTime")).setEnabled(false);
        ((KDPromptBox)this.dataBinder.getComponetByField("auditor")).setEnabled(false);
        ((KDDatePicker)this.dataBinder.getComponetByField("auditTime")).setEnabled(false);
        this.txtNumber.setMaxLength(80);
        if (this.dataBinder.getComponetByField("description") != null && this.dataBinder.getComponetByField("description") instanceof KDTextField) {
            ((KDTextField)this.dataBinder.getComponetByField("description")).setMaxLength(80);
        }
        KDTextField colTxtField = new KDTextField();
        colTxtField.setMaxLength(255);
        KDTDefaultCellEditor col_CellEditor = new KDTDefaultCellEditor((JTextField)colTxtField);
        if (this.kdtEntries.getColumn("remark") != null) {
            this.kdtEntries.getColumn("remark").setEditor((ICellEditor)col_CellEditor);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemunAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnaudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.prmtCompany.setEnabled(false);
        this.prmtPeriod.setEnabled(false);
        ((KDComboBox)this.dataBinder.getComponetByField("billStatus")).setEnabled(false);
    }

    protected void initDataStatus() {
        super.initDataStatus();
    }

    protected boolean isShowAttachmentAction() {
        return false;
    }

    protected void applyBillDefaultValue(IObjectValue vo) {
        this.innerApplyBillDefaultValue(vo);
    }

    protected void innerApplyBillDefaultValue(IObjectValue vo) {
        CompanyOrgUnitInfo companyOrg = this.getCompanyOrgInfoWithDefault();
        if (companyOrg == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.common.COMMONAutoGenerateResource", (String)"3_CMBillBaseEditUI"));
            SysUtil.abort();
        }
        this.prmtCompany.setData((Object)companyOrg);
        CMBillBaseInfo cmBillInfo = (CMBillBaseInfo)vo;
        cmBillInfo.setCompanyOrg(companyOrg);
        cmBillInfo.setBillStatus(BillBaseStatusEnum.ADD);
        cmBillInfo.setIsAuto(false);
        try {
            if (cmBillInfo.getCU() == null) {
                cmBillInfo.setCU(CMBillBaseEditUI.getRootCU());
            }
            cmBillInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            Timestamp serverDate = NCMUtils.getServerDate();
            Date date = new Date(serverDate.getTime());
            cmBillInfo.setBizDate(date);
            cmBillInfo.setCalculatePeriod(this.getPeriodByBizDate(date, companyOrg));
            cmBillInfo.setCreateTime(serverDate);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    protected abstract KDTable getDetailTable();

    protected PeriodInfo getPeriodByBizDate(Date date, CompanyOrgUnitInfo orgInfo) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String myString = sdf.format(date);
        try {
            date = sdf.parse(myString);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        KDBizPromptBox prmt = new KDBizPromptBox();
        NCMClientUtils.filterCompanyOrgForPeriod(prmt, orgInfo);
        FilterInfo filter = prmt.getEntityViewInfo().getFilter();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)date, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)date, CompareType.GREATER_EQUALS));
        PeriodCollection pc = null;
        try {
            prmt.getEntityViewInfo().getFilter().mergeFilter(filter, "and");
            IPeriod ipe = PeriodFactory.getRemoteInstance();
            pc = ipe.getPeriodCollection(prmt.getEntityViewInfo());
            if (pc != null && pc.size() > 0) {
                return pc.get(0);
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return null;
    }

    public void onLoad() throws Exception {
        this.txtNumber = this.getNumTextField();
        this.kdtEntries = this.getDetailTable();
        this.prmtCompany = (KDBizPromptBox)this.dataBinder.getComponetByField("companyOrg");
        this.prmtPeriod = (KDBizPromptBox)this.dataBinder.getComponetByField("calculatePeriod");
        this.pkDate = (KDDatePicker)this.dataBinder.getComponetByField("bizDate");
        super.onLoad();
        this.prmtCompany.setData((Object)this.getCompanyOrgInfoWithDefault());
        NCMClientUtils.addSqlMenu((CoreUIObject)this, this.menuEdit);
        this.addCustomListeners();
        if (this.editData.getCU() == null) {
            this.editData.setCU(CMBillBaseEditUI.getRootCU());
        }
        this.clientHelper.registerRequireColumns(this.getValidateColumns());
        this.initBillStatus();
        this.setAutoNumberForOrg();
        if ("EDIT".equalsIgnoreCase(this.getOprtState())) {
            this.setNumTextField();
        }
        this.setOprtState(this.getOprtState());
        if ("ADDNEW".equalsIgnoreCase(this.getOprtState()) && this.isBindTable()) {
            this.setNumTextField();
            super.addLine(this.kdtEntries);
        } else if ("ADDNEW".equalsIgnoreCase(this.getOprtState()) && !this.isBindTable()) {
            this.setNumTextField();
            this.kdtEntries.addRow();
        }
        this.addnew_and_save = "ADDNEW".equalsIgnoreCase(this.getOprtState()) || ((CMBillBaseInfo)this.editData).getBillStatus().equals((Object)BillBaseStatusEnum.ADD);
        this.storeFields();
        super.initOldData((IObjectValue)this.editData);
    }

    protected boolean isBindTable() {
        return true;
    }

    protected boolean isPkDateChangeToPeriod() {
        return true;
    }

    protected void setAutoNumberForOrg() throws EASBizException, BOSException {
        this.setAutoNumberForOrg("Company");
    }

    private void addCustomListeners() {
        this.pkDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    CMBillBaseEditUI.this.pkDate_dataChanged(e);
                }
                catch (Exception exc) {
                    CMBillBaseEditUI.this.handUIException(exc);
                }
            }
        });
        this.prmtCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    CMBillBaseEditUI.this.prmtCompany_dataChanged(e);
                }
                catch (Exception exc) {
                    CMBillBaseEditUI.this.handUIException(exc);
                }
            }
        });
    }

    void pkDate_dataChanged(DataChangeEvent e) throws Exception {
        if (this.isPkDateChangeToPeriod()) {
            Date newDate = (Date)e.getNewValue();
            if (newDate == null || newDate.equals(e.getOldValue())) {
                return;
            }
            if (this.prmtCompany.getData() != null) {
                this.prmtPeriod.setData((Object)this.getPeriodByBizDate(newDate, this.getCompanyOrgInfoWithDefault()));
            }
            this.pkBizDate_dataChanged(e);
        }
    }

    protected void pkBizDate_dataChanged(DataChangeEvent e) throws Exception {
    }

    void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        CompanyOrgUnitInfo newCom = (CompanyOrgUnitInfo)e.getNewValue();
        if (newCom == null || newCom.equals(e.getOldValue())) {
            return;
        }
        if (this.pkDate.getValue() != null) {
            this.prmtPeriod.setData((Object)this.getPeriodByBizDate((Date)this.pkDate.getValue(), newCom));
        }
        this.prmtCompanyOrg_dataChanged(e);
    }

    protected void prmtCompanyOrg_dataChanged(DataChangeEvent e) throws Exception {
    }

    public void eliminateIneffectiveEntries() {
        AbstractObjectCollection ovs = (AbstractObjectCollection)this.kdtEntries.getUserObject();
        int n = ovs.size();
        while (n-- > 0) {
            if (NCMClientUtils.isValidEntry(ovs.getObject(n), this.getCheckInvalidColumns())) continue;
            ovs.removeObject(n);
        }
        int m = this.kdtEntries.getRowCount();
        while (m-- > 0) {
            if (NCMClientUtils.isValidEntry(this.kdtEntries, this.getCheckInvalidColumns(), m)) continue;
            this.kdtEntries.removeRow(m);
        }
    }

    @Override
    public void loadFields() {
        this.dataBinder.loadFields();
    }

    protected void removeByPK(IObjectPK pk) throws Exception {
        super.removeByPK(pk);
        this.recycleNumberByOrg((IObjectValue)this.editData, "NONE", this.editData.getString("number"));
    }

    protected void recycleNumberByOrg(IObjectValue editData2, String orgType, String number) {
        if (!StringUtils.isEmpty((String)number)) {
            try {
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                iCodingRuleManager.recycleNumber(editData2, orgType, number);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    public static CtrlUnitInfo getRootCU() {
        CtrlUnitInfo rootCU = new CtrlUnitInfo();
        rootCU.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
        return rootCU;
    }

    protected void setAutoNumberForOrg(String orgType) throws EASBizException, BOSException {
        this.ruleStatus = NCMClientUtils.getCodingRuleAttr((CMBillBaseInfo)this.editData);
        if (!this.ruleStatus.isExist()) {
            return;
        }
        if (this.editData.getNumber() == null) {
            String sysNumber = null;
            if (this.editData.getCU() == null) {
                this.editData.setCU(CMBillBaseEditUI.getRootCU());
            }
            try {
                ICMBillBase icmbb = (ICMBillBase)this.getBizInterface();
                String orgId = ((CMBillBaseInfo)this.editData).getCompanyOrg().getId().toString();
                if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && orgId != null) {
                    sysNumber = this.getNumberByClient((IObjectValue)this.editData, orgId);
                } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                    sysNumber = icmbb.getNewNumber((IObjectValue)this.editData, orgId, null);
                }
                if (!StringUtils.isEmpty(sysNumber)) {
                    this.editData.setNumber(sysNumber);
                    if (this.ruleStatus.isAddView() || this.ruleStatus.isAddNoBreak()) {
                        this.txtNumber.setText(sysNumber);
                    }
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.setAutoNumberForOrg();
        this.setNumTextField();
        if (this.isBindTable()) {
            super.addLine(this.kdtEntries);
        } else {
            this.kdtEntries.removeRows();
            this.kdtEntries.addRow();
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.innerApplyBillDefaultValue((IObjectValue)this.editData);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setOprtStateForEDIT(((CMBillBaseInfo)this.editData).getBillStatus().getValue());
        this.setNumTextField();
    }

    public String getNumberByClient(IObjectValue caller, String orgID) throws CodingRuleException, EASBizException, BOSException {
        String strNumber = "";
        if (orgID == null || orgID.trim().length() == 0) {
            orgID = "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
        if (this.ruleStatus.isExist()) {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            if (this.ruleStatus.isAddNoBreak()) {
                strNumber = iCodingRuleManager.readNumber(caller, orgID);
            } else if (this.ruleStatus.isAddView()) {
                strNumber = iCodingRuleManager.getNumber(caller, orgID);
            }
        }
        return strNumber;
    }

    protected void setNumTextField() throws Exception {
        if (!this.ruleStatus.isExist() || this.ruleStatus.isModifiable()) {
            this.txtNumber.setEnabled(true);
        } else {
            this.txtNumber.setEnabled(false);
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (BillBaseStatusEnum.TEMPORARILYSAVED != ((CMBillBaseInfo)this.editData).getBillStatus() && BillBaseStatusEnum.ADD != ((CMBillBaseInfo)this.editData).getBillStatus()) {
            String msg = EASResource.getString((String)"com.kingdee.eas.ncm.common.CommonResource.CantSave");
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            SysUtil.abort();
        }
        ((CMBillBaseInfo)this.editData).setIsAuto(false);
        if (this.isBindTable()) {
            this.eliminateIneffectiveEntries();
        }
        super.actionSave_actionPerformed(e);
        this.setOprtStateForEDIT(2);
        if (((CMBillBaseInfo)this.editData).getCompanyOrg() != null) {
            String orgid = ((CMBillBaseInfo)this.editData).getCompanyOrg().getId().toString();
            NCMClientUtils.setNumberByRule((CMBillBaseInfo)this.editData, orgid, this.txtNumber);
        }
        String id = this.editData.getId().toString();
        ICMBillBase iCMBill = (ICMBillBase)this.getBizInterface();
        if (this.addnew_and_save) {
            ((KDDatePicker)this.dataBinder.getComponetByField("lastUpdateTime")).setValue(null);
            this.editData.setLastUpdateTime(null);
            ((KDPromptBox)this.dataBinder.getComponetByField("lastUpdateUser")).setData(null);
            this.editData.setLastUpdateUser(null);
            iCMBill.setUpdateNull(id);
        }
        this.storeFields();
        super.initOldData((IObjectValue)this.editData);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.ruleStatus.isExist()) {
            return;
        }
        if (UIRuleUtil.isNull((String)this.txtNumber.getText())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this.txtNumber.getBoundLabelText()});
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.isBindTable()) {
            this.eliminateIneffectiveEntries();
        }
        if ((this.getOprtState().equals("ADDNEW") || this.getOprtState().equals("EDIT")) && !this.verifyManager.verify()) {
            SysUtil.abort();
        }
        this.checkValidDataForSubmit();
        int rowCount = this.kdtEntries.getRowCount();
        if (rowCount <= 0) {
            MsgBox.showInfo((String)NCMClientUtils.getNcmBillResource("entry_Is_Null"));
            SysUtil.abort();
        }
        this.clientHelper.checkEntryRquiredColumns(this.getDetailTable());
        ((CMBillBaseInfo)this.editData).setIsAuto(false);
        super.actionSubmit_actionPerformed(e);
        this.setOprtStateForEDIT(3);
        this.setNumTextField();
        this.storeFields();
        super.initOldData((IObjectValue)this.editData);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.btnSave.setEnabled(true);
        }
    }

    protected void doAfterSubmit(IObjectPK pk) throws Exception {
        String orgId = ((CMBillBaseInfo)this.editData).getCompanyOrg().getId().toString();
        if (NCMUtils.isAuditAfterSubmit(null, orgId) && this.isBillSupportAuditAfterSubmit()) {
            if (this.editData.getId() == null) {
                this.editData.setId(BOSUuid.read((String)pk.toString()));
            }
            ((CMBillBaseInfo)this.editData).setBillStatus(BillBaseStatusEnum.SUBMITED);
            try {
                this.auditAction_actionPerformed(null);
            }
            catch (Exception e2) {
                MsgBox.showInfo((String)"\u5355\u636e\u5ba1\u6838\u5931\u8d25");
            }
        }
        super.doAfterSubmit(pk);
    }

    protected String[] getCheckInvalidColumns() {
        return null;
    }

    protected void checkValidDataForSubmit() throws Exception {
        if (UIRuleUtil.isNull((Object)this.prmtCompany.getValue())) {
            this.prmtCompany.requestFocus();
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{BDCMClientUtils.getNcmResource((String)"CompanyOrgUnit")});
        }
        if (UIRuleUtil.isNull((Object)this.prmtPeriod.getData())) {
            this.prmtPeriod.requestFocus();
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{BDCMClientUtils.getNcmResource((String)"Period")});
        }
        if (UIRuleUtil.isNull((Object)this.pkDate.getValue())) {
            this.pkDate.requestFocus();
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{BDCMClientUtils.getNcmResource((String)"BizDate")});
        }
    }

    protected String[] getValidateColumns() {
        return null;
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kdtEntries);
        this.kdtEntries.getPrintManager().print();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kdtEntries);
        this.kdtEntries.getPrintManager().printPreview();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        this.kdtEntries.getPrintManager().pageSetup();
    }

    protected void showSaveSuccess() {
        StringBuffer msg = new StringBuffer(16);
        msg.append(this.getClassAlise()).append(" ").append(NCMClientUtils.getNcmBillResource("number")).append(this.editData.getNumber()).append(" ").append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        this.setMessageText(msg.toString());
        this.setNextMessageText(this.getClassAlise() + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Edit"));
        this.setShowMessagePolicy(0);
        this.setIsShowTextOnly(false);
        this.showMessage();
    }

    protected void showSubmitSuccess() {
        StringBuffer msg = new StringBuffer(16);
        msg.append(this.getClassAlise()).append(" ").append(NCMClientUtils.getNcmBillResource("number")).append(this.editData.getNumber()).append(" ");
        this.setMessageText(msg.toString() + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        if (this.chkMenuItemSubmitAndAddNew.isSelected()) {
            msg.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_AddNew"));
        } else if (!this.chkMenuItemSubmitAndPrint.isSelected() && this.chkMenuItemSubmitAndAddNew.isSelected()) {
            msg.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_AddNew"));
        } else {
            msg.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Edit"));
        }
        this.setNextMessageText(msg.toString());
        this.setIsShowTextOnly(false);
        this.setShowMessagePolicy(0);
        this.showMessage();
    }

    public abstract KDTextField getNumTextField();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void auditAction_actionPerformed(ActionEvent e) throws Exception {
        int num;
        this.kdtEntries.getEditManager().stopEditing();
        if (((CMBillBaseInfo)this.editData).getBillStatus() == BillBaseStatusEnum.TEMPORARILYSAVED) {
            String msg = EASResource.getString((String)"com.kingdee.eas.ncm.common.CommonResource.NotAudit");
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            return;
        }
        if (this.isModify() && e != null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ncm.common.CommonResource.NotAudit"));
            SysUtil.abort();
        }
        String[] selIDs = new String[1];
        if (this.editData.getId() == null) {
            return;
        }
        selIDs[0] = this.editData.getId().toString();
        ICMBillBase iCMBill = (ICMBillBase)this.getBizInterface();
        try {
            num = selIDs.length;
            for (int i = 0; i < num; ++i) {
                this.pubFireVOChangeListener(selIDs[i]);
            }
            String[] idListArray = new String[]{this.editData.getId().toString()};
            if (this.checkAllBizObjInWfProcess(idListArray)) {
                this.actionMultiapprove_actionPerformed(null);
                return;
            }
            iCMBill.audit(NCMUtils.convertStringToObjectPK(selIDs));
            MsgBox.showInfo((String)NCMClientUtils.getNcmBillResource("AUDIT_SUCCESS"));
            this.refreshCurPage();
            this.setOprtStateForAUDIT(4);
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            try {
                num = selIDs.length;
                for (int i = 0; i < num; ++i) {
                    this.pubFireVOChangeListener(selIDs[i]);
                }
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
        this.lockUIForViewStatus();
        this.storeFields();
        super.initOldData((IObjectValue)this.editData);
        String orgId = ((CMBillBaseInfo)this.editData).getCompanyOrg().getId().toString();
        if (this.chkMenuItemSubmitAndAddNew.isSelected() && NCMUtils.isAuditAfterSubmit(null, orgId)) {
            this.actionAddNew_actionPerformed(null);
        }
    }

    protected boolean checkAllBizObjInWfProcess(String[] ids) throws BOSException, EASBizException {
        if (ids == null || ids.length < 1 || ids[0].toString().length() == 0) {
            return false;
        }
        IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
        int n = ids.length;
        for (int i = 0; i < n; ++i) {
            if (!service.billIsInProcessQueueOrHasProcessInst(ids[i].toString())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unauditAction_actionPerformed(ActionEvent e) throws Exception {
        String[] selIDs = new String[1];
        if (this.editData.getId() == null) {
            return;
        }
        selIDs[0] = this.editData.getId().toString();
        ICMBillBase iCMBill = (ICMBillBase)this.getBizInterface();
        try {
            this.setOprtState("UNAUDIT");
            int num = selIDs.length;
            for (int i = 0; i < num; ++i) {
                this.pubFireVOChangeListener(selIDs[i]);
            }
            iCMBill.unAudit(NCMUtils.convertStringToObjectPK(selIDs));
            MsgBox.showInfo((String)NCMClientUtils.getNcmBillResource("UNAUDIT_SUCCESS"));
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            String orgid = ((CMBillBaseInfo)this.editData).getCompanyOrg().getId().toString();
            if (!iCodingRuleManager.isExist((IObjectValue)this.editData, orgid)) {
                this.txtNumber.setAccessAuthority(0);
                this.txtNumber.setEnabled(true);
            }
            this.refreshCurPage();
            this.setOprtStateForUNAUDIT(3);
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                int num = selIDs.length;
                for (int i = 0; i < num; ++i) {
                    this.pubFireVOChangeListener(selIDs[i]);
                }
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
        this.storeFields();
        super.initOldData((IObjectValue)this.editData);
    }

    protected void refreshCurPage() throws EASBizException, BOSException, Exception {
        if (this.editData.getId() != null) {
            ObjectUuidPK iObjectPk = new ObjectUuidPK(this.editData.getId());
            this.editData = (CoreBillBaseInfo)((ICoreBillBase)this.getBizInterface()).getValue((IObjectPK)iObjectPk, this.getSelectors());
            this.setDataObject((IObjectValue)this.editData);
            this.loadFields();
            try {
                ((CMBillBaseListUI)((Object)this.getUIContext().get("Owner"))).refreshList();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    public void actionNextPerson_actionPerformed(ActionEvent e) throws Exception {
        String businessObjId = this.editData.getId().toString();
        ProcessDef processDef = null;
        String procInstId = null;
        IEnactmentService service = new EASWfServiceClient().getService();
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        AssignmentInfo[] assignmentInfoArray = service.checkAssignmentInfos(businessObjId, userId);
        for (int i = 0; i <= assignmentInfoArray.length - 1; ++i) {
            String activityInstId = assignmentInfoArray[i].getActInstId();
            ActivityInstInfo activityInstInfo = service.getActivityInstByActInstId(activityInstId);
            if (activityInstInfo.getState().startsWith("closed")) continue;
            processDef = service.getProcessDefByDefineHashValue(activityInstInfo.getProcDefHashValue());
            procInstId = activityInstInfo.getProcInstId();
            break;
        }
        if (procInstId == null || processDef == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ncm.common.COMMONAutoGenerateResource", (String)"4_CMBillBaseEditUI"));
            return;
        }
        super.actionNextPerson_actionPerformed(e);
    }

    protected String getAddNewPermItemName() {
        String permItemName = null;
        try {
            permItemName = PermissionUtils.getAddNewPermItemName(this.getBizInterface(), this.getEntityBOSType());
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        return permItemName;
    }

    protected OrgUnitInfo getBizOrgUnitInfo() {
        if (this.addNewPermItemName == null) {
            this.addNewPermItemName = this.getAddNewPermItemName();
        }
        if (this.addNewPermItemName == null) {
            return null;
        }
        OrgType orgType = this.getMainBizOrgType();
        return OrgUnitClientUtils.getBizOrgUnitInfo(this.addNewPermItemName, orgType, this.getMainOrgContext());
    }

    protected void isStartSet() throws Exception {
    }

    protected void isStart() throws Exception {
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        if (!sysctrol.isStart(1001, SysContext.getSysContext().getCurrentFIUnit().getId().toString())) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
    }

    private void initBillStatus() {
        if (this.getUIContext().get("Owner") instanceof CMBillBaseListUI) {
            CMBillBaseListUI listUI = (CMBillBaseListUI)((Object)this.getUIContext().get("Owner"));
            KDTable tblMain = listUI.getMainTable();
            BizEnumValueInfo enu = (BizEnumValueInfo)KDTableUtils.getFieldValue((KDTable)tblMain, (int)tblMain.getSelectManager().getActiveRowIndex(), (String)"billStatus");
            if (enu != null) {
                this.billStatus = Integer.valueOf(enu.getValue().toString());
            }
        } else {
            this.billStatus = BillBaseStatusEnum.ADD.getValue();
        }
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        if ("ADDNEW".equals(this.oprtState)) {
            this.setOprtStateForADD(this.billStatus);
        } else if ("EDIT".equals(this.oprtState)) {
            this.setOprtStateForEDIT(this.billStatus);
        } else if ("VIEW".equals(this.oprtState)) {
            this.setOprtStateForVIEW(this.billStatus);
        } else if ("AUDIT".equalsIgnoreCase(this.oprtState)) {
            this.setOprtStateForAUDIT(this.billStatus);
        }
    }

    protected void setOprtStateForADD(int billStatus) {
        this.menuItemAudit.setEnabled(false);
        this.menuItemunAudit.setEnabled(false);
        this.btnAudit.setEnabled(false);
        this.btnUnaudit.setEnabled(false);
        this.menuItemSubmit.setEnabled(true);
        this.btnSubmit.setEnabled(true);
        this.menuItemSave.setEnabled(true);
        this.btnSave.setEnabled(true);
        this.menuItemNextPerson.setEnabled(false);
        BDCMClientUtils.setEnable((boolean)true, (Component[])new Component[]{this.menuItemAddLine, this.menuItemInsertLine, this.menuItemRemoveLine, this.btnAddLine, this.btnInsertLine, this.btnRemoveLine});
    }

    protected void setOprtStateForEDIT(int billStatus) {
        this.menuItemunAudit.setEnabled(false);
        this.btnUnaudit.setEnabled(false);
        this.btnSave.setEnabled(false);
        this.menuItemSave.setEnabled(false);
        if (this.prmtPeriod != null) {
            this.prmtPeriod.setEnabled(false);
        }
        this.btnEdit.setEnabled(false);
        this.menuItemEdit.setEnabled(false);
        BDCMClientUtils.setEnable((boolean)true, (Component[])new Component[]{this.menuItemAddLine, this.menuItemInsertLine, this.menuItemRemoveLine, this.btnAddLine, this.btnInsertLine, this.btnRemoveLine});
        if (2 == billStatus) {
            this.btnSave.setEnabled(true);
            this.menuItemSave.setEnabled(true);
        } else if (3 == billStatus) {
            this.menuItemAudit.setEnabled(true);
            this.btnAudit.setEnabled(true);
            this.menuItemSubmit.setEnabled(true);
            this.btnSubmit.setEnabled(true);
        }
    }

    protected void setOprtStateForVIEW(int billStatus) {
        this.menuItemunAudit.setEnabled(false);
        this.btnUnaudit.setEnabled(false);
        this.menuItemAudit.setEnabled(false);
        this.btnAudit.setEnabled(false);
        this.btnEdit.setEnabled(false);
        this.menuItemEdit.setEnabled(false);
        if (3 == billStatus) {
            this.menuItemAudit.setEnabled(true);
            this.btnAudit.setEnabled(true);
            this.btnEdit.setEnabled(true);
            this.menuItemEdit.setEnabled(true);
        } else if (4 == billStatus) {
            this.menuItemunAudit.setEnabled(true);
            this.btnUnaudit.setEnabled(true);
        } else if (2 == billStatus) {
            this.btnEdit.setEnabled(true);
            this.menuItemEdit.setEnabled(true);
        }
    }

    protected void setOprtStateForAUDIT(int billStatus) {
        this.btnSave.setEnabled(false);
        this.menuItemSave.setEnabled(false);
        if (4 == billStatus) {
            this.btnSubmit.setEnabled(false);
            this.menuItemSubmit.setEnabled(false);
            this.menuItemunAudit.setEnabled(true);
            this.btnAudit.setEnabled(false);
            this.btnUnaudit.setEnabled(true);
            this.menuItemEdit.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
            this.btnRemove.setEnabled(false);
            BDCMClientUtils.setEnable((boolean)false, (Component[])new Component[]{this.menuItemAddLine, this.menuItemInsertLine, this.menuItemRemoveLine, this.btnAddLine, this.btnInsertLine, this.btnRemoveLine});
        } else {
            this.menuItemunAudit.setEnabled(false);
            this.btnAudit.setEnabled(true);
            this.btnUnaudit.setEnabled(false);
            this.btnSubmit.setEnabled(true);
            this.menuItemSubmit.setEnabled(true);
            this.menuItemEdit.setEnabled(true);
            this.btnEdit.setEnabled(true);
            this.menuItemRemove.setEnabled(true);
            this.btnRemove.setEnabled(true);
            BDCMClientUtils.setEnable((boolean)true, (Component[])new Component[]{this.menuItemAddLine, this.menuItemInsertLine, this.menuItemRemoveLine, this.btnAddLine, this.btnInsertLine, this.btnRemoveLine});
        }
    }

    protected void setOprtStateForUNAUDIT(int billStatus) {
        if (3 == billStatus) {
            this.menuItemAudit.setEnabled(true);
            this.btnAudit.setEnabled(true);
            this.menuItemunAudit.setEnabled(false);
            this.btnUnaudit.setEnabled(false);
            this.menuItemSubmit.setEnabled(true);
            this.btnSubmit.setEnabled(true);
            this.menuItemSave.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.menuItemEdit.setEnabled(true);
            this.btnEdit.setEnabled(true);
            this.menuItemRemove.setEnabled(true);
            this.btnRemove.setEnabled(true);
            BDCMClientUtils.setEnable((boolean)false, (Component[])new Component[]{this.menuItemAddLine, this.menuItemInsertLine, this.menuItemRemoveLine, this.btnAddLine, this.btnInsertLine, this.btnRemoveLine});
        }
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        ((CMBillBaseInfo)newData).setLastUpdateUser(null);
        ((CMBillBaseInfo)newData).setLastUpdateTime(null);
        ((CMBillBaseInfo)newData).setAuditor(null);
        ((CMBillBaseInfo)newData).setAuditTime(null);
        ((CMBillBaseInfo)newData).setBillStatus(BillBaseStatusEnum.ADD);
    }

    public ActionManager getActionManager() {
        if (this.actionManager == null) {
            this.actionManager = new ActionManager((CoreUIObject)this){

                public void registerAction(String actionName, ItemAction itemAction) {
                    if ("actionSubmit".equals(actionName)) {
                        CMBillBaseEditUI.this.actionSubmit.putValue("AcceleratorKey", (Object)KeyStroke.getKeyStroke("ctrl S"));
                    } else if ("auditAction".equals(actionName)) {
                        CMBillBaseEditUI.this.auditAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl U"));
                    } else if ("unauditAction".equals(actionName)) {
                        CMBillBaseEditUI.this.unauditAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl shift U"));
                    }
                    super.registerAction(actionName, itemAction);
                }
            };
        }
        return this.actionManager;
    }

    protected boolean isBillSupportAuditAfterSubmit() {
        return false;
    }

    protected CompanyOrgUnitInfo getCompanyOrgInfoWithDefault() {
        if (this.prmtCompany.getData() != null) {
            CompanyOrgUnitInfo org = (CompanyOrgUnitInfo)this.prmtCompany.getData();
            if (!org.isLoaded() && org.getId().toString().trim().length() > 0) {
                try {
                    org = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(org.getId().toString()));
                }
                catch (EASBizException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
            return org;
        }
        if (this.getUIContext().get("NcmCompanyOrg") != null) {
            CompanyOrgUnitInfo org = (CompanyOrgUnitInfo)this.getUIContext().get("NcmCompanyOrg");
            if (!org.isLoaded() && org.getId().toString().trim().length() > 0) {
                try {
                    org = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(org.getId().toString()));
                }
                catch (EASBizException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
            return org;
        }
        return SysContext.getSysContext().getCurrentFIUnit();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(this.getCompanyOrgInfoWithDefault().getId());
    }
}

