/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.uistatemanage.ActionManager;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.ICMBillBase;
import com.kingdee.eas.ncm.common.client.AbstractCMBillBaseListUI;
import com.kingdee.eas.ncm.common.client.CMBillBaseFilterUI;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMCommonQueryProcessor;
import com.kingdee.eas.ncm.common.utils.client.NCMMaterialPromptBoxFactory;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class CMBillBaseListUI
extends AbstractCMBillBaseListUI {
    private static final Logger logger = CoreUIObject.getLogger(CMBillBaseListUI.class);
    public static final String TB_BASESTATE = "billStatus";
    private ActionManager actionManager = null;
    protected boolean isNormal = true;
    private CommonQueryDialog dialog;
    protected boolean isSubmitting = false;

    public CMBillBaseListUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
    }

    public void onLoad() throws Exception {
        if (this.isNormal) {
            this.isStart();
        }
        super.onLoad();
        NCMClientUtils.addSqlMenu((CoreUIObject)this, this.menuEdit);
        NCMClientUtils.addLLCListUI((CoreUIObject)this, this.menuEdit);
        NCMClientUtils.addNCMDataToolUI((CoreUIObject)this, this.menuEdit);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.getMainTable().setColumnMoveable(true);
        ItemAction[] actList = new ItemAction[]{this.actionCopyTo, this.actionCreateTo, this.actionLocate, this.actionAttachment, this.actionCancel, this.actionCancelCancel, this.actionVoucher, this.actionDelVoucher, this.actionAuditResult, this.actionMultiapprove, this.actionNextPerson, this.actionSignature, this.actionStartWorkFlow, this.actionWorkFlowG, this.actionWorkflowList, this.actionTraceUp, this.actionTraceDown};
        NCMClientUtils.setActionVisible(false, actList);
        this.menuBiz.setVisible(false);
        this.menuItemSendSmsMessage.setVisible(false);
        boolean isEnableSubmt = this.isEnableSubmit();
        this.actionSubmit.setEnabled(isEnableSubmt);
        this.actionSubmit.setVisible(isEnableSubmt);
        this.menuSubmit.setEnabled(isEnableSubmt);
        this.menuSubmit.setVisible(isEnableSubmt);
        this.btnSubmit.setEnabled(isEnableSubmt);
        this.btnSubmit.setVisible(isEnableSubmt);
        this.isStartSet(null);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemunAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnaudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.menuSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
    }

    protected boolean isShowAttachmentAction() {
        return false;
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
    }

    protected String[] getCountQueryFields() {
        String[] strstrs = new String[]{"id"};
        return strstrs;
    }

    @Override
    public void auditAction_actionPerformed(ActionEvent e) throws Exception {
        this.checkAction("audit");
        ArrayList ids = this.getSelectedIdValues();
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        ArrayList retList = new ArrayList();
        for (int i = 0; i < ids.size(); ++i) {
            retList.add(ids.get(i));
        }
        String[] selIDs = new String[retList.size()];
        selIDs = retList.toArray(selIDs);
        ICMBillBase iCMBill = (ICMBillBase)this.getBizInterface();
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        try {
            this.setOprtState("AUDIT");
            Map map = mutexServiceControl.batchRequestObjIDForUpdate((List)ids);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                if (((Boolean)map.get(iterator.next())).booleanValue()) continue;
                mutexServiceControl.batchReleaseObjIDForUpdate((List)ids);
                throw new CMBillException(CMBillException.BILL_LOCKED);
            }
        }
        catch (Throwable t) {
            this.handUIException(t);
            this.abort();
        }
        if (this.checkAllBizObjInWfProcess(selIDs)) {
            this.actionMultiapprove_actionPerformed(null);
            this.refreshList();
            this.refresh(selectBlock);
            return;
        }
        iCMBill.audit(NCMUtils.convertStringToObjectPK(selIDs));
        MsgBox.showInfo((String)NCMClientUtils.getNcmBillResource("AUDIT_SUCCESS"));
        this.refreshList();
        this.refresh(selectBlock);
        this.setOprtState("RELEASEALL");
        try {
            mutexServiceControl.batchReleaseObjIDForUpdate((List)ids);
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
    }

    protected boolean checkAllBizObjInWfProcess(String[] ids) throws BOSException, EASBizException {
        if (ids == null || ids.length < 1 || ids[0].toString().length() == 0) {
            return false;
        }
        IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
        int n = ids.length;
        for (int i = 0; i < n; ++i) {
            if (!service.billIsInProcessQueueOrHasProcessInst(ids[i].toString())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unauditAction_actionPerformed(ActionEvent e) throws Exception {
        this.checkAction("unAudit");
        ArrayList ids = this.getSelectedIdValues();
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        ArrayList retList = new ArrayList();
        for (int i = 0; i < ids.size(); ++i) {
            retList.add(ids.get(i));
        }
        String[] selIDs = new String[retList.size()];
        selIDs = retList.toArray(selIDs);
        ICMBillBase iCMBill = (ICMBillBase)this.getBizInterface();
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        try {
            this.setOprtState("AUDIT");
            Map map = mutexServiceControl.batchRequestObjIDForUpdate((List)ids);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                if (((Boolean)map.get(iterator.next())).booleanValue()) continue;
                mutexServiceControl.batchReleaseObjIDForUpdate((List)ids);
                throw new CMBillException(CMBillException.BILL_LOCKED);
            }
            iCMBill.unAudit(NCMUtils.convertStringToObjectPK(selIDs));
            MsgBox.showInfo((String)NCMClientUtils.getNcmBillResource("UNAUDIT_SUCCESS"));
            this.refreshList();
            this.refresh(selectBlock);
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                mutexServiceControl.batchReleaseObjIDForUpdate((List)ids);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    public void refresh(KDTSelectBlock selectBlock) throws Exception {
        int curIndex = 0;
        if (selectBlock != null) {
            curIndex = selectBlock.getTop();
        }
        this.tblMain.getSelectManager().select(curIndex, 0);
        this.tblMain.getLayoutManager().scrollRowToShow(curIndex);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkAction("edit");
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkAction("remove");
        ArrayList ids = this.getSelectedIdValues();
        ArrayList retList = new ArrayList();
        for (int i = 0; i < ids.size(); ++i) {
            retList.add(ids.get(i));
        }
        String[] selIDs = new String[retList.size()];
        selIDs = retList.toArray(selIDs);
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        if (super.confirmRemove()) {
            try {
                this.setOprtState("REMOVE");
                Map map = mutexServiceControl.batchRequestObjIDForUpdate((List)ids);
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    if (((Boolean)map.get(iterator.next())).booleanValue()) continue;
                    mutexServiceControl.batchReleaseObjIDForUpdate((List)ids);
                    throw new CMBillException(CMBillException.BILL_LOCKED);
                }
            }
            catch (Throwable ex) {
                this.handUIException(ex);
                this.abort();
            }
            ICMBillBase iCMBill = (ICMBillBase)this.getBizInterface();
            iCMBill.deleteBatchData(NCMUtils.convertStringToObjectPK(selIDs));
        }
        try {
            this.setOprtState("RELEASEALL");
            mutexServiceControl.batchReleaseObjIDForUpdate((List)ids);
        }
        catch (Throwable ex) {
            this.handUIException(ex);
        }
        super.refreshList();
    }

    protected void checkAction(String action) throws Exception {
        this.checkSelected();
        this.checkStart();
        int size = this.tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                String billStatus = row.getCell(TB_BASESTATE).getValue().toString().trim();
                if ("audit".equals(action)) {
                    this.checkAudit(billStatus);
                    continue;
                }
                if ("edit".equals(action)) {
                    this.checkEdit(billStatus);
                    continue;
                }
                if ("remove".equals(action)) {
                    this.checkRemove(billStatus);
                    continue;
                }
                if ("unAudit".equals(action)) {
                    this.checkUnAudit(billStatus);
                    continue;
                }
                if (!"submit".equals(action)) continue;
                this.checkSubmit(billStatus);
            }
        }
    }

    private void checkAudit(String billStatus) {
        if (this.isSubmitting) {
            return;
        }
        if (!billStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.SUBMITED.toString())) {
            MsgBox.showError((String)NCMClientUtils.getNcmBillResource("CHECK_CAN_AUDIT"));
            SysUtil.abort();
        }
    }

    private void checkEdit(String billStatus) {
        if (!billStatus.equalsIgnoreCase(BillBaseStatusEnum.TEMPORARILYSAVED.toString()) && !billStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.SUBMITED.toString())) {
            MsgBox.showError((String)NCMClientUtils.getNcmBillResource("CHECK_CAN_EDIT"));
            SysUtil.abort();
        }
    }

    private void checkRemove(String billStatus) {
        if (!billStatus.equalsIgnoreCase(BillBaseStatusEnum.TEMPORARILYSAVED.toString()) && !billStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.SUBMITED.toString())) {
            MsgBox.showError((String)NCMClientUtils.getNcmBillResource("CHECK_CAN_DELETE"));
            SysUtil.abort();
        }
    }

    private void checkUnAudit(String billStatus) {
        if (!billStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.AUDITED.toString())) {
            MsgBox.showError((String)NCMClientUtils.getNcmBillResource("CHECK_CAN_UNAUDIT"));
            SysUtil.abort();
        }
    }

    private void checkSubmit(String billStatus) {
        if (!billStatus.equalsIgnoreCase(BillBaseStatusEnum.TEMPORARILYSAVED.toString()) && !billStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.SUBMITED.toString())) {
            MsgBox.showError((String)"\u53ea\u80fd\u63d0\u4ea4\u4fdd\u5b58\u72b6\u6001\u6216\u8005\u63d0\u4ea4\u72b6\u6001\u5355\u636e!");
            SysUtil.abort();
        }
    }

    protected void isStartSet(ItemAction[] actList) throws Exception {
    }

    protected void isStart() throws Exception {
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        if (!sysctrol.isStart(1001, this.getCompanyOrgInfoWithDefault().getId().toString())) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
    }

    public void checkStart() throws Exception {
        if (!this.isCheckStart()) {
            return;
        }
        ArrayList pkList = this.getSelectedIdValues();
        ObjectUuidPK[] pks = new ObjectUuidPK[pkList.size()];
        for (int i = 0; i < pkList.size(); ++i) {
            String id = pkList.get(i).toString();
            pks[i] = new ObjectUuidPK(id);
        }
        ((ICMBillBase)this.getBizInterface()).checkStart((IObjectPK[])pks);
    }

    protected boolean isCheckStart() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        if (!this.isEnableMultiOrgSupport()) {
            FilterInfo filter2 = new FilterInfo();
            filter2.getFilterItems().add(new FilterItemInfo("companyOrg.id", (Object)this.getCompanyOrgInfoWithDefault().getId().toString(), CompareType.EQUALS));
            try {
                if (FilterUtility.hasFilterItem((FilterInfo)filter)) {
                    filter.mergeFilter(filter2, "AND");
                } else {
                    filter = filter2;
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return filter;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CMBillBaseFilterUI filterUI;
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = super.initCommonQueryDialog();
        if (this.getFilterUI() != null) {
            this.dialog.addUserPanel((KDPanel)this.getFilterUI());
        }
        NCMMaterialPromptBoxFactory ncmF7Factory = new NCMMaterialPromptBoxFactory(this.getFilterUI(), this.getMainBizOrgType());
        this.dialog.setPromptBoxFactory((IPromptBoxFactory)ncmF7Factory);
        final CommonQueryProcessor cmcq = this.getCustomerCommonQueryProcessor();
        this.dialog.setProcessor((IProcessor)cmcq);
        if (this.getFilterUI() != null && this.getFilterUI() instanceof CMBillBaseFilterUI && cmcq instanceof NCMCommonQueryProcessor && (filterUI = (CMBillBaseFilterUI)this.getFilterUI()) != null && filterUI.getCompanyF7() != null) {
            final KDBizPromptBox compF7 = filterUI.getCompanyF7();
            filterUI.getCompanyF7().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (compF7.getData() != null && compF7.getData() instanceof CompanyOrgUnitInfo) {
                        CompanyOrgUnitInfo org = (CompanyOrgUnitInfo)compF7.getData();
                        cmcq.set("companyOrg", (Object)org.getId().toString());
                        CMBillBaseListUI.this.getUIContext().put("ORG.PK", new ObjectUuidPK(org.getId()));
                    }
                    CMBillBaseListUI.this.afterFilterUIMainOrgChanged(e);
                }
            });
        }
        this.dialog.setWidth(this.getCommonQueryDialogWidth());
        this.dialog.setHeight(this.getCommonQueryDialogHeight());
        return this.dialog;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor qe = super.getQueryExecutor(queryPK, viewInfo);
        qe.option().isIgnoreOrder = true;
        qe.option().isAutoIgnoreZero = false;
        return qe;
    }

    protected CustomerQueryPanel getFilterUI() {
        return null;
    }

    protected CommonQueryProcessor getCustomerCommonQueryProcessor() {
        NCMCommonQueryProcessor cmcq = new NCMCommonQueryProcessor(this.getFilterUI());
        cmcq.set("companyOrg", this.getCompanyOrgInfoWithDefault().getId().toString());
        return cmcq;
    }

    protected int getCommonQueryDialogWidth() {
        return 450;
    }

    protected int getCommonQueryDialogHeight() {
        return 330;
    }

    protected boolean isEnableSubmit() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkAction("submit");
        ArrayList ids = this.getSelectedIdValues();
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("companyID", this.getCompanyOrgInfoWithDefault().getId().toString());
        Map report = ((ICMBillBase)this.getBizInterface()).submit(ids, param);
        if (report == null || report.isEmpty()) {
            String orgId = this.getCompanyOrgInfoWithDefault().getId().toString();
            if (NCMUtils.isAuditAfterSubmit(null, orgId) && this.isBillSupportAuditAfterSubmit()) {
                try {
                    this.isSubmitting = true;
                    try {
                        this.auditAction_actionPerformed(e);
                    }
                    catch (Exception e2) {
                        MsgBox.showInfo((String)"\u5355\u636e\u5ba1\u6838\u5931\u8d25");
                    }
                }
                finally {
                    this.isSubmitting = false;
                }
            } else if (ids.size() == 1) {
                MsgBox.showInfo((String)"\u5355\u636e\u63d0\u4ea4\u6210\u529f");
            } else {
                MsgBox.showInfo((String)"\u5355\u636e\u6279\u91cf\u63d0\u4ea4\u6210\u529f");
            }
        } else {
            StringBuffer detail = new StringBuffer();
            String billNumber = null;
            List errorDetail = null;
            Iterator itr = report.keySet().iterator();
            while (itr.hasNext()) {
                billNumber = itr.next().toString();
                errorDetail = (List)report.get(billNumber);
                detail.append("\u5355\u636e\u7f16\u7801\uff1a" + billNumber + "\n");
                int size = errorDetail.size();
                for (int i = 0; i < size; ++i) {
                    if (i == size - 1) {
                        detail.append("     " + errorDetail.get(i)).append("\n");
                        continue;
                    }
                    detail.append("     " + errorDetail.get(i) + ";\n");
                }
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)"\u5355\u636e\u6279\u91cf\u63d0\u4ea4\u8fc7\u7a0b\u4e2d\uff0c\u5b58\u5728\u5982\u4e0b\u5355\u636e\u4e0d\u7b26\u5408\u63d0\u4ea4\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5\uff01", (String)detail.toString(), (int)2);
        }
        this.refreshList();
        this.refresh(selectBlock);
    }

    public ActionManager getActionManager() {
        if (this.actionManager == null) {
            this.actionManager = new ActionManager((CoreUIObject)this){

                public void registerAction(String actionName, ItemAction itemAction) {
                    if ("actionImportData".equals(actionName)) {
                        CMBillBaseListUI.this.actionImportData.putValue("AcceleratorKey", (Object)KeyStroke.getKeyStroke("ctrl I"));
                    } else if ("actionExportData".equals(actionName)) {
                        CMBillBaseListUI.this.actionExportData.putValue("AcceleratorKey", (Object)KeyStroke.getKeyStroke("ctrl shift E"));
                    } else if ("actionSubmit".equals(actionName)) {
                        CMBillBaseListUI.this.actionSubmit.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl S"));
                    } else if ("auditAction".equals(actionName)) {
                        CMBillBaseListUI.this.auditAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl U"));
                    } else if ("unauditAction".equals(actionName)) {
                        CMBillBaseListUI.this.unauditAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl shift U"));
                    }
                    super.registerAction(actionName, itemAction);
                }
            };
        }
        return this.actionManager;
    }

    protected boolean isEnableMultiOrgSupport() {
        return false;
    }

    protected boolean isBillSupportAuditAfterSubmit() {
        return false;
    }

    protected IMultiOrgSupport getMainCustomerQueryPanel() {
        try {
            CMBillBaseFilterUI filterUI = (CMBillBaseFilterUI)this.getFilterUI();
            if (filterUI == null) {
                return null;
            }
            filterUI.setMetaDataPKForPemmission(this.mainQueryPK);
            filterUI.setMetaDataPKForPemmissionByUI(this.getMetaDataPK());
            return filterUI;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        CMBillBaseFilterUI filterUI;
        ItemAction action = this.getActionFromActionEvent(e);
        if (action.equals(this.actionAddNew)) {
            filterUI = (CMBillBaseFilterUI)this.getFilterUI();
            if (filterUI != null && filterUI.getCompanyF7() != null && filterUI.getCompanyF7().getData() != null) {
                uiContext.put((Object)"NcmCompanyOrg", filterUI.getCompanyF7().getData());
            }
            if (this.getUIContext().containsKey(OrgType.Company) && this.getUIContext().get(OrgType.Company) != null) {
                uiContext.put((Object)"NcmCompanyOrg", this.getUIContext().get(OrgType.Company));
            }
        }
        if ((filterUI = (CMBillBaseFilterUI)this.getFilterUI()) != null && filterUI.getCompanyF7() != null && filterUI.getCompanyF7().getData() != null) {
            CompanyOrgUnitInfo companyOrg = (CompanyOrgUnitInfo)filterUI.getCompanyF7().getData();
            if (companyOrg != null) {
                uiContext.put((Object)"ORG.PK", (Object)new ObjectUuidPK(companyOrg.getId()));
            }
        } else if (this.getUIContext().containsKey(OrgType.Company) && this.getUIContext().get(OrgType.Company) != null) {
            uiContext.put((Object)"ORG.PK", (Object)new ObjectUuidPK(((CompanyOrgUnitInfo)this.getUIContext().get(OrgType.Company)).getId()));
        }
    }

    protected CompanyOrgUnitInfo getCompanyOrgInfoWithDefault() {
        CMBillBaseFilterUI filterUI = (CMBillBaseFilterUI)this.getFilterUI();
        if (filterUI != null && filterUI.getCompanyF7() != null && filterUI.getCompanyF7().getData() != null && filterUI.getCompanyF7().getData() instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo org = (CompanyOrgUnitInfo)filterUI.getCompanyF7().getData();
            if (!org.isLoaded() && org.getId().toString().trim().length() > 0) {
                try {
                    org = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(org.getId().toString()));
                }
                catch (EASBizException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
            return org;
        }
        if (this.getUIContext().containsKey(OrgType.Company) && this.getUIContext().get(OrgType.Company) != null) {
            return (CompanyOrgUnitInfo)this.getUIContext().get(OrgType.Company);
        }
        return SysContext.getSysContext().getCurrentFIUnit();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(this.getCompanyOrgInfoWithDefault().getId());
    }

    public void afterFilterUIMainOrgChanged(ChangeEvent e) {
    }

    protected ArrayList getSelectedIdValues() {
        this.checkSelected();
        return super.getSelectedIdValues();
    }

    protected KDBizPromptBox getMainBizOrg() {
        CMBillBaseFilterUI filterUI = (CMBillBaseFilterUI)this.getFilterUI();
        if (filterUI == null) {
            return null;
        }
        return filterUI.getCompanyF7();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected List getMainBizOrgs(QuerySolutionInfo solution) {
        ArrayList<String> list = new ArrayList<String>();
        if (solution != null) {
            OrgUnitInfo[] orgUnitInfos = this.getMainOrgFromSolution(solution);
            if (orgUnitInfos != null && orgUnitInfos.length >= 1) {
                CMBillBaseFilterUI filterUI = (CMBillBaseFilterUI)this.getFilterUI();
                if (filterUI != null) {
                    String permissionItem = filterUI.getPermissionItem();
                    try {
                        if (!SCMGroupClientUtils.isAuthoriedForOrg((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)OrgType.Company, (IObjectPK)new ObjectStringPK(orgUnitInfos[0].getId().toString()), (String)permissionItem)) {
                            MsgBox.showInfo((String)"\u6ca1\u6709\u8be5\u65b9\u6848\u6240\u9009\u8d22\u52a1\u7ec4\u7ec7\u7684\u6743\u9650");
                            SysUtil.abort();
                        }
                    }
                    catch (EASBizException e) {
                        logger.error((Object)"", (Throwable)e);
                    }
                    catch (BOSException e) {
                        logger.error((Object)"", (Throwable)e);
                    }
                }
                this.getUIContext().put(this.getMainBizOrgType(), orgUnitInfos[0]);
                for (int i = 0; i < orgUnitInfos.length; ++i) {
                    if (orgUnitInfos[i] == null) continue;
                    list.add(orgUnitInfos[i].getId().toString());
                }
            } else {
                this.getUIContext().put(this.getMainBizOrgType(), null);
                if (this.getMainOrgContext() != null) {
                    FrameWorkUtils.setCurrentOrgUnit((Context)this.getMainOrgContext(), null);
                }
            }
        } else if (this.getUIContext().get(this.getMainBizOrgType()) != null) {
            list.add(((OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType())).getId().toString());
        }
        return list;
    }

    private OrgUnitInfo[] getMainOrgFromSolution(QuerySolutionInfo solution) {
        String key = this.getPropertyOfBizOrg(this.getMainBizOrgType());
        if (solution != null && key != null) {
            QueryPanelCollection queryPanelCollection = solution.getQueryPanelInfo();
            int size = queryPanelCollection.size();
            for (int i = 0; i < size; ++i) {
                String params;
                QueryPanelInfo queryPanelInfo = queryPanelCollection.get(i);
                if (queryPanelInfo.getPanelClassName() == null || queryPanelInfo.getPanelClassName().equalsIgnoreCase("com.kingdee.eas.base.commonquery.client.CommonFilterPanel") || queryPanelInfo.getPanelClassName().equalsIgnoreCase("com.kingdee.eas.base.commonquery.client.CommonSorterPanel") || (params = queryPanelInfo.getCustomerParams()) == null) continue;
                CustomerParams cp = new CustomerParams();
                try {
                    ArrayList al = XMLBean.TransStrToAL((String)params);
                    Iterator j = al.iterator();
                    XMLBean xb = null;
                    while (j.hasNext()) {
                        xb = (XMLBean)j.next();
                        cp.addCustomerParam(xb.getName(), xb.getValue());
                    }
                    String orgs = cp.getCustomerParam(key);
                    if (orgs != null) {
                        return SCMGroupClientUtils.getOrgUnitInfos((String)orgs);
                    }
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
        }
        return null;
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        return "CompanyPick";
    }
}

